/**
 *
 * @file  mtkerrs.h
 * @brief Media Toolkit API error code definitions
 * @date  Oct. 16, 2008
 *
 * DIALOGIC CONFIDENTIAL      
 * Copyright (C) 2006-2008 Dialogic Corporation. All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to
 * the source code ("Material") are owned by Dialogic Corporation or its 
 * suppliers or licensors.  Title to the Material remains with Dialogic 
 * Corporation or its suppliers and licensors.  The Material contains trade
 * secrets and proprietary and confidential information of Dialogic or its 
 * suppliers and licensors.  The Material is protected by worldwide copyright
 * and trade secret laws and treaty provisions.  No part of the Material may be
 * used, copied, reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way without Dialogic's prior express written
 * permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual 
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise.  Any license under such intellectual property rights must be
 * express and approved by Dialogic in writing.
 */

#ifndef _MTKERRS_H_
#define _MTKERRS_H_

/*
 * Error code definitions.
 */
 
#define EMTK_NOERROR                0    ///< No error
#define EMTK_INVALID_DEVICE         1    ///< Invalid device
#define EMTK_INVALID_HANDLE         2    ///< Invalid device handle
#define EMTK_INVALID_NAME           3    ///< Invalid device name
#define EMTK_INVALID_PARM           4    ///< Invalid parameter in function call
#define EMTK_INVALID_ATTR           5	 ///< Invalid attribute
#define EMTK_INVALID_EVENT          6	 ///< Invalid event
#define EMTK_INVALID_STATE          7    ///< Invalid state for current operation
#define EMTK_SUBSYSTEM              8    ///< Internal subsystem error
#define EMTK_FIRMWARE               9    ///< Firmware error
#define EMTK_LIBRARY                10   ///< Library error
#define EMTK_SYSTEM                 11   ///< System error
#define EMTK_MEMORY_ALLOC           12   ///< Memory allocation error
#define EMTK_UNSUPPORTED_API        13   ///< API not supported
#define EMTK_UNSUPPORTED_TECH       14   ///< Technology not supported
#define EMTK_UNSUPPORTED_FUNC       15   ///< Functionality not supported
#define EMTK_MAX_OVERLAYS_EXCEEDED  16   ///< sm library error code - Exceeded maximum number of overlays for a device 
#define EMTK_FILENOTEXIST           17   ///< mc library error code - File does not exist 
#define EMTK_FILECORRUPT            18   ///< mc library error code - File corrupt error 
#define EMTK_UNKNOWNERR             19   ///< mc library error code - Unknown error 

#endif /* _MTKERRS_H_ */

