
/*
 * This file was automatically generated from os_t1defs.txt.
 * Author: "DM3 TSP Team"
 * Version: "Revision 1.21"
 * Date: Thu Mar 13 19:35:13 2003
 * The output was written to os_t1defs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_os_t1defs_h_)
#define _os_t1defs_h_ 1
/* This file describes the list of additional Mercury messages, parameters and 
 * equates supported by the Mercury T1 Channel Protocol Component and its 
 * Instances. */
/* 
 * Addedum to the Channel Protocol Component Definition 
 */
/* 
 * T1 CHP Message Definitions
 */
/* Protocol Variant Parameters. This structure is used as the body of the 
 * CHP_MsgDefineVariant message to set the parameter values for a protocol 
 * variant. */

#define CHP_OS_T1_Variant_ProtocolType_EM	0x1	/* 1 */

#define CHP_OS_T1_Variant_ProtocolType_Loop_FXS	0x2	/* 2 */

#define CHP_OS_T1_Variant_ProtocolType_Ground_FXS	0x3	/* 3 */

#define CHP_OS_T1_Variant_ProtocolType_Loop_FXO	0x4	/* 4 */

#define CHP_OS_T1_Variant_ProtocolType_Ground_FXO	0x5	/* 5 */

#define CHP_OS_T1_Variant_ProtocolType_Analog_Loop_FXS	0x6	/* 6 */

#define CHP_OS_T1_Variant_ProtocolType_Analog_Loop_FXO	0x7	/* 7 */

#define CHP_OS_T1_Variant_ProtocolType_Analog_HIZ	0x8	/* 8 */
/*
 * Type of T1 protocol to run.  E&M, Loop Start FXS, or Ground Start FXS.
 * New two variants Analog LoopFXS and LoopFXO cover the analog protocol.
 * Added Analog_HIZ 
 */

#define CHP_OS_T1_Variant_ProtocolType	0x380000	/* 3670016 */
typedef	UInt32	CHP_OS_T1_Variant_ProtocolType_t;

#define CHP_OS_T1_Variant_Wink_No	0	/* 0 */

#define CHP_OS_T1_Variant_Wink_Yes	0x1	/* 1 */
/*
 * Enables Wink detection for outbound and Wink generation for inbound calls (T1 
 * E&M only).
 */

#define CHP_OS_T1_Variant_Wink	0x380004	/* 3670020 */
typedef	UInt32	CHP_OS_T1_Variant_Wink_t;
/*
 * E&M:	The amount of time that a call originator will wait for a wink 
 * once it has seized the line.  The outbound call will fail if this time 
 * is exceeded.
 * GroundStart:	The amount of time that a call originator will wait for the dial 
 * tone signal once it has seized the line.  The outbound call will fail 
 * if this time is exceeded.
 * LoopStart:	The call originator will wait the specified amount of time after 
 * seizing the line, and then proceed to sending digits (i.e. wait for 
 * dial tone).
 * Units of 1ms.  
 */

#define CHP_OS_T1_Variant_StartTimeout	0x380008	/* 3670024 */
typedef	UInt32	CHP_OS_T1_Variant_StartTimeout_t;

#define CHP_OS_T1_Variant_FarEndAnswer_No	0	/* 0 */

#define CHP_OS_T1_Variant_FarEndAnswer_Yes	0x1	/* 1 */
/* Ground start protocols only. Enable this if the network provides far end 
 * (remote) answer signaling. */

#define CHP_OS_T1_Variant_FarEndAnswer	0x38000c	/* 3670028 */
typedef	UInt32	CHP_OS_T1_Variant_FarEndAnswer_t;
/* 
 *  maximum time allowed between a remote party sending a wink and answering a 
 * call. Units of 1ms. 
 */

#define CHP_OS_T1_Variant_AnswerTimeout	0x380010	/* 3670032 */
typedef	UInt32	CHP_OS_T1_Variant_AnswerTimeout_t;
/* 
 * maximum time allowed between a local disconnect (MsgDropCall) and a reconnect 
 * (MsgReconnectCall). Units of 1ms. 
 */

#define CHP_OS_T1_Variant_ReconnectTimeout	0x380014	/* 3670036 */
typedef	UInt32	CHP_OS_T1_Variant_ReconnectTimeout_t;
/* the time before a remote drop is considered to be a disconnect. If 
 * MsgDropCall is followed by a MsgReconnectCall within this time period then 
 * the call will be reconnected and remain in connected state. Units of 1ms. */

#define CHP_OS_T1_Variant_DisconnectTimeout	0x380018	/* 3670040 */
typedef	UInt32	CHP_OS_T1_Variant_DisconnectTimeout_t;
/* 
 * The minimum time required between outbound calls.  Units of 1ms.
 */

#define CHP_OS_T1_Variant_InterCallDelay	0x38001c	/* 3670044 */
typedef	UInt32	CHP_OS_T1_Variant_InterCallDelay_t;

#define CHP_OS_T1_Variant_Dial_No	0	/* 0 */

#define CHP_OS_T1_Variant_Dial_Yes	0x1	/* 1 */
/*
 * Enables outbound dialing.
 */

#define CHP_OS_T1_Variant_Dial	0x380020	/* 3670048 */
typedef	UInt32	CHP_OS_T1_Variant_Dial_t;

#define CHP_OS_T1_Variant_DialFormat_DTMF	0x1	/* 1 */

#define CHP_OS_T1_Variant_DialFormat_MF	0x2	/* 2 */

#define CHP_OS_T1_Variant_DialFormat_DP	0x3	/* 3 */
/* 
 * Format of Dial digits; DTMF, MF, DP. 
 */

#define CHP_OS_T1_Variant_DialFormat	0x380024	/* 3670052 */
typedef	UInt32	CHP_OS_T1_Variant_DialFormat_t;

#define CHP_OS_T1_Variant_ANI_No	0	/* 0 */

#define CHP_OS_T1_Variant_ANI_Pre	0x1	/* 1 */

#define CHP_OS_T1_Variant_ANI_Post	0x2	/* 2 */
/* Enables ANI collection for inbound calls. Collection can be pre-answer or 
 * post- answer. */

#define CHP_OS_T1_Variant_ANI	0x380028	/* 3670056 */
typedef	UInt32	CHP_OS_T1_Variant_ANI_t;

#define CHP_OS_T1_Variant_ANIFormat_DTMF	0x1	/* 1 */

#define CHP_OS_T1_Variant_ANIFormat_MF	0x2	/* 2 */

#define CHP_OS_T1_Variant_ANIFormat_DP	0x3	/* 3 */

#define CHP_OS_T1_Variant_ANIFormat_FSK_US	0x4	/* 4 */

#define CHP_OS_T1_Variant_ANIFormat_FSK_JP	0x5	/* 5 */

#define CHP_OS_T1_Variant_ANIFormat_FSK_UK	0x6	/* 6 */
/* 
 * Format of ANI digits; DTMF, MF, DP FSK_US, FSK_JP, FSK_UK.
 * 
 * FSK_US: BellCore 202 FSK Modulation and ASCII character set.
 * FSK_JP: V.23 FSK Modulation and JIS character set.
 * FSK_UK: BellCore 202 Modulation , ONHOOK reception before first ring. Need
 * To detect polarity reversal. */

#define CHP_OS_T1_Variant_ANIFormat	0x38002c	/* 3670060 */
typedef	UInt32	CHP_OS_T1_Variant_ANIFormat_t;
/* 
 * Number of ANI digits to collect from incoming call.
 * 0 = as many as provided.
 */

#define CHP_OS_T1_Variant_ANICount	0x380030	/* 3670064 */
typedef	UInt32	CHP_OS_T1_Variant_ANICount_t;

#define CHP_OS_T1_Variant_DNIS_No	0	/* 0 */

#define CHP_OS_T1_Variant_DNIS_Yes	0x1	/* 1 */
/* 
 * Enables DNIS collection for inbound calls. 
 */

#define CHP_OS_T1_Variant_DNIS	0x380034	/* 3670068 */
typedef	UInt32	CHP_OS_T1_Variant_DNIS_t;

#define CHP_OS_T1_Variant_DNISFormat_DTMF	0x1	/* 1 */

#define CHP_OS_T1_Variant_DNISFormat_MF	0x2	/* 2 */

#define CHP_OS_T1_Variant_DNISFormat_DP	0x3	/* 3 */

#define CHP_OS_T1_Variant_DNISFormat_DTMF_DID_JP	0x4	/* 4 */
/* 
 * Format of DNIS digits; DTMF, MF, DP. [GSK]+ New format DTMF_DID_JP 
 * collects offhoook dtmf DNIS digits on NTT  lines. */

#define CHP_OS_T1_Variant_DNISFormat	0x380038	/* 3670072 */
typedef	UInt32	CHP_OS_T1_Variant_DNISFormat_t;
/* 
 * Number of DNIS digits to collect from incoming call.
 * 0 = as many as provided.
 */

#define CHP_OS_T1_Variant_DNISCount	0x38003c	/* 3670076 */
typedef	UInt32	CHP_OS_T1_Variant_DNISCount_t;
/* Defines the maximum amount of time that the protocol will wait to receive 
 * digits once a call has been initiated. E&M wink-start protocols start this 
 * time from the end of the wink. Units of 10ms. */

#define CHP_OS_T1_Variant_PreDigitTimeout	0x380040	/* 3670080 */
typedef	UInt32	CHP_OS_T1_Variant_PreDigitTimeout_t;
/*
 * Maximum amount of time between digits.  If a digit is not followed by another 
 * within this time limit then digit collection is terminated.  Units of 10ms.
 */

#define CHP_OS_T1_Variant_InterDigitTimeout	0x380044	/* 3670084 */
typedef	UInt32	CHP_OS_T1_Variant_InterDigitTimeout_t;

#define CHP_OS_T1_Variant_CallProgress_No	0	/* 0 */

#define CHP_OS_T1_Variant_CallProgress_Yes	0x1	/* 1 */
/* 
 * Enable Call Progress Detection for call setup.
 */

#define CHP_OS_T1_Variant_CallProgress	0x380048	/* 3670088 */
typedef	UInt32	CHP_OS_T1_Variant_CallProgress_t;
/* 
 * The Signal Set used to detect ringing for Call Progress Analysis.
 */

#define CHP_OS_T1_Variant_CaRingingSet	0x38004c	/* 3670092 */
typedef	UInt32	CHP_OS_T1_Variant_CaRingingSet_t;
/* 
 * The Signal Set used to detect busy for Call Progress Analysis.
 */

#define CHP_OS_T1_Variant_CaBusySet	0x380050	/* 3670096 */
typedef	UInt32	CHP_OS_T1_Variant_CaBusySet_t;
/* 
 * The Signal Set used to detect SIT tones for Call Progress Analysis.
 */

#define CHP_OS_T1_Variant_CaSitSet	0x380054	/* 3670100 */
typedef	UInt32	CHP_OS_T1_Variant_CaSitSet_t;
/* 
 * The Signal Set used to detect Fax tones for Call Progress Analysis.
 */

#define CHP_OS_T1_Variant_CaFaxSet	0x380058	/* 3670104 */
typedef	UInt32	CHP_OS_T1_Variant_CaFaxSet_t;
/* 
 * The signal Id to use for Positive Voice Detection in Call Progress Analysis.
 */

#define CHP_OS_T1_Variant_CaPvdId	0x38005c	/* 3670108 */
typedef	UInt32	CHP_OS_T1_Variant_CaPvdId_t;
/* 
 * The signal Id to use for Positive Answering Machine Detection in Call Progress 
 * Analysis.
 */

#define CHP_OS_T1_Variant_CaPamdId	0x380060	/* 3670112 */
typedef	UInt32	CHP_OS_T1_Variant_CaPamdId_t;
/* The maximum time to wait to detect a Call Progress tone from one of the 
 * Call Analysis signal sets. If this time is exceeded then the outbound call 
 * will fail with the reason being NoAnswer. Units of 10msec. */

#define CHP_OS_T1_Variant_CaSignalTimeout	0x380064	/* 3670116 */
typedef	UInt32	CHP_OS_T1_Variant_CaSignalTimeout_t;
/* This is the maximum time that Call Analysis will wait for Ringback to stop 
 * (i.e. equivalent to the number of rings). If this time is exceeded then the 
 * outbound call will fail with the reason being NoAnswer. Units of 10msec. */

#define CHP_OS_T1_Variant_CaAnswerTimeout	0x380068	/* 3670120 */
typedef	UInt32	CHP_OS_T1_Variant_CaAnswerTimeout_t;
/* This is the maximum time that Call Analysis will wait to detect PAMD or PVD 
 * once ringback has ceased. If this time is exceeded then connection type will 
 * be reported as ?Unknown? (i.e. not Fax, PAMD, or PVD). */

#define CHP_OS_T1_Variant_CaPvdTimeout	0x38006c	/* 3670124 */
typedef	UInt32	CHP_OS_T1_Variant_CaPvdTimeout_t;
/* 
 * The signal Id to use for Dial Tone detection.  Used for Loop Start protocols. 
 * If this is set to 0 (Null) then dial tone detection is not used. 
 */

#define CHP_OS_T1_Variant_DialToneId	0x380070	/* 3670128 */
typedef	UInt32	CHP_OS_T1_Variant_DialToneId_t;
/* This is the maximum time that the Dial funtion will wait for the Call 
 * Analysis component to return a result. If this time is exceeded then a Call 
 * Analysis timeout is reported. [GSK]+ */

#define CHP_OS_T1_Variant_CaDialTimeout	0x380074	/* 3670132 */
typedef	UInt32	CHP_OS_T1_Variant_CaDialTimeout_t;
/* T1 E&M Offhook CAS transition signal id. This signal is sent to make an 
 * outbound call, or to a nswer an incoming call. Receving this signal 
 * indicates that the nework is offering a call. */

#define CHP_OS_T1_Variant_EM_Offhook	0x380078	/* 3670136 */
typedef	UInt32	CHP_OS_T1_Variant_EM_Offhook_t;
/* T1 E&M Onhook CAS transition signal id.  This signal is sent to drop a call. */

#define CHP_OS_T1_Variant_EM_Onhook	0x38007c	/* 3670140 */
typedef	UInt32	CHP_OS_T1_Variant_EM_Onhook_t;
/* T1 E&M Onhook CAS transition signal id to use when flash-hook transfer is 
 * enabled.  This signal is sent to drop a call. */

#define CHP_OS_T1_Variant_EM_FlashOnhook	0x380080	/* 3670144 */
typedef	UInt32	CHP_OS_T1_Variant_EM_FlashOnhook_t;
/* T1 E&M Wink CAS pulse signal id. This signal is used as part of the inbound 
 * call setup for wink-start E&M protocols. Sent in response to EM_Offhook to 
 * tell the far end to proceed with the call. */

#define CHP_OS_T1_Variant_EM_Wink	0x380084	/* 3670148 */
typedef	UInt32	CHP_OS_T1_Variant_EM_Wink_t;
/* T1 E&M Flash CAS pulse signal id.  This signal is used to initiate a blind 
 * transfer while the call is connected. */

#define CHP_OS_T1_Variant_EM_Flash	0x380088	/* 3670152 */
typedef	UInt32	CHP_OS_T1_Variant_EM_Flash_t;
/* T1 LoopStart PBX Open CAS transition signal id.  This signal is sent to drop a 
 * call. */

#define CHP_OS_T1_Variant_LS_PBX_Open	0x38008c	/* 3670156 */
typedef	UInt32	CHP_OS_T1_Variant_LS_PBX_Open_t;
/* T1 LoopStart PBX Open CAS transition signal id to use when flash-hook 
 * transfer is enabled.  This signal is sent to drop a call. */

#define CHP_OS_T1_Variant_LS_PBX_FlashOpen	0x380090	/* 3670160 */
typedef	UInt32	CHP_OS_T1_Variant_LS_PBX_FlashOpen_t;
/* T1 LoopStart PBX Close CAS transition signal id.  This signal is sent to make 
 * an outbound call, or to answer an incoming call.  */

#define CHP_OS_T1_Variant_LS_PBX_Close	0x380094	/* 3670164 */
typedef	UInt32	CHP_OS_T1_Variant_LS_PBX_Close_t;
/* T1 LoopStart PBX Flash CAS pulse signal id . This signal is used to 
 * initiate a blind transfer while the call is connected. */

#define CHP_OS_T1_Variant_LS_PBX_Flash	0x380098	/* 3670168 */
typedef	UInt32	CHP_OS_T1_Variant_LS_PBX_Flash_t;
/* T1 LoopStart Net Answer CAS transition signal id.  Receiving this signal 
 * indicates that the network has answered an outbound call. */

#define CHP_OS_T1_Variant_LS_Net_Answer	0x38009c	/* 3670172 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_Answer_t;
/* T1 LoopStart Net Drop CAS transition signal id.  Receiving this signal 
 * indicates that the nework has dropped the call. */

#define CHP_OS_T1_Variant_LS_Net_Drop	0x3800a0	/* 3670176 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_Drop_t;
/* T1 LoopStart Net Drop CAS transition signal id to use when flash-hook 
 * transfer is enabled. Receiving this signal indicates that the nework has 
 * dropped the call. */

#define CHP_OS_T1_Variant_LS_Net_FlashDrop	0x3800a4	/* 3670180 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_FlashDrop_t;
/* T1 LoopStart Net Abandon CAS transition signal id. Receiving this signal 
 * indicates that the network has dropped an offered call (i.e. ringing has 
 * stopped). */

#define CHP_OS_T1_Variant_LS_Net_Abandon	0x3800a8	/* 3670184 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_Abandon_t;
/* T1 LoopStart Net RingOn CAS transition signal id. Receiving this signal 
 * indicates that the network is ?ringing? the line, and an inbound call is 
 * offered. This is the leading edge of the ring. */

#define CHP_OS_T1_Variant_LS_Net_RingOn	0x3800ac	/* 3670188 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_RingOn_t;
/* T1 LoopStart Net RingOff CAS transition signal id. Receiving this signal 
 * indicates that the network is ?ringing? the line, and an inbound call is 
 * offered. This is the leading edge of the ring. */

#define CHP_OS_T1_Variant_LS_Net_RingOff	0x3800b0	/* 3670192 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_RingOff_t;
/* T1 GroundStart PBX Ground CAS transition signal id.  This signal is sent to 
 * make an outbound call.  */

#define CHP_OS_T1_Variant_GS_PBX_Ground	0x3800b4	/* 3670196 */
typedef	UInt32	CHP_OS_T1_Variant_GS_PBX_Ground_t;
/* T1 GroundStart PBX Answer CAS transition signal id.  This signal is sent to 
 * answer an incoming call.  */

#define CHP_OS_T1_Variant_GS_PBX_Answer	0x3800b8	/* 3670200 */
typedef	UInt32	CHP_OS_T1_Variant_GS_PBX_Answer_t;
/* T1 GroundStart PBX Release CAS transition signal id. */

#define CHP_OS_T1_Variant_GS_PBX_Release	0x3800bc	/* 3670204 */
typedef	UInt32	CHP_OS_T1_Variant_GS_PBX_Release_t;
/* T1 GroundStart PBX Drop CAS transition signal id.  This signal is sent to drop 
 * a call. */

#define CHP_OS_T1_Variant_GS_PBX_Drop	0x3800c0	/* 3670208 */
typedef	UInt32	CHP_OS_T1_Variant_GS_PBX_Drop_t;
/*  T1 GroundStart PBX Drop CAS transition signal id to use when flash-hook 
 * transfer is enabled.  This signal is sent to drop a call. */

#define CHP_OS_T1_Variant_GS_PBX_FlashDrop	0x3800c4	/* 3670212 */
typedef	UInt32	CHP_OS_T1_Variant_GS_PBX_FlashDrop_t;
/* T1 GroundStart PBX Flash CAS pulse signal id . This signal is used to 
 * initiate a blind transfer while the call is connected. */

#define CHP_OS_T1_Variant_GS_PBX_Flash	0x3800c8	/* 3670216 */
typedef	UInt32	CHP_OS_T1_Variant_GS_PBX_Flash_t;
/* T1 GroundStart Net Ground CAS transition signal id. Receiving this signal 
 * indicates that the network has answered an outbound call, or that the 
 * network is offering an inbound call. */

#define CHP_OS_T1_Variant_GS_Net_Ground	0x3800cc	/* 3670220 */
typedef	UInt32	CHP_OS_T1_Variant_GS_Net_Ground_t;
/* T1 GroundStart Net Drop CAS transition signal id.  Receiving this signal 
 * indicates that the nework has dropped the call. */

#define CHP_OS_T1_Variant_GS_Net_Drop	0x3800d0	/* 3670224 */
typedef	UInt32	CHP_OS_T1_Variant_GS_Net_Drop_t;
/* T1 GroundStart Net Drop CAS transition signal id to use when flash-hook 
 * transfer is enabled. Receiving this signal indicates that the nework has 
 * dropped the call. */

#define CHP_OS_T1_Variant_GS_Net_FlashDrop	0x3800d4	/* 3670228 */
typedef	UInt32	CHP_OS_T1_Variant_GS_Net_FlashDrop_t;
/* T1 GroundStart Net RingOn CAS transition signal id. Receiving this signal 
 * indicates that the network is ?ringing? the line, and an inbound call is 
 * offered. This is the leading edge of the ring. */

#define CHP_OS_T1_Variant_GS_Net_RingOn	0x3800d8	/* 3670232 */
typedef	UInt32	CHP_OS_T1_Variant_GS_Net_RingOn_t;
/* T1 GroundStart Net RingOff CAS transition signal id. Receiving this signal 
 * indicates that the network is ?ringing? the line, and an inbound call is 
 * offered. This is the leading edge of the ring. */

#define CHP_OS_T1_Variant_GS_Net_RingOff	0x3800dc	/* 3670236 */
typedef	UInt32	CHP_OS_T1_Variant_GS_Net_RingOff_t;

#define CHP_OS_T1_Variant_PolarityDetection_No	0	/* 0 */

#define CHP_OS_T1_Variant_PolarityDetection_Yes	0x1	/* 1 */
/* The Battery Reversal is used as an indication of beginning of call set up 
 * in this T1-Loopstart protocol. */

#define CHP_OS_T1_Variant_PolarityDetection	0x3800e0	/* 3670240 */
typedef	UInt32	CHP_OS_T1_Variant_PolarityDetection_t;
/* Signal Id of the definition of T1-Loopstart Net Polarity Inversion Bits */

#define CHP_OS_T1_Variant_LS_Net_PolarityInversion	0x3800e4	/* 3670244 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_PolarityInversion_t;
/* Signal Id of the definition of T1-Loopstart Net Polarity Normal Bits */

#define CHP_OS_T1_Variant_LS_Net_PolarityNormal	0x3800e8	/* 3670248 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_PolarityNormal_t;
/* The special ring (CAR) used by NTT/CO before sending caller id data */

#define CHP_OS_T1_Variant_LS_Net_CIDRingOn	0x3800ec	/* 3670252 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_CIDRingOn_t;
/* CAR definition signal id */

#define CHP_OS_T1_Variant_LS_Net_CIDRingOff	0x3800f0	/* 3670256 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_CIDRingOff_t;
/* Defines the number of ring cycles generated by a TSC_MsgMakeCall for a 
 * LSFXO protocol, before failing the makecall. [ci]+*/

#define CHP_OS_T1_Variant_LS_Net_NumberOfRingCycles	0x3800f4	/* 3670260 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_NumberOfRingCycles_t;
/* Defines the first of a set of template Ids used to generate different rings 
 * by a TSC_MsgMakeCall for a LSFXO protocol. The set will be composed of 16 
 * pairs of LS_Net_RingOn/ LS_Net_RingOff type signaling templates. [ci]+ */

#define CHP_OS_T1_Variant_LS_Net_TransmitRingSet	0x3800f8	/* 3670264 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_TransmitRingSet_t;
/* This defines the pair of LS_Net_RingOn/ LS_Net_RingOff type signaling 
 * templates from LS_Net_TransmitRingSet table that will be used by 
 * TSC_MsgMakeCall to generate a ring to a station. It has to be a number 
 * between 1 and 16. If this number is set to 0, LS_Net_RingOn / LS_Net_RingOff 
 * variant signals will be used to generate the ring to a station for LSFXO 
 * protocol. [ci]+ */

#define CHP_OS_T1_Variant_LS_Net_ActiveTransmitRingId	0x3800fc	/* 3670268 */
typedef	UInt32	CHP_OS_T1_Variant_LS_Net_ActiveTransmitRingId_t;
/* 
 * The signal id for Hook Flash is expected to be located at this location.
 */

#define CHP_OS_T1_Variant_CAS_SigId1	0x380100	/* 3670272 */
typedef	UInt32	CHP_OS_T1_Variant_CAS_SigId1_t;
/* 
 * The signal id for next CAS template in the table.
 */

#define CHP_OS_T1_Variant_CAS_SigId2	0x380104	/* 3670276 */
typedef	UInt32	CHP_OS_T1_Variant_CAS_SigId2_t;
/* 
 * The signal id for next CAS template in the table.
 */

#define CHP_OS_T1_Variant_CAS_SigId3	0x380108	/* 3670280 */
typedef	UInt32	CHP_OS_T1_Variant_CAS_SigId3_t;
/* 
 * The signal id for next CAS template in the table.
 */

#define CHP_OS_T1_Variant_CAS_SigId4	0x38010c	/* 3670284 */
typedef	UInt32	CHP_OS_T1_Variant_CAS_SigId4_t;
/* 
 * The signal id for next CAS template in the table.
 */

#define CHP_OS_T1_Variant_CAS_SigId5	0x380110	/* 3670288 */
typedef	UInt32	CHP_OS_T1_Variant_CAS_SigId5_t;
/* 
 * The signal id L for Local Dial Tone.
 */

#define CHP_OS_T1_Variant_Tone_SigId1	0x380114	/* 3670292 */
typedef	UInt32	CHP_OS_T1_Variant_Tone_SigId1_t;
/* 
 * The signal Id for international dial tone I is expected at this location.
 */

#define CHP_OS_T1_Variant_Tone_SigId2	0x380118	/* 3670296 */
typedef	UInt32	CHP_OS_T1_Variant_Tone_SigId2_t;
/* 
 * The signal ID X is expected at this location. Some X dial tone.
 */

#define CHP_OS_T1_Variant_Tone_SigId3	0x38011c	/* 3670300 */
typedef	UInt32	CHP_OS_T1_Variant_Tone_SigId3_t;
/* 
 * The signal id for next Tone template in the table.
 */

#define CHP_OS_T1_Variant_Tone_SigId4	0x380120	/* 3670304 */
typedef	UInt32	CHP_OS_T1_Variant_Tone_SigId4_t;
/* 
 * The signal id for next Tone template in the table.
 */

#define CHP_OS_T1_Variant_Tone_SigId5	0x380124	/* 3670308 */
typedef	UInt32	CHP_OS_T1_Variant_Tone_SigId5_t;

#define CHP_OS_T1_Variant_BlindTransfer_No	0	/* 0 */

#define CHP_OS_T1_Variant_BlindTransfer_Yes	0x1	/* 1 */
/* 
 * Enable Blind Transfer.
 */

#define CHP_OS_T1_Variant_BlindTransfer	0x380128	/* 3670312 */
typedef	UInt32	CHP_OS_T1_Variant_BlindTransfer_t;
/* Signal Id to use for Dial Tone detection in a Blind Transfer. If 
 * BtDialToneId is 0 then the protocol will wait for a time period 
 * (BtStartTimeout) before sending digits after generating a Flash. */

#define CHP_OS_T1_Variant_BtDialToneId	0x38012c	/* 3670316 */
typedef	UInt32	CHP_OS_T1_Variant_BtDialToneId_t;
/* When BtDialToneId is nonzero, BtStartTimeout is the maximum time that the 
 * protocol will wait for detecting Dial Tone after a Flash has been generated 
 * before failing the transfer and returning to ?Connected? with the reason 
 * being ProtocolError. If BtDialToneId is zero, BtStartTimeout is the time 
 * period that the protocol will wait after a Flash has been generated before 
 * sending digits. */

#define CHP_OS_T1_Variant_BtStartTimeout	0x380130	/* 3670320 */
typedef	UInt32	CHP_OS_T1_Variant_BtStartTimeout_t;

#define CHP_OS_T1_Variant_BtAddressDef_None	0	/* 0 */

#define CHP_OS_T1_Variant_BtAddressDef_Dest	0x1	/* 1 */

#define CHP_OS_T1_Variant_BtAddressDef_Orig	0x2	/* 2 */

#define CHP_OS_T1_Variant_BtAddressDef_DestOrig	0x3	/* 3 */

#define CHP_OS_T1_Variant_BtAddressDef_OrigDest	0x4	/* 4 */
/* Defines what addresses will be sent on a blind transfer, and the order in 
 * which they will be sent. */

#define CHP_OS_T1_Variant_BtAddressDef	0x380134	/* 3670324 */
typedef	UInt32	CHP_OS_T1_Variant_BtAddressDef_t;

#define CHP_OS_T1_Variant_BtOrigFormat_DTMF	0x1	/* 1 */

#define CHP_OS_T1_Variant_BtOrigFormat_MF	0x2	/* 2 */

#define CHP_OS_T1_Variant_BtOrigFormat_DP	0x3	/* 3 */
/* 
 * Format of Originator address digits in a blind transfer; DTMF, MF, DP. 
 */

#define CHP_OS_T1_Variant_BtOrigFormat	0x380138	/* 3670328 */
typedef	UInt32	CHP_OS_T1_Variant_BtOrigFormat_t;

#define CHP_OS_T1_Variant_BtDestFormat_DTMF	0x1	/* 1 */

#define CHP_OS_T1_Variant_BtDestFormat_MF	0x2	/* 2 */

#define CHP_OS_T1_Variant_BtDestFormat_DP	0x3	/* 3 */
/* 
 * Format of Destination address digits in a blind transfer; DTMF, MF, DP. 
 */

#define CHP_OS_T1_Variant_BtDestFormat	0x38013c	/* 3670332 */
typedef	UInt32	CHP_OS_T1_Variant_BtDestFormat_t;

#define CHP_OS_T1_Variant_BtCancelDigitsFormat_DTMF	0x1	/* 1 */

#define CHP_OS_T1_Variant_BtCancelDigitsFormat_MF	0x2	/* 2 */

#define CHP_OS_T1_Variant_BtCancelDigitsFormat_DP	0x3	/* 3 */
/* 
 * Format of Cancel digits in a blind transfer; DTMF, MF, DP. 
 */

#define CHP_OS_T1_Variant_BtCancelDigitsFormat	0x380140	/* 3670336 */
typedef	UInt32	CHP_OS_T1_Variant_BtCancelDigitsFormat_t;
/*
 * Number of flashes to be sent to cancel or abort a transfer.
 */

#define CHP_OS_T1_Variant_BtCancelFlashCount	0x380144	/* 3670340 */
typedef	UInt32	CHP_OS_T1_Variant_BtCancelFlashCount_t;
/*
 * Time between flashes for canceling or aborting a transfer.
 */

#define CHP_OS_T1_Variant_BtCancelInterFlashDuration	0x380148	/* 3670344 */
typedef	UInt32	CHP_OS_T1_Variant_BtCancelInterFlashDuration_t;
/*
 * Digits to dial after the flash sequence in a cancel or abort.
 */

#define CHP_OS_T1_Variant_BtCancelDigits	0x50994c	/* 5282124 */
typedef	Char	CHP_OS_T1_Variant_BtCancelDigits_t[20];
/* 
 * Digits to be dialed immediately following the Destination Address in a Blind 
 * Transfer.
 */

#define CHP_OS_T1_Variant_BtDestSuffix	0x509960	/* 5282144 */
typedef	Char	CHP_OS_T1_Variant_BtDestSuffix_t[20];
/* Digits to be dialed immediately before the Destination Address in a Blind 
 * Transfer. */

#define CHP_OS_T1_Variant_BtDestPrefix	0x509974	/* 5282164 */
typedef	Char	CHP_OS_T1_Variant_BtDestPrefix_t[20];
/* 
 * Digits to be dialed immediately before the Originator?s Address in a Blind 
 * Transfer.
 */

#define CHP_OS_T1_Variant_BtOrigPrefix	0x509988	/* 5282184 */
typedef	Char	CHP_OS_T1_Variant_BtOrigPrefix_t[20];
/* 
 * Digits to be dialed immediately following the Originator?s Address in a Blind 
 * Transfer.
 */

#define CHP_OS_T1_Variant_BtOrigSuffix	0x50999c	/* 5282204 */
typedef	Char	CHP_OS_T1_Variant_BtOrigSuffix_t[20];
/* 
 * CA parameter to provide Springware-compatible configuration.  
 * There are 3 8-bit parameters packed in this 32-bit value.  The 
 * parameters are:  Hedge, Logltch, and Higltch
 */

#define CHP_OS_T1_Variant_CaHdgLoHiGl	0x3801b0	/* 3670448 */
typedef	UInt32	CHP_OS_T1_Variant_CaHdgLoHiGl_t;
/*
 * CA parameter to provide Springware-compatible configuration.  
 * There is 1 16-bit parameter and 1 8-bit parameter packed in this 32-
 * bit value.  The parameters are:  Ansrdgl (16-bit)  PamdSpdval (8-
 * bit)
 *  */

#define CHP_OS_T1_Variant_CaAnsdglPSV	0x3801b4	/* 3670452 */
typedef	UInt32	CHP_OS_T1_Variant_CaAnsdglPSV_t;


typedef struct {
	UInt32	ProtocolType;
	UInt32	Wink;
	UInt32	StartTimeout;
	UInt32	FarEndAnswer;
	UInt32	AnswerTimeout;
	UInt32	ReconnectTimeout;
	UInt32	DisconnectTimeout;
	UInt32	InterCallDelay;
	UInt32	Dial;
	UInt32	DialFormat;
	UInt32	ANI;
	UInt32	ANIFormat;
	UInt32	ANICount;
	UInt32	DNIS;
	UInt32	DNISFormat;
	UInt32	DNISCount;
	UInt32	PreDigitTimeout;
	UInt32	InterDigitTimeout;
	UInt32	CallProgress;
	UInt32	CaRingingSet;
	UInt32	CaBusySet;
	UInt32	CaSitSet;
	UInt32	CaFaxSet;
	UInt32	CaPvdId;
	UInt32	CaPamdId;
	UInt32	CaSignalTimeout;
	UInt32	CaAnswerTimeout;
	UInt32	CaPvdTimeout;
	UInt32	DialToneId;
	UInt32	CaDialTimeout;
	UInt32	EM_Offhook;
	UInt32	EM_Onhook;
	UInt32	EM_FlashOnhook;
	UInt32	EM_Wink;
	UInt32	EM_Flash;
	UInt32	LS_PBX_Open;
	UInt32	LS_PBX_FlashOpen;
	UInt32	LS_PBX_Close;
	UInt32	LS_PBX_Flash;
	UInt32	LS_Net_Answer;
	UInt32	LS_Net_Drop;
	UInt32	LS_Net_FlashDrop;
	UInt32	LS_Net_Abandon;
	UInt32	LS_Net_RingOn;
	UInt32	LS_Net_RingOff;
	UInt32	GS_PBX_Ground;
	UInt32	GS_PBX_Answer;
	UInt32	GS_PBX_Release;
	UInt32	GS_PBX_Drop;
	UInt32	GS_PBX_FlashDrop;
	UInt32	GS_PBX_Flash;
	UInt32	GS_Net_Ground;
	UInt32	GS_Net_Drop;
	UInt32	GS_Net_FlashDrop;
	UInt32	GS_Net_RingOn;
	UInt32	GS_Net_RingOff;
	UInt32	PolarityDetection;
	UInt32	LS_Net_PolarityInversion;
	UInt32	LS_Net_PolarityNormal;
	UInt32	LS_Net_CIDRingOn;
	UInt32	LS_Net_CIDRingOff;
	UInt32	LS_Net_NumberOfRingCycles;
	UInt32	LS_Net_TransmitRingSet;
	UInt32	LS_Net_ActiveTransmitRingId;
	UInt32	CAS_SigId1;
	UInt32	CAS_SigId2;
	UInt32	CAS_SigId3;
	UInt32	CAS_SigId4;
	UInt32	CAS_SigId5;
	UInt32	Tone_SigId1;
	UInt32	Tone_SigId2;
	UInt32	Tone_SigId3;
	UInt32	Tone_SigId4;
	UInt32	Tone_SigId5;
	UInt32	BlindTransfer;
	UInt32	BtDialToneId;
	UInt32	BtStartTimeout;
	UInt32	BtAddressDef;
	UInt32	BtOrigFormat;
	UInt32	BtDestFormat;
	UInt32	BtCancelDigitsFormat;
	UInt32	BtCancelFlashCount;
	UInt32	BtCancelInterFlashDuration;
	Char	BtCancelDigits[20];
	Char	BtDestSuffix[20];
	Char	BtDestPrefix[20];
	Char	BtOrigPrefix[20];
	Char	BtOrigSuffix[20];
	UInt32	CaHdgLoHiGl;
	UInt32	CaAnsdglPSV;
} CHP_OS_T1_Variant_t;

#define CHP_OS_T1_Variant_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 90, &(offset),	\
			(CHP_OS_T1_Variant_ProtocolType), &((structAddr)->ProtocolType),	\
			(CHP_OS_T1_Variant_Wink), &((structAddr)->Wink),	\
			(CHP_OS_T1_Variant_StartTimeout), &((structAddr)->StartTimeout),	\
			(CHP_OS_T1_Variant_FarEndAnswer), &((structAddr)->FarEndAnswer),	\
			(CHP_OS_T1_Variant_AnswerTimeout), &((structAddr)->AnswerTimeout),	\
			(CHP_OS_T1_Variant_ReconnectTimeout), &((structAddr)->ReconnectTimeout),	\
			(CHP_OS_T1_Variant_DisconnectTimeout), &((structAddr)->DisconnectTimeout),	\
			(CHP_OS_T1_Variant_InterCallDelay), &((structAddr)->InterCallDelay),	\
			(CHP_OS_T1_Variant_Dial), &((structAddr)->Dial),	\
			(CHP_OS_T1_Variant_DialFormat), &((structAddr)->DialFormat),	\
			(CHP_OS_T1_Variant_ANI), &((structAddr)->ANI),	\
			(CHP_OS_T1_Variant_ANIFormat), &((structAddr)->ANIFormat),	\
			(CHP_OS_T1_Variant_ANICount), &((structAddr)->ANICount),	\
			(CHP_OS_T1_Variant_DNIS), &((structAddr)->DNIS),	\
			(CHP_OS_T1_Variant_DNISFormat), &((structAddr)->DNISFormat),	\
			(CHP_OS_T1_Variant_DNISCount), &((structAddr)->DNISCount),	\
			(CHP_OS_T1_Variant_PreDigitTimeout), &((structAddr)->PreDigitTimeout),	\
			(CHP_OS_T1_Variant_InterDigitTimeout), &((structAddr)->InterDigitTimeout),	\
			(CHP_OS_T1_Variant_CallProgress), &((structAddr)->CallProgress),	\
			(CHP_OS_T1_Variant_CaRingingSet), &((structAddr)->CaRingingSet),	\
			(CHP_OS_T1_Variant_CaBusySet), &((structAddr)->CaBusySet),	\
			(CHP_OS_T1_Variant_CaSitSet), &((structAddr)->CaSitSet),	\
			(CHP_OS_T1_Variant_CaFaxSet), &((structAddr)->CaFaxSet),	\
			(CHP_OS_T1_Variant_CaPvdId), &((structAddr)->CaPvdId),	\
			(CHP_OS_T1_Variant_CaPamdId), &((structAddr)->CaPamdId),	\
			(CHP_OS_T1_Variant_CaSignalTimeout), &((structAddr)->CaSignalTimeout),	\
			(CHP_OS_T1_Variant_CaAnswerTimeout), &((structAddr)->CaAnswerTimeout),	\
			(CHP_OS_T1_Variant_CaPvdTimeout), &((structAddr)->CaPvdTimeout),	\
			(CHP_OS_T1_Variant_DialToneId), &((structAddr)->DialToneId),	\
			(CHP_OS_T1_Variant_CaDialTimeout), &((structAddr)->CaDialTimeout),	\
			(CHP_OS_T1_Variant_EM_Offhook), &((structAddr)->EM_Offhook),	\
			(CHP_OS_T1_Variant_EM_Onhook), &((structAddr)->EM_Onhook),	\
			(CHP_OS_T1_Variant_EM_FlashOnhook), &((structAddr)->EM_FlashOnhook),	\
			(CHP_OS_T1_Variant_EM_Wink), &((structAddr)->EM_Wink),	\
			(CHP_OS_T1_Variant_EM_Flash), &((structAddr)->EM_Flash),	\
			(CHP_OS_T1_Variant_LS_PBX_Open), &((structAddr)->LS_PBX_Open),	\
			(CHP_OS_T1_Variant_LS_PBX_FlashOpen), &((structAddr)->LS_PBX_FlashOpen),	\
			(CHP_OS_T1_Variant_LS_PBX_Close), &((structAddr)->LS_PBX_Close),	\
			(CHP_OS_T1_Variant_LS_PBX_Flash), &((structAddr)->LS_PBX_Flash),	\
			(CHP_OS_T1_Variant_LS_Net_Answer), &((structAddr)->LS_Net_Answer),	\
			(CHP_OS_T1_Variant_LS_Net_Drop), &((structAddr)->LS_Net_Drop),	\
			(CHP_OS_T1_Variant_LS_Net_FlashDrop), &((structAddr)->LS_Net_FlashDrop),	\
			(CHP_OS_T1_Variant_LS_Net_Abandon), &((structAddr)->LS_Net_Abandon),	\
			(CHP_OS_T1_Variant_LS_Net_RingOn), &((structAddr)->LS_Net_RingOn),	\
			(CHP_OS_T1_Variant_LS_Net_RingOff), &((structAddr)->LS_Net_RingOff),	\
			(CHP_OS_T1_Variant_GS_PBX_Ground), &((structAddr)->GS_PBX_Ground),	\
			(CHP_OS_T1_Variant_GS_PBX_Answer), &((structAddr)->GS_PBX_Answer),	\
			(CHP_OS_T1_Variant_GS_PBX_Release), &((structAddr)->GS_PBX_Release),	\
			(CHP_OS_T1_Variant_GS_PBX_Drop), &((structAddr)->GS_PBX_Drop),	\
			(CHP_OS_T1_Variant_GS_PBX_FlashDrop), &((structAddr)->GS_PBX_FlashDrop),	\
			(CHP_OS_T1_Variant_GS_PBX_Flash), &((structAddr)->GS_PBX_Flash),	\
			(CHP_OS_T1_Variant_GS_Net_Ground), &((structAddr)->GS_Net_Ground),	\
			(CHP_OS_T1_Variant_GS_Net_Drop), &((structAddr)->GS_Net_Drop),	\
			(CHP_OS_T1_Variant_GS_Net_FlashDrop), &((structAddr)->GS_Net_FlashDrop),	\
			(CHP_OS_T1_Variant_GS_Net_RingOn), &((structAddr)->GS_Net_RingOn),	\
			(CHP_OS_T1_Variant_GS_Net_RingOff), &((structAddr)->GS_Net_RingOff),	\
			(CHP_OS_T1_Variant_PolarityDetection), &((structAddr)->PolarityDetection),	\
			(CHP_OS_T1_Variant_LS_Net_PolarityInversion), &((structAddr)->LS_Net_PolarityInversion),	\
			(CHP_OS_T1_Variant_LS_Net_PolarityNormal), &((structAddr)->LS_Net_PolarityNormal),	\
			(CHP_OS_T1_Variant_LS_Net_CIDRingOn), &((structAddr)->LS_Net_CIDRingOn),	\
			(CHP_OS_T1_Variant_LS_Net_CIDRingOff), &((structAddr)->LS_Net_CIDRingOff),	\
			(CHP_OS_T1_Variant_LS_Net_NumberOfRingCycles), &((structAddr)->LS_Net_NumberOfRingCycles),	\
			(CHP_OS_T1_Variant_LS_Net_TransmitRingSet), &((structAddr)->LS_Net_TransmitRingSet),	\
			(CHP_OS_T1_Variant_LS_Net_ActiveTransmitRingId), &((structAddr)->LS_Net_ActiveTransmitRingId),	\
			(CHP_OS_T1_Variant_CAS_SigId1), &((structAddr)->CAS_SigId1),	\
			(CHP_OS_T1_Variant_CAS_SigId2), &((structAddr)->CAS_SigId2),	\
			(CHP_OS_T1_Variant_CAS_SigId3), &((structAddr)->CAS_SigId3),	\
			(CHP_OS_T1_Variant_CAS_SigId4), &((structAddr)->CAS_SigId4),	\
			(CHP_OS_T1_Variant_CAS_SigId5), &((structAddr)->CAS_SigId5),	\
			(CHP_OS_T1_Variant_Tone_SigId1), &((structAddr)->Tone_SigId1),	\
			(CHP_OS_T1_Variant_Tone_SigId2), &((structAddr)->Tone_SigId2),	\
			(CHP_OS_T1_Variant_Tone_SigId3), &((structAddr)->Tone_SigId3),	\
			(CHP_OS_T1_Variant_Tone_SigId4), &((structAddr)->Tone_SigId4),	\
			(CHP_OS_T1_Variant_Tone_SigId5), &((structAddr)->Tone_SigId5),	\
			(CHP_OS_T1_Variant_BlindTransfer), &((structAddr)->BlindTransfer),	\
			(CHP_OS_T1_Variant_BtDialToneId), &((structAddr)->BtDialToneId),	\
			(CHP_OS_T1_Variant_BtStartTimeout), &((structAddr)->BtStartTimeout),	\
			(CHP_OS_T1_Variant_BtAddressDef), &((structAddr)->BtAddressDef),	\
			(CHP_OS_T1_Variant_BtOrigFormat), &((structAddr)->BtOrigFormat),	\
			(CHP_OS_T1_Variant_BtDestFormat), &((structAddr)->BtDestFormat),	\
			(CHP_OS_T1_Variant_BtCancelDigitsFormat), &((structAddr)->BtCancelDigitsFormat),	\
			(CHP_OS_T1_Variant_BtCancelFlashCount), &((structAddr)->BtCancelFlashCount),	\
			(CHP_OS_T1_Variant_BtCancelInterFlashDuration), &((structAddr)->BtCancelInterFlashDuration),	\
			(CHP_OS_T1_Variant_BtCancelDigits), &((structAddr)->BtCancelDigits),	\
			(CHP_OS_T1_Variant_BtDestSuffix), &((structAddr)->BtDestSuffix),	\
			(CHP_OS_T1_Variant_BtDestPrefix), &((structAddr)->BtDestPrefix),	\
			(CHP_OS_T1_Variant_BtOrigPrefix), &((structAddr)->BtOrigPrefix),	\
			(CHP_OS_T1_Variant_BtOrigSuffix), &((structAddr)->BtOrigSuffix),	\
			(CHP_OS_T1_Variant_CaHdgLoHiGl), &((structAddr)->CaHdgLoHiGl),	\
			(CHP_OS_T1_Variant_CaAnsdglPSV), &((structAddr)->CaAnsdglPSV))


#define CHP_OS_T1_Variant_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 90, &(offset),	\
			(CHP_OS_T1_Variant_ProtocolType), &((structAddr)->ProtocolType),	\
			(CHP_OS_T1_Variant_Wink), &((structAddr)->Wink),	\
			(CHP_OS_T1_Variant_StartTimeout), &((structAddr)->StartTimeout),	\
			(CHP_OS_T1_Variant_FarEndAnswer), &((structAddr)->FarEndAnswer),	\
			(CHP_OS_T1_Variant_AnswerTimeout), &((structAddr)->AnswerTimeout),	\
			(CHP_OS_T1_Variant_ReconnectTimeout), &((structAddr)->ReconnectTimeout),	\
			(CHP_OS_T1_Variant_DisconnectTimeout), &((structAddr)->DisconnectTimeout),	\
			(CHP_OS_T1_Variant_InterCallDelay), &((structAddr)->InterCallDelay),	\
			(CHP_OS_T1_Variant_Dial), &((structAddr)->Dial),	\
			(CHP_OS_T1_Variant_DialFormat), &((structAddr)->DialFormat),	\
			(CHP_OS_T1_Variant_ANI), &((structAddr)->ANI),	\
			(CHP_OS_T1_Variant_ANIFormat), &((structAddr)->ANIFormat),	\
			(CHP_OS_T1_Variant_ANICount), &((structAddr)->ANICount),	\
			(CHP_OS_T1_Variant_DNIS), &((structAddr)->DNIS),	\
			(CHP_OS_T1_Variant_DNISFormat), &((structAddr)->DNISFormat),	\
			(CHP_OS_T1_Variant_DNISCount), &((structAddr)->DNISCount),	\
			(CHP_OS_T1_Variant_PreDigitTimeout), &((structAddr)->PreDigitTimeout),	\
			(CHP_OS_T1_Variant_InterDigitTimeout), &((structAddr)->InterDigitTimeout),	\
			(CHP_OS_T1_Variant_CallProgress), &((structAddr)->CallProgress),	\
			(CHP_OS_T1_Variant_CaRingingSet), &((structAddr)->CaRingingSet),	\
			(CHP_OS_T1_Variant_CaBusySet), &((structAddr)->CaBusySet),	\
			(CHP_OS_T1_Variant_CaSitSet), &((structAddr)->CaSitSet),	\
			(CHP_OS_T1_Variant_CaFaxSet), &((structAddr)->CaFaxSet),	\
			(CHP_OS_T1_Variant_CaPvdId), &((structAddr)->CaPvdId),	\
			(CHP_OS_T1_Variant_CaPamdId), &((structAddr)->CaPamdId),	\
			(CHP_OS_T1_Variant_CaSignalTimeout), &((structAddr)->CaSignalTimeout),	\
			(CHP_OS_T1_Variant_CaAnswerTimeout), &((structAddr)->CaAnswerTimeout),	\
			(CHP_OS_T1_Variant_CaPvdTimeout), &((structAddr)->CaPvdTimeout),	\
			(CHP_OS_T1_Variant_DialToneId), &((structAddr)->DialToneId),	\
			(CHP_OS_T1_Variant_CaDialTimeout), &((structAddr)->CaDialTimeout),	\
			(CHP_OS_T1_Variant_EM_Offhook), &((structAddr)->EM_Offhook),	\
			(CHP_OS_T1_Variant_EM_Onhook), &((structAddr)->EM_Onhook),	\
			(CHP_OS_T1_Variant_EM_FlashOnhook), &((structAddr)->EM_FlashOnhook),	\
			(CHP_OS_T1_Variant_EM_Wink), &((structAddr)->EM_Wink),	\
			(CHP_OS_T1_Variant_EM_Flash), &((structAddr)->EM_Flash),	\
			(CHP_OS_T1_Variant_LS_PBX_Open), &((structAddr)->LS_PBX_Open),	\
			(CHP_OS_T1_Variant_LS_PBX_FlashOpen), &((structAddr)->LS_PBX_FlashOpen),	\
			(CHP_OS_T1_Variant_LS_PBX_Close), &((structAddr)->LS_PBX_Close),	\
			(CHP_OS_T1_Variant_LS_PBX_Flash), &((structAddr)->LS_PBX_Flash),	\
			(CHP_OS_T1_Variant_LS_Net_Answer), &((structAddr)->LS_Net_Answer),	\
			(CHP_OS_T1_Variant_LS_Net_Drop), &((structAddr)->LS_Net_Drop),	\
			(CHP_OS_T1_Variant_LS_Net_FlashDrop), &((structAddr)->LS_Net_FlashDrop),	\
			(CHP_OS_T1_Variant_LS_Net_Abandon), &((structAddr)->LS_Net_Abandon),	\
			(CHP_OS_T1_Variant_LS_Net_RingOn), &((structAddr)->LS_Net_RingOn),	\
			(CHP_OS_T1_Variant_LS_Net_RingOff), &((structAddr)->LS_Net_RingOff),	\
			(CHP_OS_T1_Variant_GS_PBX_Ground), &((structAddr)->GS_PBX_Ground),	\
			(CHP_OS_T1_Variant_GS_PBX_Answer), &((structAddr)->GS_PBX_Answer),	\
			(CHP_OS_T1_Variant_GS_PBX_Release), &((structAddr)->GS_PBX_Release),	\
			(CHP_OS_T1_Variant_GS_PBX_Drop), &((structAddr)->GS_PBX_Drop),	\
			(CHP_OS_T1_Variant_GS_PBX_FlashDrop), &((structAddr)->GS_PBX_FlashDrop),	\
			(CHP_OS_T1_Variant_GS_PBX_Flash), &((structAddr)->GS_PBX_Flash),	\
			(CHP_OS_T1_Variant_GS_Net_Ground), &((structAddr)->GS_Net_Ground),	\
			(CHP_OS_T1_Variant_GS_Net_Drop), &((structAddr)->GS_Net_Drop),	\
			(CHP_OS_T1_Variant_GS_Net_FlashDrop), &((structAddr)->GS_Net_FlashDrop),	\
			(CHP_OS_T1_Variant_GS_Net_RingOn), &((structAddr)->GS_Net_RingOn),	\
			(CHP_OS_T1_Variant_GS_Net_RingOff), &((structAddr)->GS_Net_RingOff),	\
			(CHP_OS_T1_Variant_PolarityDetection), &((structAddr)->PolarityDetection),	\
			(CHP_OS_T1_Variant_LS_Net_PolarityInversion), &((structAddr)->LS_Net_PolarityInversion),	\
			(CHP_OS_T1_Variant_LS_Net_PolarityNormal), &((structAddr)->LS_Net_PolarityNormal),	\
			(CHP_OS_T1_Variant_LS_Net_CIDRingOn), &((structAddr)->LS_Net_CIDRingOn),	\
			(CHP_OS_T1_Variant_LS_Net_CIDRingOff), &((structAddr)->LS_Net_CIDRingOff),	\
			(CHP_OS_T1_Variant_LS_Net_NumberOfRingCycles), &((structAddr)->LS_Net_NumberOfRingCycles),	\
			(CHP_OS_T1_Variant_LS_Net_TransmitRingSet), &((structAddr)->LS_Net_TransmitRingSet),	\
			(CHP_OS_T1_Variant_LS_Net_ActiveTransmitRingId), &((structAddr)->LS_Net_ActiveTransmitRingId),	\
			(CHP_OS_T1_Variant_CAS_SigId1), &((structAddr)->CAS_SigId1),	\
			(CHP_OS_T1_Variant_CAS_SigId2), &((structAddr)->CAS_SigId2),	\
			(CHP_OS_T1_Variant_CAS_SigId3), &((structAddr)->CAS_SigId3),	\
			(CHP_OS_T1_Variant_CAS_SigId4), &((structAddr)->CAS_SigId4),	\
			(CHP_OS_T1_Variant_CAS_SigId5), &((structAddr)->CAS_SigId5),	\
			(CHP_OS_T1_Variant_Tone_SigId1), &((structAddr)->Tone_SigId1),	\
			(CHP_OS_T1_Variant_Tone_SigId2), &((structAddr)->Tone_SigId2),	\
			(CHP_OS_T1_Variant_Tone_SigId3), &((structAddr)->Tone_SigId3),	\
			(CHP_OS_T1_Variant_Tone_SigId4), &((structAddr)->Tone_SigId4),	\
			(CHP_OS_T1_Variant_Tone_SigId5), &((structAddr)->Tone_SigId5),	\
			(CHP_OS_T1_Variant_BlindTransfer), &((structAddr)->BlindTransfer),	\
			(CHP_OS_T1_Variant_BtDialToneId), &((structAddr)->BtDialToneId),	\
			(CHP_OS_T1_Variant_BtStartTimeout), &((structAddr)->BtStartTimeout),	\
			(CHP_OS_T1_Variant_BtAddressDef), &((structAddr)->BtAddressDef),	\
			(CHP_OS_T1_Variant_BtOrigFormat), &((structAddr)->BtOrigFormat),	\
			(CHP_OS_T1_Variant_BtDestFormat), &((structAddr)->BtDestFormat),	\
			(CHP_OS_T1_Variant_BtCancelDigitsFormat), &((structAddr)->BtCancelDigitsFormat),	\
			(CHP_OS_T1_Variant_BtCancelFlashCount), &((structAddr)->BtCancelFlashCount),	\
			(CHP_OS_T1_Variant_BtCancelInterFlashDuration), &((structAddr)->BtCancelInterFlashDuration),	\
			(CHP_OS_T1_Variant_BtCancelDigits), &((structAddr)->BtCancelDigits),	\
			(CHP_OS_T1_Variant_BtDestSuffix), &((structAddr)->BtDestSuffix),	\
			(CHP_OS_T1_Variant_BtDestPrefix), &((structAddr)->BtDestPrefix),	\
			(CHP_OS_T1_Variant_BtOrigPrefix), &((structAddr)->BtOrigPrefix),	\
			(CHP_OS_T1_Variant_BtOrigSuffix), &((structAddr)->BtOrigSuffix),	\
			(CHP_OS_T1_Variant_CaHdgLoHiGl), &((structAddr)->CaHdgLoHiGl),	\
			(CHP_OS_T1_Variant_CaAnsdglPSV), &((structAddr)->CaAnsdglPSV))


#define CHP_OS_T1_Variant_Size		440

#define CHP_OS_T1_Variant	0x103	/* 259 */
 
/* 
 * CHP Protocol Variant Parameter Identifiers for KVSet operations 
 */ 
 
/* Call Control Parameters */ 
#define CHP_VParm_StartTimeout		0x1383 
#define CHP_VParm_AnswerTimeout		0x1385 
#define CHP_VParm_ReconnectTimeout	0x1386 
#define CHP_VParm_DisconnectTimeout	0x1387 
#define CHP_VParm_DialFormat		0x138A 
#define CHP_VParm_ANIFormat		0x138C 
 
/* Call Analysis Parameters */ 
#define CHP_VParm_CaRingingSet		0x1394 
#define CHP_VParm_CaBusySet		0x1395 
#define CHP_VParm_CaSitSet			0x1396 
#define CHP_VParm_CaFaxSet			0x1397 
#define CHP_VParm_CaPvdId			0x1398 
#define CHP_VParm_CaPamdId		0x1399 
#define CHP_VParm_CaSignalTimeout		0x139a 
#define CHP_VParm_CaAnswerTimeout	0x139b 
#define CHP_VParm_CaPvdTimeout		0x139c 
#define CHP_VParm_DialToneId		0x139d
#define CHP_VParm_CaHdgLoHiGl		0x139e
#define CHP_VParm_CaAnsdglPSV		0x139f
 
 
/* Blind Transfer Parameters */ 
#define CHP_VParm_BtDialToneId		0x13b9 
#define CHP_VParm_BtStartTimeout		0x13ba
/* Variants to control the ring cadence in case of FXO protocols */
          #define CHP_VParm_LS_Net_RingOn		0x13ab
          #define CHP_VParm_LS_Net_RingOff		0x13ac
          #define CHP_VParm_LS_Net_NumberOfRingCycles		0x13d0
          #define CHP_VParm_LS_Net_TransmitRingSet	0x13d1
          #define CHP_VParm_LS_Net_ActiveTransmitRingId		0x13d2
          

 

 
/* Need this in case user has included t1defs.h */ 
#if !defined(_t1defs_h_) 

 
/* 
 * CHP Protocol Variant Parameter Identifiers for the Variant Set Parm feature 
 */
       #define CHP_VariantFormat_T1CAS			1

       #define CHP_Variant_VariantId				0x380000
       #define CHP_Variant_Format				0x380000

       #define CHP_VParm_Min					0x1380
       #define CHP_VParm_Max				0x13c5

       #define CHP_VParm_VariantId				0x1380
       #define CHP_VParm_VariantFormat			0x13ff

       #define CHP_VParm_ProtocolType			0x1381
       #define CHP_VParm_Wink				0x1382
       #define CHP_VParm_FarEndAnswer			0x1384
       #define CHP_VParm_InterCallDelay			0x1388
       #define CHP_VParm_Dial					0x1389
       #define CHP_VParm_ANI				0x138b
       #define CHP_VParm_ANICount				0x138d
       #define CHP_VParm_DNIS				0x138e
       #define CHP_VParm_DNISFormat				0x138f
       #define CHP_VParm_DNISCount				0x1390
       #define CHP_VParm_PreDigitTimeout			0x1391
       #define CHP_VParm_InterDigitTimeout			0x1392
       #define CHP_VParm_CallProgress				0x1393
       #define CHP_VParm_EM_Offhook			0x139e
       #define CHP_VParm_EM_Onhook				0x139f
       #define CHP_VParm_EM_FlashOnhook			0x13a0
       #define CHP_VParm_EM_Wink				0x13a1
       #define CHP_VParm_EM_Flash				0x13a2
       #define CHP_VParm_LS_PBX_Open			0x13a3
       #define CHP_VParm_LS_PBX_FlashOpen			0x13a4
       #define CHP_VParm_LS_PBX_Close			0x13a5
       #define CHP_VParm_LS_PBX_Flash			0x13a6
       #define CHP_VParm_LS_Net_Answer			0x13a7
       #define CHP_VParm_LS_Net_Drop			0x13a8
       #define CHP_VParm_LS_Net_FlashDrop			0x13a9
       #define CHP_VParm_LS_Net_Abandon			0x13aa
       #define CHP_VParm_GS_PBX_Ground			0x13ad
       #define CHP_VParm_GS_PBX_Answer			0x13ae
       #define CHP_VParm_GS_PBX_Release			0x13af
       #define CHP_VParm_GS_PBX_Drop			0x13b0
       #define CHP_VParm_GS_PBX_FlashDrop			0x13b1
       #define CHP_VParm_GS_PBX_Flash			0x13b2
       #define CHP_VParm_GS_Net_Ground			0x13b3
       #define CHP_VParm_GS_Net_Drop			0x13b4
#define CHP_VParm_GS_Net_FlashDrop			0x13b5
       #define CHP_VParm_GS_Net_RingOn			0x13b6
       #define CHP_VParm_GS_Net_RingOff			0x13b7
       #define CHP_VParm_BlindTransfer			0x13b8
       #define CHP_VParm_BtAddressDef			0x13bb
       #define CHP_VParm_BtOrigFormat			0x13bc
       #define CHP_VParm_BtDestFormat			0x13bd
       #define CHP_VParm_BtCancelDigitsFormat		0x13be
       #define CHP_VParm_BtCancelFlashCount			0x13bf
       #define CHP_VParm_BtCancelInterFlashDuration		0x13c0
       #define CHP_VParm_BtCancelDigits			0x13c1
       #define CHP_VParm_BtDestSuffix				0x13c2
       #define CHP_VParm_BtDestPrefix				0x13c3
       #define CHP_VParm_BtOrigPrefix				0x13c4
       #define CHP_VParm_BtOrigSuffix				0x13c5 

 
/* Need this in case user has included t1defs.h */ 
#endif /* if !defined(_t1defs_h_)*/ 

/* 
 * End of all Mercury T1 Channel Protocol Component Definitions 
 */

#endif /* !defined(_os_t1defs_h_) */
