
/*
 * This file was automatically generated from playdefs.txt.
 * Author: "Luke Kiernan"
 * Version: "A0.39"
 * Date: Thu Oct 24 13:09:08 2002
 * The output was written to playdefs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_playdefs_h_)
#define _playdefs_h_ 1
/* This file describes the list of Mercury messages, parameters and equates 
 * supported by the Mercury Player Component and its Instances. */
/*
 * Player Component Definition
 */
/* The Player uses messages from the Standard Kernel Message Set, the Standard 
 * Component Message Set and the Standard Audio Decoder Component Message Set. */
/*
 * 	Mercury Kernel Standard Message Set defined in mercdefs.doc
 * 	*/
/*
 * 	Standard Component Message Set defined in stddefs.doc.
 * 	*/
/*
 * 	Audio Decoder Component Message Set defined in dec_defs.doc
 * 	*/
/* Decoder Type used when trying to allocate a Decoder Instance defned in 
 * coders.h */
/* 
 * Player Message Definitions
 */

#define Player_MsgStart_StreamID	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStart_StreamID_t;

#define Player_MsgStart_Decoding	0x380004	/* 3670020 */
typedef	UInt32	Player_MsgStart_Decoding_t;

#define Player_MsgStart_StartMode_NORMAL	0	/* 0 */

#define Player_MsgStart_StartMode_PAUSED	0x1	/* 1 */

#define Player_MsgStart_StartMode_TIMED	0x2	/* 2 */

#define Player_MsgStart_StartMode_SYNCH	0x4	/* 4 */

#define Player_MsgStart_StartMode_BEEPINIT	0x8	/* 8 */

#define Player_MsgStart_StartMode	0x380008	/* 3670024 */
typedef	UInt32	Player_MsgStart_StartMode_t;

#define Player_MsgStart_StartPos	0x38000c	/* 3670028 */
typedef	UInt32	Player_MsgStart_StartPos_t;

/*
 * Player_MsgStart (value = 0x100) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	StreamID;
	UInt32	Decoding;
	UInt32	StartMode;
	UInt32	StartPos;
} Player_MsgStart_t;

#define Player_MsgStart_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_MsgStart_StreamID), &((structAddr)->StreamID),	\
			(Player_MsgStart_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgStart_StartMode), &((structAddr)->StartMode),	\
			(Player_MsgStart_StartPos), &((structAddr)->StartPos))


#define Player_MsgStart_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_MsgStart_StreamID), &((structAddr)->StreamID),	\
			(Player_MsgStart_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgStart_StartMode), &((structAddr)->StartMode),	\
			(Player_MsgStart_StartPos), &((structAddr)->StartPos))


#define Player_MsgStart_Size		16

#define Player_MsgStart	0x100	/* 256 */
/* The MsgStart message is sent to initiate a playback of pre-recorded data 
 * from a specified stream using a specified decoding algorithm. MsgStart is a 
 * subset of the MsgStart2 message. Users are encouraged to use MsgStart2 for 
 * the single play case, rather than MsgStart The MsgStartCmplt message is 
 * returned when this message is received and successfully processed by the 
 * player. The EvtPlaying event may also be sent, if this event was enabled, at 
 * the time when playback actually starts. StreamID - stream identifier for 
 * playback. Decoder - decoding to use. Values: Defined in Coders Definition 
 * File "coders.h". StartMode - starting mode. This is a bit map in that all of 
 * the modes may be OR'd together and set simultaneously. StartPos - starting 
 * position (in bytes). 0 means beginning of data stream. . Starting positions 
 * should be aligned with stream block boundaries, where the block size is the 
 * header size plus the maximum data size */
/* The MsgStartCmplt message is sent as a response to the MsgStart command 
 * when the message has been received and processed. */

/*
 * Player_MsgStartCmplt (value = 0x101) is an output message
 * for component Player.
 */

#define Player_MsgStartCmplt_Size		0

#define Player_MsgStartCmplt	0x101	/* 257 */
/* The MsgStop message is sent to stop an ongoing playback. The MsgStopped is 
 * sent when playback is stopped. The EvtStopped event message may also be 
 * returned if this event was enabled. */

/*
 * Player_MsgStop (value = 0x102) is an input message
 * for component Player.
 */

#define Player_MsgStop_Size		0

#define Player_MsgStop	0x102	/* 258 */

#define Player_MsgStopped_Reason_UserStop	0x1	/* 1 */

#define Player_MsgStopped_Reason_Rtc	0x4	/* 4 */

#define Player_MsgStopped_Reason_Timeout	0x3	/* 3 */

#define Player_MsgStopped_Reason_EOT	0x2	/* 2 */

#define Player_MsgStopped_Reason_EOS	0x80	/* 128 */

#define Player_MsgStopped_Reason_InvalidDecoder	0x171	/* 369 */

#define Player_MsgStopped_Reason_Deallocated	0x172	/* 370 */

#define Player_MsgStopped_Reason_DecoderExited	0x173	/* 371 */

#define Player_MsgStopped_Reason_StreamError	0x174	/* 372 */

#define Player_MsgStopped_Reason_BrokenPipe	0x175	/* 373 */

#define Player_MsgStopped_Reason_BeepToneError	0x176	/* 374 */

#define Player_MsgStopped_Reason	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStopped_Reason_t;

#define Player_MsgStopped_RtcLabel	0x380004	/* 3670020 */
typedef	UInt32	Player_MsgStopped_RtcLabel_t;

#define Player_MsgStopped_TimePlayed	0x380008	/* 3670024 */
typedef	UInt32	Player_MsgStopped_TimePlayed_t;

#define Player_MsgStopped_BytesPlayed	0x38000c	/* 3670028 */
typedef	UInt32	Player_MsgStopped_BytesPlayed_t;

/*
 * Player_MsgStopped (value = 0x103) is an output message
 * for component Player.
 */


typedef struct {
	UInt32	Reason;
	UInt32	RtcLabel;
	UInt32	TimePlayed;
	UInt32	BytesPlayed;
} Player_MsgStopped_t;

#define Player_MsgStopped_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_MsgStopped_Reason), &((structAddr)->Reason),	\
			(Player_MsgStopped_RtcLabel), &((structAddr)->RtcLabel),	\
			(Player_MsgStopped_TimePlayed), &((structAddr)->TimePlayed),	\
			(Player_MsgStopped_BytesPlayed), &((structAddr)->BytesPlayed))


#define Player_MsgStopped_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_MsgStopped_Reason), &((structAddr)->Reason),	\
			(Player_MsgStopped_RtcLabel), &((structAddr)->RtcLabel),	\
			(Player_MsgStopped_TimePlayed), &((structAddr)->TimePlayed),	\
			(Player_MsgStopped_BytesPlayed), &((structAddr)->BytesPlayed))


#define Player_MsgStopped_Size		16

#define Player_MsgStopped	0x103	/* 259 */
/* The MsgStopped message is sent as a response to the MsgStop command when 
 * playback has stopped. It is also sent asynchronously if playback was stopped 
 * due to End Of Data or due to Run Time Control. The EvtStopped event message 
 * may also be returned if this event was enabled. Reason - reason why playback 
 * stopped. If the player were to stop due to playing the last prompt on a play 
 * list, the reason would be the flag associated with the terminating block, 
 * (EOT or EOS). RtcLabel - if Reason is Rtc then this is the EventLabel of the 
 * event that caused the playback to stop. TimePlayed - total length of time 
 * played during the play session (since the corresponding MsgStart) before 
 * stopping, in milliseconds. This is the sum of the times calculated for each 
 * play segment. BytesPlayed - total number of bytes played during the play 
 * session (since the corresponding MsgStart) before stopping. */
/* The MsgPause message is sent to pause an ongoing playback. The EvtPaused 
 * event message may returned in addition to the MsgPauseCmplt message if this 
 * event was enabled. */

/*
 * Player_MsgPause (value = 0x104) is an input message
 * for component Player.
 */

#define Player_MsgPause_Size		0

#define Player_MsgPause	0x104	/* 260 */
/* The MsgPauseCmplt message is sent as a response to the MsgPause command 
 * when playback has paused. */

/*
 * Player_MsgPauseCmplt (value = 0x105) is an output message
 * for component Player.
 */

#define Player_MsgPauseCmplt_Size		0

#define Player_MsgPauseCmplt	0x105	/* 261 */
/* The MsgResume message is sent to resume a paused playback. The EvtPlaying 
 * event message may be returned in addition to the MsgResumeCmplt message if 
 * this event was enabled. */

/*
 * Player_MsgResume (value = 0x106) is an input message
 * for component Player.
 */

#define Player_MsgResume_Size		0

#define Player_MsgResume	0x106	/* 262 */
/* The MsgResumeCmplt message is sent as a response to the MsgResume command 
 * when playback has resumed. */

/*
 * Player_MsgResumeCmplt (value = 0x107) is an output message
 * for component Player.
 */

#define Player_MsgResumeCmplt_Size		0

#define Player_MsgResumeCmplt	0x107	/* 263 */

#define Player_MsgAdjSpeed_SpeedMode_UP	0x177	/* 375 */

#define Player_MsgAdjSpeed_SpeedMode_DOWN	0x178	/* 376 */

#define Player_MsgAdjSpeed_SpeedMode_NORMAL	0x179	/* 377 */

#define Player_MsgAdjSpeed_SpeedMode_TOGGLE	0x17a	/* 378 */

#define Player_MsgAdjSpeed_SpeedMode	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgAdjSpeed_SpeedMode_t;

/*
 * Player_MsgAdjSpeed (value = 0x108) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	SpeedMode;
} Player_MsgAdjSpeed_t;

#define Player_MsgAdjSpeed_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgAdjSpeed_SpeedMode), &((structAddr)->SpeedMode))


#define Player_MsgAdjSpeed_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgAdjSpeed_SpeedMode), &((structAddr)->SpeedMode))


#define Player_MsgAdjSpeed_Size		4

#define Player_MsgAdjSpeed	0x108	/* 264 */
/* The MsgAdjSpeed message is sent to adjust the speed of playback . The 
 * EvtSpeed event message may be returned in addition to the MsgAdjSpeedCmplt 
 * message if this event was enabled. SpeedMode - mode of speed adjustment UP - 
 * Speed up one increment DOWN - Slow down one increment DEFAULT- Play at 
 * default speed TOGGLE- Toggle between default and last adjusted speed */

#define Player_MsgAdjSpeedCmplt_NewSpeed	0x80000	/* 524288 */
typedef	Int16	Player_MsgAdjSpeedCmplt_NewSpeed_t;

/*
 * Player_MsgAdjSpeedCmplt (value = 0x109) is an output message
 * for component Player.
 */


typedef struct {
	Int16	NewSpeed;
} Player_MsgAdjSpeedCmplt_t;

#define Player_MsgAdjSpeedCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgAdjSpeedCmplt_NewSpeed), &((structAddr)->NewSpeed))


#define Player_MsgAdjSpeedCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgAdjSpeedCmplt_NewSpeed), &((structAddr)->NewSpeed))


#define Player_MsgAdjSpeedCmplt_Size		2

#define Player_MsgAdjSpeedCmplt	0x109	/* 265 */
/* The MsgAdjSpeedCmplt message is sent as a response to the MsgAdjSpeed 
 * command when requested speed adjustment has taken place. NewSpeed - New 
 * speed setting */

#define Player_MsgAdjVolume_VolumeMode_UP	0x17b	/* 379 */

#define Player_MsgAdjVolume_VolumeMode_DOWN	0x17c	/* 380 */

#define Player_MsgAdjVolume_VolumeMode_NORMAL	0x17d	/* 381 */

#define Player_MsgAdjVolume_VolumeMode_TOGGLE	0x17e	/* 382 */

#define Player_MsgAdjVolume_VolumeMode	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgAdjVolume_VolumeMode_t;

/*
 * Player_MsgAdjVolume (value = 0x10a) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	VolumeMode;
} Player_MsgAdjVolume_t;

#define Player_MsgAdjVolume_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgAdjVolume_VolumeMode), &((structAddr)->VolumeMode))


#define Player_MsgAdjVolume_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgAdjVolume_VolumeMode), &((structAddr)->VolumeMode))


#define Player_MsgAdjVolume_Size		4

#define Player_MsgAdjVolume	0x10a	/* 266 */
/* The MsgAdjVolume message is sent to adjust the volume of playback . The 
 * EvtVolume event message may be returned in addition to the MsgAdjVolumeCmplt 
 * message if this event was enabled. VolumeMode - mode of volume adjustment UP 
 * - Volume up one increment DOWN - Volume down one increment DEFAULT- Play at 
 * default volume TOGGLE- Toggle between default and last adjusted volume */

#define Player_MsgAdjVolumeCmplt_NewVolume	0x80000	/* 524288 */
typedef	Int16	Player_MsgAdjVolumeCmplt_NewVolume_t;

/*
 * Player_MsgAdjVolumeCmplt (value = 0x10b) is an output message
 * for component Player.
 */


typedef struct {
	Int16	NewVolume;
} Player_MsgAdjVolumeCmplt_t;

#define Player_MsgAdjVolumeCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgAdjVolumeCmplt_NewVolume), &((structAddr)->NewVolume))


#define Player_MsgAdjVolumeCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgAdjVolumeCmplt_NewVolume), &((structAddr)->NewVolume))


#define Player_MsgAdjVolumeCmplt_Size		2

#define Player_MsgAdjVolumeCmplt	0x10b	/* 267 */
/* The MsgAdjVolumeCmplt message is sent as a response to the MsgAdjVolume 
 * command when requested volume adjustment has taken place. NewVolume - the 
 * new volume setting */

#define Player_MsgSetSpeedAdjTable_SpeedTable	0x8a000	/* 565248 */
typedef	Int16	Player_MsgSetSpeedAdjTable_SpeedTable_t[21];

/*
 * Player_MsgSetSpeedAdjTable (value = 0x10c) is an input message
 * for component Player.
 */


typedef struct {
	Int16	SpeedTable[21];
} Player_MsgSetSpeedAdjTable_t;

#define Player_MsgSetSpeedAdjTable_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgSetSpeedAdjTable_SpeedTable), &((structAddr)->SpeedTable))


#define Player_MsgSetSpeedAdjTable_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgSetSpeedAdjTable_SpeedTable), &((structAddr)->SpeedTable))


#define Player_MsgSetSpeedAdjTable_Size		42

#define Player_MsgSetSpeedAdjTable	0x10c	/* 268 */
/* The MsgSetSpeedAdjTable message is sent to change the entries in the Speed 
 * Adjustment Table. This table exists at an Instance level as well as a 
 * Component level. The Component level table is the default table when the 
 * Component is initialized. Each of the Player Instances use this default 
 * table when they are allocated. The default Component table and the Instance 
 * Tables may be changed at any time. SpeedTable - table entries of percentages 
 * from normal speed. Origin is at SpeedTable[10] The range of Speed Adjustment 
 * is from 50% to 150%, thus table entries from -50 to +150 may be used. To 
 * limit the apparent size of the table (e.g, a table of three values, 50%, 
 * 100%, and 120%), the table entries which are not used can be filled with the 
 * value Player_SpeedTable_NullValue. The origin remains at SpeedTable[10]. The 
 * value Player_SpeedTable_NullValue may not be used at the origin. */
/* The MsgSetSpeedAdjTableCmplt message is sent as a response to the 
 * MsgSetSpeedAdjTable command if the Speed Adjustment Table was successfully 
 * updated.. */

/*
 * Player_MsgSetSpeedAdjTableCmplt (value = 0x10d) is an output message
 * for component Player.
 */

#define Player_MsgSetSpeedAdjTableCmplt_Size		0

#define Player_MsgSetSpeedAdjTableCmplt	0x10d	/* 269 */

#define Player_MsgSetVolumeAdjTable_VolumeTable	0x8a000	/* 565248 */
typedef	Int16	Player_MsgSetVolumeAdjTable_VolumeTable_t[21];

/*
 * Player_MsgSetVolumeAdjTable (value = 0x10e) is an input message
 * for component Player.
 */


typedef struct {
	Int16	VolumeTable[21];
} Player_MsgSetVolumeAdjTable_t;

#define Player_MsgSetVolumeAdjTable_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgSetVolumeAdjTable_VolumeTable), &((structAddr)->VolumeTable))


#define Player_MsgSetVolumeAdjTable_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgSetVolumeAdjTable_VolumeTable), &((structAddr)->VolumeTable))


#define Player_MsgSetVolumeAdjTable_Size		42

#define Player_MsgSetVolumeAdjTable	0x10e	/* 270 */
/* The MsgSetVolumeAdjTable message is sent to change the entries in the 
 * Volume Adjustment Table. This table exists at an Instance level as well as a 
 * Component level. The Component level table is the default table when the 
 * Component is initialized. Each of the Player Instances use this default 
 * table when they are allocated. The default Component table and the Instance 
 * Tables may be changed at any time. VolumeTable - table entries of dB 
 * deviations from normal volume. Origin is at VolumeTable[10] The maximum 
 * Volume Adjustment is given by the parameter ParmMaxLevel. To limit the 
 * apparent size of the table, the table entries which are not used can be 
 * filled with the value Player_VolumeTable_NullValue. The origin of the 
 * remains at VolumeTable[10]. The value Player_VolumeTable_NullValue may not 
 * be used at the origin. */
/* The MsgSetVolumeAdjTableCmplt message is sent as a response to the 
 * MsgSetVolumeAdjTable command if the Volume Adjustment Table was successfully 
 * updated. */

/*
 * Player_MsgSetVolumeAdjTableCmplt (value = 0x10f) is an output message
 * for component Player.
 */

#define Player_MsgSetVolumeAdjTableCmplt_Size		0

#define Player_MsgSetVolumeAdjTableCmplt	0x10f	/* 271 */
/* The MsgGetSpeedAdjTable message is sent to retrieve the entries in the 
 * Speed Adjustment Table. */

/*
 * Player_MsgGetSpeedAdjTable (value = 0x110) is an input message
 * for component Player.
 */

#define Player_MsgGetSpeedAdjTable_Size		0

#define Player_MsgGetSpeedAdjTable	0x110	/* 272 */

#define Player_MsgGetSpeedAdjTableCmplt_SpeedTable	0x8a000	/* 565248 */
typedef	Int16	Player_MsgGetSpeedAdjTableCmplt_SpeedTable_t[21];

/*
 * Player_MsgGetSpeedAdjTableCmplt (value = 0x111) is an output message
 * for component Player.
 */


typedef struct {
	Int16	SpeedTable[21];
} Player_MsgGetSpeedAdjTableCmplt_t;

#define Player_MsgGetSpeedAdjTableCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgGetSpeedAdjTableCmplt_SpeedTable), &((structAddr)->SpeedTable))


#define Player_MsgGetSpeedAdjTableCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgGetSpeedAdjTableCmplt_SpeedTable), &((structAddr)->SpeedTable))


#define Player_MsgGetSpeedAdjTableCmplt_Size		42

#define Player_MsgGetSpeedAdjTableCmplt	0x111	/* 273 */
/* The MsgGetSpeedAdjTableCmplt message is sent as a response to the 
 * MsgGetSpeedAdjTable command if the Speed Adjustment Table was successfully 
 * retrieved. SpeedTable - table entries of percentages from normal speed. 
 * Origin is at SpeedTable[10] */
/* The MsgGetVolumeAdjTable message is sent to retrieve the entries in the 
 * Volume Adjustment Table. */

/*
 * Player_MsgGetVolumeAdjTable (value = 0x112) is an input message
 * for component Player.
 */

#define Player_MsgGetVolumeAdjTable_Size		0

#define Player_MsgGetVolumeAdjTable	0x112	/* 274 */

#define Player_MsgGetVolumeAdjTableCmplt_VolumeTable	0x8a000	/* 565248 */
typedef	Int16	Player_MsgGetVolumeAdjTableCmplt_VolumeTable_t[21];

/*
 * Player_MsgGetVolumeAdjTableCmplt (value = 0x113) is an output message
 * for component Player.
 */


typedef struct {
	Int16	VolumeTable[21];
} Player_MsgGetVolumeAdjTableCmplt_t;

#define Player_MsgGetVolumeAdjTableCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgGetVolumeAdjTableCmplt_VolumeTable), &((structAddr)->VolumeTable))


#define Player_MsgGetVolumeAdjTableCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgGetVolumeAdjTableCmplt_VolumeTable), &((structAddr)->VolumeTable))


#define Player_MsgGetVolumeAdjTableCmplt_Size		42

#define Player_MsgGetVolumeAdjTableCmplt	0x113	/* 275 */
/* The MsgGetVolumeAdjTableCmplt message is sent as a response to the 
 * MsgGetVolumeAdjTable command if the Volume Adjustment Table was successfully 
 * retrieved. VolumeTable - table entries of dB deviations from normal volume. 
 * Origin is at VolumeTable[10] */

#define Player_MsgPlayNextSegment_Decoding	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgPlayNextSegment_Decoding_t;

/*
 * Player_MsgPlayNextSegment (value = 0x114) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	Decoding;
} Player_MsgPlayNextSegment_t;

#define Player_MsgPlayNextSegment_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgPlayNextSegment_Decoding), &((structAddr)->Decoding))


#define Player_MsgPlayNextSegment_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgPlayNextSegment_Decoding), &((structAddr)->Decoding))


#define Player_MsgPlayNextSegment_Size		4

#define Player_MsgPlayNextSegment	0x114	/* 276 */
/* The MsgPlayNextSegment message is sent to initiate the next playback 
 * segment of pre-recorded data from the stream specified in the original 
 * MsgStart of the current multi-segment play using a specified decoding 
 * algorithm. The MsgPlayNextSegmentCmplt message is returned when this message 
 * is received and successfully processed by the player. The EvtPlaying event 
 * may also be sent, if this event was enabled, at the time when playback 
 * actually starts. Decoder - decoding to use. Values: Defined in Coders 
 * Definition File "coders.h". */
/* The MsgPlayNextSegmentCmplt message is sent as a response to the 
 * MsgPlayNextSegment command when the message has been received and processed. */

/*
 * Player_MsgPlayNextSegmentCmplt (value = 0x115) is an output message
 * for component Player.
 */

#define Player_MsgPlayNextSegmentCmplt_Size		0

#define Player_MsgPlayNextSegmentCmplt	0x115	/* 277 */

#define Player_MsgEndOfSegment_TimePlayed	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgEndOfSegment_TimePlayed_t;

#define Player_MsgEndOfSegment_BytesPlayed	0x380004	/* 3670020 */
typedef	UInt32	Player_MsgEndOfSegment_BytesPlayed_t;

/*
 * Player_MsgEndOfSegment (value = 0x116) is an output message
 * for component Player.
 */


typedef struct {
	UInt32	TimePlayed;
	UInt32	BytesPlayed;
} Player_MsgEndOfSegment_t;

#define Player_MsgEndOfSegment_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Player_MsgEndOfSegment_TimePlayed), &((structAddr)->TimePlayed),	\
			(Player_MsgEndOfSegment_BytesPlayed), &((structAddr)->BytesPlayed))


#define Player_MsgEndOfSegment_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Player_MsgEndOfSegment_TimePlayed), &((structAddr)->TimePlayed),	\
			(Player_MsgEndOfSegment_BytesPlayed), &((structAddr)->BytesPlayed))


#define Player_MsgEndOfSegment_Size		8

#define Player_MsgEndOfSegment	0x116	/* 278 */
/* The MsgEndOfSegment message is used in the case of multi-segment plays and 
 * will only happen after the completion of a play segment (a play of files of 
 * one coder type). This message is sent asynchronously if playback was stopped 
 * due to End Of Type (EOT) flag. The EvtStopped event message may also be 
 * returned if this event was enabled. */

#define Player_MsgStart2_StartMode_NORMAL	0	/* 0 */

#define Player_MsgStart2_StartMode_PAUSED	0x1	/* 1 */

#define Player_MsgStart2_StartMode_TIMED	0x2	/* 2 */

#define Player_MsgStart2_StartMode_SYNCH	0x4	/* 4 */

#define Player_MsgStart2_StartMode_BEEPINIT	0x8	/* 8 */

#define Player_MsgStart2_StartMode	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStart2_StartMode_t;

#define Player_MsgStart2_Count	0x380004	/* 3670020 */
typedef	UInt32	Player_MsgStart2_Count_t;

#define Player_MsgStart2_varStart	0x8

#define Player_MsgStart2_PlayList_StreamID	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStart2_PlayList_StreamID_t;

#define Player_MsgStart2_PlayList_Decoding	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStart2_PlayList_Decoding_t;

#define Player_MsgStart2_PlayList_StartPos	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStart2_PlayList_StartPos_t;

#define Player_MsgStart2_PlayList_Reserved	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStart2_PlayList_Reserved_t;


typedef struct {
	UInt32	StreamID;
	UInt32	Decoding;
	UInt32	StartPos;
	UInt32	Reserved;
} Player_MsgStart2_PlayList_t;

#define Player_MsgStart2_PlayList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_MsgStart2_PlayList_StreamID), &((structAddr)->StreamID),	\
			(Player_MsgStart2_PlayList_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgStart2_PlayList_StartPos), &((structAddr)->StartPos),	\
			(Player_MsgStart2_PlayList_Reserved), &((structAddr)->Reserved))


#define Player_MsgStart2_PlayList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_MsgStart2_PlayList_StreamID), &((structAddr)->StreamID),	\
			(Player_MsgStart2_PlayList_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgStart2_PlayList_StartPos), &((structAddr)->StartPos),	\
			(Player_MsgStart2_PlayList_Reserved), &((structAddr)->Reserved))


#define Player_MsgStart2_PlayList_Size		16

#define Player_MsgStart2_PlayList	0	/* 0 */

/*
 * Player_MsgStart2 (value = 0x117) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	StartMode;
	UInt32	Count;
} Player_MsgStart2_t;

#define Player_MsgStart2_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Player_MsgStart2_StartMode), &((structAddr)->StartMode),	\
			(Player_MsgStart2_Count), &((structAddr)->Count))


#define Player_MsgStart2_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Player_MsgStart2_StartMode), &((structAddr)->StartMode),	\
			(Player_MsgStart2_Count), &((structAddr)->Count))


#define Player_MsgStart2_Size		8

#define Player_MsgStart2	0x117	/* 279 */
/* The Player_MsgStart2 message is sent to initiate a playback of pre-recorded 
 * data from one or more specified streams using specified decoding algorithms. 
 * Player_MsgStart2 is a complete superset of Player_MsgStart message, with the 
 * distinctions that EOT (see note below) terminated blocks will NOT cause a 
 * Player_PlayNextSegment message to be sent to the Host, and EOS terminated 
 * blocks will not cause the Player to terminate the play session. Each EOT 
 * terminated segment must be a separate entry on the play list. The Player 
 * will continue a session of plays until the play list is exhausted, or, a 
 * command to stop (Player_MsgStop or an RTC event) is received. This will 
 * greatly reduce messaging to the Host and is an important feature in addition 
 * to cached prompts. The Player_MsgStartCmplt message is returned when this 
 * message is received and successfully processed by the player. The 
 * Player_EvtPlaying event may also be sent, if this event was enabled, at the 
 * time when playback actually starts. Player_MsgStart2_StartMode - The 
 * starting mode. This is a bit map in that all of the modes may be OR'd 
 * together and set simultaneously. Player_MsgStart2_StartMode_NORMAL - No 
 * effect. Player_MsgStart2_StartMode_PAUSED - In the Play state but not 
 * sending data to TDM port. Player_MsgStart2_StartMode_TIMED - The play back 
 * will stop after the time specified in Player_ParmDuration has elapsed. 
 * Player_MsgStart2_Count -The number of PlayList structure entries which 
 * follow in the body of the message The PlayList consists of an array of one 
 * or more structures containing the stream ID, decoder type an starting offset 
 * into the stream. StreamID - The stream identifier for playback of the 
 * current PlayList entry. Decoding - The type of decoding to use for playback 
 * of the current PlayList entry. The values are defined in coders/coders.h. 
 * StartPos - The starting position (in bytes). 0 means beginning of data 
 * stream. Starting positions should be aligned with stream block boundaries, 
 * where the block size is the header size plus the maximum data size. In other 
 * words this is a raw byte offset into the persistent stream. It is the 
 * responsibility of the application to ensure that this offset corresponds to 
 * the start of a data block header. This starting position is only relevant 
 * for persistent streams, for regular G-Streams this must be set to 0. 
 * Reserved - Reserved for future use. This field must be set to zero. */
/* struct { char * promptName; Uint32 decoding; //Type of audio coding Uint32 
 * offset; //The byte offset into the persistent stream } promptList = { 
 * {"outOfOffice.rvx", MULAW64D, 0} {"timeIs", MULAW64D, 4056}, 
 * {"notAvailable", MULAW64D, 8112}, {"welcomeToDial.rvx", MULAW64D, 12168} } 
 * Player_MsgStart2_t startMsg; //The Player_MsgStart2_PlayList_t *pPlayList; 
 * // At this point an application would write all the prompts // into a 
 * persistent stream, save the byte offsets for the start of each // one, and 
 * then close the stream. This operation need only be done once and // the 
 * stream id saved for future reference. The writing of this data is // 
 * identical as if it were a conventional stream. // cachedId = 130; // For the 
 * sake of argument 130 is the stream id with the data. hostId = 5; // For the 
 * sake of argument 5 is a conventional stream // written to by the Host per 
 * play back. if ( 
 * (qMsgAllocate(Player_MsgStart_Size+(count*sizeof(Player_MsgStart2_PlayList_t, 
 * &outMsgPtr)) != QSTATUS_ERROR){ outMsgPtr->source = hostSelfDesc; 
 * outMsgPtr->destination = playerInstDesc; outMsgPtr->transaction = 
 * transaction; outMsgPtr->type = Player_MsgStart2; startMsg.StartMode = 
 * Player_MsgStart2_StartMode_NORMAL startMsg.Count = 5; // There are five 
 * prompts in this play session offset = 0; Player_MsgStart2_put(outMsg, 
 * &startMsg, offset); // Fill the PlayList startMsg.StreamID = cachedId; //Set 
 * above startMsg.Decoding = promptList[3].decoding; startMsg.StartPos = 
 * promptList[3].offset; startMsg.Reserved = 0; offset = 
 * Player_MsgStart2_varStart; Player_MsgStart2_PlayList_put(outMsg, &startMsg, 
 * offset); startMsg.StreamID = hostId; //Set above startMsg.Decoding = OKI32D; 
 * startMsg.StartPos = 0; startMsg.Reserved = 0; 
 * Player_MsgStart2_PlayList_put(outMsg, &startMsg, offset); startMsg.StreamID 
 * = cachedId; startMsg.Decoding = promptList[2].decoding; startMsg.StartPos = 
 * promptList[2].offset; startMsg.Reserved = 0; 
 * Player_MsgStart2_PlayList_put(outMsg, &startMsg, offset); startMsg.StreamID 
 * = cachedId; startMsg.Decoding = promptList[1].decoding; startMsg.StartPos = 
 * promptList[1].offset; startMsg.Reserved = 0; 
 * Player_MsgStart2_PlayList_put(outMsg, &startMsg, offset); startMsg.StreamID 
 * = hostId; startMsg.Decoding = OKI32D; startMsg.StartPos = 0; 
 * startMsg.Reserved = 0; Player_MsgStart2_PlayList_put(outMsg, &startMsg, 
 * offset); // This call writes the Player_MsgStart2 to the Host. // qMsgWrite 
 * is Solaris MDI specific in qmsg.h. NT uses the MNTI call // mntSendMsg( ). 
 * assert(qMsgWrite(msgq, outMsg, NULL)==QSTATUS_DONE); // Now that the message 
 * is written the Player Component Instance // will send a Player_MsgStartCmplt 
 * when it receives the message // and then a Player_MsgStopped after it 
 * finishes playing the entire list. } */

#define Player_MsgAllocateDecoder_AttrCount	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgAllocateDecoder_AttrCount_t;

#define Player_MsgAllocateDecoder_varStart	0x4

#define Player_MsgAllocateDecoder_AttrList_Key	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgAllocateDecoder_AttrList_Key_t;

#define Player_MsgAllocateDecoder_AttrList_Value	0x180000	/* 1572864 */
typedef	Int32	Player_MsgAllocateDecoder_AttrList_Value_t;


typedef struct {
	UInt32	Key;
	Int32	Value;
} Player_MsgAllocateDecoder_AttrList_t;

#define Player_MsgAllocateDecoder_AttrList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Player_MsgAllocateDecoder_AttrList_Key), &((structAddr)->Key),	\
			(Player_MsgAllocateDecoder_AttrList_Value), &((structAddr)->Value))


#define Player_MsgAllocateDecoder_AttrList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Player_MsgAllocateDecoder_AttrList_Key), &((structAddr)->Key),	\
			(Player_MsgAllocateDecoder_AttrList_Value), &((structAddr)->Value))


#define Player_MsgAllocateDecoder_AttrList_Size		8

#define Player_MsgAllocateDecoder_AttrList	0x1	/* 1 */

/*
 * Player_MsgAllocateDecoder (value = 0x118) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	AttrCount;
} Player_MsgAllocateDecoder_t;

#define Player_MsgAllocateDecoder_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgAllocateDecoder_AttrCount), &((structAddr)->AttrCount))


#define Player_MsgAllocateDecoder_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgAllocateDecoder_AttrCount), &((structAddr)->AttrCount))


#define Player_MsgAllocateDecoder_Size		4

#define Player_MsgAllocateDecoder	0x118	/* 280 */
/* The MsgAllocateDecoder message is used allocate a Decoder from the Player. 
 * It is used as an instance message after initialization time. Count - The 
 * number of AttrList structure entries which follow in the body of the message 
 * AttrList - The structure consist of Key - The Decoder attribute (such as 
 * Coder_Bundle , see DM3 Standard Coders Interface Specification for keys). 
 * Value - The value of attribute */
/* The MsgAllocateDecoderCmplt message is sent as a response to the 
 * MsgAllocateDecoder command when the message has been received and processed. */

/*
 * Player_MsgAllocateDecoderCmplt (value = 0x119) is an output message
 * for component Player.
 */

#define Player_MsgAllocateDecoderCmplt_Size		0

#define Player_MsgAllocateDecoderCmplt	0x119	/* 281 */

#define Player_MsgDecoderQuery_Decoding	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDecoderQuery_Decoding_t;

/*
 * Player_MsgDecoderQuery (value = 0x11a) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	Decoding;
} Player_MsgDecoderQuery_t;

#define Player_MsgDecoderQuery_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgDecoderQuery_Decoding), &((structAddr)->Decoding))


#define Player_MsgDecoderQuery_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgDecoderQuery_Decoding), &((structAddr)->Decoding))


#define Player_MsgDecoderQuery_Size		4

#define Player_MsgDecoderQuery	0x11a	/* 282 */
/* The MsgDecoderQuery message is sent to query the player about coders which 
 * the player can allocate. The MsgDecoderQueryCmplt message is returned with 
 * the coder's attribute if it is valid. Decoder - decoder type, such as G.711 
 * or OKI: Defined in Coders Definition File "coders.h". */

#define Player_MsgDecoderQueryCmplt_Decoding	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDecoderQueryCmplt_Decoding_t;

#define Player_MsgDecoderQueryCmplt_isValid_false	0	/* 0 */

#define Player_MsgDecoderQueryCmplt_isValid_true	0x1	/* 1 */

#define Player_MsgDecoderQueryCmplt_isValid	0x380004	/* 3670020 */
typedef	UInt32	Player_MsgDecoderQueryCmplt_isValid_t;

#define Player_MsgDecoderQueryCmplt_FrameSize	0x380008	/* 3670024 */
typedef	UInt32	Player_MsgDecoderQueryCmplt_FrameSize_t;

#define Player_MsgDecoderQueryCmplt_maxDecBytesPerBlock	0x38000c	/* 3670028 */
typedef	UInt32	Player_MsgDecoderQueryCmplt_maxDecBytesPerBlock_t;

/*
 * Player_MsgDecoderQueryCmplt (value = 0x11b) is an output message
 * for component Player.
 */


typedef struct {
	UInt32	Decoding;
	UInt32	isValid;
	UInt32	FrameSize;
	UInt32	maxDecBytesPerBlock;
} Player_MsgDecoderQueryCmplt_t;

#define Player_MsgDecoderQueryCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_MsgDecoderQueryCmplt_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgDecoderQueryCmplt_isValid), &((structAddr)->isValid),	\
			(Player_MsgDecoderQueryCmplt_FrameSize), &((structAddr)->FrameSize),	\
			(Player_MsgDecoderQueryCmplt_maxDecBytesPerBlock), &((structAddr)->maxDecBytesPerBlock))


#define Player_MsgDecoderQueryCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_MsgDecoderQueryCmplt_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgDecoderQueryCmplt_isValid), &((structAddr)->isValid),	\
			(Player_MsgDecoderQueryCmplt_FrameSize), &((structAddr)->FrameSize),	\
			(Player_MsgDecoderQueryCmplt_maxDecBytesPerBlock), &((structAddr)->maxDecBytesPerBlock))


#define Player_MsgDecoderQueryCmplt_Size		16

#define Player_MsgDecoderQueryCmplt	0x11b	/* 283 */
/* The MsgDecoderQueryCmplt message is sent in response to the MsgDecoderQuery 
 * command when the message has been received and processed. Decoding This is a 
 * returned from the query message. isValid - This returns if the coding type 
 * specified is supported by this Instance. FrameSize - The frame size in 
 * bytes. For waveform codec, it depends on which task period of this codec is 
 * running on. E.g. For Mulaw64, it is 96 bytes if running on the 12ms task 
 * period.. MaxDecBytesPerBlock - The maximum number of bytes in a block that 
 * the host can stream to the resource for Play/Decode. */

#define Player_MsgLoadDictionary_StreamId	0x300000	/* 3145728 */
typedef	UInt24	Player_MsgLoadDictionary_StreamId_t;

#define Player_MsgLoadDictionary_DictionaryId	0x300003	/* 3145731 */
typedef	UInt24	Player_MsgLoadDictionary_DictionaryId_t;

#define Player_MsgLoadDictionary_languageAttribute	0x300006	/* 3145734 */
typedef	UInt24	Player_MsgLoadDictionary_languageAttribute_t;

#define Player_MsgLoadDictionary_textAttribute	0x300009	/* 3145737 */
typedef	UInt24	Player_MsgLoadDictionary_textAttribute_t;

/*
 * Player_MsgLoadDictionary (value = 0x11c) is an input message
 * for component Player.
 */


typedef struct {
	UInt24	StreamId;
	UInt24	DictionaryId;
	UInt24	languageAttribute;
	UInt24	textAttribute;
} Player_MsgLoadDictionary_t;

#define Player_MsgLoadDictionary_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_MsgLoadDictionary_StreamId), &((structAddr)->StreamId),	\
			(Player_MsgLoadDictionary_DictionaryId), &((structAddr)->DictionaryId),	\
			(Player_MsgLoadDictionary_languageAttribute), &((structAddr)->languageAttribute),	\
			(Player_MsgLoadDictionary_textAttribute), &((structAddr)->textAttribute))


#define Player_MsgLoadDictionary_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_MsgLoadDictionary_StreamId), &((structAddr)->StreamId),	\
			(Player_MsgLoadDictionary_DictionaryId), &((structAddr)->DictionaryId),	\
			(Player_MsgLoadDictionary_languageAttribute), &((structAddr)->languageAttribute),	\
			(Player_MsgLoadDictionary_textAttribute), &((structAddr)->textAttribute))


#define Player_MsgLoadDictionary_Size		12

#define Player_MsgLoadDictionary	0x11c	/* 284 */
/*
 * The LoadDictionary message is sent to initiate loading of a user dictionary.
 * StreamId	This is the ID of the GStream from which the load occurs.
 * DictionaryId	-	This is a unique (arbitrary) identifier for a user dictionary.
 * 
 * languageAttribute	-  This is the language attribute as specified in coders.h.
 *     languageAttribute is defined as 
 * Vendor  ID (23 - 16)
 * Variant Attribute (bits 15-8)
 * Language Attribute (bits 7-0)
 * 
 *  textAttribute	-  This is the text attribute as specified in coders.h.
 * 
 *  */

#define Player_MsgLoadDictionaryCmplt_StreamId	0x300000	/* 3145728 */
typedef	UInt24	Player_MsgLoadDictionaryCmplt_StreamId_t;

#define Player_MsgLoadDictionaryCmplt_DictionaryId	0x300003	/* 3145731 */
typedef	UInt24	Player_MsgLoadDictionaryCmplt_DictionaryId_t;

#define Player_MsgLoadDictionaryCmplt_languageAttribute	0x300006	/* 3145734 */
typedef	UInt24	Player_MsgLoadDictionaryCmplt_languageAttribute_t;

#define Player_MsgLoadDictionaryCmplt_textAttribute	0x300009	/* 3145737 */
typedef	UInt24	Player_MsgLoadDictionaryCmplt_textAttribute_t;

/*
 * Player_MsgLoadDictionaryCmplt (value = 0x11d) is an output message
 * for component Player.
 */


typedef struct {
	UInt24	StreamId;
	UInt24	DictionaryId;
	UInt24	languageAttribute;
	UInt24	textAttribute;
} Player_MsgLoadDictionaryCmplt_t;

#define Player_MsgLoadDictionaryCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_MsgLoadDictionaryCmplt_StreamId), &((structAddr)->StreamId),	\
			(Player_MsgLoadDictionaryCmplt_DictionaryId), &((structAddr)->DictionaryId),	\
			(Player_MsgLoadDictionaryCmplt_languageAttribute), &((structAddr)->languageAttribute),	\
			(Player_MsgLoadDictionaryCmplt_textAttribute), &((structAddr)->textAttribute))


#define Player_MsgLoadDictionaryCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_MsgLoadDictionaryCmplt_StreamId), &((structAddr)->StreamId),	\
			(Player_MsgLoadDictionaryCmplt_DictionaryId), &((structAddr)->DictionaryId),	\
			(Player_MsgLoadDictionaryCmplt_languageAttribute), &((structAddr)->languageAttribute),	\
			(Player_MsgLoadDictionaryCmplt_textAttribute), &((structAddr)->textAttribute))


#define Player_MsgLoadDictionaryCmplt_Size		12

#define Player_MsgLoadDictionaryCmplt	0x11d	/* 285 */
/* The MsgLoadDictionaryCmplt message is sent in response to the 
 * MsgLoadDictionary command when the message has been received and processed. 
 * StreamId This is the ID of the GStream from which the load occurs. 
 * DictionaryId - This is a unique (arbitrary) identifier for a user 
 * dictionary. languageAttribute - This is the language attribute as specified 
 * in coders.h. textAttribute - This is the text attribute as specified in 
 * coders.h. */

#define Player_MsgActivateDictionary_DictionaryId	0x300000	/* 3145728 */
typedef	UInt24	Player_MsgActivateDictionary_DictionaryId_t;

/*
 * Player_MsgActivateDictionary (value = 0x11e) is an input message
 * for component Player.
 */


typedef struct {
	UInt24	DictionaryId;
} Player_MsgActivateDictionary_t;

#define Player_MsgActivateDictionary_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgActivateDictionary_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgActivateDictionary_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgActivateDictionary_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgActivateDictionary_Size		3

#define Player_MsgActivateDictionary	0x11e	/* 286 */
/* The MsgActivate message is sent to initiate the activation of a user 
 * dictionary. DictionaryId The unique ID for the dictionary. */

#define Player_MsgActivateDictionaryCmplt_DictionaryId	0x300000	/* 3145728 */
typedef	UInt24	Player_MsgActivateDictionaryCmplt_DictionaryId_t;

/*
 * Player_MsgActivateDictionaryCmplt (value = 0x11f) is an output message
 * for component Player.
 */


typedef struct {
	UInt24	DictionaryId;
} Player_MsgActivateDictionaryCmplt_t;

#define Player_MsgActivateDictionaryCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgActivateDictionaryCmplt_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgActivateDictionaryCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgActivateDictionaryCmplt_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgActivateDictionaryCmplt_Size		3

#define Player_MsgActivateDictionaryCmplt	0x11f	/* 287 */
/* The MsgActivateDictionaryCmplt message is sent in response to the 
 * MsgActivateDictionary command when the message has been received and 
 * processed. DictionaryId The unique ID for the user dictionary. */

#define Player_MsgUnloadDictionary_DictionaryId	0x300000	/* 3145728 */
typedef	UInt24	Player_MsgUnloadDictionary_DictionaryId_t;

/*
 * Player_MsgUnloadDictionary (value = 0x120) is an input message
 * for component Player.
 */


typedef struct {
	UInt24	DictionaryId;
} Player_MsgUnloadDictionary_t;

#define Player_MsgUnloadDictionary_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgUnloadDictionary_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgUnloadDictionary_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgUnloadDictionary_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgUnloadDictionary_Size		3

#define Player_MsgUnloadDictionary	0x120	/* 288 */
/* The MsgUnloadDictionary message is sent to initiate unloading of a user 
 * dictionary. DictionaryID The unique ID of the user dictionary. */

#define Player_MsgUnloadDictionaryCmplt_DictionaryId	0x300000	/* 3145728 */
typedef	UInt24	Player_MsgUnloadDictionaryCmplt_DictionaryId_t;

/*
 * Player_MsgUnloadDictionaryCmplt (value = 0x121) is an output message
 * for component Player.
 */


typedef struct {
	UInt24	DictionaryId;
} Player_MsgUnloadDictionaryCmplt_t;

#define Player_MsgUnloadDictionaryCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgUnloadDictionaryCmplt_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgUnloadDictionaryCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgUnloadDictionaryCmplt_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgUnloadDictionaryCmplt_Size		3

#define Player_MsgUnloadDictionaryCmplt	0x121	/* 289 */
/* The MsgUnloadDictionaryCmplt message is sent in response to the 
 * MsgUnloadDictionary command when the message has been received and 
 * processed. DictionaryId The unique ID of the user dictionary. */

#define Player_MsgDeactivateDictionary_DictionaryId	0x300000	/* 3145728 */
typedef	UInt24	Player_MsgDeactivateDictionary_DictionaryId_t;

/*
 * Player_MsgDeactivateDictionary (value = 0x122) is an input message
 * for component Player.
 */


typedef struct {
	UInt24	DictionaryId;
} Player_MsgDeactivateDictionary_t;

#define Player_MsgDeactivateDictionary_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgDeactivateDictionary_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgDeactivateDictionary_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgDeactivateDictionary_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgDeactivateDictionary_Size		3

#define Player_MsgDeactivateDictionary	0x122	/* 290 */
/*
 * The MsgDeactivate message is sent to deactivate a user dictionary.
 * DictionaryId	The unique dictionary ID.
 *  */

#define Player_MsgDeactivateDictionaryCmplt_DictionaryId	0x300000	/* 3145728 */
typedef	UInt24	Player_MsgDeactivateDictionaryCmplt_DictionaryId_t;

/*
 * Player_MsgDeactivateDictionaryCmplt (value = 0x123) is an output message
 * for component Player.
 */


typedef struct {
	UInt24	DictionaryId;
} Player_MsgDeactivateDictionaryCmplt_t;

#define Player_MsgDeactivateDictionaryCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgDeactivateDictionaryCmplt_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgDeactivateDictionaryCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgDeactivateDictionaryCmplt_DictionaryId), &((structAddr)->DictionaryId))


#define Player_MsgDeactivateDictionaryCmplt_Size		3

#define Player_MsgDeactivateDictionaryCmplt	0x123	/* 291 */
/* The MsgDeactivateDictionaryCmplt message is sent in response to the 
 * MsgDeactivateDictionary command when the message has been received and 
 * processed. DictionaryID The unique ID of the user dictionary. */

#define Player_MsgDeallocateDecoder_AttrCount	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDeallocateDecoder_AttrCount_t;

#define Player_MsgDeallocateDecoder_varStart	0x4

#define Player_MsgDeallocateDecoder_AttrList_Key	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDeallocateDecoder_AttrList_Key_t;

#define Player_MsgDeallocateDecoder_AttrList_Value	0x180000	/* 1572864 */
typedef	Int32	Player_MsgDeallocateDecoder_AttrList_Value_t;


typedef struct {
	UInt32	Key;
	Int32	Value;
} Player_MsgDeallocateDecoder_AttrList_t;

#define Player_MsgDeallocateDecoder_AttrList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Player_MsgDeallocateDecoder_AttrList_Key), &((structAddr)->Key),	\
			(Player_MsgDeallocateDecoder_AttrList_Value), &((structAddr)->Value))


#define Player_MsgDeallocateDecoder_AttrList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Player_MsgDeallocateDecoder_AttrList_Key), &((structAddr)->Key),	\
			(Player_MsgDeallocateDecoder_AttrList_Value), &((structAddr)->Value))


#define Player_MsgDeallocateDecoder_AttrList_Size		8

#define Player_MsgDeallocateDecoder_AttrList	0x2	/* 2 */

/*
 * Player_MsgDeallocateDecoder (value = 0x124) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	AttrCount;
} Player_MsgDeallocateDecoder_t;

#define Player_MsgDeallocateDecoder_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgDeallocateDecoder_AttrCount), &((structAddr)->AttrCount))


#define Player_MsgDeallocateDecoder_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgDeallocateDecoder_AttrCount), &((structAddr)->AttrCount))


#define Player_MsgDeallocateDecoder_Size		4

#define Player_MsgDeallocateDecoder	0x124	/* 292 */
/* The MsgDeallocateDecoder message is used deallocate a Decoder from the 
 * Player. It is used as an instance message after initialization time. Count - 
 * The number of AttrList structure entries which follow in the body of the 
 * message AttrList - The structure consists of Key - The Decoder attribute 
 * (such as Coder_Bundle , see DM3 Standard Coders Interface Specification for 
 * keys). Value - The value of attribute */
/* The MsgDeallocateDecoderCmplt message is sent as a response to the 
 * MsgDeallocateDecoder command when the message has been received and 
 * processed. */

/*
 * Player_MsgDeallocateDecoderCmplt (value = 0x125) is an output message
 * for component Player.
 */

#define Player_MsgDeallocateDecoderCmplt_Size		0

#define Player_MsgDeallocateDecoderCmplt	0x125	/* 293 */

#define Player_MsgDecoderXQuery_Count	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDecoderXQuery_Count_t;

#define Player_MsgDecoderXQuery_varStart	0x4

#define Player_MsgDecoderXQuery_CoderList_Decoding	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDecoderXQuery_CoderList_Decoding_t;


typedef struct {
	UInt32	Decoding;
} Player_MsgDecoderXQuery_CoderList_t;

#define Player_MsgDecoderXQuery_CoderList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgDecoderXQuery_CoderList_Decoding), &((structAddr)->Decoding))


#define Player_MsgDecoderXQuery_CoderList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgDecoderXQuery_CoderList_Decoding), &((structAddr)->Decoding))


#define Player_MsgDecoderXQuery_CoderList_Size		4

#define Player_MsgDecoderXQuery_CoderList	0x3	/* 3 */

/*
 * Player_MsgDecoderXQuery (value = 0x126) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	Count;
} Player_MsgDecoderXQuery_t;

#define Player_MsgDecoderXQuery_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgDecoderXQuery_Count), &((structAddr)->Count))


#define Player_MsgDecoderXQuery_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgDecoderXQuery_Count), &((structAddr)->Count))


#define Player_MsgDecoderXQuery_Size		4

#define Player_MsgDecoderXQuery	0x126	/* 294 */
/* The MsgDecoderXQuery message is sent to query the player about one or more 
 * coders which the player can allocate. The MsgDecoderXQueryCmplt message is 
 * returned with the coders' attributes if they are valid. Decoder - decoder 
 * type, such as G.711 or OKI: Defined in Coders Definition File "coders.h". */

#define Player_MsgDecoderXQueryCmplt_Count	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDecoderXQueryCmplt_Count_t;

#define Player_MsgDecoderXQueryCmplt_varStart	0x4

#define Player_MsgDecoderXQueryCmplt_CoderList_Decoding	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDecoderXQueryCmplt_CoderList_Decoding_t;

#define Player_MsgDecoderXQueryCmplt_CoderList_isValid_false	0	/* 0 */

#define Player_MsgDecoderXQueryCmplt_CoderList_isValid_true	0x1	/* 1 */

#define Player_MsgDecoderXQueryCmplt_CoderList_isValid	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDecoderXQueryCmplt_CoderList_isValid_t;

#define Player_MsgDecoderXQueryCmplt_CoderList_FrameSize	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDecoderXQueryCmplt_CoderList_FrameSize_t;

#define Player_MsgDecoderXQueryCmplt_CoderList_maxDecBytesPerBlock	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgDecoderXQueryCmplt_CoderList_maxDecBytesPerBlock_t;


typedef struct {
	UInt32	Decoding;
	UInt32	isValid;
	UInt32	FrameSize;
	UInt32	maxDecBytesPerBlock;
} Player_MsgDecoderXQueryCmplt_CoderList_t;

#define Player_MsgDecoderXQueryCmplt_CoderList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_MsgDecoderXQueryCmplt_CoderList_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgDecoderXQueryCmplt_CoderList_isValid), &((structAddr)->isValid),	\
			(Player_MsgDecoderXQueryCmplt_CoderList_FrameSize), &((structAddr)->FrameSize),	\
			(Player_MsgDecoderXQueryCmplt_CoderList_maxDecBytesPerBlock), &((structAddr)->maxDecBytesPerBlock))


#define Player_MsgDecoderXQueryCmplt_CoderList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_MsgDecoderXQueryCmplt_CoderList_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgDecoderXQueryCmplt_CoderList_isValid), &((structAddr)->isValid),	\
			(Player_MsgDecoderXQueryCmplt_CoderList_FrameSize), &((structAddr)->FrameSize),	\
			(Player_MsgDecoderXQueryCmplt_CoderList_maxDecBytesPerBlock), &((structAddr)->maxDecBytesPerBlock))


#define Player_MsgDecoderXQueryCmplt_CoderList_Size		16

#define Player_MsgDecoderXQueryCmplt_CoderList	0x4	/* 4 */

/*
 * Player_MsgDecoderXQueryCmplt (value = 0x127) is an output message
 * for component Player.
 */


typedef struct {
	UInt32	Count;
} Player_MsgDecoderXQueryCmplt_t;

#define Player_MsgDecoderXQueryCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_MsgDecoderXQueryCmplt_Count), &((structAddr)->Count))


#define Player_MsgDecoderXQueryCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_MsgDecoderXQueryCmplt_Count), &((structAddr)->Count))


#define Player_MsgDecoderXQueryCmplt_Size		4

#define Player_MsgDecoderXQueryCmplt	0x127	/* 295 */
/* The MsgDecoderXQueryCmplt message is sent in response to the 
 * MsgDecoderXQuery command when the message has been received and processed. 
 * Count - The number of AttrList structure entries which follow in the body of 
 * the message CoderList - The structure consist of Decoding - This is a 
 * returned from the query message. isValid - This returns if the coding type 
 * specified is supported by this Instance. FrameSize - The frame size in 
 * bytes. For waveform codec, it depends on which task period of this codec is 
 * running on. E.g. For Mulaw64, it is 96 bytes if running on the 12ms task 
 * period.. MaxDecBytesPerBlock - The maximum number of bytes in a block that 
 * the host can stream to the resource for Play/Decode. */

#define Player_MsgStartx_StartMode_NORMAL	0	/* 0 */

#define Player_MsgStartx_StartMode_PAUSED	0x1	/* 1 */

#define Player_MsgStartx_StartMode_TIMED	0x2	/* 2 */

#define Player_MsgStartx_StartMode_SYNCH	0x4	/* 4 */

#define Player_MsgStartx_StartMode_BEEPINIT	0x8	/* 8 */

#define Player_MsgStartx_StartMode	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStartx_StartMode_t;

#define Player_MsgStartx_PlayCount	0x380004	/* 3670020 */
typedef	UInt32	Player_MsgStartx_PlayCount_t;

#define Player_MsgStartx_ParmCount	0x380008	/* 3670024 */
typedef	UInt32	Player_MsgStartx_ParmCount_t;

#define Player_MsgStartx_RTCCount	0x38000c	/* 3670028 */
typedef	UInt32	Player_MsgStartx_RTCCount_t;

#define Player_MsgStartx_DetCount	0x380010	/* 3670032 */
typedef	UInt32	Player_MsgStartx_DetCount_t;

#define Player_MsgStartx_varStart	0x14

#define Player_MsgStartx_PlayList_StreamID	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStartx_PlayList_StreamID_t;

#define Player_MsgStartx_PlayList_Decoding	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStartx_PlayList_Decoding_t;

#define Player_MsgStartx_PlayList_StartPos	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStartx_PlayList_StartPos_t;

#define Player_MsgStartx_PlayList_Reserved	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStartx_PlayList_Reserved_t;


typedef struct {
	UInt32	StreamID;
	UInt32	Decoding;
	UInt32	StartPos;
	UInt32	Reserved;
} Player_MsgStartx_PlayList_t;

#define Player_MsgStartx_PlayList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_MsgStartx_PlayList_StreamID), &((structAddr)->StreamID),	\
			(Player_MsgStartx_PlayList_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgStartx_PlayList_StartPos), &((structAddr)->StartPos),	\
			(Player_MsgStartx_PlayList_Reserved), &((structAddr)->Reserved))


#define Player_MsgStartx_PlayList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_MsgStartx_PlayList_StreamID), &((structAddr)->StreamID),	\
			(Player_MsgStartx_PlayList_Decoding), &((structAddr)->Decoding),	\
			(Player_MsgStartx_PlayList_StartPos), &((structAddr)->StartPos),	\
			(Player_MsgStartx_PlayList_Reserved), &((structAddr)->Reserved))


#define Player_MsgStartx_PlayList_Size		16

#define Player_MsgStartx_PlayList	0x5	/* 5 */

#define Player_MsgStartx_ParmList_Num	0x880000	/* 8912896 */
typedef	QParm	Player_MsgStartx_ParmList_Num_t;

#define Player_MsgStartx_ParmList_Val	0x380000	/* 3670016 */
typedef	UInt32	Player_MsgStartx_ParmList_Val_t;


typedef struct {
	QParm	Num;
	UInt32	Val;
} Player_MsgStartx_ParmList_t;

#define Player_MsgStartx_ParmList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Player_MsgStartx_ParmList_Num), &((structAddr)->Num),	\
			(Player_MsgStartx_ParmList_Val), &((structAddr)->Val))


#define Player_MsgStartx_ParmList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Player_MsgStartx_ParmList_Num), &((structAddr)->Num),	\
			(Player_MsgStartx_ParmList_Val), &((structAddr)->Val))


#define Player_MsgStartx_ParmList_Size		8

#define Player_MsgStartx_ParmList	0x6	/* 6 */

/*
 * Player_MsgStartx (value = 0x128) is an input message
 * for component Player.
 */


typedef struct {
	UInt32	StartMode;
	UInt32	PlayCount;
	UInt32	ParmCount;
	UInt32	RTCCount;
	UInt32	DetCount;
} Player_MsgStartx_t;

#define Player_MsgStartx_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(Player_MsgStartx_StartMode), &((structAddr)->StartMode),	\
			(Player_MsgStartx_PlayCount), &((structAddr)->PlayCount),	\
			(Player_MsgStartx_ParmCount), &((structAddr)->ParmCount),	\
			(Player_MsgStartx_RTCCount), &((structAddr)->RTCCount),	\
			(Player_MsgStartx_DetCount), &((structAddr)->DetCount))


#define Player_MsgStartx_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(Player_MsgStartx_StartMode), &((structAddr)->StartMode),	\
			(Player_MsgStartx_PlayCount), &((structAddr)->PlayCount),	\
			(Player_MsgStartx_ParmCount), &((structAddr)->ParmCount),	\
			(Player_MsgStartx_RTCCount), &((structAddr)->RTCCount),	\
			(Player_MsgStartx_DetCount), &((structAddr)->DetCount))


#define Player_MsgStartx_Size		20

#define Player_MsgStartx	0x128	/* 296 */
/* The MsgStartx message is sent to initiate a playback of pre-recorded data 
 * from a specified stream using a specified decoding algorithm. MsgStartx is 
 * an extension of the MsgStart2 message in which the ability to set parameters 
 * at start time is provided. The MsgStartCmplt message is returned when this 
 * message is received and successfully processed by the player. The EvtPlaying 
 * event may also be sent, if this event was enabled, at the time when playback 
 * actually starts. StartMode - starting mode. This is a bit map in that all of 
 * the modes may be OR'd together and set simultaneously. 
 * Player_MsgStartx_StartMode_NORMAL - No effect. 
 * Player_MsgStartx_StartMode_PAUSED - In the Play state but not sending data 
 * to TDM port. Player_MsgStartx_StartMode_TIMED - The play back will stop 
 * after the time specified in Player_ParmDuration has elapsed. PlayCount - 
 * number of prompt files in the PlayList. ParmCount - number of parameters to 
 * set RTCCount - for future expansion, should be set to zero DetCount - for 
 * future expansion, should be set to zero The PlayList consists of an array of 
 * one or more structures containing the stream ID, decoder type an starting 
 * offset into the stream. StreamID - The stream identifier for playback of the 
 * current PlayList entry. Decoding - The type of decoding to use for playback 
 * of the current PlayList entry. The values are defined in coders/coders.h. 
 * StartPos - The starting position (in bytes). 0 means beginning of data 
 * stream. Starting positions should be aligned with stream block boundaries, 
 * where the block size is the header size plus the maximum data size. In other 
 * words this is a raw byte offset into the persistent stream. It is the 
 * responsibility of the application to ensure that this offset corresponds to 
 * the start of a data block header. This starting position is only relevant 
 * for persistent streams, for regular G-Streams this must be set to 0. 
 * Reserved - Reserved for future use. This field must be set to zero. The 
 * ParmList contains parameters, expressed as tuples of Num and Val in List. 
 * Num - parameter number(s). Val - parameter value(s). */
/* 
 * Player Parameter Definitions
 */
/*
 * The duration for which to play.
 * (msecs). Default = 0 (i.e. no timeout).
 */

#define Player_ParmDuration	0x100	/* 256 */
typedef	UInt32	Player_ParmDuration_t;
/* The number of bytes to play before sending a EvtStatus event message. 
 * Default = 4000 */

#define Player_ParmBytesPlayed	0x101	/* 257 */
typedef	UInt32	Player_ParmBytesPlayed_t;

#define Player_ParmState_INIT	0	/* 0 */

#define Player_ParmState_DEALLOCATED	0x1	/* 1 */

#define Player_ParmState_IDLE	0x2	/* 2 */

#define Player_ParmState_PLAYING	0x3	/* 3 */

#define Player_ParmState_PAUSED	0x4	/* 4 */

#define Player_ParmState_STOPPING	0x5	/* 5 */

#define Player_ParmState_EXITING	0x6	/* 6 */
/*
 * The state of the Player Instance.
 */

#define Player_ParmState	0x102	/* 258 */
typedef	UInt32	Player_ParmState_t;
/* The level at which the file to be played has been recorded (in dBm). 
 * Default = TBD. */

#define Player_ParmRecordLevel	0x103	/* 259 */
typedef	UInt32	Player_ParmRecordLevel_t;
/* The level at which data is played to the SCBus (in dBm) when Volume Control 
 * is set to 0. Default = TBD */

#define Player_ParmNormalLevel	0x104	/* 260 */
typedef	UInt32	Player_ParmNormalLevel_t;
/*
 * The maximum level at which to transmit to the SCBus (in dBm). Default = TBD.
 */

#define Player_ParmMaxLevel	0x105	/* 261 */
typedef	UInt32	Player_ParmMaxLevel_t;
/* This parameter is provided as an aid in debugging the player resource. 
 * Setting it to a non-zero value enables the diagnostic printouts at the 
 * requested level. The parameter of the parameter is a bit-mask. Values for 
 * the options are given in section Debug Parameter. */

#define Player_ParmDebugLevel	0x106	/* 262 */
typedef	UInt32	Player_ParmDebugLevel_t;
/* This parameter is provided as an aid in debugging the decoder resource. The 
 * parameter's value is passed to the decoder associated with the player. 
 * Setting it to a non-zero value enables the diagnostic printouts at the 
 * requested level. The parameter of the parameter is a bit-mask. Values for 
 * the options are given in section Debug Parameter. */

#define Player_ParmDecoderDebugLevel	0x107	/* 263 */
typedef	UInt32	Player_ParmDecoderDebugLevel_t;

#define Player_ParmUnderrunReporting_On	0x7	/* 7 */

#define Player_ParmUnderrunReporting_Off	0x8	/* 8 */
/* This parameter is provided as a control for the reporting of underrun 
 * errors. The default for reporting of underruns is On. */

#define Player_ParmUnderrunReporting	0x108	/* 264 */
typedef	UInt32	Player_ParmUnderrunReporting_t;
/*
 * The RTC stop buffering parameter.
 * 1 = Buffering Enabled (Default)
 * 0= Buffering Disabled
 */

#define Player_ParmRtcStopBuffering	0x109	/* 265 */
typedef	UInt32	Player_ParmRtcStopBuffering_t;

#define Player_ParmResetSpdVol_CURR_SPEED	0x1	/* 1 */

#define Player_ParmResetSpdVol_CURR_VOLUME	0x2	/* 2 */

#define Player_ParmResetSpdVol_SPEED_TABLE	0x4	/* 4 */

#define Player_ParmResetSpdVol_VOLUME_TABLE	0x8	/* 8 */
/* Perform a reset to default values for the variables and tables indicated by 
 * the argument value. The argument value is bit-mapped, therefore, resetting 
 * both tables is accomplished by a bitwise OR of both values. */

#define Player_ParmResetSpdVol	0x10a	/* 266 */
typedef	UInt24	Player_ParmResetSpdVol_t;
/* Sets the speed, directly, relative increments from the origin. This means 
 * that using a value zero will set the current speed to the default value, 
 * using a value of '3' will set the speed three increments higher and using a 
 * value of '-2' will set the speed to two decrements lower. This parameter may 
 * not be used at the component level. */

#define Player_ParmCurrentSpeed	0x10b	/* 267 */
typedef	Int8	Player_ParmCurrentSpeed_t;
/* Sets the volume, directly, relative increments from the origin. This means 
 * that using a value zero will set the current volume to the default value, 
 * using a value of '3' will set the volume three increments higher and using a 
 * value of '-2' will set the volume to two decrements lower. This parameter 
 * may not be used at the component level. */

#define Player_ParmCurrentVolume	0x10c	/* 268 */
typedef	Int8	Player_ParmCurrentVolume_t;
/*
 * The Signal Id of the play-preceding beep. 
 * Default =  BEEP_DLGC
 */
/* 
 * Player Debug Parameter Options
 */

enum Player_DebugOptions {
DbgStateMachineMsgs = 0x01,

/*
 * Print all debugging messages associated with the state machine.
 */

DbgStdMsgs = 0x02,

/*
 * Print all debugging messages associated with the standard messages.
 */

DbgDecoderMsgs = 0x04,

/* Print all debugging messages pertaining to the coder associated with the 
 * player. */

DbgKernelMsgs = 0x08,

/* Print all debugging messages associated with kernel calls and messages, not 
 * including I/O streams. */

DbgInitializationMsgs = 0x10,

/*
 * Print all debugging messages associated with initialization.
 */

DbgStreamsMsgs = 0x20,

/*
 * Print all debugging messages associated with I/O streams.
 */

DbgOtherResourceMsgs = 0x40,

/*
 * Print all debugging messages associated with other resources.
 */

DbgVerbose = 0x8000};

/* Specifying DbgVerbose enables a longer, detailed printout for those areas 
 * in which it available. Typically, this will be in printing an entire message 
 * body, rather than message arrival notice. The default is the brief version, 
 * where the option exists. */
/* 
 * Player Error Code Definitions
 */

#define Player_ParmBeepSignalId	0x10d	/* 269 */
typedef	Int8	Player_ParmBeepSignalId_t;
/*
 * Invalid StreamId was specified.
 */

#define Player_ErrStreamID	0x100	/* 256 */
/*
 * Invalid Decoder was specified.
 */

#define Player_ErrDecoder	0x101	/* 257 */
/*
 * Cluster could not be activated.
 */

#define Player_ErrClusterActivate	0x102	/* 258 */
/*
 * Cluster information could not be obtained.
 */

#define Player_ErrClusterInfo	0x103	/* 259 */
/*
 * Invalid speed mode specified when adjusting speed.
 */

#define Player_ErrSpeedMode	0x104	/* 260 */
/*
 * Invalid volume mode specified when adjusting volume.
 */

#define Player_ErrVolumeMode	0x105	/* 261 */
/*
 * Invalid speed adjustment table entry. 
 */

#define Player_ErrSpeedTable	0x106	/* 262 */
/*
 * Invalid volume adjustment table entry.
 */

#define Player_ErrVolumeTable	0x107	/* 263 */
/*
 * The Reserved field has not been set to zero.
 */

#define Player_ErrReservedNotZero	0x108	/* 264 */
/*
 * Underrun detected. Not enough data in stream.
 */

#define Player_ErrUnderrun	0x109	/* 265 */
/*
 * The requested decoder is not avalaible.
 */

#define Player_ErrDecoderNotAvailable	0x10a	/* 266 */
/*
 * The requested decoder is not valid.
 */

#define Player_ErrInvalidDecoder	0x10b	/* 267 */
/*
 * The number of decoders has exceeded the maximum allowable.
 */

#define Player_ErrTooManyDecoders	0x10c	/* 268 */
/*
 * qFTimerSet failed, caused from invalid duration parameter.
 */

#define Player_ErrFTimer	0x10d	/* 269 */
/*
 * Tone Generator for the Beep-Initiated Play could not be found
 */
/*
 * Standard Attribute Definition
 */

#define Player_ErrNoTonegen	0x10e	/* 270 */

#define Player_Std_ComponentType	0x1	/* 1 */
/*
 * Player Component Type definition.
 */

#define Player_DIALOGIC	0x1	/* 1 */
/*
 * Dialogic Id.
 */
/*
 * Mercury Player Specific Attributes
 */

#define Player_Feature_SpeedControl	0x1	/* 1 */

#define Player_Feature_VolumeControl	0x2	/* 2 */

#define Player_Feature_DecoderReserve	0x3	/* 3 */

#define Player_Feature_AGC	0x4	/* 4 */

#define Player_Feature_Rewind	0x5	/* 5 */

#define Player_Feature_FastForward	0x6	/* 6 */
/*
 * Player features.
 */
/* 
 * Player Event Type Definitions. 
 */

#define Player_Feature	0x3	/* 3 */
typedef	QCompAttr	Player_Feature_t;

#define Player_Event_ReturnAddress	0x800000	/* 8388608 */
typedef	QCompDesc	Player_Event_ReturnAddress_t;

#define Player_Event_Type_EvtPlaying	0x150	/* 336 */

#define Player_Event_Type_EvtPaused	0x151	/* 337 */

#define Player_Event_Type_EvtStopped	0x152	/* 338 */

#define Player_Event_Type_EvtSpeed	0x153	/* 339 */

#define Player_Event_Type_EvtVolume	0x154	/* 340 */

#define Player_Event_Type_EvtStatus	0x155	/* 341 */

#define Player_Event_Type_EvtUnderrun	0x156	/* 342 */

#define Player_Event_Type	0x380006	/* 3670022 */
typedef	UInt32	Player_Event_Type_t;

#define Player_Event_Label	0x38000a	/* 3670026 */
typedef	UInt32	Player_Event_Label_t;

/*
 * Player_Event (value = generic) is a message
 * for component Player.
 */


typedef struct {
	QCompDesc	ReturnAddress;
	UInt32	Type;
	UInt32	Label;
} Player_Event_t;

#define Player_Event_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Player_Event_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(Player_Event_Type), &((structAddr)->Type),	\
			(Player_Event_Label), &((structAddr)->Label))


#define Player_Event_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Player_Event_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(Player_Event_Type), &((structAddr)->Type),	\
			(Player_Event_Label), &((structAddr)->Label))


#define Player_Event_Size		14

#define Player_EvtPlaying_Label	0x380000	/* 3670016 */
typedef	UInt32	Player_EvtPlaying_Label_t;

#define Player_EvtPlaying_Reason_MsgStart	0x100	/* 256 */

#define Player_EvtPlaying_Reason_Rtc	0x4	/* 4 */

#define Player_EvtPlaying_Reason_MsgResume	0x106	/* 262 */

#define Player_EvtPlaying_Reason_MsgPlayNextSegment	0x114	/* 276 */

#define Player_EvtPlaying_Reason	0x380004	/* 3670020 */
typedef	UInt32	Player_EvtPlaying_Reason_t;

#define Player_EvtPlaying_RtcLabel	0x380008	/* 3670024 */
typedef	UInt32	Player_EvtPlaying_RtcLabel_t;

/*
 * Player_EvtPlaying (value = generic) is an output message
 * for component Player.
 */


typedef struct {
	UInt32	Label;
	UInt32	Reason;
	UInt32	RtcLabel;
} Player_EvtPlaying_t;

#define Player_EvtPlaying_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Player_EvtPlaying_Label), &((structAddr)->Label),	\
			(Player_EvtPlaying_Reason), &((structAddr)->Reason),	\
			(Player_EvtPlaying_RtcLabel), &((structAddr)->RtcLabel))


#define Player_EvtPlaying_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Player_EvtPlaying_Label), &((structAddr)->Label),	\
			(Player_EvtPlaying_Reason), &((structAddr)->Reason),	\
			(Player_EvtPlaying_RtcLabel), &((structAddr)->RtcLabel))


#define Player_EvtPlaying_Size		12
/*
 * EvtPlaying is generated when playback has started.
 */

#define Player_EvtPaused_Label	0x380000	/* 3670016 */
typedef	UInt32	Player_EvtPaused_Label_t;

#define Player_EvtPaused_Reason_MsgStart	0x100	/* 256 */

#define Player_EvtPaused_Reason_MsgPause	0x104	/* 260 */

#define Player_EvtPaused_Reason_Rtc	0x4	/* 4 */

#define Player_EvtPaused_Reason	0x380004	/* 3670020 */
typedef	UInt32	Player_EvtPaused_Reason_t;

#define Player_EvtPaused_RtcLabel	0x380008	/* 3670024 */
typedef	UInt32	Player_EvtPaused_RtcLabel_t;

/*
 * Player_EvtPaused (value = generic) is an output message
 * for component Player.
 */


typedef struct {
	UInt32	Label;
	UInt32	Reason;
	UInt32	RtcLabel;
} Player_EvtPaused_t;

#define Player_EvtPaused_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Player_EvtPaused_Label), &((structAddr)->Label),	\
			(Player_EvtPaused_Reason), &((structAddr)->Reason),	\
			(Player_EvtPaused_RtcLabel), &((structAddr)->RtcLabel))


#define Player_EvtPaused_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Player_EvtPaused_Label), &((structAddr)->Label),	\
			(Player_EvtPaused_Reason), &((structAddr)->Reason),	\
			(Player_EvtPaused_RtcLabel), &((structAddr)->RtcLabel))


#define Player_EvtPaused_Size		12
/*
 * EvtPaused is generated when playback has been paused. 
 */

#define Player_EvtStopped_Label	0x380000	/* 3670016 */
typedef	UInt32	Player_EvtStopped_Label_t;

#define Player_EvtStopped_Reason_UserStop	0x1	/* 1 */

#define Player_EvtStopped_Reason_Rtc	0x4	/* 4 */

#define Player_EvtStopped_Reason_Timeout	0x3	/* 3 */

#define Player_EvtStopped_Reason_EOT	0x2	/* 2 */

#define Player_EvtStopped_Reason_EOS	0x80	/* 128 */

#define Player_EvtStopped_Reason_InvalidDecoder	0x171	/* 369 */

#define Player_EvtStopped_Reason_Deallocated	0x172	/* 370 */

#define Player_EvtStopped_Reason_DecoderExited	0x173	/* 371 */

#define Player_EvtStopped_Reason_StreamError	0x174	/* 372 */

#define Player_EvtStopped_Reason_BrokenPipe	0x175	/* 373 */

#define Player_EvtStopped_Reason_BeepToneError	0x176	/* 374 */

#define Player_EvtStopped_Reason	0x380004	/* 3670020 */
typedef	UInt32	Player_EvtStopped_Reason_t;

#define Player_EvtStopped_RtcLabel	0x380008	/* 3670024 */
typedef	UInt32	Player_EvtStopped_RtcLabel_t;

#define Player_EvtStopped_TimePlayed	0x38000c	/* 3670028 */
typedef	UInt32	Player_EvtStopped_TimePlayed_t;

#define Player_EvtStopped_BytesPlayed	0x380010	/* 3670032 */
typedef	UInt32	Player_EvtStopped_BytesPlayed_t;

/*
 * Player_EvtStopped (value = generic) is an output message
 * for component Player.
 */


typedef struct {
	UInt32	Label;
	UInt32	Reason;
	UInt32	RtcLabel;
	UInt32	TimePlayed;
	UInt32	BytesPlayed;
} Player_EvtStopped_t;

#define Player_EvtStopped_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(Player_EvtStopped_Label), &((structAddr)->Label),	\
			(Player_EvtStopped_Reason), &((structAddr)->Reason),	\
			(Player_EvtStopped_RtcLabel), &((structAddr)->RtcLabel),	\
			(Player_EvtStopped_TimePlayed), &((structAddr)->TimePlayed),	\
			(Player_EvtStopped_BytesPlayed), &((structAddr)->BytesPlayed))


#define Player_EvtStopped_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(Player_EvtStopped_Label), &((structAddr)->Label),	\
			(Player_EvtStopped_Reason), &((structAddr)->Reason),	\
			(Player_EvtStopped_RtcLabel), &((structAddr)->RtcLabel),	\
			(Player_EvtStopped_TimePlayed), &((structAddr)->TimePlayed),	\
			(Player_EvtStopped_BytesPlayed), &((structAddr)->BytesPlayed))


#define Player_EvtStopped_Size		20
/* EvtStopped is generated when playback has stopped. The reason for stopping, 
 * the length of time played before stopping (since the corresponding 
 * MsgStart), in milliseconds, and the number of bytes played before stopping 
 * (since the corresponding MsgStart) are in the data field of the message. */

#define Player_EvtSpeed_Label	0x380000	/* 3670016 */
typedef	UInt32	Player_EvtSpeed_Label_t;

#define Player_EvtSpeed_NewSpeed	0x80004	/* 524292 */
typedef	Int16	Player_EvtSpeed_NewSpeed_t;

#define Player_EvtSpeed_Reason_MsgAdjSpeed	0x108	/* 264 */

#define Player_EvtSpeed_Reason_Rtc	0x4	/* 4 */

#define Player_EvtSpeed_Reason_ParmSetSpeed	0x5	/* 5 */

#define Player_EvtSpeed_Reason_Reset	0x6	/* 6 */

#define Player_EvtSpeed_Reason	0x380006	/* 3670022 */
typedef	UInt32	Player_EvtSpeed_Reason_t;

#define Player_EvtSpeed_RtcLabel	0x38000a	/* 3670026 */
typedef	UInt32	Player_EvtSpeed_RtcLabel_t;

/*
 * Player_EvtSpeed (value = generic) is an output message
 * for component Player.
 */


typedef struct {
	UInt32	Label;
	Int16	NewSpeed;
	UInt32	Reason;
	UInt32	RtcLabel;
} Player_EvtSpeed_t;

#define Player_EvtSpeed_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_EvtSpeed_Label), &((structAddr)->Label),	\
			(Player_EvtSpeed_NewSpeed), &((structAddr)->NewSpeed),	\
			(Player_EvtSpeed_Reason), &((structAddr)->Reason),	\
			(Player_EvtSpeed_RtcLabel), &((structAddr)->RtcLabel))


#define Player_EvtSpeed_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_EvtSpeed_Label), &((structAddr)->Label),	\
			(Player_EvtSpeed_NewSpeed), &((structAddr)->NewSpeed),	\
			(Player_EvtSpeed_Reason), &((structAddr)->Reason),	\
			(Player_EvtSpeed_RtcLabel), &((structAddr)->RtcLabel))


#define Player_EvtSpeed_Size		14
/* EvtSpeed is generated when playback speed has been changed. The new speed 
 * (i.e. index in Speed Adjustment Table) is in the data field of the message. */

#define Player_EvtVolume_Label	0x380000	/* 3670016 */
typedef	UInt32	Player_EvtVolume_Label_t;

#define Player_EvtVolume_NewVolume	0x80004	/* 524292 */
typedef	Int16	Player_EvtVolume_NewVolume_t;

#define Player_EvtVolume_Reason_MsgAdjVolume	0x10a	/* 266 */

#define Player_EvtVolume_Reason_Rtc	0x4	/* 4 */

#define Player_EvtVolume_Reason_ParmSetVolume	0x5	/* 5 */

#define Player_EvtVolume_Reason_Reset	0x6	/* 6 */

#define Player_EvtVolume_Reason	0x380006	/* 3670022 */
typedef	UInt32	Player_EvtVolume_Reason_t;

#define Player_EvtVolume_RtcLabel	0x38000a	/* 3670026 */
typedef	UInt32	Player_EvtVolume_RtcLabel_t;

/*
 * Player_EvtVolume (value = generic) is an output message
 * for component Player.
 */


typedef struct {
	UInt32	Label;
	Int16	NewVolume;
	UInt32	Reason;
	UInt32	RtcLabel;
} Player_EvtVolume_t;

#define Player_EvtVolume_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Player_EvtVolume_Label), &((structAddr)->Label),	\
			(Player_EvtVolume_NewVolume), &((structAddr)->NewVolume),	\
			(Player_EvtVolume_Reason), &((structAddr)->Reason),	\
			(Player_EvtVolume_RtcLabel), &((structAddr)->RtcLabel))


#define Player_EvtVolume_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Player_EvtVolume_Label), &((structAddr)->Label),	\
			(Player_EvtVolume_NewVolume), &((structAddr)->NewVolume),	\
			(Player_EvtVolume_Reason), &((structAddr)->Reason),	\
			(Player_EvtVolume_RtcLabel), &((structAddr)->RtcLabel))


#define Player_EvtVolume_Size		14
/* EvtVolumeis generated when playback volume has been changed. The new volume 
 * (i.e. index in Volume Adjustment Table) is in the data field of the message. */

#define Player_EvtStatus_Label	0x380000	/* 3670016 */
typedef	UInt32	Player_EvtStatus_Label_t;

#define Player_EvtStatus_BytesPlayed	0x380004	/* 3670020 */
typedef	UInt32	Player_EvtStatus_BytesPlayed_t;

/*
 * Player_EvtStatus (value = generic) is an input or output message
 * for component Player.
 */


typedef struct {
	UInt32	Label;
	UInt32	BytesPlayed;
} Player_EvtStatus_t;

#define Player_EvtStatus_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Player_EvtStatus_Label), &((structAddr)->Label),	\
			(Player_EvtStatus_BytesPlayed), &((structAddr)->BytesPlayed))


#define Player_EvtStatus_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Player_EvtStatus_Label), &((structAddr)->Label),	\
			(Player_EvtStatus_BytesPlayed), &((structAddr)->BytesPlayed))


#define Player_EvtStatus_Size		8
/* EvtStatus is generated when all of the bytes in a block flagged with EOD 
 * have been consumed. The number of bytes played is reported in this message. */

#define Player_EvtUnderrun_Label	0x380000	/* 3670016 */
typedef	UInt32	Player_EvtUnderrun_Label_t;

/*
 * Player_EvtUnderrun (value = generic) is an input or output message
 * for component Player.
 */


typedef struct {
	UInt32	Label;
} Player_EvtUnderrun_t;

#define Player_EvtUnderrun_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Player_EvtUnderrun_Label), &((structAddr)->Label))


#define Player_EvtUnderrun_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Player_EvtUnderrun_Label), &((structAddr)->Label))


#define Player_EvtUnderrun_Size		4
/* EvtUnderrun is generated when there are insufficient data to continue 
 * playing. (Silence will be transmitted.) */
/* 
 * Player Run Time Control Actions Definitions
 */

#define Player_Action_Label	0x380000	/* 3670016 */
typedef	UInt32	Player_Action_Label_t;

#define Player_Action_Type_RtcStop	0x170	/* 368 */

#define Player_Action_Type_RtcPause	0x171	/* 369 */

#define Player_Action_Type_RtcResume	0x172	/* 370 */

#define Player_Action_Type_RtcSpeedUp	0x173	/* 371 */

#define Player_Action_Type_RtcSpeedDown	0x174	/* 372 */

#define Player_Action_Type_RtcSpeedNormal	0x175	/* 373 */

#define Player_Action_Type_RtcSpeedToggle	0x176	/* 374 */

#define Player_Action_Type_RtcVolumeUp	0x177	/* 375 */

#define Player_Action_Type_RtcVolumeDown	0x178	/* 376 */

#define Player_Action_Type_RtcVolumeNormal	0x179	/* 377 */

#define Player_Action_Type_RtcVolumeToggle	0x17a	/* 378 */

#define Player_Action_Type	0x380004	/* 3670020 */
typedef	UInt32	Player_Action_Type_t;

/*
 * Player_Action (value = generic) is a message
 * for component Player.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
} Player_Action_t;

#define Player_Action_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Player_Action_Label), &((structAddr)->Label),	\
			(Player_Action_Type), &((structAddr)->Type))


#define Player_Action_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Player_Action_Label), &((structAddr)->Label),	\
			(Player_Action_Type), &((structAddr)->Type))


#define Player_Action_Size		8
/*
 * RtcStop is a RTC Action to stop playback.
 */
/*
 * RtcPause is a RTC Action to pause playback. 
 */
/*
 * RtcResume is a RTC Action to resume playback.
 */
/*
 * RtcSpeedUp is a RTC Action to speed up one increment.
 */
/*
 * RtcSpeedDown is a RTC Action to slow down one increment.
 */
/*
 * RtcSpeedNormal is a RTC Action to play at normal speed.
 */
/* RtcSpeedToggle is a RTC Action to toggle between current speed and normal 
 * speed. */
/*
 * RtcVolumeUp is a RTC Action to adjust volume up one increment.
 */
/*
 * RtcVolumeDown is a RTC Action to adjust volume down one increment.
 */
/*
 * RtcVolumeNormal is a RTC Action to play at normal volume
 */
/* RtcVolumeToggle is a RTC Action to toggle between current volume and normal 
 * volume. */

#define Player_SpeedTable_NullValue 0x7ffe
#define Player_VolumeTable_NullValue 0x7fff

/*
 * End of all Mercury Player Component Definitions
 */

#define Player	0x1	/* 1 */

typedef struct {
	UInt32		ParmDuration;
	UInt32		ParmBytesPlayed;
	UInt32		ParmState;
	UInt32		ParmRecordLevel;
	UInt32		ParmNormalLevel;
	UInt32		ParmMaxLevel;
	UInt32		ParmDebugLevel;
	UInt32		ParmDecoderDebugLevel;
	UInt32		ParmUnderrunReporting;
	UInt32		ParmRtcStopBuffering;
	UInt24		ParmResetSpdVol;
	Int8		ParmCurrentSpeed;
	Int8		ParmCurrentVolume;
	Int8		ParmBeepSignalId;

} Playerparm_t;

#if defined ( Player_DEFINED )

ParmStruct PlayerParmTab []= {
{Player_ParmDuration, 14, 0, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmDuration), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmBytesPlayed), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmState), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmRecordLevel), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmNormalLevel), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmMaxLevel), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmDebugLevel), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmDecoderDebugLevel), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmUnderrunReporting), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Playerparm_t, ParmRtcStopBuffering), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Playerparm_t, ParmResetSpdVol), PARM_READWRITE, 0, 0, 0},
 {0x0, offsetof(Playerparm_t, ParmCurrentSpeed), PARM_READWRITE, 0, 0, 0},
 {0x0, offsetof(Playerparm_t, ParmCurrentVolume), PARM_READWRITE, 0, 0, 0},
 {0x0, offsetof(Playerparm_t, ParmBeepSignalId), PARM_READWRITE, 0, 0, 0},

};

#endif


#endif /* !defined(_playdefs_h_) */
