/****************************************************************************
 *		Copyright (c) 1995-2002 Intel Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         playLocs.h
 * AUTHOR:       Ray Bailey
 * ORG:          Intel Corporation
 * ORIG-DATE:    13-Apr-00 at 18:03:04
 * LAST-MOD:      8-Oct-02 at 14:05:13 by Art Elwell
 * PURPOSE:
 *
 * HISTORY:
 * Date			Who	Description
 * 13-Apr-00          	RB	Initial Version
 ***************************************************************************/
#if !defined(_playerLocations_h)
#define _playerLocations_h 1

#define END_OF_LOCS_TABLE 0

#include "qmiscapi.h"

/* 
 * Player wrappers for qError( ) calls
 */
void playerErrKillTask ( Uint24 errTag );
void playerErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc );
void playerErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 );
void playerErrWarning ( Uint24 errTag );
void playerErrInstWarning ( Uint24 errTag, QCompDesc *pDesc );
void playerErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 );
void playerErrAdvisory ( Uint24 errTag );
void playerErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc );
void playerErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 );


#if !defined(_Playcomp_C__)
extern char *playerLocationsFileName;
#else 
char *playerLocationsFileName = "playlocs.h";

/******************************************************************************
 *       NAME : playerErrKillTask
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void playerErrKillTask ( Uint24 errTag )
{
  qError (QERR_KILLTASK, errTag, playerLocationsFileName);
}

/******************************************************************************
 *       NAME : playerErrInstKillTask
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void playerErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_KILLTASK, errTag, playerLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : playerErrArgsKillTask
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void playerErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
   int count=4;
   qErrorArgs (QERR_KILLTASK, errTag, playerLocationsFileName, pDesc, count, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : playerErrWarning
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void playerErrWarning ( Uint24 errTag )
{
  qError (QERR_WARNING, errTag, playerLocationsFileName);
}

/******************************************************************************
 *       NAME : playerErrInstWarning
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void playerErrInstWarning ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_WARNING, errTag, playerLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : playerErrArgsWarning
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void playerErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_WARNING, errTag, playerLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : playerErrAdvisory
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void playerErrAdvisory ( Uint24 errTag )
{
  qError (QERR_ADVISORY, errTag, playerLocationsFileName);
}

/******************************************************************************
 *       NAME : playerErrInstAdvisory
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void playerErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_ADVISORY, errTag, playerLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : playerErrArgsAdvisory
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void playerErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_ADVISORY, errTag, playerLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

#endif

#define PLAY_LOC_000	0x800000 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_001	0x800001 /* PLAYER:playcomp.c:playerCompTask(),
				    Player received NON_Std_MsgCrashCP message */

#define PLAY_LOC_002	0x800002 /* PLAYER:playcomp.c:playerCompTask(),
				    playerComp in unexpected initState %02xH */

#define PLAY_LOC_003	0x800003 /* PLAYER:playcomp.c:playerCompTask(),
				    playerComp in unexpected state %02xH */

#define PLAY_LOC_004	0x800004 /* PLAYER:playinst.c:playerPausedStateHdlr(),
				    playInst%02d in unexpected pausedState %02d */

#define PLAY_LOC_005	0x800005 /* PLAYER:playinst.c:playerPlayingStateHdlr(),
				    playInst%02d in unexpected playingState %02d */

#define PLAY_LOC_006	0x800006 /* PLAYER:playinst.c:playerMainStateHdlr(),
				    playInst%02d Unexpected mainState %02d */

#define PLAY_LOC_007	0x800007 /* PLAYER:playinst.c:playerAdjustSpeed(),
				    playInst%02d cannot make speed adjustment */

#define PLAY_LOC_008	0x800008 /* PLAYER:playinst.c:playerAdjustVolume(),
				    playInst%02d cannot make volume adjustment */

#define PLAY_LOC_009	0x800009 /* PLAYER:playinst.c:playerRTCAction(),
				    Invalid Action in RTC Action List!! */

#define PLAY_LOC_010	0x800010 /* PLAYER:playcomp.c:playerRegisterInstances(),
                               qCompInstanceRegister FAILURE*/

#define PLAY_LOC_011	0x800011 /* PLAYER:.playcomp.c:(),
                               Unable to allocate Std_MsgInit, qMsgAllocate FAIL*/

#define PLAY_LOC_012	0x800012 /* PLAYER:.playcomp.c:(),
                               Unable to send Std_MsgInit, qMsgWrite FAIL*/   

#define PLAY_LOC_013	0x800013 /* PLAYER:.playcomp.c:(),
                               Unable to create Component Parameter Table, 
                               qMemAlloc FAILURE */

#define PLAY_LOC_014	0x800014 /* PLAYER:.playcomp.c:(),
                               qCompRegister FAILURE */

#define PLAY_LOC_015	0x800015 /* PLAYER:.playcomp.c:(),
                               qMsgRead FAILURE */

#define PLAY_LOC_016	0x800016 /* PLAYER:.playcomp.c:(),
                               Std_MsgSetParm_get FAILURE */

#define PLAY_LOC_017	0x800017 /* PLAYER:.playcomp.c:(),
                               Std_MsgSetParmDef_get FAILURE */

#define PLAY_LOC_018	0x800018 /* PLAYER:.playcomp.c:(),
                               Std_MsgGetParm_get FAILURE */

#define PLAY_LOC_019	0x800019 /* PLAYER:.playcomp.c:(),
                               Unable to allocate message Std_MsgGetParmCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_020	0x800020 /* PLAYER:.playcomp.c:(),
                               Std_MsgGetParmCmplt_put FAILURE */

#define PLAY_LOC_021	0x800021 /* PLAYER:.playcomp.c:(),
                               Unable to send message Std_MsgGetParmCmplt,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_022	0x800022 /* PLAYER:.playcomp.c:(),
                               Player_MsgSetSpeedAdjTable_get FAILURE */

#define PLAY_LOC_023	0x800023 /* PLAYER:.playcomp.c:(),
                               Unable to allocate message 
                               Player_MsgSetSpeedAdjTableCmplt, qMsgAllocate FAILURE*/

#define PLAY_LOC_024	0x800024 /* PLAYER:.playcomp.c:(),
                               Unable to send
                               Player_MsgSetSpeedAdjTableCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_025	0x800025 /* PLAYER:.playcomp.c:(),
                               Player_MsgSetVolumeAdjTable_get FAILURE */

#define PLAY_LOC_026	0x800026 /* PLAYER:.playcomp.c:(),
                               Unable to allocate message
                               Player_MsgSetVolumeAdjTableCmplt, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_027	0x800027 /* PLAYER:.playcomp.c:(),
                               Unable to send
                               Player_MsgSetVolumeAdjTableCmplt, qMsgWrite FAILURE*/

#define PLAY_LOC_028	0x800028 /* PLAYER:.playcomp.c:(),
                               Unable to allocate
                               Player_MsgGetSpeedAdjTableCmplt, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_029	0x800029 /* PLAYER:.playcomp.c:(),
                               Player_MsgGetSpeedAdjTableCmplt_put FAILURE */

#define PLAY_LOC_030	0x800030 /* PLAYER:.playcomp.c:(),
                               Unable to send
                               Player_MsgGetSpeedAdjTableCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_031	0x800031 /* PLAYER:.playcomp.c:(),
                               Unable to allocate message
                               Player_MsgGetVolumeAdjTableCmplt, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_032	0x800032 /* PLAYER:.playcomp.c:(),
                               Player_MsgGetVolumeAdjTableCmplt_put FAILURE */

#define PLAY_LOC_033	0x800033 /* PLAYER:.playcomp.c:(),
                               Unable to send
                               Player_MsgGetVolumeAdjTableCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_034	0x800034 /* PLAYER:.playcomp.c:(),
                               playerGetParmValue FAILURE for Std_ParmInstNum */

#define PLAY_LOC_035	0x800035 /* PLAYER:.playcomp.c:(),
                               playerGetParmValue FAILURE for Std_ParmMaxInst*/

#define PLAY_LOC_036	0x800036 /* PLAYER:.playcomp.c:(),
                               playerGetParmValue FAILURE for Std_ParmStartInst*/

#define PLAY_LOC_037	0x800037 /* PLAYER:.playcomp.c:(),
                                qMemAlloc FAILURE while creating player
                                instances (IDBs) */

#define PLAY_LOC_038	0x800038 /* PLAYER:.playcomp.c:(),
                                qMemAlloc FAILURE while creating decoder
                                attribute  table */

#define PLAY_LOC_039	0x800039 /* PLAYER:.playcomp.c:(),
                               Unable to allocate message
                               Player_MsgAllocateDecoderCmplt, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_040	0x800040 /* PLAYER:.playcomp.c:(),
                               Unable to send Player_MsgAllocateDecoderCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_041	0x800041 /* PLAYER:.playcomp.c:(),
                               Unable to allocate message Std_MsgInitCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_042	0x800042 /* PLAYER:.playcomp.c:(),
                               Unable to send Std_MsgInitCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_043	0x800043 /* PLAYER:.playcomp.c:(),
                               qMsgFree FAILURE */

#define PLAY_LOC_044	0x800044 /* PLAYER:playinst.c:(),
                               During  MsgStart unable to allocate
                               Std_MsgSetParm, qMsgAllocate FAILURE, for Player_MsgAdjVolume */

#define PLAY_LOC_045	0x800045 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE, for Player_MsgAdjVolume */

#define PLAY_LOC_046	0x800046 /* PLAYER:playinst.c:(),
                               Unable to send
                               Std_MsgSetParm, qMsgWrite FAILURE, for 
                               Player_MsgAdjVolume */

#define PLAY_LOC_047	0x800047 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Std_MsgSetParm, qMsgAllocate FAILURE, for
                               Player_MsgAdjSpeed  */

#define PLAY_LOC_048	0x800048 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE, for
                               Player_MsgAdjSpeed */

#define PLAY_LOC_049	0x800049 /* PLAYER:playinst.c:(),
                               Unable to send
                               Std_MsgSetParm, qMsgWrite FAILURE, for 
                               Player_MsgAdjSpeed*/

#define PLAY_LOC_050	0x800050 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgStart, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_051	0x800051 /* PLAYER:playinst.c:(),
                               Unable to allocate message Std_MsgSetParm,
                               qMsgAllocate FAILURE during 
                               */

#define PLAY_LOC_052	0x800052 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE duing 
                               */

#define PLAY_LOC_053	0x800053 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgSetParm, qMsgWrite
                               FAILURE 
                                */

#define PLAY_LOC_054	0x800054 /* PLAYER:playinst.c:(),
                               Unable to allocate message Std_MsgEvtDetected,
                               qMsgAllocate FAILURE during EvtPlaying*/

#define PLAY_LOC_055	0x800055 /* PLAYER:playinst.c:(),
                               Player_EvtPlaying_put FAILURE */

#define PLAY_LOC_056	0x800056 /* PLAYER:playinst.c:(),
                                Unable to allocate Std_MsgEvtDetected,
                                qMsgAllocate  during EvtPlaying */

#define PLAY_LOC_057	0x800057 /* PLAYER:playinst.c:(),
                               qMsgFree FAILURE for Std_MsgEvtDetected*/

#define PLAY_LOC_058	0x800058 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate FAILURE during EvtPaused*/

#define PLAY_LOC_059	0x800059 /* PLAYER:playinst.c:(),
                               Player_EvtPaused_put FAILURE */

#define PLAY_LOC_060	0x800060 /* PLAYER:playinst.c:(),
                               Unable to send EvtPaused, qMsgWrite FAILURE */

#define PLAY_LOC_061	0x800061 /* PLAYER:playinst.c:(),
                               Unable to allocate message Std_MsgEvtDetected,
                               qMsgAllocate FAILURE during EvtPaused */

#define PLAY_LOC_062	0x800062 /* PLAYER:playinst.c:(),
                               qMsgFree FAILURE for Std_MsgEvtDetected */

#define PLAY_LOC_063	0x800063 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate during EvtStopped */

#define PLAY_LOC_064	0x800064 /* PLAYER:playinst.c:(),
                               Player_EvtStopped_put FAILURE */

#define PLAY_LOC_065	0x800065 /* PLAYER:playinst.c:(),
                               Unable to send EvtStopped, qMsgWrite FAILURE */

#define PLAY_LOC_066	0x800066 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate FAILURE  during EvtStopped*/

#define PLAY_LOC_067	0x800067 /* PLAYER:playinst.c:(),
                               qMsgFree FAILURE for Std_MsgEvtDetected */

#define PLAY_LOC_068	0x800068 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate during EvtSpeed */

#define PLAY_LOC_069	0x800069 /* PLAYER:playinst.c:(),
                                Player_EvtSpeed_put FAILURE */

#define PLAY_LOC_070	0x800070 /* PLAYER:playinst.c:(),
                               Unable to send EvtSpeed, qMsgWrite FAILURE */

#define PLAY_LOC_071	0x800071 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate FAILURE during EvtSpeed */

#define PLAY_LOC_072	0x800072 /* PLAYER:playinst.c:(),
                               qMsgFree FAILURE for Std_MsgEvtDetected */

#define PLAY_LOC_073	0x800073 /* PLAYER:playinst.c:(),
                                Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate FAILURE  during EvtVolume*/

#define PLAY_LOC_074	0x800074 /* PLAYER:playinst.c:(),
                               Player_EvtVolume_put FAILURE */

#define PLAY_LOC_075	0x800075 /* PLAYER:playinst.c:(),
                               Unable to send EvtVolume, qMsgWrite FAILURE */

#define PLAY_LOC_076	0x800076 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate FAILURE  during EvtVolume*/

#define PLAY_LOC_077	0x800077 /* PLAYER:playinst.c:(),
                               qMsgFree FAILURE for Std_MsgEvtDetected */

#define PLAY_LOC_078	0x800078 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate FAILURE  during EvtStatus */

#define PLAY_LOC_079	0x800079 /* PLAYER:playinst.c:(),
                               Player_EvtStatus_put FAILURE */

#define PLAY_LOC_080	0x800080 /* PLAYER:playinst.c:(),
                               Unable to send EvtStatus, qMsgWrite FAILURE*/

#define PLAY_LOC_081	0x800081 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate FAILURE  during EvtStatus*/

#define PLAY_LOC_082	0x800082 /* PLAYER:playinst.c:(),
                               qMsgFree FAILURE for Std_MsgEvtDetected */

#define PLAY_LOC_083	0x800083 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate FAILURE  during EvtUnderrun*/

#define PLAY_LOC_084	0x800084 /* PLAYER:playinst.c:(),
                               Std_MsgEvtDetected_put FAILURE for EvtUnderrun */

#define PLAY_LOC_085	0x800085 /* PLAYER:playinst.c:(),
                               Unable to send EvtDetected for EvtUnderrun, 
                               qMsgWrite FAILURE*/

#define PLAY_LOC_086	0x800086 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgEvtDetected,
                               qMsgAllocate FAILURE  during EvtUnderrun */

#define PLAY_LOC_087	0x800087 /* PLAYER:playinst.c:(),
                               qMsgFree FAILURE for Std_MsgEvtDetected */

#define PLAY_LOC_088	0x800088 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE */

#define PLAY_LOC_089	0x800089 /* PLAYER:playinst.c:(),
                               Unable to allocate message Player_MsgStopped,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_090	0x800090 /* PLAYER:playinst.c:(),
                               Player_MsgStopped_put FAILURE */

#define PLAY_LOC_091	0x800091 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgStopped, qMsgWrite
                               FAILURE */

#define PLAY_LOC_092	0x800092 /* PLAYER:playinst.c:(),
                               qHostExitCmplt FAILURE */

#define PLAY_LOC_093	0x800093 /* PLAYER:playinst.c:(),
                               qCompAllocateAck FAILURE */

#define PLAY_LOC_094	0x800094 /* PLAYER:playinst.c:(),
                               qCompFree FAILURE */

#define PLAY_LOC_095	0x800095 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE */

#define PLAY_LOC_096	0x800096 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE. This was the result
                               of an asynchronous cluster activation with a
                               MsgStop received before the QResultComplete.*/

#define PLAY_LOC_097	0x800097 /* PLAYER:playinst.c:(),
                               Unable to allocate message
                               Player_MsgActivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_098	0x800098 /* PLAYER:playinst.c:(),
                                Player_MsgActivateDictionaryCmplt_put FAILURE */

#define PLAY_LOC_099	0x800099 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgActivateDictionaryCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_100	0x800100 /* PLAYER:playinst.c:(),
                               Unable to allocate message
                               Player_MsgDeactivateDictionaryCmplt,
                               qMsgAllocate FAILURE  */

#define PLAY_LOC_101	0x800101 /* PLAYER:playinst.c:(),
                                Player_MsgDeactivateDictionaryCmplt_put
                                FAILURE */

#define PLAY_LOC_102	0x800102 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgDeactivateDictionaryCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_103	0x800103 /* PLAYER:playinst.c:(),
                               Player_MsgUnloadDictionary_get FAILURE */

#define PLAY_LOC_104	0x800104 /* PLAYER:playinst.c:(),
                               Player_MsgUnloadDictionary_get FAILURE */

#define PLAY_LOC_105	0x800105 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgUnloadDictionary,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_106	0x800106 /* PLAYER:playinst.c:(),
                               ADec_MsgUnloadDictionary_put FAILURE */

#define PLAY_LOC_107	0x800107 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgUnloadDictionary,
                               qMsgWrite FAILURE */

#define PLAY_LOC_108	0x800108 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgUnloadDictionaryCmplt, qMsgAllocate
                               FAILURE  */

#define PLAY_LOC_109	0x800109 /* PLAYER:playinst.c:(),
                               Player_MsgUnloadDictionaryCmplt_put FAILURE */

#define PLAY_LOC_110	0x800110 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgUnloadDictionaryCmplt, qMsgWrite
                               FAILURE  */

#define PLAY_LOC_111	0x800111 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during qFTimerSet
                               FAILURE */

#define PLAY_LOC_112	0x800112 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgStart, qMsgWrite
                               FAILURE */

#define PLAY_LOC_113	0x800113 /* PLAYER:playinst.c:(),
                               Unable to allocate message
                               Player_MsgResumeCmplt, qMsgAllocate FAILURE */

#define PLAY_LOC_114	0x800114 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgResumeCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_115	0x800115 /* PLAYER:playinst.c:(),
                              qGStreamTerminate FAILURE, rcvd Player_MsgStop
                              in paused_start state */

#define PLAY_LOC_116	0x800116 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgActivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_117	0x800117 /* PLAYER:playinst.c:(),
                               Player_MsgActivateDictionaryCmplt_put FAILURE */

#define PLAY_LOC_118	0x800118 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgActivateDictionaryCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_119	0x800119 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgDeactivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_120	0x800120 /* PLAYER:playinst.c:(),
                               Player_MsgDeactivateDictionaryCmplt_put
                               FAILURE */

#define PLAY_LOC_121	0x800121 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgDeactivateDictionaryCmplt, qMsgWrite
                               FAILURE  */

#define PLAY_LOC_122	0x800122 /* PLAYER:playinst.c:(),
                               Std_MsgError_get FAILURE */

#define PLAY_LOC_123	0x800123 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, after Std_MsgError
                               for ADec_ErrInStmOpn*/

#define PLAY_LOC_124	0x800124 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgResume,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_125	0x800125 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgResume, qMsgWrite
                               FAILURE */

#define PLAY_LOC_126	0x800126 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgResumeCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_127	0x800127 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgResumeCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_128	0x800128 /* PLAYER:playinst.c:(),
                               qFTimerCancel FAILURE */

#define PLAY_LOC_129	0x800129 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgStop
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_130	0x800130 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgStop, qMsgWrite
                               FAILURE */

#define PLAY_LOC_131	0x800131 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgActivateDictionaryCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_132	0x800132 /* PLAYER:playinst.c:(),
                               Player_MsgActivateDictionaryCmplt_put FAILURE */

#define PLAY_LOC_133	0x800133 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgActivateDictionaryCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_134	0x800134 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgDeactivateDictionaryCmplt,
                               qMsgAllocate FAILURE  */

#define PLAY_LOC_135	0x800135 /* PLAYER:playinst.c:(),
                               Player_MsgDeactivateDictionaryCmplt_put
                               FAILURE */

#define PLAY_LOC_136	0x800136 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgDeactivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_137	0x800137 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgEndOfSegment,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_138	0x800138 /* PLAYER:playinst.c:(),
                               Player_MsgEndOfSegment_put FAILURE */

#define PLAY_LOC_139	0x800139 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgEndOfSegment,
                               qMsgWrite FAILURE  */

#define PLAY_LOC_140	0x800140 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during invalid
                               decoder type */

#define PLAY_LOC_141	0x800141 /* PLAYER:playinst.c:(),
                               Unable to send  ADec_MsgStart, qMsgWrite
                               FAILURE */

#define PLAY_LOC_142	0x800142 /* PLAYER:playinst.c:(),
                               qFTimerCancel FAILURE */

#define PLAY_LOC_143	0x800143 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgStop, qMsgAllocate
                               FAILURE  */

#define PLAY_LOC_144	0x800144 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgStop, qMsgWrite FAILURE */

#define PLAY_LOC_145	0x800145 /* PLAYER:playinst.c:(),
                               Std_MsgError_get FAILURE */

#define PLAY_LOC_146	0x800146 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during 
                               Error Code = ADec_ErrInStmOpn*/

#define PLAY_LOC_147	0x800147 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during
                               qClusterSlotInfo FAILURE */

#define PLAY_LOC_148	0x800148 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgStartCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_149	0x800149 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgStartCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_150	0x800150 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during qFTimerSet
                               FAILURE */

#define PLAY_LOC_151	0x800151 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgStart, qMsgWrite
                               FAILURE */

#define PLAY_LOC_152	0x800152 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgStartCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_153	0x800153 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgStartCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_154	0x800154 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgStartCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_155	0x800155 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgStartCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_156	0x800156 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during qFTimerSet
                               FAILURE */

#define PLAY_LOC_157	0x800157 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgStart, qMsgWrite
                               FAILURE */

#define PLAY_LOC_158	0x800158 /* PLAYER:playinst.c:(),
                               Unablel to allocate Player_MsgStartCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_159	0x800159 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgStartCmplt,qMsgWrite
                               FAILURE */

#define PLAY_LOC_160	0x800160 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE*/

#define PLAY_LOC_161	0x800161 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgPauseCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_162	0x800162 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgPauseCmplt,qMsgWrite FAILURE*/

#define PLAY_LOC_163	0x800163 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgResumeCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_164	0x800164 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgResumeCmplt,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_165	0x800165 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during cannot 
                               activate cluster port*/

#define PLAY_LOC_166	0x800166 /* PLAYER:playinst.c:(),
                               qFTimerCancel FAILURE*/

#define PLAY_LOC_167	0x800167 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgStop, qMsgAllocate FAILURE*/

#define PLAY_LOC_168	0x800168 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgStop, qMsgWrite FAILURE*/

#define PLAY_LOC_169	0x800169 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgPause, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_170	0x800170 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgPause, qMsgWrite
                               FAILURE */

#define PLAY_LOC_171	0x800171 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgPauseCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_172	0x800172 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgPauseCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_173	0x800173 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgEndOfSegment,
                               qMsgAllocate FAILURE */  

#define PLAY_LOC_174	0x800174 /* PLAYER:playinst.c:(),
                               Player_MsgEndOfSegment_put FAILURE */

#define PLAY_LOC_175	0x800175 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgEndOfSegment,
                               qMsgWrite FAILURE */

#define PLAY_LOC_176	0x800176 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during invalid
                               decoder type*/

#define PLAY_LOC_177	0x800177 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgStart, qMsgWrite FAILURE*/

#define PLAY_LOC_178	0x800178 /* PLAYER:playinst.c:(),
                               qFTimerCancel FAILURE */

#define PLAY_LOC_179	0x800179 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgStop, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_180	0x800180 /* PLAYER:playinst.c:(),
                               Unable so send ADec_MsgStop, qMsgWrite FAILURE */

#define PLAY_LOC_181	0x800181 /* PLAYER:playinst.c:(),
                               Std_MsgError_get FAILURE */

#define PLAY_LOC_182	0x800182 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during 
                               Error Code = ADec_ErrInStmOpn*/

#define PLAY_LOC_183	0x800183 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgActivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_184	0x800184 /* PLAYER:playinst.c:(),
                               Player_MsgActivateDictionaryCmplt_put FAILURE */

#define PLAY_LOC_185	0x800185 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgActivateDictionaryCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_186	0x800186 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgDeactivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_187	0x800187 /* PLAYER:playinst.c:(),
                               Player_MsgDeactivateDictionaryCmplt_put
                               FAILURE */

#define PLAY_LOC_188	0x800188 /* PLAYER:playinst.c:(),
                               Player_MsgPlayNextSegment_get FAILURE */

#define PLAY_LOC_189	0x800189 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during invalid
                               decoder type*/

#define PLAY_LOC_190	0x800190 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgStart, qMsgWrite FAILURE*/

#define PLAY_LOC_191	0x800191 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgPlayNextSegmentCmplt, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_192	0x800192 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgPlayNextSegmentCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_193	0x800193 /* PLAYER:playinst.c:(),
                               qFTimerCancel FAILURE */

#define PLAY_LOC_194	0x800194 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE*/

#define PLAY_LOC_195	0x800195 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE */

#define PLAY_LOC_196	0x800196 /* PLAYER:playinst.c:(),
                               Std_MsgError_get FAILURE */

#define PLAY_LOC_197	0x800197 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE*/

#define PLAY_LOC_198	0x800198 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgActivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_199	0x800199 /* PLAYER:playinst.c:(),
                               Player_MsgActivateDictionaryCmplt_put FAILURE */

#define PLAY_LOC_200	0x800200 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgActivateDictionaryCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_201	0x800201 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgDeactivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_202	0x800202 /* PLAYER:playinst.c:(),
                               Player_MsgDeactivateDictionaryCmplt_put FAILURE*/

#define PLAY_LOC_203	0x800203 /* PLAYER:playinst.c:(),
                               Unable to send
                               Player_MsgDeactivateDictionaryCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_204	0x800204 /* PLAYER:playinst.c:(),
                               Player_MsgStart2_get FAILURE */

#define PLAY_LOC_205	0x800205 /* PLAYER:playinst.c:(),
                               qPoolAlloc FAILURE for play file list*/

#define PLAY_LOC_206	0x800206 /* PLAYER:playinst.c:(),
                               Player_MsgStart_get FAILURE */

#define PLAY_LOC_207	0x800207 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE, during invalid
                               decoder type */

#define PLAY_LOC_208	0x800208 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgStartCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_209	0x800209 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgStartCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_210	0x800210 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE */

#define PLAY_LOC_211	0x800211 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgPause,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_212	0x800212 /* PLAYER:playinst.c:(),
                                 Unable to send 
                                 Player_MsgDeactivateDictionaryCmplt, qMsgWrite
                                 FAILURE */

#define PLAY_LOC_213	0x800213 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgPause, qMsgWrite
                               FAILURE */

#define PLAY_LOC_214	0x800214 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgResume,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_215	0x800215 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgResume, qMsgWrite FAILURE*/

#define PLAY_LOC_216	0x800216 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgStop,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_217	0x800217 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgStop, qMsgWrite
                               FAILURE */

#define PLAY_LOC_218	0x800218 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE*/

#define PLAY_LOC_219	0x800219 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE */

#define PLAY_LOC_220	0x800220 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgStartCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_221	0x800221 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgStartCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_222	0x800222 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE */

#define PLAY_LOC_223	0x800223 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgStart, qMsgWrite
                               FAILURE */

#define PLAY_LOC_224	0x800224 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgStartCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_225	0x800225 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgStartCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_226	0x800226 /* PLAYER:playinst.c:(),
                               Player_MsgLoadDictionary_get FAILURE */

#define PLAY_LOC_227	0x800227 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgLoadDictionary,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_228	0x800228 /* PLAYER:playinst.c:(),
                               ADec_MsgLoadDictionary_put FAILURE */

#define PLAY_LOC_229	0x800229 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgLoadDictionary,
                               qMsgWrite FAILURE */

#define PLAY_LOC_230	0x800230 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgLoadDictionaryCmplt, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_231	0x800231 /* PLAYER:playinst.c:(),
                               Player_MsgLoadDictionaryCmplt_put FAILURE */

#define PLAY_LOC_232	0x800232 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgLoadDictionaryCmplt, qMsgAllocate
                               FAILURE */

#define PLAY_LOC_233	0x800233 /* PLAYER:playinst.c:(),
                               Player_MsgUnloadDictionary_get FAILURE */

#define PLAY_LOC_234	0x800234 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgUnloadDictionary,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_235	0x800235 /* PLAYER:playinst.c:(),
                               ADec_MsgUnloadDictionary_put FAILURE */

#define PLAY_LOC_236	0x800236 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgUnloadDictionary,
                               qMsgWrite FAILURE */

#define PLAY_LOC_237	0x800237 /* PLAYER:playinst.c:(),
                               Unable to allocate
                               Player_MsgUnloadDictionaryCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_238	0x800238 /* PLAYER:playinst.c:(),
                               Player_MsgUnloadDictionaryCmplt_put FAILURE */

#define PLAY_LOC_239	0x800239 /* PLAYER:playinst.c:(),
                                Unable to send Player_MsgUnloadDictionaryCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_240	0x800240 /* PLAYER:playinst.c:(),
                               Player_MsgActivateDictionary_get FAILURE*/

#define PLAY_LOC_241	0x800241 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgActivateDictionary,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_242	0x800242 /* PLAYER:playinst.c:(),
                               ADec_MsgActivateDictionary_put FAILURE */

#define PLAY_LOC_243	0x800243 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgActivateDictionary,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_244	0x800244 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgActivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_245	0x800245 /* PLAYER:playinst.c:(),
                               Player_MsgActivateDictionaryCmplt_put FAILURE */

#define PLAY_LOC_246	0x800246 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgActivateDictionaryCmplt,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_247	0x800247 /* PLAYER:playinst.c:(),
                               Player_MsgDeactivateDictionary_get FAILURE */

#define PLAY_LOC_248	0x800248 /* PLAYER:playinst.c:(),
                               Unable to allocate ADec_MsgDeactivateDictionary,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_249	0x800249 /* PLAYER:playinst.c:(),
                               ADec_MsgDeactivateDictionary_put FAILURE*/

#define PLAY_LOC_250	0x800250 /* PLAYER:playinst.c:(),
                               Unable to send ADec_MsgDeactivateDictionary,
                               qMsgWrite FAILURE */

#define PLAY_LOC_251	0x800251 /* PLAYER:playinst.c:(),
                               Unable to allocate 
                               Player_MsgDeactivateDictionaryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_252	0x800252 /* PLAYER:playinst.c:(),
                               Player_MsgDeactivateDictionaryCmplt_put
                               FAILURE */

#define PLAY_LOC_253	0x800253 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgDeactivateDictionaryCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_254	0x800254 /* PLAYER:playinst.c:(),
                               qCompAllocate FAILURE */

#define PLAY_LOC_255	0x800255 /* PLAYER:playinst.c:(),
                               Unable to allocate 
                               Std_MsgInitCmplt, qMsgAllocate FAILURE */

#define PLAY_LOC_256	0x800256 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgInitCmplt,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_257	0x800257 /* PLAYER:playinst.c:(),
                               Unable to allocate 
                               Std_MsgSetParm, qMsgAllocate FAILURE */

#define PLAY_LOC_258	0x800258 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE */

#define PLAY_LOC_259	0x800259 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgSetParm,
                               qMsgWrite FAILURE */

#define PLAY_LOC_260	0x800260 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgSetParm, 
                               qMsgAllocate FAILURE for ADec_ParmVolume*/

#define PLAY_LOC_261	0x800261 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE for ADec_ParmVolume*/

#define PLAY_LOC_262	0x800262 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgSetParm,
                               qMsgWrite FAILURE for ADec_ParmVolume*/

#define PLAY_LOC_263	0x800263 /* PLAYER:playinst.c:(),
                               Unable to allocate 
                               Std_MsgSetParm, qMsgAllocate FAILURE for ADec_ParmSpeed */

#define PLAY_LOC_264	0x800264 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE for ADec_ParmSpeed*/

#define PLAY_LOC_265	0x800265 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgSetParm,
                               qMsgWrite FAILURE for ADec_ParmSpeed */

#define PLAY_LOC_266	0x800266 /* PLAYER:playinst.c:(),
                               Unable to allocate 
                               Std_MsgSetParm, qMsgAllocate FAILURE for ADec_ParmVolume*/

#define PLAY_LOC_267	0x800267 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE for ADec_ParmVolume */

#define PLAY_LOC_268	0x800268 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgSetParm,
                               qMsgWrite FAILURE for ADec_ParmVolume */

#define PLAY_LOC_269	0x800269 /* PLAYER:playinst.c:(),
                               playerGetParmDefValue FAILURE for ADec_ParmNrmLvl*/

#define PLAY_LOC_270	0x800270 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgComtest,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_271	0x800271 /* PLAYER:playinst.c:(),
                               Unable to send NON_Std_MsgCrashDSP,
                               qMsgWrite FAILURE */

#define PLAY_LOC_272	0x800272 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_get FAILURE */

#define PLAY_LOC_273	0x800273 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_get FAILURE ??? */

#define PLAY_LOC_274	0x800274 /* PLAYER:playinst.c:(),
                               Std_MsgSetParmDef_get FAILURE */

#define PLAY_LOC_275	0x800275 /* PLAYER:playinst.c:(),
                               playerGetParmDefValue  FAILURE for ADec_ParmNrmLvl */

#define PLAY_LOC_276	0x800276 /* PLAYER:playinst.c:(),
                               playerGetParmDefValue  FAILURE for
                               ADec_ParmNrmLvl */

#define PLAY_LOC_277	0x800277 /* PLAYER:playinst.c:(),
                               Std_MsgGetParm_get FAILURE */

#define PLAY_LOC_278	0x800278 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgGetParmCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_279	0x800279 /* PLAYER:playinst.c:(),
                               Std_MsgGetParmCmplt_put FAILURE */

#define PLAY_LOC_280	0x800280 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgGetParmCmplt, qMsgWrite
                               FAILURE */

#define PLAY_LOC_281	0x800281 /* PLAYER:playinst.c:(),
                               Std_MsgDetectEvt_get FAILURE */

#define PLAY_LOC_282	0x800282 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgSetParm ,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_283	0x800283 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE */

#define PLAY_LOC_284	0x800284 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgSetParm, qMsgWrite
                               FAILURE for EvtStatus
                               ADec_ParmEvtStatusReporting */

#define PLAY_LOC_285	0x800285 /* PLAYER:playinst.c:(),
                               Std_MsgCancelEvt_get FAILURE */

#define PLAY_LOC_286	0x800286 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgSetParm ,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_287	0x800287 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE */

#define PLAY_LOC_288	0x800288 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgSetParm, qMsgWrite
                               FAILURE for EvtStatus
                               ADec_ParmEvtStatusReporting */

#define PLAY_LOC_289	0x800289 /* PLAYER:playinst.c:(),
                                Std_MsgArmRTC_get FAILURE */

#define PLAY_LOC_290	0x800290 /* PLAYER:playinst.c:(),
                                playerGetParmValue FAILURE for Player_ParmRtcStopBuffering*/

#define PLAY_LOC_291	0x800291 /* PLAYER:playinst.c:(),
                               Std_MsgDisarmRTC_get FAILURE */

#define PLAY_LOC_292	0x800292 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgDisarmRTCCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_293	0x800293 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgDisarmRTCCmplt, qMsgWrite
                               FAILUR*/

#define PLAY_LOC_294	0x800294 /* PLAYER:playinst.c:(),
                               Unable to allocate  Std_MsgDisarmAllRTCsCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_295	0x800295 /* PLAYER:playinst.c:(),
                               Unable to send  Std_MsgDisarmAllRTCsCmplt, qMsgWrite
                               FAILURE*/

#define PLAY_LOC_296	0x800296 /* PLAYER:playinst.c:(),
                               Std_MsgEvtDetected_get FAILURE */

#define PLAY_LOC_297	0x800297 /* PLAYER:playinst.c:(),
                                Player_MsgAdjSpeed_get FAILURE */

#define PLAY_LOC_298	0x800298 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgAdjSpeedCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_299	0x800299 /* PLAYER:playinst.c:(),
                               Player_MsgAdjSpeedCmplt_put FAILURE */

#define PLAY_LOC_300	0x800300 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgAdjSpeedCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_301	0x800301 /* PLAYER:playinst.c:(),
                               Player_MsgAdjVolume_get FAILURE */

#define PLAY_LOC_302	0x800302 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgAdjVolumeCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_303	0x800303 /* PLAYER:playinst.c:(),
                               Player_MsgAdjVolumeCmplt_put FAILURE */

#define PLAY_LOC_304	0x800304 /* PLAYER:playinst.c:(),
                                Unable to send Player_MsgAdjVolumeCmplt,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_305	0x800305 /* PLAYER:playinst.c:(),
                               Player_MsgSetSpeedAdjTable_get FAILURE */

#define PLAY_LOC_306	0x800306 /* PLAYER:playinst.c:(),
                                Unable to allocate Player_MsgSetSpeedAdjTableCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_307	0x800307 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgSetSpeedAdjTableCmplt,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_308	0x800308 /* PLAYER:playinst.c:(),
                               Player_MsgSetVolumeAdjTable_get */

#define PLAY_LOC_309	0x800309 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgSetVolumeAdjTableCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_310	0x800310 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgSetVolumeAdjTableCmplt,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_311	0x800311 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgGetSpeedAdjTableCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_312	0x800312 /* PLAYER:playinst.c:(),
                               Player_MsgGetSpeedAdjTableCmplt_put FAILURE */

#define PLAY_LOC_313	0x800313 /* PLAYER:playinst.c:(),
                                Unable to send Player_MsgGetSpeedAdjTableCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_314	0x800314 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgGetVolumeAdjTableCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_315	0x800315 /* PLAYER:playinst.c:(),
                               Player_MsgGetVolumeAdjTableCmplt_put FAILURE */

#define PLAY_LOC_316	0x800316 /* PLAYER:playinst.c:(),
                                Unable to send Player_MsgGetVolumeAdjTableCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_317	0x800317 /* PLAYER:playinst.c:(),
                               Player_MsgDecoderQuery_get FAILURE */

#define PLAY_LOC_318	0x800318 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgDecoderQueryCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_319	0x800319 /* PLAYER:playinst.c:(),
                               Player_MsgDecoderQueryCmplt_put FAILURE */

#define PLAY_LOC_320	0x800320 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgDecoderQueryCmplt,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_321	0x800321 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgAllocateDecoderCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_322	0x800322 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgAllocateDecoderCmplt,
                               qMsgWrite FAILURE*/

#define PLAY_LOC_323	0x800323 /* PLAYER:playinst.c:(),
                               Unable to allocate Player_MsgDeallocateDecoderCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_324	0x800324 /* PLAYER:playinst.c:(),
                               Unable to send Player_MsgDeallocateDecoderCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_325	0x800325 /* PLAYER:playinst.c:(),
                                QCompInstNotify_get FAILURE */

#define PLAY_LOC_326	0x800326 /* PLAYER:playinst.c:(),
                               qCompAllocateAck FAILURE */

#define PLAY_LOC_327	0x800327 /* PLAYER:playinst.c:(),
                               QHostExited_get FAILURE */

#define PLAY_LOC_328	0x800328 /* PLAYER:playinst.c:(),
                               qHostExitCmplt FAILURE */

#define PLAY_LOC_329	0x800329 /* PLAYER:playinst.c:(),
                               qHostExitCmplt FAILURE */

#define PLAY_LOC_330	0x800330 /* PLAYER:playinst.c:(),
                               qHostExitCmplt FAILURE */

#define PLAY_LOC_331	0x800331 /* PLAYER:playinst.c:(),
                               qHostExitCmplt FAILURE */

#define PLAY_LOC_332	0x800332 /* PLAYER:playinst.c:(),
                               QCompExited_get FAILURE */

#define PLAY_LOC_333	0x800333 /* PLAYER:playinst.c:(),
                               qHostExitCmplt FAILURE */

#define PLAY_LOC_334	0x800334 /* PLAYER:playinst.c:(),
                               qFTimerCancel FAILURE */

#define PLAY_LOC_335	0x800335 /* PLAYER:playinst.c:(),
                               qGStreamTerminate FAILURE */

#define PLAY_LOC_336	0x800336 /* PLAYER:playinst.c:(),
                               qFTimerSet FAILURE */

#define PLAY_LOC_337	0x800337 /* PLAYER:playinst.c:(),
                               FTimerSet FAILURE */

#define PLAY_LOC_338	0x800338 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgError,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_339	0x800339 /* PLAYER:playstds.c:(),
                               Std_MsgError_put FAILURE */

#define PLAY_LOC_340	0x800340 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgError,
                               qMsgWrite FAILURE */

#define PLAY_LOC_341	0x800341 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgError,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_342	0x800342 /* PLAYER:playstds.c:(),
                               Std_MsgError_put FAILURE */

#define PLAY_LOC_343	0x800343 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgError,
                               qMsgWrite FAILURE */

#define PLAY_LOC_344	0x800344 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgComtestCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_345	0x800345 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgComtestCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_346	0x800346 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgSetParmCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_347	0x800347 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgSetParmCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_348	0x800348 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgSetParmDefCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_349	0x800349 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgSetParmDefCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_350	0x800350 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgSetAllParmsDefCmplt,
                               qMsgAllocate FAILURE*/

#define PLAY_LOC_351	0x800351 /* PLAYER:playstds.c:(),
                                Unable to send Std_MsgSetAllParmsDefCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_352	0x800352 /* PLAYER:playstds.c:(),
                               Std_MsgDetectEvt_get FAILURE */

#define PLAY_LOC_353	0x800353 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgDetectEvtCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_354	0x800354 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgDetectEvtCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_355	0x800355 /* PLAYER:playstds.c:(),
                               Std_MsgCancelEvt_get FAILURE */

#define PLAY_LOC_356	0x800356 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgCancelEvtCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_357	0x800357 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgCancelEvtCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_358	0x800358 /* PLAYER:playstds.c:(),
                               Std_MsgArmRTC_get FAILURE */

#define PLAY_LOC_359	0x800359 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgArmRTCCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_360	0x800360 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgArmRTCCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_361	0x800361 /* PLAYER:playstds.c:(),
                               Std_MsgEvtDetected_get FAILURE*/

#define PLAY_LOC_362	0x800362 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgSetParm to
                               propagate ADec_ParmNrmLvl */

#define PLAY_LOC_363	0x800363 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE */

#define PLAY_LOC_364	0x800364 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgSetParm,
                               qMsgWrite FAILURE */

#define PLAY_LOC_365	0x800365 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgGetxParmsCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_366	0x800366 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgSetParm for 
                               ADec_ParmEvtStatusReporting */

#define PLAY_LOC_367	0x800367 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgSetParm,
                               qMsgWrite FAILURE */

#define PLAY_LOC_368	0x800368 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgDetectxEvtsCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_369	0x800369 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgSetParm for 
                               ADec_ParmEvtStatusReporting */

#define PLAY_LOC_370	0x800370 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgSetParm for 
                               ADec_ParmEvtStatusReporting,
                               qMsgWrite FAILURE */


#define PLAY_LOC_371	0x800371 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgGetxParmsCmplt */

#define PLAY_LOC_372	0x800372 /* PLAYER:playinst.c:(),
                               Std_MsgGetxParmsCmplt_put FAILURE */

#define PLAY_LOC_373	0x800373 /* PLAYER:playinst.c:(),
                               Std_MsgGetxParms_List_get FAILURE */

#define PLAY_LOC_374	0x800374 /* PLAYER:playinst.c:(),
                               Std_MsgDetectxEvts_get FAILURE */

#define PLAY_LOC_375	0x800375 /* PLAYER:playinst.c:(),
                               Std_MsgDetectxEvts_List_get FAILURE*/

#define PLAY_LOC_376	0x800376 /* PLAYER:playinst.c:(),
                               Std_MsgDetectxEvts_List_get FAILURE */

#define PLAY_LOC_377	0x800377 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE */

#define PLAY_LOC_378	0x800378 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgDetectxEvtsCmplt */

#define PLAY_LOC_379	0x800379 /* PLAYER:playinst.c:(),
                               Std_MsgCancelxEvts_get FAILURE */

#define PLAY_LOC_380	0x800380 /* PLAYER:playinst.c:(),
                               Std_MsgCancelxEvts_List_get FAILURE */

#define PLAY_LOC_381	0x800381 /* PLAYER:playinst.c:(),
                               Std_MsgSetParm_put FAILURE */

#define PLAY_LOC_382	0x800382 /* PLAYER:playinst.c:(),
                               Unable to allocate Std_MsgCancelxEvtsCmplt */

#define PLAY_LOC_383	0x800383 /* PLAYER:playinst.c:(),
                               Std_MsgArmxRTCs_get FAILURE */

#define PLAY_LOC_384	0x800384 /* PLAYER:playinst.c:(),
                               Std_MsgArmxRTCs_List_get FAILURE */

#define PLAY_LOC_385	0x800385 /* PLAYER:playinst.c:(),
                               Std_MsgArmxRTCs_List_get FAILURE*/

#define PLAY_LOC_386	0x800386 /* PLAYER:playinst.c:(),
                               Failure to get value of
                               Player_ParmRtcStopBuffering */

#define PLAY_LOC_387	0x800387 /* PLAYER:playinst.c:(),
                               Failure to allocate Std_MsgArmxRTCsCmplt */

#define PLAY_LOC_388	0x800388 /* PLAYER:playinst.c:(),
                               Std_MsgDisarmxRTCs_get FAILURE */

#define PLAY_LOC_389	0x800389 /* PLAYER:playinst.c:(),
                               Std_MsgDisarmxRTCs_List_get FAILURE */

#define PLAY_LOC_390	0x800390 /* PLAYER:playinst.c:(),
                               Failure to allocate Std_MsgDisarmxRTCsCmplt */

#define PLAY_LOC_391	0x800391 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgArmxRTCsCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_392	0x800392 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgDisarmxRTCsCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_393	0x800393 /* PLAYER:playinst.c:(),
                               Unable to send Std_MsgCancelxEvtsCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_394	0x800394 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgSetxParmsCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_395	0x800395 /* PLAYER:playstds.c:(),
                               Unable to allocate Std_MsgSetxParmsDefCmplt,
                               qMsgAllocate FAILURE */

#define PLAY_LOC_396	0x800396 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgSetxParmsCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_397	0x800397 /* PLAYER:playstds.c:(),
                               Unable to send Std_MsgSetxParmsDefCmplt,
                               qMsgWrite FAILURE */

#define PLAY_LOC_398	0x800398 /* PLAYER:playinst.c:(),
				    Parm number error, getting Player_ParmBitNibbleRev*/

#define PLAY_LOC_399	0x800399 /* PLAYER:playinst.c:(),
				    Std_MsgSetParm_put failure */

#define PLAY_LOC_400	0x800400 /* PLAYER:playinst.c:(),
				    qMsgWrite failure */

#define PLAY_LOC_401	0x800401 /* PLAYER:playerInit.c:(),
				    qTaskCreate failure */

#define PLAY_LOC_402	0x800402 /* PLAYER:playerInit.c:(),
				    qCompInitStart failure*/

#define PLAY_LOC_403	0x800403 /* PLAYER:playinst.c:(),
				    playerGetParmValue failed getting Player_ParmSyncRecord */

#define PLAY_LOC_404	0x800404 /* PLAYER:playinst.c:(),
				    Msg allocation failed for Std_MsgSetParm */

#define PLAY_LOC_405	0x800405 /* PLAYER:playinst.c:(),
				    Std_MsgSetParm_put failed */

#define PLAY_LOC_406	0x800406 /* PLAYER:playinst.c:(),
				    qMsg Write failure for Std_MsgSetParm */

#define PLAY_LOC_407	0x800407 /* PLAYER:playinst.c:(),
				    Player_MsgDecoderXQuery_get failed */

#define PLAY_LOC_408	0x800408 /* PLAYER:playinst.c:(),
				    qMsgAllocate failed for Player_MsgDecoderXQueryCmplt */

#define PLAY_LOC_409	0x800409 /* PLAYER:playinst.c:(),
				    Player_MsgDecoderXQueryCmplt failed */

#define PLAY_LOC_410	0x800410 /* PLAYER:playinst.c:(),
				    Player_MsgDecoderXQueryCmplt_CoderList_put failed */

#define PLAY_LOC_411	0x800411 /* PLAYER:playinst.c:(),
				    qMsgWrite failed */

#define PLAY_LOC_412	0x800412 /* PLAYER:playinst.c:(),
				    Player_MsgStartx_get failed. */

#define PLAY_LOC_413	0x800413 /* PLAYER:playinst.c:(),
				    Failure while allocating Tgen_MsgPlayTone message */

#define PLAY_LOC_414	0x800414 /* PLAYER:playinst.c:(),
				    Failure during mmdl Tgen_MsgPlayTone_put macro */

#define PLAY_LOC_415	0x800415 /* PLAYER:playinst.c:(),
				    qMsgWrite failure */

#define PLAY_LOC_416	0x800416 /* PLAYER:playinst.c:(),
				    Failure while allocating Player_MsgResumeCmplt message */

#define PLAY_LOC_417	0x800417 /* PLAYER:playinst.c:(),
				    qMsgWrite failure */

#define PLAY_LOC_418	0x800418 /* PLAYER:playinst.c:(),
				    Failure while allocating Tgen_MsgStop message */

#define PLAY_LOC_419	0x800419 /* PLAYER:playinst.c:(),
				    qMsgWrite failure */

#define PLAY_LOC_420	0x800420 /* PLAYER:playinst.c:(),
				    Failure during GStream termination */

#define PLAY_LOC_421	0x800421 /* PLAYER:playinst.c:(),
				    Failure during GStream termination */

#define PLAY_LOC_422	0x800422 /* PLAYER:playinst.c:(),
				    Unexpected message in startbeepinit state*/

#define PLAY_LOC_423	0x800423 /* PLAYER:playinst.c:(),
				    Error while getting beep signal id parameter*/

#define PLAY_LOC_424	0x800424 /* PLAYER:playinst.c:(),
                qGStreamTerminate FAILURE, after Std_MsgError
                for Tgen_MsgPlayTone mesage*/

#define PLAY_LOC_425	0x800425 /* PLAYER:.c:(),
				    Failure during playerCloseAndFlushGstream */

#define PLAY_LOC_426	0x800426 /* PLAYER:.c:(),
				    Failure during playerCloseAndFlushGstream */

#define PLAY_LOC_427	0x800427 /* PLAYER:playstds.c:(),
				    failed allocating Std_MsgSetParm*/

#define PLAY_LOC_428	0x800428 /* PLAYER:playstds.c:(),
				    Std_MsgSetParm_put failed*/

#define PLAY_LOC_429	0x800429 /* PLAYER:playstds.c:(),
				    qMsgWrite failed */

#define PLAY_LOC_430	0x800430 /* PLAYER:playstds.c:(),
				    Std_MsgSetParm_put failed*/

#define PLAY_LOC_431	0x800431 /* PLAYER:playstds.c:(),
				    Std_MsgSetParm_put failed*/

#define PLAY_LOC_432	0x800432 /* PLAYER:playstds.c:(),
				    qMsgWrite failed */

#define PLAY_LOC_433	0x800433 /* PLAYER:playinst.c:(),
				    QCompExited received. Decoder has gone away? */

#if  END_OF_LOCS_TABLE
#define PLAY_LOC_434	0x800434 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_435	0x800435 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_436	0x800436 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_437	0x800437 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_438	0x800438 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_439	0x800439 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_440	0x800440 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_441	0x800441 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_442	0x800442 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_443	0x800443 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_444	0x800444 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_445	0x800445 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_446	0x800446 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_447	0x800447 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_448	0x800448 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_449	0x800449 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_450	0x800450 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_451	0x800451 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_452	0x800452 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_453	0x800453 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_454	0x800454 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_455	0x800455 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_456	0x800456 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_457	0x800457 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_458	0x800458 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_459	0x800459 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_460	0x800460 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_461	0x800461 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_462	0x800462 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_463	0x800463 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_464	0x800464 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_465	0x800465 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_466	0x800466 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_467	0x800467 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_468	0x800468 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_469	0x800469 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_470	0x800470 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_471	0x800471 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_472	0x800472 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_473	0x800473 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_474	0x800474 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_475	0x800475 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_476	0x800476 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_477	0x800477 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_478	0x800478 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_479	0x800479 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_480	0x800480 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_481	0x800481 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_482	0x800482 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_483	0x800483 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_484	0x800484 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_485	0x800485 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_486	0x800486 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_487	0x800487 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_488	0x800488 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_489	0x800489 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_490	0x800490 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_491	0x800491 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_492	0x800492 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_493	0x800493 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_494	0x800494 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_495	0x800495 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_496	0x800496 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_497	0x800497 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_498	0x800498 /* PLAYER:.c:(),
				    */

#define PLAY_LOC_499	0x800499 /* PLAYER:.c:(),
				    */


#endif END_OF_LOCS_TABLE
#endif /* #if !defined(_playerLocations_h) */

