/******************************************************************************
*     Copyright (c) 1995-2001 Intel Corporation. All Rights Reserved.
*
*     All names, products, and services mentioned herein are the trademarks
*     or registered trademarks of their respective organizations and are the
*     sole property of their respective owners.
*  
*
*     THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation.
*     The copyright notice above does not evidence any actual or
*     intended publication of such source code.
******************************************************************************/

/****************************************************************************
 * FILE:         
 * AUTHOR:       Goutham Puppala
 * ORG:          Intel Corporation
 * ORIG-DATE:    10-May-95 at 17:28:54
 * LAST-MOD:     16-Nov-95 at 12:38:34 by puppalag
 * PURPOSE:
 *    This module contains all the processor specific code converting the
 *    basic datatypes to/from the local from/to global memory format
 *    
 * HISTORY:
 * Date			Who	Description
 * 18-Jun-95	GP	   Added I960 support
 * 15-Oct-94	GP 	Initial Creation.
 ***************************************************************************/

/***************************************************************************/
/***************************** IMPORTANT NOTE ******************************/
/***************************************************************************/
/*                                                                         */
/* This file is part of the system release. Please try not to add kernel   */
/* specific stuff to this file. However, if you must, it should be         */
/* included in if (QCPU < QHOST) section.                                  */
/*                                                                         */
/***************************************************************************/



#if (QCPU < QHOST)
#include "qcpu.h"
#include "qkererror.h"
#endif /* QCPU < QHOST */
#include "qtypes.h"
#ifdef __cplusplus
extern "C" {
#endif

#ifndef QINST_WIDTH
#error QINST_WIDTH Not defined
#define QINST_WIDTH 8
#endif

#if (QCPU==QM56301) /*******************************************************/



#define MASK_BYTE  0x0000ff

#define gtolUInt8(dest,src,destOffset,srcOffset) \
{ \
   *(dest+destOffset/QCHAR_BYTE) = 0; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   destOffset += 2; \
}


#define gtolUInt16(dest,src,destOffset,srcOffset) \
{ \
   *(dest+destOffset/QCHAR_BYTE) = 0; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   destOffset += 1;   \
}


#define gtolUInt24(dest,src,destOffset,srcOffset) \
{ \
   *(dest+destOffset/QCHAR_BYTE) = 0; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
}


#define gtolUInt32(dest,src,destOffset,srcOffset) \
{ \
    *(dest+destOffset/QCHAR_BYTE) = 0; \
    *(dest+destOffset/QCHAR_BYTE+1) = 0; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   destOffset += 2;   \
}


#define gtolInt8(dest,src,destOffset,srcOffset) \
{ \
	Uint24 *tmp = (Uint24 *)(dest+destOffset/QCHAR_BYTE); \
	*tmp = 0; \
   movebyte(dest,src,destOffset,srcOffset); \
	*tmp |= ((*tmp & 0x80)?0xffff00:0x000000); \
   destOffset++; srcOffset++; \
   destOffset += 2; \
}


#define gtolInt16(dest,src,destOffset,srcOffset) \
{ \
	Uint24 *tmp = (Uint24 *)(dest+destOffset/QCHAR_BYTE); \
   *tmp = 0; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
	*tmp |= ((*tmp & 0x8000)?0xff0000:0x000000); \
   destOffset++; srcOffset++; \
   destOffset += 1;   \
}


#define gtolInt24(dest,src,destOffset,srcOffset) \
	gtolUInt24(dest, src, destOffset, srcOffset)


#define gtolInt32(dest,src,destOffset,srcOffset) \
{ \
	Uint24 *tmp = (Uint24 *)(dest+destOffset/QCHAR_BYTE+1); \
   *(dest+destOffset/QCHAR_BYTE) = 0; \
   *tmp = 0; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
	*tmp |= ((*tmp & 0x80)?0xffff00:0x000000); \
   destOffset++; srcOffset++; \
   destOffset += 2;   \
}


#define gtolPtr(dest,src,destOffset,srcOffset) \
{ \
   *(dest+destOffset/QCHAR_BYTE) = 0; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   srcOffset++; \
}


#define ltogUInt8(dest,src,destOffset,srcOffset) \
{ \
   movebyte(dest,src,destOffset,srcOffset);    \
   destOffset++; srcOffset++; \
   srcOffset += 2; \
}


#define ltogUInt16(dest,src,destOffset,srcOffset) \
{ \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   srcOffset += 1; \
}



#define ltogUInt24(dest,src,destOffset,srcOffset) \
{ \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
}


#define ltogUInt32(dest,src,destOffset,srcOffset) \
{ \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   srcOffset += 2; \
}


#define ltogPtr(dest,src,destOffset,srcOffset) \
{ \
	Uint8 zero = 0; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
   movebyte(dest,src,destOffset,srcOffset); \
   destOffset++; srcOffset++; \
	movebyte(dest,&zero,destOffset,0); \
   destOffset++; \
}

/* 
   The ltog macro's work in two different ways :
   For a 16 bit host and 8 bit firmware we need to expand the instance and shrink the node.
   For a 8 bit host and 16 bit firmware we need to expand the node and shrink the instance.
   Since the instance and the node are just interchanged in the 8 bit vs 16 bit QCompDesc, 
   the same macro works just fine.
*/

#define ltogSwapCompDesc(mdest,msrc,mdOff,msOff) \
{ \
  Uint24 mtemp; \
  if(((*(msrc) & 0x00ff00) != 0) && ((*(msrc) & 0xffff) != 0xffff)){ \
		qKerWarning(QMSG_ERR1F); \
  } \
  movebyte(mdest,msrc,mdOff,msOff+5); \
  if((*(msrc+1) >> 16) == 0xff){ \
	  mtemp = 0xff; \
  } \
  else { \
	  mtemp = 0; \
  } \
  movebyte(mdest,&mtemp,mdOff+1,0); \
  movebyte(mdest,msrc,mdOff+2,msOff+2); \
  movebyte(mdest,msrc,mdOff+3,msOff+3); \
  movebyte(mdest,msrc,mdOff+4,msOff+4); \
  movebyte(mdest,msrc,mdOff+5,msOff); \
  mdOff += 6; \
  msOff += 6; \
}


#if (QINST_WIDTH == 8)
#define ltogCompDesc(dest,src,destOffset,srcOffset) \
{ \
   if(qKerCompFormat == 0){ \
      ltogUInt24(dest,src,destOffset,srcOffset); \
      ltogUInt24(dest,src,destOffset,srcOffset); \
	} \
	else { \
      ltogSwapCompDesc(dest,src,destOffset,srcOffset); \
	} \
}
#elif (QINST_WIDTH == 16)
#define ltogCompDesc(dest,src,destOffset,srcOffset) \
{ \
   if(qKerCompFormat == 0){ \
      ltogSwapCompDesc(dest,src,destOffset,srcOffset); \
   } \
   else { \
      ltogUInt24(dest,src,destOffset,srcOffset); \
      ltogUInt24(dest,src,destOffset,srcOffset); \
   } \
}
#else
#error Unknown QINST_WIDTH
#endif
 

#define ltogStreamRef(dest,src,destOffset,srcOffset) \
{ \
             ltogUInt24(dest,src,destOffset,srcOffset); /* openMode */ \
             ltogPtr(dest,src,destOffset,srcOffset);    /* bHandle */  \
             ltogUInt16(dest,src,destOffset,srcOffset); /* streamId */      \
             ltogUInt16(dest,src,destOffset,srcOffset); /* pad */ \
}


/* 
   The gtol macro's work in two different ways :
   For a 16 bit host and 8 bit firmware we need to shrink the instance and expand the node.
   For a 8 bit host and 16 bit firmware we need to expand the instance and shrink the node.
   Since the instance and the node are just interchanged in the 8 bit vs 16 bit QCompDesc, 
   the same macro works just fine.
*/
#define gtolSwapCompDesc(mdest,msrc,mdOff,msOff) \
{ \
  Uint8 mtemp;\
  Uint8 mtemp1;\
  movebyte(&mtemp,msrc,0,msOff);\
  movebyte(&mtemp1,msrc,0,msOff+1);\
  mtemp = mtemp & 0xff; /* Mask out the higher order 16 bits */\
  mtemp1 = mtemp1 & 0xff; /* mask out the higher order 16 bits */\
  if(mtemp1 != 0){ \
     if((mtemp1 != 0xff) ||\
       (mtemp != 0xff)){ \
          qKerWarning(QMSG_ERR36); \
       } \
  }\
  movebyte(mdest,msrc,mdOff+5,msOff); \
  movebyte(mdest,msrc,mdOff,msOff+5); \
  if(((*mdest) & 0xff) == 0xff){ \
	 mtemp = 0xff; \
  } \
  else { \
	 mtemp = 0; \
  } \
  movebyte(mdest,&mtemp,mdOff+1,0); \
  movebyte(mdest,msrc,mdOff+2,msOff+2); \
  movebyte(mdest,msrc,mdOff+3,msOff+3); \
  movebyte(mdest,msrc,mdOff+4,msOff+4); \
  mdOff += 6; \
  msOff += 6; \
}

#if (QINST_WIDTH == 8)
#define gtolCompDesc(dest,src,destOffset,srcOffset) \
{ \
   if(qKerCompFormat == 0){ \
      ltogUInt24(dest,src,destOffset,srcOffset); \
      ltogUInt24(dest,src,destOffset,srcOffset); \
   } \
   else { \
      gtolSwapCompDesc(dest,src,destOffset,srcOffset); \
   } \
}
#elif (QINST_WIDTH == 16)
#define gtolCompDesc(dest,src,destOffset,srcOffset) \
{ \
   if(qKerCompFormat == 0){ \
      gtolSwapCompDesc(dest,src,destOffset,srcOffset); \
   } \
   else { \
      ltogUInt24(dest,src,destOffset,srcOffset); \
      ltogUInt24(dest,src,destOffset,srcOffset); \
   } \
}

#else
#error Unknown QINST_WIDTH
#endif


#define gtolStreamRef(dest,src,destOffset,srcOffset) \
{ \
             gtolUInt24(dest,src,destOffset,srcOffset); \
             gtolPtr(dest,src,destOffset,srcOffset); \
             gtolUInt16(dest,src,destOffset,srcOffset); \
             gtolUInt16(dest,src,destOffset,srcOffset); \
}


#elif (QCPU==QSIMSPARC) /*****************************************************/





#define gtolUInt8(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset)); \
	destOffset += 1; \
	srcOffset++; \
}


#define gtolUInt16(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+0)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
	destOffset += 2; \
}


#define gtolUInt24(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset+3)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+2)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+0)) = 0; \
	destOffset += 4; \
}


#define gtolUInt32(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset+3)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+2)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+0)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
	destOffset += 4; \
}


#define gtolInt8(dest,src,destOffset,srcOffset) \
	gtolUInt8(dest,src,destOffset,srcOffset) 


#define gtolInt16(dest,src,destOffset,srcOffset) \
	gtolUInt16(dest,src,destOffset,srcOffset) 


#define gtolInt24(dest,src,destOffset,srcOffset) \
{ \
	Uint8 tmp; \
   *((Uint8 *)(dest+destOffset+3)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+2)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
	tmp = *((Uint8 *)(src+srcOffset)); \
   *((Uint8 *)(dest+destOffset+1)) = tmp; \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+0)) = (tmp & 0x80)?(0xff):(0x00); \
	destOffset += 4; \
}


#define gtolInt32(dest,src,destOffset,srcOffset) \ 
	gtolUInt32(dest,src,destOffset,srcOffset) 


#define ltogUInt8(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset)); \
	destOffset++; \
	srcOffset += 1; \
}


#define ltogUInt16(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+1)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+0)); \
	destOffset++; \
	srcOffset += 2; \
}


#define ltogUInt24(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+3)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+2)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+1)); \
	destOffset++; \
	srcOffset += 4; \
}


#define ltogUInt32(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+3)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+2)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+1)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+0)); \
	destOffset++; \
	srcOffset += 4; \
}


#define ltogPtr(dest,src,destOffset,srcOffset) \
	ltogUInt32(dest,src,destOffset,srcOffset)

#define gtolPtr(dest,src,destOffset,srcOffset) \
	gtolUInt32(dest,src,destOffset,srcOffset)


#define ltogCompDesc(dest,src,destOffset,srcOffset) \
             ltogUInt16(dest,src,destOffset,srcOffset); \
             ltogUInt8(dest,src,destOffset,srcOffset); \
				 srcOffset += 1; \
             ltogUInt8(dest,src,destOffset,srcOffset); \
             ltogUInt8(dest,src,destOffset,srcOffset); \
             ltogUInt8(dest,src,destOffset,srcOffset);

#define ltogStreamRef(dest,src,destOffset,srcOffset) \
             ltogUInt24(dest,src,destOffset,srcOffset); /* openMode */ \
             ltogPtr(dest,src,destOffset,srcOffset);    /* bHandle */  \
             ltogUInt16(dest,src,destOffset,srcOffset); /* streamId */      \
             ltogUInt16(dest,src,destOffset,srcOffset); /* pad */

#define gtolCompDesc(dest,src,destOffset,srcOffset) \
             gtolUInt16(dest,src,destOffset,srcOffset); \
             gtolUInt8(dest,src,destOffset,srcOffset); \
				 destOffset += 1; \
             gtolUInt8(dest,src,destOffset,srcOffset); \
             gtolUInt8(dest,src,destOffset,srcOffset); \
             gtolUInt8(dest,src,destOffset,srcOffset);

#define gtolStreamRef(dest,src,destOffset,srcOffset) \
             gtolUInt24(dest,src,destOffset,srcOffset); \
             gtolPtr(dest,src,destOffset,srcOffset); \
             gtolUInt16(dest,src,destOffset,srcOffset); \
             gtolUInt16(dest,src,destOffset,srcOffset);





#elif (QCPU==QI960) || (QCPU == QC6X) || (QCPU == QX86) || (QCPU==QARM) || (QCPU==QXSCALE) || (QCPU==QHOST_LITTLE_ENDIAN)
/*******************************************************/

#define gtolUInt8(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   destOffset += 1; \
}


#define gtolUInt16(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset+0)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   destOffset += 2; \
}

#define gtolUInt24(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset+0)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+2)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+3)) = 0; \
	destOffset += 4; \
}


#define gtolUInt32(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset+0)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+2)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+3)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   destOffset += 4; \
}


#define gtolInt8(dest,src,destOffset,srcOffset) \
	gtolUInt8(dest,src,destOffset,srcOffset) 


#define gtolInt16(dest,src,destOffset,srcOffset) \
	gtolUInt16(dest,src,destOffset,srcOffset) 


#define gtolInt24(dest,src,destOffset,srcOffset) \
{ \
	Uint8 tmp; \
   *((Uint8 *)(dest+destOffset+0)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
	srcOffset++; \
	tmp = *((Uint8 *)(src+srcOffset)); \
   *((Uint8 *)(dest+destOffset+2)) = tmp; \
	srcOffset++; \
   *((Uint8 *)(dest+destOffset+3)) = (tmp & 0x80)?(0xff):(0x00); \
	destOffset += 4; \
}


#define gtolInt32(dest,src,destOffset,srcOffset) \
	gtolUInt32(dest,src,destOffset,srcOffset) 


#define ltogUInt8(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset)); \
   srcOffset += 1; \
	destOffset++; \
}


#define ltogUInt16(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+0)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+1)); \
	destOffset++; \
   srcOffset += 2; \
}


#define ltogUInt24(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+0)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+1)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+2)); \
	destOffset++; \
	srcOffset += 4; \
}


#define ltogUInt32(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+0)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+1)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+2)); \
	destOffset++; \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+3)); \
	destOffset++; \
   srcOffset += 4; \
}


#define ltogPtr(dest,src,destOffset,srcOffset) \
	ltogUInt32(dest,src,destOffset,srcOffset)

#define gtolPtr(dest,src,destOffset,srcOffset) \
	gtolUInt32(dest,src,destOffset,srcOffset)

/* 
   The ltog macro's work in two different ways :
   For a 16 bit host and 8 bit firmware we need to expand the instance and shrink the node.
   For a 8 bit host and 16 bit firmware we need to expand the node and shrink the instance.
   Since the instance and the node are just interchanged in the 8 bit vs 16 bit QCompDesc, 
   the same macro works just fine.
*/

#define ltogSwapCompDesc(mdest,msrc,mdOff,msOff) \
{ \
   if(*((Uint8 *)msrc+msOff+1) != 0){ \
	   if((*((Uint8 *)msrc+msOff) != 0xff) && \
			(*((Uint8 *)msrc+msOff+1) != 0xff)){ \
           qKerWarning(QMSG_ERR24); \
      } \
   } \
	if(*((Uint8 *)msrc+msOff+6) == 0xff){ \
	   *((Uint8 *)mdest+mdOff+1) = 0xff; \
	} \
   else { \
	   *((Uint8 *)mdest+mdOff+1) = 0x0; \
	} \
   *((Uint8 *)mdest+mdOff) = *((Uint8 *)msrc+msOff+6); \
	mdOff += 2; \
   *((Uint8 *)mdest+mdOff) = *((Uint8 *)msrc+msOff+2); \
   mdOff++; \
   *((Uint8 *)mdest+mdOff) = *((Uint8 *)msrc+msOff+4); \
	mdOff++; \
   *((Uint8 *)mdest+mdOff) = *((Uint8 *)msrc+msOff+5); \
   mdOff++; \
   *((Uint8 *)mdest+mdOff) = *((Uint8 *)msrc+msOff); \
   mdOff++; \
   msOff += 7; \
}

#if (QCPU==QI960) || (QCPU == QC6X) || (QCPU == QX86) || (QCPU==QARM) || (QCPU==QXSCALE)
#if (QINST_WIDTH == 8)
#define ltogCompDesc(dest,src,destOffset,srcOffset) \
{ \
  if(qKerCompFormat == 0){ \
             ltogUInt16(dest,src,destOffset,srcOffset); \
             ltogUInt8(dest,src,destOffset,srcOffset); \
				 srcOffset += 1; \
             ltogUInt8(dest,src,destOffset,srcOffset); \
             ltogUInt8(dest,src,destOffset,srcOffset); \
             ltogUInt8(dest,src,destOffset,srcOffset); \
  } \
  else { \
     ltogSwapCompDesc(dest,src,destOffset,srcOffset); \
  } \
}
#elif (QINST_WIDTH == 16)
#define ltogCompDesc(dest,src,destOffset,srcOffset) \
{ \
  if(qKerCompFormat == 0){ \
     ltogSwapCompDesc(dest,src,destOffset,srcOffset); \
  } \
  else { \
	 ltogUInt16(dest,src,destOffset,srcOffset); \
	 ltogUInt8(dest,src,destOffset,srcOffset); \
	 srcOffset += 1; \
	 ltogUInt8(dest,src,destOffset,srcOffset); \
	 ltogUInt8(dest,src,destOffset,srcOffset); \
	 ltogUInt8(dest,src,destOffset,srcOffset); \
  } \
}

#else
#error Unknown QINST_WIDTH
#endif
#else /* QCPU == QHOST/QHOST_LITTLE_ENDIAN */
#define ltogCompDesc(dest,src,destOffset,srcOffset) \
{ \
   ltogUInt16(dest,src,destOffset,srcOffset); \
   ltogUInt8(dest,src,destOffset,srcOffset); \
   srcOffset += 1; \
   ltogUInt8(dest,src,destOffset,srcOffset); \
   ltogUInt8(dest,src,destOffset,srcOffset); \
   ltogUInt8(dest,src,destOffset,srcOffset); \
}
#endif /* (QCPU==QI960) || (QCPU == QC6X) || (QCPU == QX86) || (QCPU==QARM) || (QCPU==QXSCALE) */


#define ltogStreamRef(dest,src,destOffset,srcOffset) \
{ \
             ltogUInt24(dest,src,destOffset,srcOffset); /* openMode */ \
             ltogPtr(dest,src,destOffset,srcOffset);    /* bHandle */  \
             ltogUInt16(dest,src,destOffset,srcOffset); /* streamId */      \
             ltogUInt16(dest,src,destOffset,srcOffset); /* pad */ \
}

/* 
   The gtol macro's work in two different ways :
   For a 16 bit host and 8 bit firmware we need to shrink the instance and expand the node.
   For a 8 bit host and 16 bit firmware we need to expand the instance and shrink the node.
   Since the instance and the node are just interchanged in the 8 bit vs 16 bit QCompDesc, 
   the same macro works just fine.
*/
#define gtolSwapCompDesc(mdest,msrc,mdOff,msOff) { \
    if(*((Uint8 *)msrc+msOff+1) != 0){ \
	   if((*((Uint8 *)msrc+msOff+1) != 0xff) && \
		   (*((Uint8 *)msrc+msOff) != 0xff)){ \
		  qKerWarning(QMSG_ERR21); \
		} \
	 } \
	 *((Uint8 *)mdest+mdOff+6) = *((Uint8 *)msrc+msOff); \
	 msOff += 2; \
	 *((Uint8 *)mdest+mdOff+2) = *((Uint8 *)msrc+msOff); \
	 msOff++; \
	 *((Uint8 *)mdest+mdOff+4) = *((Uint8 *)msrc+msOff); \
	 msOff++; \
	 *((Uint8 *)mdest+mdOff+5) = *((Uint8 *)msrc+msOff); \
	 msOff++; \
	 *((Uint8 *)mdest+mdOff) = *((Uint8 *)msrc+msOff); \
	 msOff++; \
	 if(*((Uint8 *)mdest+mdOff) == 0xff){ \
		*((Uint8 *)mdest+mdOff+1) = 0xff; \
	 } \
	 else { \
		*((Uint8 *)mdest+mdOff+1) = 0; \
	 } \
	 mdOff += 7; \
}

#if (QCPU==QI960) || (QCPU == QC6X) || (QCPU == QX86) || (QCPU==QARM) || (QCPU==QXSCALE)
#if (QINST_WIDTH == 8)
#define gtolCompDesc(dest,src,destOffset,srcOffset) \
{ \
if(qKerCompFormat == 0){ \
             gtolUInt16(dest,src,destOffset,srcOffset); \
             gtolUInt8(dest,src,destOffset,srcOffset); \
				 destOffset += 1; \
             gtolUInt8(dest,src,destOffset,srcOffset); \
             gtolUInt8(dest,src,destOffset,srcOffset); \
             gtolUInt8(dest,src,destOffset,srcOffset); \
} \
else { \
    gtolSwapCompDesc(dest,src,destOffset,srcOffset); \
} \
}
#elif (QINST_WIDTH == 16)
#define gtolCompDesc(dest,src,destOffset,srcOffset) \
{ \
  if(qKerCompFormat == 0){ \
    if(*((Uint8 *)src+srcOffset+1) != 0){ \
	   if((*((Uint8 *)src+srcOffset+1) != 0xff) && \
		   (*((Uint8 *)src+srcOffset) != 0xff)){ \
		  qKerWarning(QMSG_ERR21); \
		} \
	 } \
	 *((Uint8 *)dest+destOffset+6) = *((Uint8 *)src+srcOffset); \
	 srcOffset += 2; \
	 *((Uint8 *)dest+destOffset+2) = *((Uint8 *)src+srcOffset); \
	 srcOffset++; \
	 *((Uint8 *)dest+destOffset+4) = *((Uint8 *)src+srcOffset); \
	 srcOffset++; \
	 *((Uint8 *)dest+destOffset+5) = *((Uint8 *)src+srcOffset); \
	 srcOffset++; \
	 *((Uint8 *)dest+destOffset) = *((Uint8 *)src+srcOffset); \
	 srcOffset++; \
	 if(*((Uint8 *)dest+destOffset) == 0xff){ \
		*((Uint8 *)dest+destOffset+1) = 0xff; \
	 } \
	 else { \
		*((Uint8 *)dest+destOffset+1) = 0; \
	 } \
	 destOffset += 7; \
  } \
  else { \
	 gtolUInt16(dest,src,destOffset,srcOffset); \
	 gtolUInt8(dest,src,destOffset,srcOffset); \
	 destOffset += 1; \
	 gtolUInt8(dest,src,destOffset,srcOffset); \
	 gtolUInt8(dest,src,destOffset,srcOffset); \
	 gtolUInt8(dest,src,destOffset,srcOffset); \
  } \
}

#else
#error Unknown QINST_WIDTH
#endif
#else /* QCPU == QHOST/QHOST_LITTLE_ENDIAN */
#define gtolCompDesc(dest,src,destOffset,srcOffset) \
{ \
   gtolUInt16(dest,src,destOffset,srcOffset); \
   gtolUInt8(dest,src,destOffset,srcOffset); \
	  destOffset += 1; \
   gtolUInt8(dest,src,destOffset,srcOffset); \
   gtolUInt8(dest,src,destOffset,srcOffset); \
   gtolUInt8(dest,src,destOffset,srcOffset); \
}
#endif /* (QCPU==QI960) || (QCPU == QC6X) || (QCPU == QX86) || (QCPU==QARM) || (QCPU==QXSCALE) */

#define gtolStreamRef(dest,src,destOffset,srcOffset) \
{ \
             gtolUInt24(dest,src,destOffset,srcOffset); \
             gtolPtr(dest,src,destOffset,srcOffset); \
             gtolUInt16(dest,src,destOffset,srcOffset); \
             gtolUInt16(dest,src,destOffset,srcOffset); \
}

#elif (QCPU == QPPC603) || (QCPU == QMPC8260) || (QCPU == QHOST_BIG_ENDIAN)
/*************************************/

/* PPC is Big Endian so the bytes are in reverse order for datatypes
  gtolUInt8, gtolUInt16. gtolUInt24 and gtolUInt32 bit data values are 
  ok .
  */
/* PPC bytes are reversed in the msg buffers, so the first byte is
   really byte 3 */
#define NextMsgByte(offset) { if ((offset & 3) == 0) offset+=7; else offset--; }

#define gtolUInt8(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   destOffset += 1; \
}


#define gtolUInt16(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   *((Uint8 *)(dest+destOffset+0)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   destOffset += 2; \
}


#define gtolUInt24(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset+3)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   *((Uint8 *)(dest+destOffset+2)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
   *((Uint8 *)(dest+destOffset+0)) = 0; \
	NextMsgByte(srcOffset); \
	destOffset += 4; \
}


#define gtolUInt32(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset+3)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   *((Uint8 *)(dest+destOffset+2)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   *((Uint8 *)(dest+destOffset+0)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   destOffset += 4; \
}

#define gtolInt8(dest,src,destOffset,srcOffset) \
	gtolUInt8(dest,src,destOffset,srcOffset) 


#define gtolInt16(dest,src,destOffset,srcOffset) \
	gtolUInt16(dest,src,destOffset,srcOffset) 

#define gtolInt24(dest,src,destOffset,srcOffset) \
{ \
	Uint8 tmp; \
   *((Uint8 *)(dest+destOffset+3)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
   *((Uint8 *)(dest+destOffset+2)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(srcOffset); \
	tmp = *((Uint8 *)(src+srcOffset)); \
   *((Uint8 *)(dest+destOffset+1)) = *((Uint8 *)(src+srcOffset)); \
   *((Uint8 *)(dest+destOffset+0)) =  (tmp & 0x80)?(0xff):(0x00); \
	NextMsgByte(srcOffset); \
	destOffset += 4; \
}

#define gtolInt32(dest,src,destOffset,srcOffset) \
	gtolUInt32(dest,src,destOffset,srcOffset) 


#define ltogUInt8(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset)); \
	NextMsgByte(destOffset); \
   srcOffset += 1; \
}


#define ltogUInt16(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+1)); \
	NextMsgByte(destOffset); \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+0)); \
	NextMsgByte(destOffset); \
   srcOffset += 2; \
}


#define ltogUInt24(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+3)); \
	NextMsgByte(destOffset); \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+2)); \
	NextMsgByte(destOffset); \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+1)); \
	NextMsgByte(destOffset); \
	srcOffset += 4; \
}


#define ltogUInt32(dest,src,destOffset,srcOffset) \
{ \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+3)); \
	NextMsgByte(destOffset); \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+2)); \
	NextMsgByte(destOffset); \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+1)); \
	NextMsgByte(destOffset); \
   *((Uint8 *)(dest+destOffset)) = *((Uint8 *)(src+srcOffset+0)); \
	NextMsgByte(destOffset); \
   srcOffset += 4; \
}


#define ltogPtr(dest,src,destOffset,srcOffset) \
	ltogUInt32(dest,src,destOffset,srcOffset)

#define gtolPtr(dest,src,destOffset,srcOffset) \
	gtolUInt32(dest,src,destOffset,srcOffset)


/* 
   The ltog macro's work in two different ways :
   For a 16 bit host and 8 bit firmware we need to expand the instance and shrink the node.
   For a 8 bit host and 16 bit firmware we need to expand the node and shrink the instance.
   Since the instance and the node are just interchanged in the 8 bit vs 16 bit QCompDesc, 
   the same macro works just fine.
*/

#define ltogSwapCompDesc(mdest,msrc,mdOff,msOff) { \
	if(*((Uint8 *)(msrc)+msOff+2) != 0){ \
		if((*((Uint8 *)(msrc)+msOff+2) != 0xff) && \
		   (*((Uint8 *)(msrc)+msOff+3) != 0xff)){ \
			 qKerWarning(QMSG_ERR22); \
	   } \
	} \
	*((Uint8 *)(mdest)+mdOff) = *((Uint8 *)(msrc)+msOff+5); \
      if(*((Uint8 *)(mdest)+mdOff) == 0xff){ \
	      NextMsgByte(mdOff); \
	   	*((Uint8 *)(mdest)+mdOff) = 0xff; \
	   } \
  	   else { \
		   NextMsgByte(mdOff); \
		   *((Uint8 *)(mdest)+mdOff) = 0; \
	   } \
		NextMsgByte(mdOff); \
		*((Uint8 *)(mdest)+mdOff) = *((Uint8 *)(msrc)+msOff+1); \
		NextMsgByte(mdOff); \
		*((Uint8 *)(mdest)+mdOff) = *((Uint8 *)(msrc)+msOff+7); \
		NextMsgByte(mdOff); \
		*((Uint8 *)(mdest)+mdOff) = *((Uint8 *)(msrc)+msOff+6); \
		NextMsgByte(mdOff); \
		*((Uint8 *)(mdest)+mdOff) = *((Uint8 *)(msrc)+msOff+3); \
		NextMsgByte(mdOff); \
		msOff += 6; \
}

#if (QCPU == QPPC603) || (QCPU == QMPC8260)
#if (QINST_WIDTH == 8)

#define ltogCompDesc(dest,src,destOffset,srcOffset) \
{ \
    if(qKerCompFormat == 0){ \
				 srcOffset += 2; /* Skip Pad and Board */ \
             ltogUInt16(dest,src,destOffset,srcOffset); /* Node */ \
				 srcOffset -= 3; /* Go back to Board */ \
             ltogUInt8(dest,src,destOffset,srcOffset); /* Board */ \
				 srcOffset += 5; /* Skip Node and Pad2, Instance and Comp */ \
             ltogUInt8(dest,src,destOffset,srcOffset); /* Processor */ \
				 srcOffset -= 2; /* Skip back to Comp */ \
             ltogUInt8(dest,src,destOffset,srcOffset); /* Component */ \
				 srcOffset -= 2; /* Skip back to Instance */ \
             ltogUInt8(dest,src,destOffset,srcOffset); /* Instance */ \
   } \
   else { \
      ltogSwapCompDesc(dest,src,destOffset,srcOffset); \
   } \
}
#elif (QINST_WIDTH == 16)
#define ltogCompDesc(dest,src,destOffset,srcOffset) \
{ \
    if(qKerCompFormat == 0){ \
      ltogSwapCompDesc(dest,src,destOffset,srcOffset); \
	} \
   else { \
	   srcOffset += 2; /* Skip Pad and Board */ \
 	   ltogUInt16(dest,src,destOffset,srcOffset); /* Node */ \
	   srcOffset -= 3; /* Go back to Board */ \
	   ltogUInt8(dest,src,destOffset,srcOffset); /* Board */ \
	   srcOffset += 5; /* Skip Node and Pad2, Instance and Comp */ \
	   ltogUInt8(dest,src,destOffset,srcOffset); /* Processor */ \
	   srcOffset -= 2; /* Skip back to Comp */ \
	   ltogUInt8(dest,src,destOffset,srcOffset); /* Component */ \
	   srcOffset -= 2; /* Skip back to Instance */ \
	   ltogUInt8(dest,src,destOffset,srcOffset); /* Instance */ \
  } \
}

#else
#error Unknown QINST_WIDTH
#endif
#else /* QCOU = QHOST_BIG_ENDIAN */
#define ltogCompDesc(dest,src,destOffset,srcOffset) \
{ \
   srcOffset += 2; /* Skip Pad and Board */ \
   ltogUInt16(dest,src,destOffset,srcOffset); /* Node */ \
   srcOffset -= 3; /* Go back to Board */ \
   ltogUInt8(dest,src,destOffset,srcOffset); /* Board */ \
   srcOffset += 5; /* Skip Node and Pad2, Instance and Comp */ \
   ltogUInt8(dest,src,destOffset,srcOffset); /* Processor */ \
   srcOffset -= 2; /* Skip back to Comp */ \
   ltogUInt8(dest,src,destOffset,srcOffset); /* Component */ \
   srcOffset -= 2; /* Skip back to Instance */ \
   ltogUInt8(dest,src,destOffset,srcOffset); /* Instance */ \
}
#endif /* (QCPU == QPPC603) || (QCPU == QMPC8260) */


#define ltogStreamRef(dest,src,destOffset,srcOffset) \
{ \
             ltogUInt24(dest,src,destOffset,srcOffset); /* openMode */ \
             ltogPtr(dest,src,destOffset,srcOffset);    /* bHandle */  \
             ltogUInt16(dest,src,destOffset,srcOffset); /* streamId */ \
             ltogUInt16(dest,src,destOffset,srcOffset); /* pad */ \
}

/* 
   The gtol macro's work in two different ways :
   For a 16 bit host and 8 bit firmware we need to shrink the instance and expand the node.
   For a 8 bit host and 16 bit firmware we need to expand the instance and shrink the node.
   Since the instance and the node are just interchanged in the 8 bit vs 16 bit QCompDesc, 
   the same macro works just fine.
*/
#define gtolSwapCompDesc(mdest,msrc,mdOff,msOff) {\
	*((Uint8 *)(mdest)+mdOff+5) = *((Uint8 *)msrc+msOff); /* Node L */ \
	NextMsgByte(msOff); \
   if(*((Uint8 *)msrc+msOff) != 0){ \
	   if((*((Uint8 *)msrc+msOff) != 0xff) && \
			(*((Uint8 *)mdest+mdOff+5) != 0xff)){ \
			 qKerWarning(QMSG_ERR23); \
		} \
	} \
	NextMsgByte(msOff); \
   *((Uint8 *)mdest+mdOff+1) = *((Uint8 *)msrc+msOff); \
	NextMsgByte(msOff); \
   *((Uint8 *)mdest+mdOff+7) = *((Uint8 *)msrc+msOff); \
	NextMsgByte(msOff); \
	*((Uint8 *)mdest+mdOff+6) = *((Uint8 *)msrc+msOff); \
   NextMsgByte(msOff); \
	*((Uint8 *)mdest+mdOff+3) = *((Uint8 *)msrc+msOff); \
   if(*((Uint8 *)mdest+mdOff+3) == 0xff){ \
	   *((Uint8 *)mdest+mdOff+2) = 0xff; \
	} \
	else { \
  	   *((Uint8 *)mdest+mdOff+2) = 0; \
	} \
	NextMsgByte(msOff); \
	mdOff += 6; \
}

#if (QCPU == QPPC603) || (QCPU == QMPC8260)
#if (QINST_WIDTH == 8)

#define gtolCompDesc(dest,src,destOffset,srcOffset) \
{ \
    if(qKerCompFormat == 0){ \
				 destOffset += 2; /* Skip pad and board */ \
             gtolUInt16(dest,src,destOffset,srcOffset); /* Node */ \
				 destOffset -= 3; /* Go back to Board */ \
             gtolUInt8(dest,src,destOffset,srcOffset);  /* Board */ \
				 destOffset += 5; /* Skip Node and Pad2, Instance and Comp */ \
             gtolUInt8(dest,src,destOffset,srcOffset); /* Processor */ \
				 destOffset -= 2; /* Skip back to Comp */ \
             gtolUInt8(dest,src,destOffset,srcOffset); /* Component */ \
				 destOffset -= 2; /* Skip back to Instance */ \
             gtolUInt8(dest,src,destOffset,srcOffset); /* Instance */ \
   } \
   else { \
      gtolSwapCompDesc(dest,src,destOffset,srcOffset); \
   } \
}
#elif (QINST_WIDTH == 16)
#define gtolCompDesc(dest,src,destOffset,srcOffset) \
{ \
   if(qKerCompFormat == 0){ \
      gtolSwapCompDesc(dest,src,destOffset,srcOffset); \
	} \
   else { \
	  destOffset += 2; /* Skip pad and board */ \
	  gtolUInt16(dest,src,destOffset,srcOffset); /* Node */ \
	  destOffset -= 3; /* Go back to Board */ \
	  gtolUInt8(dest,src,destOffset,srcOffset);  /* Board */ \
	  destOffset += 5; /* Skip Node and Pad2, Instance and Comp */ \
	  gtolUInt8(dest,src,destOffset,srcOffset); /* Processor */ \
	  destOffset -= 2; /* Skip back to Comp */ \
	  gtolUInt8(dest,src,destOffset,srcOffset); /* Component */ \
	  destOffset -= 2; /* Skip back to Instance */ \
	  gtolUInt8(dest,src,destOffset,srcOffset); /* Instance */ \
  } \
}

#else
#error Unknown QINST_WIDTH
#endif
#else /* QCOU = QHOST_BIG_ENDIAN */
#define gtolCompDesc(dest,src,destOffset,srcOffset) \
{ \
   destOffset += 2; /* Skip pad and board */ \
   gtolUInt16(dest,src,destOffset,srcOffset); /* Node */ \
   destOffset -= 3; /* Go back to Board */ \
   gtolUInt8(dest,src,destOffset,srcOffset);  /* Board */ \
   destOffset += 5; /* Skip Node and Pad2, Instance and Comp */ \
   gtolUInt8(dest,src,destOffset,srcOffset); /* Processor */ \
   destOffset -= 2; /* Skip back to Comp */ \
   gtolUInt8(dest,src,destOffset,srcOffset); /* Component */ \
   destOffset -= 2; /* Skip back to Instance */ \
   gtolUInt8(dest,src,destOffset,srcOffset); /* Instance */ \
}
#endif /* (QCPU == QPPC603) || (QCPU == QMPC8260) */

#define gtolStreamRef(dest,src,destOffset,srcOffset) \
{ \
             gtolUInt24(dest,src,destOffset,srcOffset); \
             gtolPtr(dest,src,destOffset,srcOffset); \
             gtolUInt16(dest,src,destOffset,srcOffset); \
             gtolUInt16(dest,src,destOffset,srcOffset); \
}


#else
#error QCPU selection error
#endif

#ifdef __cplusplus
}
#endif
