/****************************************************************************
 *		Copyright (c) 1995 Intel Corporation
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qdebug.h
 * AUTHOR:       Gerry Lachac
 * ORG:          Intel Corporation
 * ORIG-DATE:     1-Jul-97 at 14:49:11
 * LAST-MOD:     21-Jul-97 at 15:08:06 by Gerry Lachac
 * PURPOSE:
 *     Contains code for accessing debug functions in library and driver 
 *
 * HISTORY:
 * Date                 Who     Description
 * 15-May-97            GL      Initial Creation.
 ***************************************************************************/

#ifndef __QDEBUG_H__
#define __QDEBUG_H__

/* Board diagnostic boot state information */
typedef struct  {
   UInt32      boardNumber;   /* board number - valid only after mapped state */
	UInt32	   boardState;    /* state of this board */
   UInt32      DiagRetVal1;	/* Diagnostic Return Code from Kernel */
   UInt32      DiagRetVal2;	/* Diagnostic Return Code from Kernel */
} QBoardDiagState;


/* Size of a crash dump */
#define QCRASHDUMP_SIZE 0x100

/* Driver Debug TRACE Level Defines */
#define  QDRV_TRACE_ALL          1
#define  QDRV_MAX_TRACE_SIZE     10500
#define  QDRV_MAX_TRACE_MSGS     1500

/* Driver debug buffer structure */
typedef struct {
   UInt32   traceLevel;
   UInt32   drv2BrdTraceIndex;
   UInt32   brd2DrvTraceIndex;
   UInt32   drv2BrdAllocated;
   UInt32   brd2DrvAllocated;
   UInt32   brd2DrvBuffer[QDRV_MAX_TRACE_SIZE];   
   UInt32   drv2BrdBuffer[QDRV_MAX_TRACE_SIZE];
} QDrvTraceBuffer;

typedef struct {
   UInt32   traceLevel;
   UInt32   drv2BrdTraceIndex;
   UInt32   brd2DrvTraceIndex;
   UInt32   drv2BrdAllocated;
   UInt32   brd2DrvAllocated;
  UInt32   *buffer;
} QSelectTraceBuffer;


typedef struct _mercd_trace_parameter_sT {
  Int32 mode;
  UInt32 board;
  UInt32 level;
  UInt32 msgsAllocate;
  UInt32 dumpThreshold;
  UInt32 dtSzLimit;
  UInt32 * b2dTypeFilter;
  UInt32 * d2bTypeFilter;
  UInt32 * b2dStrIdFilter;
  UInt32 * d2bStrIdFilter;
  UInt32 * SrcDesc;
  UInt32 * DstDesc;
} mercd_trace_parameter_sT, *pmercd_trace_parameter_sT;
/* Function prototypes */

#ifdef __cplusplus
extern "C"{
#endif

QStatus qDrvGetCrashDump (QHandle ,UInt32, void * );
QStatus qDrvBrdGetDiagState (QHandle , UInt32 , QBoardDiagState *);
QStatus qDrvEnableTrace (QHandle msgqueue, pmercd_trace_parameter_sT ptr);
QStatus qDrvDisableTrace (QHandle msgqueue,UInt32 board  );
QStatus qDrvGetTrace(QHandle, UInt32, UInt32 , QDrvTraceBuffer *);
int qLibDebugLevel (  int level );
int qLibDebugFile (  FILE *pFile );


#ifdef __cplusplus
}
#endif

#endif








