/****************************************************************************
 *		Copyright (c) 1995 Intel Corporation
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qcluster.h
 * AUTHOR:       Gerry Lachac x6193
 * ORG:          Intel Corporation
 * ORIG-DATE:    27-Jun-96 at 10:00:43
 * LAST-MOD:      4-Nov-96 at 11:40:32 by Gerry Lachac
 * PURPOSE:
 *    This module equates and prototypes relating to downloading
 *
 * HISTORY:
 * Date                 Who     Description
 * 20-Sep-96            GL      Creation date.
 ***************************************************************************/

#ifndef __QDNLD_H__
#define __QDNLD_H__


/* Type of target processors and components to start/dnld */
#define  MODTYPE_960RUNTIME      1
#define  MODTYPE_ONYXRUNTIME     2
#define  MODTYPE_ONYXBOOT        3
#define  MODTYPE_960COMPONENTS   4
#define  MODTYPE_ONYXCOMPONENTS  5
#define  MODTYPE_POWERBOOT       6
#define  MODTYPE_POWERRUNTIME    7
#define  MODTYPE_C6XBOOT         8
#define  MODTYPE_C6XRUNTIME      9

/* type of parameters */
#define  MODPARM_GLOBAL       1
#define  MODPARM_960_CP       2
#define  MODPARM_ONYX_SP      3




/* For our C++ friends */
#ifdef __cplusplus
extern "C"{
#endif


/* Prototypes */
QStatus qModuleStart(QCompDesc,UInt32);
QStatus qModuleLoadParms(QCompDesc,UInt32,void *);
QStatus qModuleLoad(QCompDesc,UInt32,UInt32,char *);

#ifdef __cplusplus
}
#endif

#endif /* __Q_DNLD_H__*/
