/*=======================================================================
//        FILE: qdrverr.h
// DESCRIPTION: Mercury Streams Driver Errors Defination file
//
// Date Created: 02/21/97
//       Author: Rajiv Gadre
//
//   Copyright (c) 1997-99 Intel Corporation
//
//   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation
//   The copyright notice above does not evidence any actual or
//   intended publication of such source code.
//=======================================================================*/

/*=======================================================================
// HISTORY:
// Date                 Who     Description
// 21-Feb-97            RG      Initial Creation.
//
//========================================================================*/

#ifndef _MDERRDEF_
#define _MDERRDEF_

/* Message Error Codes */

/* No error */
#define  MD_OK    0

#ifndef QERR_SYSTEM_DRIVER
#define QERR_SYSTEM_DRIVER	0x01000000
#endif

/* CD Error messages */

#define CD_ERROR  0x00010000

#define CD_ERR_BAD_MSG_ID  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000001)
#define CD_ERR_NO_MEMORY      (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000002)
#define CD_ERR_NO_BIND_HANDLE (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000003)
#define CD_ERR_BAD_STATE   (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000004)
#define CD_ERR_BAD_PARAMETER  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000005)
#define CD_ERR_NO_STREAM_HANDLE  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000006)
#define CD_ERR_BAD_STREAM_HANDLE (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000007)
#define CD_ERR_BAD_BOARD_NUMBER  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000008)
#define CD_ERR_BAD_BIND_HANDLE   (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000009)
#define CD_ERR_SEND_Q_OVERFLOW   (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000010)
#define CD_ERR_PAM_FAILURE (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000012)
#define CD_ERR_ADD_INTR_FAILED   (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000013)
#define CD_ERR_BAD_CLASS   (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000014)
#define CD_ERR_BAD_SUBCLASS1  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000015)
#define CD_ERR_BAD_SUBCLASS2  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000016)
#define CD_ERR_MAPPING_FAILED (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000017)
#define CD_ERR_UNMAPPING_FAILED  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000018)
#define CD_ERR_ADAPTER_BUSY   (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000019)
#define CD_ERR_DRIVER_BUSY (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000020)
#define CD_ERR_SYSTEM_ERROR   (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000021)
#define CD_ERR_KAW_START_FAILED  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000022)
#define CD_ERR_KAW_STOP_FAILED   (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000023)
#define CD_ERR_STREAM_DATA_NULL  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000024)
#define CD_ERR_BAD_BOARD_STATE   (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000025)
#define CD_ERR_BAD_STREAM_STATE  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000026)
#define CD_ERR_BAD_MSG_SIZE  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000027)
#define CD_ERR_STREAM_BROKEN  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000028)
#define CD_ERR_ADAPTER_INVALID  (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000029)
#define CD_ERR_HOST_RAM_TIMEOUT (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000030)
#define CD_ERR_INVALID_DEBUG_PORT (QERR_SYSTEM_DRIVER|CD_ERROR|0x00000031)

/* PAM error messages */

#define PAM_ERROR 0x00020000

#define PAM_ERR_BAD_ADAPTER_STATE   (QERR_SYSTEM_DRIVER|PAM_ERROR|0x00000001)
#define PAM_ERR_NO_MEMORY  (QERR_SYSTEM_DRIVER|PAM_ERROR|0x00000002)
#define PAM_ERR_STREAM_OPEN_FAILED  (QERR_SYSTEM_DRIVER|PAM_ERROR|0x00000003)
#define PAM_ERR_REGISTER_DPC  (QERR_SYSTEM_DRIVER|PAM_ERROR|0x00000004)
#define PAM_ERR_BAD_MSG_ID (QERR_SYSTEM_DRIVER|PAM_ERROR|0x00000005)
#define PAM_ERR_BAD_PAM_STATE (QERR_SYSTEM_DRIVER|PAM_ERROR|0x00000006)
#define PAM_ERR_NO_BOARD   (QERR_SYSTEM_DRIVER|PAM_ERROR|0x00000007)
#define PAM_ERR_ADMIN_FAILURE (QERR_SYSTEM_DRIVER|PAM_ERROR|0x00000008)
#define PAM_ERR_DEREGISTER_DPC   (QERR_SYSTEM_DRIVER|PAM_ERROR|0x00000009)
#define PAM_ERR_BAD_PARAMETER (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000010)
#define PAM_ERR_STREAM_CLOSE_FAILED (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000011)
#define PAM_ERR_BAD_PARAM_BLOCK_SIZE (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000012)
#define PAM_ERR_WRITE_CONFIG_BLK_FAILED (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000013)

//WW support
#define PAM_ERR_WW_PAM_ERR_INVALID_PARAM (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000014)
#define PAM_ERR_WW_PAM_ERR_NO_WW_PARM (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000015)
#define PAM_ERR_WW_PAM_ERR_REGISTER_DPC (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000016)
#define PAM_ERR_WW_PAM_ERR_NO_MEMORY (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000017)
#define PAM_ERR_WW_PAM_ERR_REGISTER_ISR (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000018)
#define PAM_ERR_WW_PAM_WW_MODE_NOT_OPERATIONAL  (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000019)
#define PAM_ERR_WW_PAM_ERR_STOP_SRAM_TIMER  (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000020)
#define PAM_ERR_WW_PAM_ERR_DEREGISTER_ISR (QERR_SYSTEM_DRIVER|PAM_ERROR|0x000000021)
 
//WW support
#define WW_PARAM_ERROR 0x00030000
#define CD_ERR_WW_INVALID_PARAM  (QERR_SYSTEM_DRIVER|WW_PARAM_ERROR|0x00000001)
#define CD_ERR_WW_NOT_SUPPORTED  (QERR_SYSTEM_DRIVER|WW_PARAM_ERROR|0x00000002)
#define CD_ERR_WW_MAPPING_FAILED  (QERR_SYSTEM_DRIVER|WW_PARAM_ERROR|0x00000003)
#define CD_ERR_WW_RTK_POST_LOCATION_READ  (QERR_SYSTEM_DRIVER|WW_PARAM_ERROR|0x00000004)
#define CD_ERR_WW_RTK_POST_IN_PROGRESS  (QERR_SYSTEM_DRIVER|WW_PARAM_ERROR|0x00000005)
#endif
