/****************************************************************************
 *		Copyright (c) 1995 - 2003 Intel Corporation.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qerrorsys.h
 * AUTHOR:       Gerry Lachac x6193
 * ORG:          Intel Corporation
 * ORIG-DATE:    31-Jan-96 at 16:55:42
 * LAST-MOD:     31-Jan-96 at 17:27:45 by Gerry Lachac x6193
 * PURPOSE:
 *    This module contains the main error defines for creating 
 *    error code equates in any of the Mercury System Software.
 *
 * HISTORY:
 * Date                 Who     Description
 * 31-Jan-96            GL      Initial Creation.
 ***************************************************************************/


#if !defined(_qerrorsys_h_)
#define _qerrorsys_h_

/***************************************************************************
 *
 * Error numbers are a 32bit unsigned value that is split into three parts.
 * It looks like this:
 *
 *      -----------------------------------------
 *     | SystemID  | ModuleID  |  Specific Error |
 *     |  8 bits   |  8 bits   |   16 bits       |
 *      -----------------------------------------
 *
 *  SystemID identifies which part of the Mercury system software generated
 *  this error code.  It can be one of three parts, kernel, driver and
 *  host library.  The values for this field are contained in this file.  
 *  Each of the three systems must set this field to the approriate value
 *  when setting an error code.
 *
 *  Values for the other two fields are controlled by the individual system
 *
 ***************************************************************************/


/* Errorcode bitmasks */
#define  QERR_MASK_SYSTEM  0xFF000000
#define  QERR_MASK_MODULE  0x00FF0000
#define  QERR_MASK_ERROR   0x0000FFFF

/* System types */
#define  QERR_SYSTEM_KERNEL   0x00000000
#define  QERR_SYSTEM_DRIVER   0x01000000
#define  QERR_SYSTEM_HOSTLIB  0x02000000


#endif /* !defined(_qerrorsys_h_) */
