/****************************************************************************
 *      Copyright (c) 1995 Dialogic Corp.
 *      All Rights Reserved.
 *
 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *      The copyright notice above does not evidence any actual or
 *      intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qinit.h
 * AUTHOR:       Gerry Lachac
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    26-Apr-95 at 10:43:25
 * LAST-MOD:      7-Nov-97 at 09:28:40 by Gerry Lachac
 * PURPOSE:
 *    Defines and prototypes for low level configuration of host driver
 *
 * HISTORY:
 * Date            Who   Description
 * 10-8-96        GL    Initial creation
 ***************************************************************************/

#ifndef __QINIT_H__
#define __QINIT_H__

#include "qtypes.h"
#include "qcomplib.h"
#include "qaccess.h"



/* 
 *  Board Configuration structure for driver - this tells the driver where the
 *  board resides in shared memory
 */
typedef struct  {
   UInt32      pamId;               /* Which protocol module to use */
   UInt32      physSramStart;       /* Where in shared RAM the board start */
   UInt32      physSramSize;        /* The size of shared RAM */
   UInt16      boardNumber;         /* The board number */
   UInt16      interruptLevel;      /* What interrupt level the board is at */
   UInt16      interruptVector;     /* What interrupt vector the board is at */
   UInt16      interruptSharable;   /* Can this interrupt be shared? */
   UInt16      ioPortStart;         /* I/O port used by this board */
   UInt16      ioPortSize;          /* I/O port size used by this board */
   UInt16      dmaChannel;          /* Enable DMA for this board? */
   UInt16      busType;             /* What is the bus arch. for this board */
} QBoardConfig;


/***** Begin WereWolf Modifications *****/

typedef struct {
   UInt16 numberMFAInboundQ;      /* Number of MFA's in the Inbound Q */
   UInt16 sizeofMFAInboundQ;      /* Size of MFA in the Inbound Q */
   UInt16 numberMFAOutboundQ;     /* Number of MFA's in the Outbound Q */
   UInt16 sizeofMFAOutboundQ;     /* Size of MFA for the outbound Q */
   UInt16 numberBigMsgBlocks;     /* Number of Big Msg blocks to be sent 
                                     to the board */
   UInt16 sizeofBigMsgBlocks;     /* size of the big message blocks */
   UInt16 numberOfOrphanEntries;  /* Number of Orphan Q enteries */

   /* The following fields are of no use for the driver */
   UInt16 flowControlToBoard;     /* Flow Control to the board */
   UInt16 flowControlFromBoard;   /* Flow COntrol from the board */
   UInt16 hardwareTimeout;        /* Timeout interval for the hardware */
   UInt16 maxNumStreamMFAAllowed; /* The max number of mfa's  allowed for 
                                     the streams on this board */
} QBoardWWParms;

/****** End WereWolf Modifications ******/


/* Defines  used in QBoardConfig Structure */

#define QPAM_DEFAULTID         0x0
#define QCFG_MERCURY_PAM_ID         0x0
#define QCFG_VME_SRAM_START_BASE    0x0
#define QCFG_VME_SRAM_SIZE_DEFAULT  0x80000


/* Interrupt Sharable*/
#define IRQ_SHARED      0
#define IRQ_NOTSHARED   1

/*DMA enable*/
#define DMA_UNUSED      0

/* Bus Types */
#define BUS_TYPE_ISA             0x0001
#define BUS_TYPE_EISA            0x0002
#define BUS_TYPE_VME             0x0003
#define BUS_TYPE_PCI             0x0004
#define BUS_TYPE_MICRO_CHANNEL   0x0005
#define BUS_TYPE_PCMCIA          0x0006


/*Board shutdown parameters*/
#define QCFG_SHUTDOWN_NORMAL  0
#define QCFG_SHUTDOWN_FORCE   1
#define QCFG_HOTSWAP_LED_ON   2
#define QCFG_HOTSWAP_LED_OFF  3


#define MAX_POST_ENABLE 0
#define MIN_POST_ENABLE 1

/*
 *  Structure that is passed to board to start the kernel running.  This
 *  structure defines adjustable parameters 
 */
typedef struct  {
   UInt32   protocolRev;      /* Revision of protocol between host/board */
   UInt32   checkSum;         /* Checksum of this block */ 
   UInt32   hostConfigSize;   /* the total size of the structure in bytes */
   UInt32   maxHostMsgs;      /* Max number of messages to host */
   UInt32   maxFwMsgs;        /* Max number of messages to firmware */
   UInt32   dataAlignment;      /* power of 2 starts at 2**1 */
   UInt32   maxHostDataXfer;
   UInt32   maxFwDataXfer;
   UInt32   hostConfigMask;
   UInt32   hwIntInterval;    /* Delay before sending msgs from board to host */
   UInt32   dataBlockLimit;   /* Must be < 100 */
   UInt32   extBlockLimit;      /* This + dataBlockLimit must be < 100 */
   UInt32   boardNumber;      /* Board number to set board to*/
   UInt32   nodeNumber;       /* node number to set to board */
   UInt32   interruptLevel;   /* Interrupt level of board */
   UInt32   interruptVector;  /* Interrupt vector of board */
    QBoardWWParms  WWParam;    /* WW initialization parmaeters */
} QBoardStartConfig;


/* Some reasonable default parameters for QBoardStartConfig structure */
#define QCFG_PROTO_REV           1
#define QCFG_CFGSTRUCT_SIZE      64
#define QCFG_DEF_HOSTMSGQ_SIZE   32
#define QCFG_DEF_FWMSGQ_SIZE     48
#define QCFG_DATA_ALIGN          0
#define QCFG_DEF_HDATAXFER       48
#define QCFG_DEF_FDATAXFER       48
#define QCFG_DEF_CFGMASK         0
#define QCFG_DEF_HWINTERVAL      80
#define QCFG_DEF_DATABLK_LIM     80
#define QCFG_DEF_EXTBLK_LIM      10
   


/* 
 *  Board Report - driver scans boards and can tell us this information
 *  about them
 */
typedef struct  {
   UInt16      cfgId;               /* Which protocol module to use */
   UInt16      busType;             /* type of bus */
   UInt8       busId;               /* which bus in multi-bus system */
   UInt8       slotNumber;          /* which slot in that bus  */
   UInt32      physSramStart;       /* Where in shared RAM the board start */
   UInt32      physSramSize;        /* The size of shared RAM */
   UInt16      ioPortStart;         /* I/O port used by this board */
   UInt16      ioPortSize;          /* I/O port size used by this board */
   UInt16      interruptLevel;      /* What interrupt level the board is at */
   UInt16      interruptVector;     /* What interrupt vector the board is at */
   UInt8       interruptSharable;   /* Can this interrupt be shared? */
    UInt8         dmaChannel;          /* DMA channel assiged (PCI) */
   //Actual PCI slot_number for Listboards
  UInt8         pciSlotNumber;
} QBoardReport;

/* Board state information */
typedef struct  {
   UInt16      cfgId;         /* Configuration id */
   UInt16      boardNumber;   /* board number - valid only after mapped state */
   UInt16      boardState;    /* state of this board */
   UInt16      SubState;      /* substate of this board */
   UInt16      DiagRetVal1;   /* Diagnostic Return Code from Kernel */
   UInt16      DiagRetVal2;   /* Diagnostic Return Code from Kernel */
} QBoardState;

typedef enum 
{
   DM3_INITIALIZED, 
   DM3_RESET, 
   DM3_CONFIG_PENDING, 
   DM3_CONFIGURED, 
   DM3_RUNNING, 
   DM3_QUISCED, 
   DM3_SHUTDOWN, 
   DM3_POWERDOWN

} MPD_BOARD_STATE, DM3_BOARD_STATE;



// Linux Driver Sub States

#define MERCD_ADAPTER_STATE_INIT                    0x0001
#define MERCD_ADAPTER_STATE_READY                   0x0002
#define MERCD_ADAPTER_STATE_CONFIGED                0x1002
#define MERCD_ADAPTER_STATE_MAPPED                  0x2002
#define MERCD_ADAPTER_STATE_STARTED                 0x0004
#define MERCD_ADAPTER_STATE_CP_STARTED              0x1004
#define MERCD_ADAPTER_STATE_DOWNLOADED              0x0008
#define MERCD_ADAPTER_STATE_STOPPED                 0x0010
#define MERCD_ADAPTER_STATE_SHUTDOWN_PROGRESS       0x0020
#define MERCD_ADAPTER_STATE_OUT_OF_SERVICE          0x0040
#define MERCD_ADAPTER_STATE_CRASHED                 0x0080
#define MERCD_ADAPTER_STATE_OUT_OF_SYNC             0x0100
#define MERCD_ADAPTER_STATE_SEND_DATA_PEND          0x0200
#define MERCD_ADAPTER_STATE_HRAM_SEM_TIMEOUT_PEND   0x0400
#define MERCD_ADAPTER_STATE_HOTSWAP                 0x0800


// Linux WereWolf States
#define MERCD_ADAPTER_WW_MODE_STATE                0x0001
#define MERCD_ADAPTER_WW_MODE_ENABLED              (MERCD_ADAPTER_WW_MODE_STATE)
#define MERCD_ADAPTER_WW_MODE_NOTENABLED           (MERCD_ADAPTER_WW_MODE_STATE << 1)
#define MERCD_ADAPTER_WW_I20_MESSAGING_READY       (MERCD_ADAPTER_WW_MODE_STATE << 2)

//States of pwwDev->state
#define MERCD_ADAPTER_WW_MODE_INIT_INTR_PENDING    (MERCD_ADAPTER_WW_MODE_STATE << 3)
#define MERCD_ADAPTER_WW_MODE_INIT_INTR_ACKED      (MERCD_ADAPTER_WW_MODE_STATE << 4)
#define MERCD_ADAPTER_WW_MODE_INIT_MSG_READY_INTR_PENDING \
                                                   (MERCD_ADAPTER_WW_MODE_STATE << 5)
#define MERCD_ADAPTER_WW_MODE_INIT_MSG_READY_INTR_ACKED \
                                                   (MERCD_ADAPTER_WW_MODE_STATE << 6)
#define MERCD_ADAPTER_WW_SUCCEDED                  (MERCD_ADAPTER_WW_MODE_STATE << 7)
#define MERCD_ADAPTER_WW_FAILED                    (MERCD_ADAPTER_WW_MODE_STATE << 8)
#define MERCD_ADAPTER_WW_NOTREADY                  (MERCD_ADAPTER_WW_MODE_STATE << 9)
#define MERCD_ADAPTER_WW_IN_SHUTDOWN               (MERCD_ADAPTER_WW_MODE_STATE << 10)
#define MERCD_ADAPTER_WW_MIN_POST_ENABLE           (MERCD_ADAPTER_WW_MODE_STATE << 11)

typedef struct {

  int logicalID;
 
  DM3_BOARD_STATE curState;

  unsigned long status;

  unsigned long WWState;

  unsigned long plxICS; 

} BOARD_STATE;

typedef struct {

  BOARD_STATE boardState[256];

  int numBoards;

} GET_BOARDS_STATE, *PGET_BOARDS_STATE;

#define MAXHMPOPENS 4096

typedef struct _trans_str {
  int fd;
  int fd1;
  int fd2;
  int fd3;
} GET_TRANS_STR;

typedef struct _HMP_board_t {
  QBoardReport Attr;
  QBoardState Info;
  Uint8   *SharedBitMask;
  GET_TRANS_STR     transTable[MAXHMPOPENS];
} HMP_board_t;


/* Valid board states - Need real driver values -gerry*/
#define  QBOARD_STATE_INITED     1
#define  QBOARD_STATE_MAPPED     2
#define  QBOARD_STATE_CONFIGED   3
#define  QBOARD_STATE_STARTED    4
#define  QBOARD_STATE_DOWNLOADED 5

/* Configuration ROM size */
#define  QCFG_ROMSIZE         0x0100

/* Maximum number of boards supported */
#define  QCFG_MAXBOARDS       255


/* Function Prototypes */
#ifdef __cplusplus
extern "C"{
#endif
QStatus qDrvStart (QHandle,UInt32, UInt32 );
QStatus qDrvShutdown (QHandle );
QStatus qDrvBrdConfig (QHandle, QBoardConfig * );
QStatus qDrvBrdGetROM (QHandle, UInt16,unsigned char  * );
QStatus qDrvBrdMap (QHandle, UInt16, UInt16);
QStatus qDrvBrdStart  (QHandle,QCompDesc,UInt16,UInt32,QBoardStartConfig *,UInt32);
QStatus qDrvBrdShutdown (QHandle, UInt16,UInt16);
QStatus qDrvReportBoards (QHandle, QBoardReport *,UInt32 *);
QStatus qDrvReportBrdStates (QHandle, QBoardState *,UInt32 *);
QStatus qDrvScanSlot (QHandle, UInt16);
/***** Begin WereWolf Modifications *****/
QStatus  qWWSetParm (QHandle , UInt32 ,QBoardWWParms *);
QStatus  qWWGetParm (QHandle , UInt32 ,QBoardWWParms *);
QStatus  qWWSetMode (QHandle , UInt32 , UInt32 *);
QStatus  qWWGetMode (QHandle , UInt32 ,UInt32 *);
QStatus  qDrvGetBoardsState(GET_BOARDS_STATE *getBoardsState);
/****** End WereWolf Modifications ******/
#ifdef __cplusplus
}
#endif

#endif
