/******************************************************************************
*     Copyright (c) 1995-2003 Intel Corporation. All Rights Reserved.
*
*     All names, products, and services mentioned herein are the trademarks
*     or registered trademarks of their respective organizations and are the
*     sole property of their respective owners.
*
*
*     THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation.
*     The copyright notice above does not evidence any actual or
*     intended publication of such source code.
******************************************************************************/

/****************************************************************************
 * FILE:         qkernerr.h
 * AUTHOR:       Arthur Elwell
 * ORG:          Intel Corporation
 * PURPOSE:
 *    This include file defines all the merucry kernel error code values.
 *
 * HISTORY:
 * Date        Who   Description
 * 25-Apr-2001 SSA   Add a set of Geo error codes for the qClusterAttrAdd().
 * 18-Jul-2000 NS    Add a set of unique error codes for the qSlotPool functions.
 * 04-17-00    NS    Added error codes for Si port state.
 * 12-01-96    DG    Added error codes for more files, created number ranges.
 * 02-13-96    AE    Initial Creation (#defines for nid sub-system)
 * 07-07-99    LL    Added error codes & mem def. for hdlc. Tagged "for_hdlc".
 ***************************************************************************/
#ifndef QKERNERR
#define QKERNERR

#ifdef __cplusplus
extern "C" {
#endif

/*************************** IMPORTANT NOTE ************************************/
/* To keep the format on MS Windows, this file should be saved without tabs.   */
/* To convert tabs to spaces in emacs use "C-x h ESC x untabify" before saving */
/*******************************************************************************/

/******************************************************************************
* reserved number ranges
*******************************************************************************
0x000000 *** No error set ***
0x000001 *** os error ***
0x000002-0x00ffff spare
0x010000-0x012fff hwinit sub-system
0x013000-0x015fff bsp sub-system
0x016000-0x016fff qslac sub-system
0x017000-0x017fff ondiag sub-system
0x018000-0x01ffff spare
0x020000-0x027fff memory sub-system
0x028000-0x02ffff clustmgt sub-system
0x030000-0x037fff router sub-system
0x038000-0x03ffff library sub-system
0x040000-0x047fff stream sub-system
0x048000-0x04ffff nid sub-system
0x050000-0x055fff mma sub-system
0x056000-0x056fff soft mma sub-system for Venus
0x057000-0x057fff soft mma sub-system for Third Rock
0x058000-0x0583ff ftimer sub-system
0x058400-0x05ffff ftimer mma  sub-system
0x060000-0x067fff qagent sub-system
0x068000-0x069fff acg sub-system
0x06A000-0x06ffff spare
0x070000-0x077fff sc4000 sub-system
0x078000-0x07ffff sysinit sub-system
0x080000-0x08ffff regmgt sub-system
0x098000-0x09bfff sram sub-system
0x09c000-0x09ffff loader sub-system
0x0a0000-0x0affff print/trace sub-system
0x0b0000-0x0bffff hdlc sub-system
0x0c0000-0x0cffff TCP/IP sub-system
0x0d0000-0x0fffff spare

0x100000-0xffffff resource
0x01000000-0xffffffff   host
*/
/*******************************************************************************
* ONDIAG errors
*******************************************************************************/
#define QONDIAG_ERR1   0x017001 /* Comments to be included */
#define QONDIAG_ERR2   0x017002 /* Comments to be included */
#define QONDIAG_ERR3   0x017003 /* Comments to be included */
#define QONDIAG_ERR4   0x017004 /*qMsgAllocate failed for Online Diagnostics*/
/*******************************************************************************
* QSLAC errors
*******************************************************************************/
#define QSLAC_ERR1     0x016001 /* Comments to be included */
#define QSLAC_ERR2     0x016002 /* Comments to be included */
#define QSLAC_ERR3     0x016003 /* Comments to be included */
#define QSLAC_ERR4     0x016004 /* Comments to be included */
#define QSLAC_ERR5     0x016005 /* Comments to be included */
#define QSLAC_ERR6     0x016006 /* Comments to be included */
#define QSLAC_ERR7     0x016007 /* Comments to be included */
#define QSLAC_ERR8     0x016008 /* Comments to be included */
#define QSLAC_ERR9     0x016009 /* Comments to be included */
#define QSLAC_ERRA     0x01600a /* Comments to be included */
#define QSLAC_ERRB     0x01600b /* Comments to be included */
#define QSLAC_ERRC     0x01600c /* Comments to be included */
#define QSLAC_ERRD     0x01600d /* Comments to be included */
#define QSLAC_ERRE     0x01600e /* Comments to be included */
#define QSLAC_ERRF     0x01600f /* Comments to be included */
#define QSLAC_ERR10    0x016010 /* Comments to be included */
#define QSLAC_ERR11    0x016011 /* Comments to be included */
#define QSLAC_ERR12    0x016012 /* Comments to be included */
#define QSLAC_ERR13    0x016013 /* Comments to be included */
#define QSLAC_ERR14    0x016014 /* Comments to be included */
#define QSLAC_ERR15    0x016015 /* Comments to be included */
#define QSLAC_ERR16    0x016016 /* Comments to be included */
#define QSLAC_ERR17    0x016017 /* Comments to be included */
#define QSLAC_ERR18    0x016018 /* Comments to be included */
#define QSLAC_ERR19    0x016019 /* Comments to be included */
#define QSLAC_ERR1A    0x01601a /* Comments to be included */
#define QSLAC_ERR1B    0x01601b /* Comments to be included */
#define QSLAC_ERR1C    0x01601c /* Comments to be included */
#define QSLAC_ERR1D    0x01601d /* Comments to be included */
#define QSLAC_ERR1E    0x01601e /* Comments to be included */
#define QSLAC_ERR1F    0x01601f /* Comments to be included */
#define QSLAC_ERR20    0x016020 /* Comments to be included */
#define QSLAC_ERR21    0x016021 /* Comments to be included */
#define QSLAC_ERR22    0x016022 /* Comments to be included */
#define QSLAC_ERR23    0x016023 /* Comments to be included */
#define QSLAC_ERR24    0x016024 /* Comments to be included */
#define QSLAC_ERR25    0x016025 /* Comments to be included */
#define QSLAC_ERR26    0x016026 /* Comments to be included */
#define QSLAC_ERR27    0x016027 /* Comments to be included */
#define QSLAC_ERR28    0x016028 /* Comments to be included */
#define QSLAC_ERR29    0x016029 /* Comments to be included */
#define QSLAC_ERR2A    0x01602a /* Comments to be included */
#define QSLAC_ERR2B    0x01602b /* Comments to be included */
#define QSLAC_ERR2C    0x01602c /* Comments to be included */
#define QSLAC_ERR2D    0x01602d /* Comments to be included */
#define QSLAC_ERR2E    0x01602e /* Comments to be included */
#define QSLAC_ERR2F    0x01602f /* Comments to be included */
#define QSLAC_ERR30    0x016030 /* Comments to be included */
#define QSLAC_ERR31    0x016031 /* Comments to be included */
#define QSLAC_ERR32    0x016032 /* Comments to be included */
#define QSLAC_ERR33    0x016033 /* Comments to be included */
#define QSLAC_ERR34    0x016034 /* Comments to be included */
#define QSLAC_ERR35    0x016035 /* Comments to be included */
#define QSLAC_ERR36    0x016036 /* Comments to be included */
#define QSLAC_ERR37    0x016037 /* Comments to be included */
#define QSLAC_ERR38    0x016038 /* Comments to be included */
#define QSLAC_ERR39    0x016039 /* Comments to be included */
#define QSLAC_ERR3A    0x01603a /* Comments to be included */
#define QSLAC_ERR3B    0x01603b /* Comments to be included */
#define QSLAC_ERR3C    0x01603c /* Comments to be included */
#define QSLAC_ERR3D    0x01603d /* Comments to be included */
#define QSLAC_ERR3E    0x01603e /* Comments to be included */
#define QSLAC_ERR3F    0x01603f /* Comments to be included */
#define QSLAC_ERR40    0x016040 /* Comments to be included */
#define QSLAC_ERR41    0x016041 /* Comments to be included */
#define QSLAC_ERR42    0x016042 /* Comments to be included */
#define QSLAC_ERR43    0x016043 /* Comments to be included */
#define QSLAC_ERR44    0x016044 /* Comments to be included */
#define QSLAC_ERR45    0x016045 /* Comments to be included */
#define QSLAC_ERR46    0x016046 /* Comments to be included */
#define QSLAC_ERR47    0x016047 /* Comments to be included */
#define QSLAC_ERR48    0x016048 /* Comments to be included */
#define QSLAC_ERR49    0x016049 /* Comments to be included */
#define QSLAC_ERR4A    0x01604a /* Comments to be included */
#define QSLAC_ERR4B    0x01604b /* Comments to be included */
#define QSLAC_ERR4C    0x01604c /* Comments to be included */
#define QSLAC_ERR4D    0x01604d /* Comments to be included */
#define QSLAC_ERR4E    0x01604e /* Comments to be included */
#define QSLAC_ERR4F    0x01604f /* Comments to be included */
#define QSLAC_ERR50    0x016050 /* Comments to be included */
#define QSLAC_ERR51    0x016051 /* Comments to be included */
#define QSLAC_ERR52    0x016052 /* Comments to be included */
#define QSLAC_ERR53    0x016053 /* Comments to be included */
#define QSLAC_ERR54    0x016054 /* Comments to be included */
#define QSLAC_ERR55    0x016055 /* Comments to be included */
#define QSLAC_ERR56    0x016056 /* Comments to be included */
#define QSLAC_ERR57    0x016057 /* Comments to be included */
#define QSLAC_ERR58    0x016058 /* Comments to be included */
#define QSLAC_ERR59    0x016059 /* Comments to be included */
#define QSLAC_ERR5A    0x01605a /* Comments to be included */
#define QSLAC_ERR5B    0x01605b /* Comments to be included */
#define QSLAC_ERR5C    0x01605c /* Comments to be included */
#define QSLAC_ERR5D    0x01605d /* Comments to be included */
#define QSLAC_ERR5E    0x01605e /* Comments to be included */
#define QSLAC_ERR5F    0x01605f /* Comments to be included */
#define QSLAC_ERR60    0x016060 /* Comments to be included */
#define QSLAC_ERR61    0x016061 /* Comments to be included */
#define QSLAC_ERR62    0x016062 /* Comments to be included */
#define QSLAC_ERR63    0x016063 /* Comments to be included */
#define QSLAC_ERR64    0x016064 /* Comments to be included */

/*******************************************************************************
* hwinit qErrNo definitions (0x011000 to 0x01ffff)
*******************************************************************************/
#define QHWINIT_ERR1     0x011001 /* Comments to be included */
#define QHWINIT_ERR2     0x011002 /* Comments to be included */
#define QHWINIT_ERR3     0x011003 /* Comments to be included */
#define QHWINIT_ERR4     0x011004 /* Comments to be included */
#define QHWINIT_ERR5     0x011005 /* Comments to be included */
#define QHWINIT_ERR6     0x011006 /* Comments to be included */
#define QHWINIT_ERR7     0x011007 /* Comments to be included */
#define QHWINIT_ERR8     0x011008 /* Comments to be included */
#define QHWINIT_ERR9     0x011009 /* Comments to be included */
#define QHWINIT_ERRA     0x01100a /* Comments to be included */
#define QHWINIT_ERRB     0x01100b /* Comments to be included */
#define QHWINIT_ERRC     0x01100c /* Comments to be included */
#define QHWINIT_ERRD     0x01100d /* Comments to be included */
#define QHWINIT_ERRE     0x01100e /* Comments to be included */
#define QHWINIT_ERRF     0x01100f /* Comments to be included */
#define QHWINIT_ERR10    0x011010 /* Comments to be included */
#define QHWINIT_ERR11    0x011011 /* Comments to be included */
#define QHWINIT_ERR12    0x011012 /* Comments to be included */
#define QHWINIT_ERR13    0x011013 /* Comments to be included */
#define QHWINIT_ERR14    0x011014 /* Comments to be included */
#define QHWINIT_ERR15    0x011015 /* Comments to be included */
#define QHWINIT_ERR16    0x011016 /* Comments to be included */
#define QHWINIT_ERR17    0x011017 /* Comments to be included */
#define QHWINIT_ERR18    0x011018 /* Comments to be included */
#define QHWINIT_ERR19    0x011019 /* Comments to be included */

/*******************************************************************************
* BSP errors
*******************************************************************************/
#define QBSP960_ERR0     0x013000 /* Comments to be included */

#define QBSPARM_ERR0     0x013010 /* Comments to be included */

#define QBSPONYX_ERR1    0x013021 /* Comments to be included */
#define QBSPONYX_ERR2    0x013022 /* Comments to be included */
#define QBSPONYX_ERR3    0x013023 /* Comments to be included */
#define QBSPONYX_ERR4    0x013024 /* Comments to be included */
#define QBSPONYX_ERR5    0x013025 /* Comments to be included */

#define QBSPPPC_ERR1     0x013031 /* Comments to be included */

#define QBSPX86_ERR1     0x013041 /* no longer used */
#define QBSPX86_ERR2     0x013042 /* no longer used */
#define QBSPX86_ERR3     0x013043 /* no longer used */
#define QBSPX86_ERR4     0x013044 /* no longer used */
#define QBSPX86_ERR5     0x013045 /* no longer used */
#define QBSPX86_ERR6     0x013046 /* no longer used */
#define QBSPX86_ERR7     0x013047 /* no longer used */

/*******************************************************************************
* Download errors
*******************************************************************************/
#define QDWNLD_NO_ERROR     0        /* There is no error */
/*******************************************************************************
* qpoolapi.c qErrNo definitions (0x020000 to 0x020fff)
*******************************************************************************/
#define QPOOL_ERR1   0x020001 /* qPoolAlloc(), bad pool id passed */
#define QPOOL_ERR2   0x020002 /* qPoolAlloc(), buffer read from
                                 free queue has allocated flag set */
#define QPOOL_ERR3   0x020003 /* Not used any more */

#define QPOOL_ERR4   0x020004 /* qSysPoolAlloc(), bad pool id passed */
#define QPOOL_ERR5   0x020005 /* qSysPoolAlloc(), pool empty */
#define QPOOL_ERR6   0x020006 /* qSysPoolAlloc(), buffer read from
                                 free queue has allocated flag set */

#define QPOOL_ERR7   0x020007 /* qPoolFree(), pointer not in range */
#define QPOOL_ERR8   0x020008 /* qPoolFree(), buffer given doesn't
                                 have allocated flag set */
#define QPOOL_ERR9   0x020009 /* qPoolFree(), buffer given is out
                                 of address range for pool */
#define QPOOL_ERRA   0x02000a /* qPoolFree(), buffer given is not
                                 on a block boundry for this pool */
#define QPOOL_ERRB   0x02000b /* qPoolFree(), pool queue is full */

#define QPOOL_ERRC   0x02000c /* qSysPoolFree(), pointer not in range */
#define QPOOL_ERRD   0x02000d /* qSysPoolFree(), buffer given
                                 doesn't have allocated flag set */
#define QPOOL_ERRE   0x02000e /* qSysPoolFree(), buffer given is out
                                 of address range for pool */
#define QPOOL_ERRF   0x02000f /* qSysPoolFree(), pool queue is full */

#define QPOOL_ERR10  0x020010 /* qPoolFind(), bad region */
#define QPOOL_ERR11  0x020011 /* qPoolFind(), no pool with given
                                 size available for given region */
#define QPOOL_ERR12  0x020012 /* qLclPoolCreate(), the Block size is not multiple
                                 of the processor's word size.*/
#define QPOOL_ERR13  0x020013 /* qLclPoolSysInit(),illegal Memory region*/
#define QPOOL_ERR14  0x020014 /* qLclPoolSysInit(),The memory region specified for
                                 i960 processor is not in DRAM memoryin local pools */
#define QPOOL_ERR15  0x020015 /* qLclPoolSysInit(),The regions are not grouped together*/
#define QPOOL_ERR16  0x020016 /* qLclPoolSysInit(),The block sizes of a group of
                                 local pools in a region should be specified in
                                 ascending order */
#define QPOOL_ERR17  0x020017 /* qLclPoolValidateSysInit(), The memory asked
                                 for was more that the processor can provide */
#define QPOOL_ERR18  0x020018 /* Comments to be included */

/*
 * The following errors imply that qPoolAlloc has failed,
 * and that a particular pool is empty. The same codes are also
 * used when the magic number is corrupted.
 * The next 32 error codes have been blocked out to represent
 * the various pool id's in which the memory is exhausted
 * Presently we have QMAX_LCL_POOLS set to 20. These errors have
 * been added for future expansion. Errors from QPOOL_ERR21 to QPOOL_ERR3F
 * are not set anywhere in the kernel. They represent QPOOL_ERR20
 * with the pool_id.
 * [QPOOL_ERR20 to QPOOL_ERR3f are grouped]
 */
#define QPOOL_ERR20  0x020020 /* qPoolAlloc, Pool Id 0 exhausted */
#define QPOOL_ERR21  0x020021 /* qPoolAlloc, Pool Id 1 exhausted */
#define QPOOL_ERR22  0x020022 /* qPoolAlloc, Pool Id 2 exhausted */
#define QPOOL_ERR23  0x020023 /* qPoolAlloc, Pool Id 3 exhausted */
#define QPOOL_ERR24  0x020024 /* qPoolAlloc, Pool Id 4 exhausted */
#define QPOOL_ERR25  0x020025 /* qPoolAlloc, Pool Id 5 exhausted */
#define QPOOL_ERR26  0x020026 /* qPoolAlloc, Pool Id 6 exhausted */
#define QPOOL_ERR27  0x020027 /* qPoolAlloc, Pool Id 7 exhausted */
#define QPOOL_ERR28  0x020028 /* qPoolAlloc, Pool Id 8 exhausted */
#define QPOOL_ERR29  0x020029 /* qPoolAlloc, Pool Id 9 exhausted */
#define QPOOL_ERR2A  0x02002a /* qPoolAlloc, Pool Id 10 exhausted */
#define QPOOL_ERR2B  0x02002b /* qPoolAlloc, Pool Id 11 exhausted */
#define QPOOL_ERR2C  0x02002c /* qPoolAlloc, Pool Id 12 exhausted */
#define QPOOL_ERR2D  0x02002d /* qPoolAlloc, Pool Id 13 exhausted */
#define QPOOL_ERR2E  0x02002e /* qPoolAlloc, Pool Id 14 exhausted */
#define QPOOL_ERR2F  0x02002f /* qPoolAlloc, Pool Id 15 exhausted */
#define QPOOL_ERR30  0x020030 /* qPoolAlloc, Pool Id 16 exhausted */
#define QPOOL_ERR31  0x020031 /* qPoolAlloc, Pool Id 17 exhausted */
#define QPOOL_ERR32  0x020032 /* qPoolAlloc, Pool Id 18 exhausted */
#define QPOOL_ERR33  0x020033 /* qPoolAlloc, Pool Id 19 exhausted */
#define QPOOL_ERR34  0x020034 /* qPoolAlloc, Pool Id 20 exhausted */
#define QPOOL_ERR35  0x020035 /* qPoolAlloc, Pool Id 21 exhausted */
#define QPOOL_ERR36  0x020036 /* qPoolAlloc, Pool Id 22 exhausted */
#define QPOOL_ERR37  0x020037 /* qPoolAlloc, Pool Id 23 exhausted */
#define QPOOL_ERR38  0x020038 /* qPoolAlloc, Pool Id 24 exhausted */
#define QPOOL_ERR39  0x020039 /* qPoolAlloc, Pool Id 25 exhausted */
#define QPOOL_ERR3A  0x02003a /* qPoolAlloc, Pool Id 26 exhausted */
#define QPOOL_ERR3B  0x02003b /* qPoolAlloc, Pool Id 27 exhausted */
#define QPOOL_ERR3C  0x02003c /* qPoolAlloc, Pool Id 28 exhausted */
#define QPOOL_ERR3D  0x02003d /* qPoolAlloc, Pool Id 29 exhausted */
#define QPOOL_ERR3E  0x02003e /* qPoolAlloc, Pool Id 30 exhausted */
#define QPOOL_ERR3F  0x02003f /* qPoolAlloc, Pool Id 31 exhausted */

#define QPOOL_ERR40  0x020040 /* qPoolAlloc: no magic number */
#define QPOOL_ERR41  0x020041 /* qPoolAlloc: no magic number for linked pointer */
#define QPOOL_ERR42  0x020042 /* qPoolAlloc: wrong linked pointer */
#define QPOOL_ERR43  0x020043 /* qPoolSetPermanent: pointer not in range */
#define QPOOL_ERR44  0x020044 /* qPoolSetPermanent: invalid pointer */
#define QPOOL_ERR45  0x020045 /* qPoolUnSetPermanent: pointer not in range */
#define QPOOL_ERR46  0x020046 /* qPoolUnSetPermanent : invalid pointer */
#define QPOOL_ERR47  0x020047 /* qPoolFree: wrong pointer (permananent msg) */
#define QPOOL_ERR48  0x020048 /* qPoolFree: wrong pointer */
#define QPOOL_ERR49  0x020049 /* qSysPoolFree: wrong pointer (permananent msg) */
#define QPOOL_ERR4A  0x02004A /* qSysPoolFree: wrong pointer */
#define QPOOL_ERR4B  0x02004B /* qPoolResize: qMemAlloc failed */
#define QPOOL_ERR4C  0x02004C /* qPoolInit: qMemAlloc failed for pCtl */
#define QPOOL_ERR4D  0x02004D /* qPoolResize: occured in qPoolAlloc */
#define QPOOL_ERR4E  0x02004E /* qPoolResize: occured in qPoolAllocNoLock */
#define QPOOL_ERR4F  0x02004F /* qPoolAllocNoResize: no magic number */
#define QPOOL_ERR50  0x020050 /* qPoolAllocNoResize: no magic number for linked pointer */
#define QPOOL_ERR51  0x020051 /* qPoolAllocNoResize: wrong linked pointer */
#define QPOOL_ERR52  0x020052 /* qPoolAllocNoLock: no magic number */
#define QPOOL_ERR53  0x020053 /* qPoolAllocNoLock: no magic number for linked pointer */
#define QPOOL_ERR54  0x020054 /* qPoolAllocNoLock: wrong linked pointer */
/*
 * The following errors imply that qPoolResize warning,
 * and that a particular pool is empty.
 * The next 32 error codes have been blocked out to represent
 * the various pool id's in which pool was resizes
 * Presently we have QMAX_LCL_POOLS set to 20. These errors have
 * been added for future expansion. Errors from QPOOL_ERR61 to QPOOL_ERR7F
 * are not set anywhere in the kernel. They represent QPOOL_ERR60
 * with the pool_id.
 * [QPOOL_ERR60 to QPOOL_ERR7f are grouped]
 */

#define QPOOL_ERR60  0x020060 /* Resize Pool Id 0 */
#define QPOOL_ERR61  0x020061 /* Resize Pool Id 1 */
#define QPOOL_ERR62  0x020062 /* Resize Pool Id 2 */
#define QPOOL_ERR63  0x020063 /* Resize Pool Id 3 */
#define QPOOL_ERR64  0x020064 /* Resize Pool Id 4 */
#define QPOOL_ERR65  0x020065 /* Resize Pool Id 5 */
#define QPOOL_ERR66  0x020066 /* Resize Pool Id 6 */
#define QPOOL_ERR67  0x020067 /* Resize Pool Id 7 */
#define QPOOL_ERR68  0x020068 /* Resize Pool Id 8 */
#define QPOOL_ERR69  0x020069 /* Resize Pool Id 9 */
#define QPOOL_ERR6A  0x02006a /* Resize Pool Id 10 */
#define QPOOL_ERR6B  0x02006b /* Resize Pool Id 11 */
#define QPOOL_ERR6C  0x02006c /* Resize Pool Id 12 */
#define QPOOL_ERR6D  0x02006d /* Resize Pool Id 13 */
#define QPOOL_ERR6E  0x02006e /* Resize Pool Id 14 */
#define QPOOL_ERR6F  0x02006f /* Resize Pool Id 15 */
#define QPOOL_ERR70  0x020070 /* Resize Pool Id 16 */
#define QPOOL_ERR71  0x020071 /* Resize Pool Id 17 */
#define QPOOL_ERR72  0x020072 /* Resize Pool Id 18 */
#define QPOOL_ERR73  0x020073 /* Resize Pool Id 19 */
#define QPOOL_ERR74  0x020074 /* Resize Pool Id 20 */
#define QPOOL_ERR75  0x020075 /* Resize Pool Id 21 */
#define QPOOL_ERR76  0x020076 /* Resize Pool Id 22 */
#define QPOOL_ERR77  0x020077 /* Resize Pool Id 23 */
#define QPOOL_ERR78  0x020078 /* Resize Pool Id 24 */
#define QPOOL_ERR79  0x020079 /* Resize Pool Id 25 */
#define QPOOL_ERR7A  0x02007a /* Resize Pool Id 26 */
#define QPOOL_ERR7B  0x02007b /* Resize Pool Id 27 */
#define QPOOL_ERR7C  0x02007c /* Resize Pool Id 28 */
#define QPOOL_ERR7D  0x02007d /* Resize Pool Id 29 */
#define QPOOL_ERR7E  0x02007e /* Resize Pool Id 30 */
#define QPOOL_ERR7F  0x02007f /* Resize Pool Id 31 */

/*
 * The following errors imply that qPoolFind has failed.
 * The next 10 error codes have been blocked out to represent the various region id's in
 * which the memory is exhausted or doesn't exist (region was not specified).
 * Error code is generated by adding base value QREGN_ERR80 and region ID.
 * Look for QREGN_ERR80 to find place in the code.
 * [QPOOL_ERR80 to QPOOL_ERR89 are grouped]
 */

#define QPOOL_ERR80  0x020080 /* qPoolFind(), no pool with given size available for region 0 */
#define QPOOL_ERR81  0x020081 /* qPoolFind(), no pool with given size available for region 1 */
#define QPOOL_ERR82  0x020082 /* qPoolFind(), no pool with given size available for region 2 */
#define QPOOL_ERR83  0x020083 /* qPoolFind(), no pool with given size available for region 3 */
#define QPOOL_ERR84  0x020084 /* qPoolFind(), no pool with given size available for region 4 */
#define QPOOL_ERR85  0x020085 /* qPoolFind(), no pool with given size available for region 5 */
#define QPOOL_ERR86  0x020086 /* qPoolFind(), no pool with given size available for region 6 */
#define QPOOL_ERR87  0x020087 /* qPoolFind(), no pool with given size available for region 7 */
#define QPOOL_ERR88  0x020088 /* qPoolFind(), no pool with given size available for region 8 */
#define QPOOL_ERR89  0x020089 /* qPoolFind(), no pool with given size available for region 9 */


/*******************************************************************************
* qmemapi.c qErrNo definitions (0x021000-0x021fff)
*******************************************************************************/
#define QMEM_ERR1    0x021001 /* qMemAlloc(), bad value in align parameter */
#define QMEM_ERR2    0x021002 /* qMemAlloc(), heap exausted (no more memory) */
#define QMEM_ERR3    0x021003 /* qMemValloc(), bad value in align parameter */
#define QMEM_ERR4    0x021004 /* qMemValloc(), heap exausted (no more memory) */
#define QMEM_ERR5    0x021005 /* qMemCalloc(), bad value in align parameter */
#define QMEM_ERR6    0x021006 /* qMemCalloc(), heap exausted (no more memory) */
#define QMEM_ERR7    0x021007 /* qMemFree(), bad address for pointer */
#define QMEM_ERR8    0x021008 /* qMemCreateSpSramPart(), Unable to create SP SRAM
                                 memory partition for the XFER area allocations */

/*for_hdlc_start*/
#define QMEM_ERR9    0x021009 /* qMemCreateSpMemPart(), Unable to create SP

        HDLC1 SRAM memory partition for the XFER area

        allocations */
#define QMEM_ERR10    0x02100a /* qMemCreateSpMemPart(), Unable to create SP

        HDLC2 SRAM memory partition for the XFER area

        allocations */
/*for_hdlc_end*/
#define QMEM_ERR11    0x02100b /* Comments to be included */
#define QMEM_ERR12    0x02100c /* Comments to be included */
#define QMEM_ERR13    0x02100d /* Comments to be included */
#define QMEM_ERR14    0x02100e /* Comments to be included */
#define QMEM_ERR15    0x02100f /* Comments to be included */
#define QMEM_ERR16    0x021010 /* Comments to be included */
#define QMEM_ERR17    0x021011 /* Comments to be included */
#define QMEM_ERR18    0x021012 /* Comments to be included */
#define QMEM_ERR19    0x021013 /* Comments to be included */
#define QMEM_ERR1A    0x021014 /* Comments to be included */
#define QMEM_ERR1B    0x021015 /* Comments to be included */

#define QMEM_BADREGION  0x021020 /* qMemAlloc(), qMemValloc(), qMemCalloc(),
											 bad value in region parameter */
#define QMEM_NOMEMORY   0x021021 /* qMemAlloc(), qMemValloc(), qMemCalloc(),
                                  no memory available */
#define QMEM_TEARDOWN_NOMEMORY 0x021022   /* Teardown's resource tracking
                                  library was unable to allocate memory. */
#define QMEM_ERR1C   0x021023 /* qMsgQCreate failed because no memory for MsgQObject */
#define QMEM_ERR1D   0x021024 /* qMsgQCreate failed because no memory for the Data queue */
#define QMEM_ERR1E   0x021025 /* qMsgQCreate failed because could not
				 allocate msgAvailableSemaphore */
#define QMEM_ERR1F   0x021026 /* qMsgQCreate failed because could not
				 allocate msgRemovedSemaphore */
/* for the delayed message transaction handler - out of memory errors */
#define QMEM_ERR20      0x021027 /*qMsgDelayedTransactionFindPoolId: Function called multiple
				times */
#define QMEM_ERR21      0x021028 /*qMsgDelayedTransactionFindPoolId: Cannot find pool big
				enough to store the transaction list */


/*******************************************************************************
* qgmheap.c qErrNo definitions (0x022000-0x022fff)
*******************************************************************************/
#define QGMHEAP_ERR1 0x022001 /* qGmAlloc(), not enough global memory for
                                 allocation */
#define QGMHEAP_ERR2 0x022002 /* qGmAlloc(), size 0 passed for allocation */


/*****************************************************************************
* qnodeapi.c qErrNo definitions (0x023000-0x023fff)
******************************************************************************/
#define QNERR_EXTPOOL_1    0x023000    /* qnodeapi.c: external pool alread
y exists */
#define QNERR_BAD_POOL_HANDLE_1 0x023001    /* qnodeapi.c: Illegal pool handle
= NULL   */
#define QNERR_ALREADY_FREE_1    0x023002    /* qnodeapi.c: Child buffer already
 free */
#define QNERR_ALREADY_FREE_2     0x023003    /* qnodeapi.c: Parent buffer alread
y free */
#define QNERR_POOL_NOT_FOUND_1   0x023004    /* qnodesys.c: pool not found  */
#define QNERR_POOL_EXHAUSTED_1   0x023005    /* qnodeapi.c: Pool empty */
#define QNERR_POOL_EXHAUSTED_2   0x023006    /* qnodesys.c: No child node for sp
lit  */
#define QNERR_POOL_EXHAUSTED_3   0x023007    /* qnodesys.c: No child node for li
nk external  */
#define QNERR_POOL_EXHAUSTED_4   0x023008    /* qnodesys.c: child pool empty  */
#define QNERR_NO_CHILD_POOL_1    0x023009    /* qnodesys.c: No children pool def
ined  */
#define QNERR_MEM_EXHAUSTED_1    0x02300A    /* qnodesys.c: insufficient memory
to create pool header  */
#define QNERR_MEM_EXHAUSTED_3    0x02300B    /* qnodesys.c: insufficient memory
for %d BDs  */
#define QNERR_MEM_EXHAUSTED_4    0x02300C    /* qnodesys.c: insufficient memory
for %d blocks  */
#define QNERR_MEM_EXHAUSTED_5    0x02300D    /* qnodesys.c: insufficient memory
for memBlock (%d)  */
#define QNERR_BUF_FREE_1         0x02300E    /* qnodesys.c: error free buf */



/*******************************************************************************
* clustmgt qErrNo definitions (0x028000-0x02ffff)
*******************************************************************************/
#define QCLUST_ErrNone              QSTATUS_DONE   /* No error */
#define QCLUST_ErrDesc              0x028001 /* Bad comp/cluster descriptor */
#define QCLUST_ErrPortId            0x028002 /* Bad Port Id */
#define QCLUST_ErrDesc1             0x028003 /* Bad descriptor #1 */
#define QCLUST_ErrPortId1           0x028004 /* Bad Port Id #1 */
#define QCLUST_ErrDesc2             0x028005 /* Bad descriptor #2 */
#define QCLUST_ErrPortId2           0x028006 /* Bad Port Id #2 */
#define QCLUST_ErrPortNotFound      0x028007 /* No matching port found */
#define QCLUST_ErrClusterNotFound   0x028008 /* Cluster does not exist or
                                                cannot be found */
#define QCLUST_ErrRemote            0x028009 /* Descriptor corresponds to a
                                                remote address, i.e. off-board
                                                or off-node address */
#define QCLUST_ErrNotBound          0x02800a /* Port not bound to any instance*/

#if 0
#define QCLUST_ErrNoSlots           0x02800b /* -Not used- No timeslots assign to port */
#endif

#define QCLUST_ErrAssigned          0x02800c /* Timeslots already assigned
                                                to port */
#define QCLUST_ErrNotAssigned       0x02800d /* Timeslots not assigned to port*/
#define QCLUST_ErrNoConnection      0x02800e /* No connection setup between
                                                two ports */
#define QCLUST_ErrNoPath            0x02800f /* No connection path available
                                                between two ports */
#define QCLUST_ErrActive            0x028010 /* Cannot perform operation;
                                                destination port is active for
                                                another connection */
#define QCLUST_ErrNotActive         0x028011 /* Attempting to deactivate an
                                                already Idle port */
#define QCLUST_ErrNotSuspended      0x028012 /* Attempting to resume an
                                                un-suspended connection */
#define QCLUST_ErrReject            0x028013 /* Cannot suspend connection;
                                                request reject by current
                                                talker */
#define QCLUST_ErrUnknownMsg        0x028014 /* Cluster manager received
                                                an unknown message */
#define QCLUST_ErrAsync             0x028015 /* With the passed in parameters
                                                this should be an asynchronous
                                                call */

#if 0
#define QCLUST_ErrUnknown           0x028016 /* -Not used- Unknown error - location 0*/
#endif

#define QCLUST_ErrNotSupported      0x028017 /* Feature not supported yet */
#define QCLUST_ErrNoMem             0x028018 /* Out of memory */
#define QCLUST_ErrAttrPortType      0x028019 /* Invalid port type
                                                specified by attribute */
#define QCLUST_ErrAttrPortDir       0x02801a /* Invalid port direction
                                                specified by attribute */
#define QCLUST_ErrAttrPortCount     0x02801b /* Invalid port count
                                                specified by attribute */
#define QCLUST_ErrExpired           0x02801c /* Invalid request id -
                                                internal error */
#define QCLUST_ErrNullArgument      0x02801d /* Null argument specified with
                                                QIO_IMMEDIATE mode */
#define QCLUST_ErrCompNotFound      0x02801e /* Component not found */
#define QCLUST_ErrAttribute         0x02801f /* Error in an attribute */
#define QCLUST_ErrAttrListSize      0x028020 /* Attribute list exceeds limit */
#define QCLUST_ErrSlotId            0x028021 /* Invalid Timeslot Id */
#define QCLUST_ErrSlotWidth         0x028022 /* Invalid slotset width */
#define QCLUST_ErrSlotGroup         0x028023 /* Timeslots in wrong slot group */
#define QCLUST_ErrFatal             0x028024 /* Fatal internal error occurred */
#define QCLUST_ErrInstNotAllocated  0x028025 /* Instance not allocated to the
                                                cluster */
#define QCLUST_ErrClusterNotAllocated  0x028026 /* Cluster not allocated */
#define QCLUST_ErrAttrNotPresent    0x028028 /* qClusterAttrRemove: One or more
                                                attributes not present in the
                                                cluster attribute list */
#define QCLUST_ErrExhausted         0x028029 /* cluster cannot be allocated */
#define QCLUST_ErrAttrListFull      0x02802a /* No more attributes can be added
                                                to the cluster */
#define QCLUST_ErrNotAnAllocator    0x02802b /* qClusterFree: Only an allocator can free its cluster */

#define QCLUST_ErrNotAnOwner        0x02802c /* qClusterDestroy: Only an owner (creator) can destroy its cluster */

#define QCLUST_ErrDestroyPending    0x02802d /* qClusterDestroy: Cannot destroy already pending to be destroyed */

#define QCLUST_ErrCannotCmpltSync   0x02802e /* Cannot complete the call synchronously */

#define QCLUST_ErrFreePending       0x02802f /* qClusterFree: Cannot free already pending to be deallocated */

#define QCLUST_ErrMax               0x028030 /* Marker to end errors */
#define QCLUST_ErrSyncCallOnSp      0x028031 /* Sync calls not permitted on SP */
#define QCLUST_ErrWrongStdComponent 0x028032 /* qClusterInit: componet number returned by qCompRegister doesn't agree with Standard component declaration*/
#define QCLUST_ErrUnlinkHostfailed  0x028033 /* qXnAllocateUnlink, cannot remove the instance from the
                                                Host list as the replyDesc is not the allocator*/
#define QCLUST_ERR34                0x028034 /* Comments to be included */
#define QCLUST_ERR35                0x028035 /* Comments to be included */
#define QCLUST_ERR36                0x028036 /* Comments to be included */
#define QCLUST_ERR37                0x028037 /* Comments to be included */
#define QCLUST_ERR38                0x028038 /* Comments to be included */
#define QCLUST_ERR39                0x028039 /* Comments to be included */
#define QCLUST_ERR3A                0x02803a /* Comments to be included */
#define QCLUST_ERR3B                0x02803b /* Comments to be included */
#define QCLUST_ERR3C                0x02803c /* qTsCreatePaths: edge table overlow */
#define QCLUST_ERR3D                0x02803d /* Comments to be included */
#define QCLUST_ERR3E                0x02803e /* Comments to be included */
#define QCLUST_ERR3F                0x02803f /* Comments to be included */
#define QCLUST_ERR40                0x028040 /* Comments to be included */
#define QCLUST_ERR41                0x028041 /* Comments to be included */
#define QCLUST_ERR42                0x028042 /* Comments to be included */
#define QCLUST_ERR43                0x028043 /* Comments to be included */
#define QCLUST_ERR44                0x028044 /* Comments to be included */
#define QCLUST_ERR45                0x028045 /* Comments to be included */
#define QCLUST_ERR46                0x028046 /* Comments to be included */
#define QCLUST_ERR47                0x028047 /* Comments to be included */
#define QCLUST_ERR48                0x028048 /* Comments to be included */
#define QCLUST_ERR49                0x028049 /* Comments to be included */
#define QCLUST_ERR4A                0x02804a /* Comments to be included */
#define QCLUST_ERR4B                0x02804b /* Comments to be included */
#define QCLUST_ERR4C                0x02804c /* Comments to be included */
#define QCLUST_ERR4D                0x02804d /* Comments to be included */
#define QCLUST_ERR4E                0x02804e /* Comments to be included */
#define QCLUST_ERR4F                0x02804f /* Comments to be included */
#define QCLUST_ERR50                0x028050 /* Comments to be included */
#define QCLUST_ERR51                0x028051 /* Comments to be included */
#define QCLUST_ERR52                0x028052 /* Comments to be included */
#define QCLUST_ERR53                0x028053 /* Comments to be included */
#define QCLUST_ERR54                0x028054 /* Comments to be included */
#define QCLUST_ERR55                0x028055 /* Comments to be included */
#define QCLUST_ERR56                0x028056 /* Comments to be included */
#define QCLUST_ERR57                0x028057 /* Comments to be included */
#define QCLUST_ERR58                0x028058 /* Comments to be included */
#define QCLUST_ERR59                0x028059 /* Comments to be included */
#define QCLUST_ERR5A                0x02805a /* Comments to be included */
#define QCLUST_ERR5B                0x02805b /* Comments to be included */
#define QCLUST_ERR5C                0x02805c /* Comments to be included */
#define QCLUST_ERR5D                0x02805d /* Comments to be included */
#define QCLUST_ERR5E                0x02805e /* Comments to be included */
#define QCLUST_ERR5F                0x02805f /* Comments to be included */
#define QCLUST_ERR60                0x028060 /* Comments to be included */
#define QCLUST_ERR61                0x028061 /* Comments to be included */
#define QCLUST_ERR62                0x028062 /* Comments to be included */
#define QCLUST_ERR63                0x028063 /* Comments to be included */
#define QCLUST_ERR64                0x028064 /* Comments to be included */
#define QCLUST_ERR65                0x028065 /* Comments to be included */
#define QCLUST_ERR66                0x028066 /* Comments to be included */
#define QCLUST_ERR67                0x028067 /* Comments to be included */
#define QCLUST_ERR68                0x028068 /* Comments to be included */
#define QCLUST_ERR69                0x028069 /* Comments to be included */
#define QCLUST_ERR6A                0x02806a /* Comments to be included */
#define QCLUST_ERR6B                0x02806b /* Comments to be included */
#define QCLUST_ERR6C                0x02806c /* Comments to be included */
#define QCLUST_ERR6D                0x02806d /* Comments to be included */
#define QCLUST_ERR6E                0x02806e /* Comments to be included */
#define QCLUST_ERR6F                0x02806f /* Comments to be included */
#define QCLUST_ERR70                0x028070 /* Comments to be included */
#define QCLUST_ERR71                0x028071 /* Comments to be included */
#define QCLUST_ERR72                0x028072 /* Comments to be included */
#define QCLUST_ERR73                0x028073 /* Comments to be included */
#define QCLUST_ERR74                0x028074 /* Comments to be included */
#define QCLUST_ERR75                0x028075 /* Comments to be included */
#define QCLUST_ERR76                0x028076 /* Comments to be included */
#define QCLUST_ERR77                0x028077 /* Comments to be included */
#define QCLUST_ERR78                0x028078 /* Comments to be included */
#define QCLUST_ERR79                0x028079 /* Comments to be included */
#define QCLUST_ERR7A                0x02807a /* Comments to be included */
#define QCLUST_ERR7B                0x02807b /* Comments to be included */
#define QCLUST_ERR7C                0x02807c /* Comments to be included */
#define QCLUST_ERR7D                0x02807d /* Comments to be included */
#define QCLUST_ERR7E                0x02807e /* Comments to be included */
#define QCLUST_ERR7F                0x02807f /* Comments to be included */
#define QCLUST_ERR80                0x028080 /* Comments to be included */
#define QCLUST_ERR81                0x028081 /* Comments to be included */
#define QCLUST_ERR82                0x028082 /* Comments to be included */
#define QCLUST_ERR83                0x028083 /* Comments to be included */
#define QCLUST_ERR84                0x028084 /* Comments to be included */
#define QCLUST_ERR85                0x028085 /* Comments to be included */
#define QCLUST_ERR86                0x028086 /* Comments to be included */
#define QCLUST_ERR87                0x028087 /* Comments to be included */
#define QCLUST_ERR88                0x028088 /* Comments to be included */
#define QCLUST_ERR89                0x028089 /* Comments to be included */
#define QCLUST_ERR8A                0x02808a /* Comments to be included */
#define QCLUST_ERR8B                0x02808b /* Comments to be included */
#define QCLUST_ERR8C                0x02808c /* Comments to be included */
#define QCLUST_ERR8D                0x02808d /* Comments to be included */
#define QCLUST_ERR8E                0x02808e /* Comments to be included */
#define QCLUST_ERR8F                0x02808f /* Comments to be included */
#define QCLUST_ERR90                0x028090 /* Comments to be included */
#define QCLUST_ERR91                0x028091 /* Comments to be included */
#define QCLUST_ERR92                0x028092 /* Comments to be included */
#define QCLUST_ERR93                0x028093 /* Comments to be included */
#define QCLUST_ERR94                0x028094 /* Comments to be included */
#define QCLUST_ERR95                0x028095 /* no longer used */
#define QCLUST_ERR96                0x028096 /* Comments to be included */
#define QCLUST_ERR97                0x028097 /* no longer used */
#define QCLUST_ERR98                0x028098 /* Comments to be included */
#define QCLUST_ERR99                0x028099 /* Comments to be included */
#define QCLUST_ERR9A                0x02809a /* Comments to be included */
#define QCLUST_ERR9B                0x02809b /* Comments to be included */
#define QCLUST_ERR9C                0x02809c /* no longer used */
#define QCLUST_ERR9D                0x02809d /* Comments to be included */
#define QCLUST_ERR9E                0x02809e /* Comments to be included */
#define QCLUST_ERR9F                0x02809f /* Comments to be included */
#define QCLUST_ERRA0                0x0280a0 /* Comments to be included */
#define QCLUST_ERRA1                0x0280a1 /* Comments to be included */
#define QCLUST_ERRA2                0x0280a2 /* Comments to be included */
#define QCLUST_ERRA3                0x0280a3 /* Comments to be included */
#define QCLUST_ERRA4                0x0280a4 /* Comments to be included */
#define QCLUST_ERRA5                0x0280a5 /* Comments to be included */
#define QCLUST_ERRA6                0x0280a6 /* Comments to be included */
#define QCLUST_ERRA7                0x0280a7 /* Comments to be included */
#define QCLUST_ERRA8                0x0280a8 /* Comments to be included */
#define QCLUST_ERRA9                0x0280a9 /* Comments to be included */
#define QCLUST_ERRAA                0x0280aa /* Comments to be included */
#define QCLUST_ERRAB                0x0280ab /* Comments to be included */
#define QCLUST_ERRAC                0x0280ac /* Comments to be included */
#define QCLUST_ERRAD                0x0280ad /* Comments to be included */
#define QCLUST_ERRAE                0x0280ae /* Comments to be included */
#define QCLUST_ERRAF                0x0280af /* Comments to be included */
#define QCLUST_ERRB0                0x0280b0 /* Comments to be included */
#define QCLUST_ERRB1                0x0280b1 /* Comments to be included */
#define QCLUST_ERRB2                0x0280b2 /* Comments to be included */
#define QCLUST_ERRB3                0x0280b3 /* Comments to be included */
#define QCLUST_ERRB4                0x0280b4 /* Comments to be included */
#define QCLUST_ERRB5                0x0280b5 /* Comments to be included */
#define QCLUST_ERRB6                0x0280b6 /* Comments to be included */
#define QCLUST_ERRB7                0x0280b7 /* Comments to be included */
#define QCLUST_ERRB8                0x0280b8 /* Comments to be included */
#define QCLUST_ErrSiInvalidState    0x0280b9 /* Invalid state of the Si port */
#define QCLUST_ErrSiNoData          0x0280ba /* SiData structure does not exist */
#define QCLUST_ErrInvalidTalkerMode 0x0280bc /* Invalid talker mode at activation */
#define QCLUST_ErrInvalidDevice     0x0280bd /* Invalid TDM device */

#define QCLUST_ErrSlPlInvArg        0x0280be /* slotPool: invalid argument          */
#define QCLUST_ErrSlPlInvStrType    0x0280bf /* slotPool: invalid stream type       */
#define QCLUST_ErrSlPlSlotNotAvail  0x0280c0 /* slotPool: no more slots available   */
#define QCLUST_ErrSlPlSlotIsAlloc   0x0280c1 /* slotPool: slot is already allocated */
#define QCLUST_ErrSlPlSlotIsFree    0x0280c2 /* slotPool: slot is already free      */
#define QCLUST_ERRC3                0x0280c3 /* Comments to be included */
#define QCLUST_ERRC4                0x0280c4 /* Comments to be included */
#define QCLUST_ERRC5                0x0280c5 /* Comments to be included */
#define QCLUST_ERRC6                0x0280c6 /* Comments to be included */
#define QCLUST_ERRC7                0x0280c7 /* Comments to be included */
#define QCLUST_ERRC8                0x0280c8 /* Comments to be included */
#define QCLUST_ERRC9                0x0280c9 /* Comments to be included */

#define QCLUST_ErrPortConnected     0x0280ca /* Cannot perform operation;
                                                destination port is connected
                                                to other ports */
#define QCLUST_ErrPortExists        0x0280cb /* Cannot perform operation;
                                                destination port already
                                                exists */
#define QCLUST_ErrConnectEnabled    0x0280cc /* Cannot perform operation;
                                                cluster has auto connect mode
                                                enabled */

#define QCLUST_ERRCD                0x0280CD /* echoDelay: invalid input port
                                                ids */
#define QCLUST_ERRCE                0x0280CE /* echoDelay: component is not in
                                                the cluster */
#define QCLUST_ERRCF                0x0280CF /* echoDelay: port is not bound to
                                                the component */
#define QCLUST_ERRD0                0x0280D0 /* echoDelay: port is not connected */
#define QCLUST_ERRD1                0x0280D1 /* echoDelay: port is not active */
#define QCLUST_ERRD2                0x0280D2 /* echoDelay: port is not supported */
#define QCLUST_ERRD3                0x0280D3 /* echoDelay: port is not supported */
#define QCLUST_ERRD4                0x0280D4 /* echoDelay: port is not supported */
#define QCLUST_ERRD5                0x0280D5 /* txRefEchoDelay: WINOS not supported */
#define QCLUST_ErrUnknown_01        0x0280D6 /* Unknown error - location  1 */
#define QCLUST_ErrUnknown_02        0x0280D7 /* Unknown error - location  2 */
#define QCLUST_ErrUnknown_03        0x0280D8 /* Unknown error - location  3 */
#define QCLUST_ErrUnknown_04        0x0280D9 /* Unknown error - location  4 */
#define QCLUST_ErrUnknown_05        0x0280DA /* Unknown error - location  5 */
#define QCLUST_ErrUnknown_06        0x0280DB /* Unknown error - location  6 */
#define QCLUST_ErrUnknown_07        0x0280DC /* Unknown error - location  7 */
#define QCLUST_ErrUnknown_08        0x0280DE /* Unknown error - location  8 */
#define QCLUST_ErrUnknown_09        0x0280DF /* Unknown error - location  9 */
#define QCLUST_ErrUnknown_10        0x0280E0 /* Unknown error - location 10 */
#define QCLUST_ErrUnknown_11        0x0280E1 /* Unknown error - location 11 */
#define QCLUST_ErrUnknown_12        0x0280E2 /* Unknown error - location 12 */
#define QCLUST_ERRE3                0x0280E3 /* qClusterPortCurrentTalker: Invalid portID */
#define QCLUST_ERRE4                0x0280E4 /* qClusterPortCurrentTalker: Port not
															   bound to Component */
#define QCLUST_ERRE5                0x0280e5 /* qClusterPortCurrentTalker: Talker port
															   not active */
#define QCLUST_ERRE6                0x0280e6 /* qClusterPortConnectList: Invalid portId */
#define QCLUST_ERRE7                0x0280e7 /* qClusterPortConnectList: Port not
															   bound to Component */
#define QCLUST_ErrNoPathRoRi_01     0x0280e8 /* qPortUnMuteRoRi: Could not find any path */
#define QCLUST_ErrNoPathRoRi_02     0x0280e9 /* qPortUnMuteRoRi: Could not find any path */
#define QCLUST_ErrSlotAllocRoRi_01  0x0280ea /* qPortUnMuteRoRi: Error allocating timeslot */
#define QCLUST_ErrSc2Net_Exists     0x0280eb /* sc2netdb:(Insert) entry already exists   */
#define QCLUST_ErrSc2Net_DbFull     0x0280ec /* sc2netdb:(Insert) database is full       */
#define QCLUST_ErrSc2Net_NotFound1  0x0280ed /* sc2netdb:(Remove) entry not found        */
#define QCLUST_ErrSc2Net_Shared     0x0280ee /* sc2netdb:(Remove) entry is beeing shared */
#define QCLUST_ErrSc2Net_NotFound2  0x0280ef /* sc2netdb:(Share)  entry not found        */
#define QCLUST_ErrSc2Net_MaxShare   0x0280f0 /* sc2netdb:(Share)  max share count is reched */
#define QCLUST_ErrSc2Net_NotFound3  0x0280f1 /* sc2netdb:(UnShare)entry not found        */
#define QCLUST_ErrSc2Net_NotShared  0x0280f2 /* sc2netdb:(UnShare)entry is not shared    */

#define QCLUST_ErrPUM_MallocFail1   0x0280f3 /* portUnMute: fail to allocate slotSet     */

#define QCLUST_ErrNoSlots1          0x0280f4 /* Error unassigning a slot, port has
                                                no slots assigned */
#define QCLUST_ErrNoSlots2          0x0280f5 /* qClusterSlotInfo: port has
                                                no slots assigned */
#define QCLUST_ErrNoSlots3          0x0280f6 /* Can not make physical connection, both producer
                                                and consumer have no timeslots assigned */
#define QCLUST_ErrNoSlots4          0x0280f7 /* Can not make physical connection, both producer
                                                and consumer have no timeslots assigned*/
#define QCLUST_ErrNoSlots5          0x0280f8 /* Error freeing timeslots from the port,
                                                port has no timeslots assigned*/
#define QCLUST_ErrNoSlots6          0x0280f9 /* Error autoassigning the timeslots to a port,
                                                producer and consumer have the same direction */
#define QCLUST_ErrNoSlots7          0x0280fa /* Error activating of the So port,
                                                the port has no timeslots assigned*/
#define QCLUST_ErrGeoInvalidGeoId   0x0280fb /* qClusterAttrAdd: Invalid GeoId attribute. */
#define QCLUST_ErrGeoInvalidCTConnectMaskLow   0x0280fc /* qClusterAttrAdd: Invalid ctConnectMaskLow attribute. */
#define QCLUST_ErrGeoInvalidCTConnectMaskHigh  0x0280fd /* qClusterAttrAdd: Invalid ctConnectMaskHigh attribute. */
#define QCLUST_ErrGeoInvalidProcessorMask      0x0280fe /* qClusterAttrAdd: Invalid ctConnectMaskHigh attribute. */

#define QCLUST_ErrNoPath_00         0x0280FF /* No connection path available between two ports - location 00 */
#define QCLUST_ErrNoPath_01         0x028100 /* No connection path available between two ports - location 01 */
#define QCLUST_ErrNoPath_02         0x028101 /* No connection path available between two ports - location 02 */
#define QCLUST_ErrNoPath_03         0x028102 /* No connection path available between two ports - location 03 */
#define QCLUST_ErrNoPath_04         0x028103 /* No connection path available between two ports - location 04 */
#define QCLUST_ErrNoPath_05         0x028104 /* No connection path available between two ports - location 05 */
#define QCLUST_ErrNoPath_08         0x028105 /* No connection path available between two ports - location 08 */
#define QCLUST_ErrNoPath_09         0x028106 /* No connection path available between two ports - location 09 */

#define QCLUST_ErrNotSuspended_00   0x028107 /* Attempting to resume an un-suspended connection - location 00 */
#define QCLUST_ErrGeoNoDefault      0x028108 /* The default Geo value is not defined
                                                for this hardware platform. */
#define QCLUST_ErrNotAllSuspended   0x028109 /* qPortActivate: Not all of the suspended
                                                consumer's lastTalker's connectList is
                                                suspended*/
#define QCLUST_ErrNoNetwork_00      0x02810A /* QTS_Ntwrk_localTS: No network devices on Mercury board*/
#define QCLUST_ErrNoNetwork_01      0x02810B /* QGetDeviceIdAndTslot: No network devices Mercury board*/
#define QCLUST_ErrNoNetwork_02      0x02810C /* QGetStreamAndTslot: No network devices Mercury board*/
#define QCLUST_ErrInvalidRefStream  0x02810d /* Requested reference stream for
                                                reference stream.  Can't do
                                                that. */
#define QCLUST_ErrNotAssigned_01    0x02810e /* qClusterSetBaseGain: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_02    0x02810f /* qClusterGetBaseGain: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_03    0x028110 /* qClusterSetMinGain: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_04    0x028111 /* qClusterGetMinGain: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_05    0x028112 /* qClusterSetMaxGain: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_06    0x028113 /* qClusterGetMaxGain: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_07    0x028114 /* qClusterSetGain: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_08    0x028115 /* qClusterGetGain: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_09    0x028116 /* qClusterSetMode: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_10    0x028117 /* qClusterGetMode: Timeslots not assigned to port*/
#define QCLUST_ErrNotAssigned_11    0x028118 /* qClusterModifyGain: Timeslots not assigned to port*/

#define QCLUST_ErrNoNetwork_03      0x028119 /* QTS_Ntwrk_localTS_DTI: No network devices on DTI16 board*/
#define QCLUST_ErrNoNetwork_04      0x02811a /* QTS_Ntwrk_localTS_Whitney: No network devices on Whitney board*/
#define QCLUST_ErrNoNetwork_05      0x02811b /* qClusterSlotGetTxRef_Whitney: This function is not implemented on Whitney.*/
#define QCLUST_ErrNoNetwork_06      0x02811c /* QTS_Ntwrk_LocalTS__Whitney: Invalid Stream Instance passed to this function */
#define QCLUST_ErrNoNetwork_07      0x02811d /* QGetSlotId__Whitney: Invalid Stream Instance passed to this function */
#define QCLUST_ErrNoNetwork_08      0x02811e /* QGetSlotId__Gannet: Invalid Stream Instance passed to this function */
#define QCLUST_ErrNoNetwork_09      0x02811f /* qClusterSlotGetTxRef_DTI: No network devices on DTI16 board*/

#define QCLUST_ErrInvalidDevType    0x028120 /* qClusterNetStreamTypeUpdate: Invalid device type*/
#define QCLUST_ErrStrNotFound       0x028121 /* qTSreamInstMod: Stream in QStreamTab[] not found*/
#define QCLUST_ErrInvalidDevType_01 0x028122 /* QGetDeviceIdAndTslot_DTI: Invalid device type*/

#define QCLUST_ErrStrNotFound02     0x028123 /* qTStreamInstTabUpdateInstFree:
                                                Stream not found */
#define QCLUST_ErrStrTooSmall       0x028124 /* qTStreamInstTabUpdateInstFree:
                                                Free count is less then zero */
#define QCLUST_ErrStrTooLarge       0x028125 /* qTStreamInstTabUpdateInstFree:
                                                Free count is greater then stream size */
#define QCLUST_ErrInvStreamId1      0x028126 /* qMap_NetStream_CtEchoStream_CTSwitch:
                                                Invalid stream id. */
#define QCLUST_ErrTxRefNetTsNotCon  0x028127 /* qTxRefGetEchoTimeslot_CTSwitch:
                                                TxRef for network timeslot is not connected */
#define QCLUST_ErrTxRefNetTsInv1    0x028128 /* qTxRefGetEchoTimeslot_CTSwitch:
                                                Network timeslot number is invalid */
#define QCLUST_ErrTxRefNetTsInv2    0x028129 /* qTxRefConnectNetToEchoTimeslot_CTSwitch:
                                                Network timeslot number is invalid */
#define QCLUST_ErrTxRefHwNotSup1    0x02812a /* qTxRefConnectNetToEchoTimeslot_CTSwitch:
                                                Tx ref is not supported on this hardware */
#define QCLUST_ErrTxRefStream1      0x02812b /* qTxRefConnectNetToEchoTimeslot_CTSwitch:
                                                Error updating stream SC OUT */
#define QCLUST_ErrTxRefPool1        0x02812c /* qTxRefConnectNetToEchoTimeslot_CTSwitch:
                                                Error assigning a timeslot to SC OUT pool */
#define QCLUST_ErrTxRefStream2      0x02812d /* qTxRefConnectNetToEchoTimeslot_CTSwitch:
                                                Error updating stream MMA IN */
#define QCLUST_ErrTxRefPool2        0x02812e /* qTxRefConnectNetToEchoTimeslot_CTSwitch:
                                                Error assigning a timeslot to MMA IN pool */

#define QCLUST_ErrNoPath_10         0x02812f /* qTSFindPathUsingGeo: No connection path available between two ports - location 10 */
#define QCLUST_ErrNoPath_11         0x028130 /* qTSFindPathUsingGeo: No connection path available between two ports - location 11 */
#define QCLUST_ErrNoPath_12         0x028131 /* qTSFindPathUsingGeo: No connection path available between two ports - location 12 */
#define QCLUST_ErrNoPath_13         0x028132 /* qTSFindPathUsingGeo: No port transmitting direction specified in a path. - location 13 */
#define QCLUST_ErrNoPath_14         0x028133 /* qTSFindPathUsingGeo: Unexpected port direction specified by user.*/
#define QCLUST_ErrNoPath_15         0x028134 /* qTSFindPathUsingGeo: Unexpected port direction specified by user..*/
#define QCLUST_ErrNoPath_16         0x028135 /* qTSFindPathUsingGeo: Un known stream type.*/
#define QCLUST_ErrNoPath_17         0x028136 /* qTSFindPathUsingGeo: Unknown Port Priority value specified.*/
#define QCLUST_ErrGeoInvalidAttr    0x028137 /* qClusterAttrAdd: Invalid Geo attribute was supplied.*/
#define QCLUST_ErrGeoInvalidPri     0x028138 /* qValidateAndProcessGeoAttr: Invalid Geo priority was supplied.*/
#define QCLUST_ErrReroute_Failed    0x028139 /* Optimized slot reassign and activate feature failed.*/
#define QCLUST_ErrUnroute_Failed    0x02813a /* Optimized slot unassign and deactivate feature failed.*/

#define QCLUST_ErrEdgeTabOver1      0x02813b /* qTsCreateEdges: edge table overlow */
#define QCLUST_ErrEdgeTabOver2      0x02813c /* qTsCreateEdges: edge table overlow */
#define QCLUST_ErrEdgeTabOver3      0x02813d /* qTsCreateEdges: edge table overlow */
#define QCLUST_ErrEdgeTabOver4      0x02813e /* qTsCreatePaths: edge table overlow */

#define QCLUST_ErrSlotInfoWidth     0x02813f /* qClusterSlotInfo() found slot width > 1*/
#define QCLUST_ErrAskTalker1        0x028140 /* qCLusterSlotReroute on askTalker mode is not allowed*/
#define QCLUST_ErrAskTalker2        0x028141 /* qCLusterSlotUnroute on askTalker mode is not allowed*/
#define QCLUST_ErrSlotAssignMMA     0x028142 /* qClusterSlotAssign: Disallow user assignment
                                                of MMA ports*/
#define QCLUST_ErrSlotUnAssignMMA   0x028143 /* qClusterSlotUnassign: Disallow user un-assignment
                                                of MMA ports*/
#define QCLUST_ErrInvalEncode_01    0x028144 /* qClusterSlotAssign: Disallow assignment of invalid slotset
                                                for NET ports*/
#define QCLUST_ErrInvalEncode_02    0x028145 /* qClusterSlotUnassign: Disallow assignment of invalid slotset
                                                for SCBus ports*/
#define QCLUST_ErrIdleConvert_01    0x028146 /* qPortAutoAssignTSAndIdle: No idlePattern failed to convert to
                                                Ri or Si idlePattern */
#define QCLUST_ErrIdleConvert_02    0x028147 /* qPortAutoAssignTSAndIdle: Ni idlePattern failed to convert to
                                                Ro or So idlePattern */
#define QCLUST_ErrAssTSProd         0x028148 /* qPortAutoAssignTSAndIdle: Producer's slotSet assignment failure*/
#define QCLUST_ErrAssTSCons         0x028149 /* qPortAutoAssignTSAndIdle: Consumer's slotSet assignment failure*/
#define QCLUST_Err_Ro_UnAssign      0x02814a /* qClusterDeactivate: XSCALE only: Failed to unassign MMA:OUT slots*/
#define QCLUST_Err_Ri_UnAssign      0x02814b /* qPortMute: XSCALE only: Failed to unassign MMA:IN slots*/
#define QCLUST_ErrNoNetwork_10      0x02814c /* QTS_Ntwrk_LocalTS_Mercury1_95: No network devices on 1.95 board*/
#define QCLUST_ErrTSEdgeMallocFail  0x02814d /* Failed to allocate memery for  qTSEdgeDef*/
#define QCLUST_ErrTransCreate1      0x02814e /* Cannot create delayed message transaction within the
			  	                                    qClusterSlotAssign function */
#define QCLUST_ErrTransCreate2      0x02814f /* Cannot create delayed message transaction within the
			                                       qClusterActivate function */
#define QCLUST_ErrTransCreate3      0x028150 /* Cannot create delayed message transaction within the
		                                          qClusterDeactivate function */
#define QCLUST_ErrTransCreate4      0x028151 /* Cannot create delayed message transaction within the
		                                          qClusterSlotReroute function */
#define QCLUST_ErrTransCreate5      0x028152 /* Cannot create delayed message transaction within the
	                                             qClusterSlotUnroute function */
#define QCLUST_ErrTransNotFound     0x028153 /* Cannot find matching transaction in qMsgDelayedTransactionRemove */
#define QCLUST_ErrTransNotFound1    0x028154 /* Cannot find matching transaction in
					                                 qMsgDelayedMsgListProcessOnAsyncResponse */
#define QCLUST_ShServerError        0x028155 /* Sh server responded with an error.*/
#define QCLUST_ERR156               0x028156 /* Comments to be included */
#define QCLUST_ErrMercBusSet        0x028157 /* qClusterSlotAssign: qTdmBusLawSet failed
                                                on first slot assign to S port
                                                on Mercury Resource Only board */
#define QCLUST_ErrMercBusSet2       0x028158 /* qClusterSlotAssign: qTdmBusLawSet failed
                                                on first slot assign to S port
                                                on DI Series board */
#define QCLUST_ErrMercBusSet3       0x028159 /* qClusterSlotAssign: qTdmBusLawSet failed
                                                on first slot assign to N port
                                                on DI Series board */
#define QCLUST_ERR15a               0x02815a /* Comments to be included */
#define QCLUST_ErrInvalidArg        0x02815b /* qPortSetSPBuff: TimeSlot or Stream given is
                                                out of range */
#define QCLUST_ErrXTableMsgFail     0x028160 /* Comments to be included */
#define QCLUST_ErrXTableMsgFailAloc 0x028161 /* Comments to be included */
#define QCLUST_ErrSuspend           0x028162 /* qCSUA: Port is Suspended */


/*******************************************************************************
* qmsgapi.c qErrNo definitions (0x030000 to 0x030fff)
*******************************************************************************/
#define QMSG_ERR1    0x030001 /* qMsgRead(), task has not been
                                 registered properly or OS call failed */
#define QMSG_ERR2    0x030002 /* qMsgWrite(), message size field
                                 is too big for pool buffer */
#define QMSG_ERR3    0x030003 /* qMsgWrite(), message size field
                                 is bigger than size requested in
                                 qMsgAllocate or qMsgReallocate */
#define QMSG_ERR4    0x030004 /* qMsgWrite(), message size field
                                 is smaller than area of message body written
                                 with qMsgVarFieldPut() */
#define QMSG_ERR5    0x030005 /* qMsgWrite(), error in OS msg
                                 write call (host bound message) */
#define QMSG_ERR6    0x030006 /* qMsgWrite(), message queue for
                                 local destination desc does not exist */
#define QMSG_ERR7    0x030007 /* qMsgWrite(), error in OS msg
                                 write call (maybe msg queue is full?)
                                 (local bound message) */
#define QMSG_ERR8    0x030008 /* qMsgWrite(), cp boot kernel
                                 does not support IPC messaging */
#define QMSG_ERR9    0x030009 /* qMsgAllocate(), no pool with
                                 size bytes was found */
#define QMSG_ERRA    0x03000a /* qMsgVarFieldPut(), QT_FRAC16, QT_FRAC24,
                                 and QT_CHAR_PACKED not yet implemented */
#define QMSG_ERRB    0x03000b /* qMsgVarFieldPut(), bad data type */
#define QMSG_ERRC    0x03000c /* qMsgVarFieldPut(), message put overflowed
                                 message size */
#define QMSG_ERRD    0x03000d /* qMsgVarFieldGet(), QT_FRAC16, QT_FRAC24, and
                                 QT_CHAR_PACKED not yet implemented */
#define QMSG_ERRE    0x03000e /* qMsgVarFieldGet(), bad data type */
#define QMSG_ERRF    0x03000f /* qMsgCheck, msgcnt pointer is NULL */
#define QMSG_ERR10   0x030010 /* Comments to be included */
#define QMSG_ERR11   0x030011 /* Comments to be included */
#define QMSG_ERR12   0x030012 /* Comments to be included */
#define QMSG_ERR13   0x030013 /* Comments to be included */
#define QMSG_ERR14   0x030014 /* Comments to be included */
#define QMSG_ERR15   0x030015 /* Comments to be included */
#define QMSG_ERR16   0x030016 /* Comments to be included */
#define QMSG_ERR17   0x030017 /* Comments to be included */
#define QMSG_ERR18   0x030018 /* Comments to be included */
#define QMSG_ERR19   0x030019 /* Comments to be included */
#define QMSG_ERR1A   0x03001a /* Comments to be included */
#define QMSG_ERR1B   0x03001b /* Comments to be included */
#define QMSG_ERR1C   0x03001c /* Comments to be included */
#define QMSG_ERR1D   0x03001d /* Comments to be included */
#define QMSG_ERR1E   0x03001e /* Comments to be included */
#define QMSG_ERR1F   0x03001f /* MMDL on a 563XX truncated a 16 bit
											QCompDesc field */
#define QMSG_ERR20   0x030020 /* MMDL on a 32 bit little endian processor
											truncated a instance field in a 16-bit
											QCompDesc. */
#define QMSG_ERR21   0x030021 /* MMDL on a 32 bit little endian processor
											truncated a node field in a 16-bit
											QCompDesc. */
#define QMSG_ERR22   0x030022 /* MMDL on a 32 bit big endian processor
											truncated a instance field in a 16-bit
											QCompDesc. */
#define QMSG_ERR23   0x030023 /* MMDL on a 32 bit big endian processor
											truncated a node field in a 16-bit
											QCompDesc. */
#define QMSG_ERR24   0x030024 /* MMDL on a 32 bit little endian processor
											truncated a node field in a 8-bit
											QCompDesc. */
#define QMSG_ERR25   0x030025 /* qMsgRead Error: Undefined Format feild in
                                 a SMart Message */
#define QMSG_ERR26   0x030026 /* qMsgFree: Failure to free the Smart message */
#define QMSG_ERR27   0x030027 /* Failure to post the sucessive message
                                 within the smart message */
#define QMSG_ERR28   0x030028 /* MsgAllocate for SmartReply Failed */
#define QMSG_ERR29   0x030029 /* Invalid value for Passreply, or errorreply
                                 fields in Smartmessage */
#define QMSG_ERR2A   0x03002a /* qMsgWrite Failed to send the message in qMsgWrite2 */
#define QMSG_ERR2B   0x03002b /* qMsgWrite Failed to send the reply message in qMsgWrite2 */
#define QMSG_ERR2C   0x03002c /* qMsgWrite Failed to free the reply message in qMsgWrite2 */
#define QMSG_ERR2D   0x03002d /* qMsgWrite Failed to send the local reply message in qMsgWrite2 */
#define QMSG_ERR2E   0x03002e /* qMsgWrite Failed to free the reply message in qMsgWrite2 */
#define QMSG_ERR2F   0x03002f /* qMsgWrite Failed to send the smart reply message in qMsgWrite2 */
#define QMSG_ERR32   0x030032 /* qMsgWrite Failed to free the smart message in qMsgWrite2 */
#define QMSG_ERR33   0x030033 /* qMsgWrite Failed to send the subsequent embeddded message
                                 within the smart message in qMsgWrite2 */
#define QMSG_ERR34   0x030034 /* qMsgWrite Failed to free the smart message in qMsgWrite2 */
#define QMSG_ERR35   0x030035 /* qOsMsgqPriPost: Failed to post the message
                                 to the queue inside qMsg APIs' for
                                 Smartmessages */
#define QMSG_ERR36   0x030036 /* MMDL on a 536xx found that the higher order 8 bits of the
			         node/instance are set and the node/instance entry is not
                                 the wild card */
#define QMSG_ERR37   0x030037 /* qDelayedMsgWriteHandlerTaskInit - Initialization failed */
#define QMSG_ERR38   0x030038 /* qDelayedMsgHandlerTask - Sys Component Registration failed */
#define QMSG_ERR39   0x030039 /* qDelayedMsgHandlerTask - Initialization of the sh remote failed */
#define QMSG_ERR3A   0x03003A /* qDelayedMsgHandlerTask - qOsMsgQPend returned an error
 				on an Infinite timeout*/
#define QMSG_ERR3B   0x03003B /* qMsgDelayedMsgListWrite - qMsgWrite Failed*/
#define QMSG_ERR3C   0x03003C /* qMsgDelayedSendErrorResponse - qMsgWrite Failed*/
#define QMSG_ERR3D   0x03003D /* qDelayedMsgWriteHandlerTaskExit - qMsgWrite Failed*/
#define QMSG_ERR3E   0x03003E /* sh_remoteFindServer - qMsgWrite Failed*/
#define QMSG_ERR3F   0x03003F /* qMsgDelayedWrite - Reached Max message count*/
#define QMSG_ERR40   0x030040 /* qMsgDelayedMsgAndStateHandlerTask - Sys Comp Register Failed*/
#define QMSG_ERR41   0x030041 /* qMsgDelayedMsgAndStateHandlerTask - FTimerSet Failed*/

/*******************************************************************************
* qmsomgr.c qErrNo definitions (0x031000 to 0x031fff)
*******************************************************************************/
#define QMSO_ERR1    0x031001 /* qMsoSysInit(), qOsSemPend failed
                                 (qMmaStrtupSem) */
#define QMSO_ERR2    0x031002 /* no longer used */
#define QMSO_ERR3    0x031003 /* no longer used */
#define QMSO_ERR4    0x031004 /* no longer used */
#define QMSO_ERR5    0x031005 /* qMsoWrite(), Destination processor does not
                                 exist */
#define QMSO_ERR6    0x031006 /* qMsoWrite(), IPC queue for destination
                                 processor has not yet been initialized */
#define QMSO_ERR7    0x031007 /* qMsoWrite(), qmsg->size > QMSG_MAX_SIZE */
#define QMSO_ERR8    0x031008 /* qMsoReadCb(), Incoming IPC message size is
                                 greater than QMSG_MAX_SIZE  (incoming IPC
                                 message queue is corrupted) */
#define QMSO_ERR9    0x031009 /* qMsoReadCb(), Incoming IPC message size is
                                 less than QGM_MSG_HEAD_SIZE  (incoming IPC
                                 message queue is corrupted) */
#define QMSO_ERRA    0x03100a /* qMsoReadCb(), internal error, dmaCount is
                                 larger than 1st amount read */
#define QMSO_ERRB    0x03100b /* qMsoReadCb(), Configuration error, no local
                                 pool large enough to hold incoming message */
#define QMSO_ERRC    0x03100c /* qSpDbgCmdHandle(), bad message type */
#define QMSO_ERRD    0x03100d /* qSpDbgCmdHandle(), bad message transaction */
#define QMSO_ERRE    0x03100e /* no longer used */
#define QMSO_ERRF    0x03100f /* no longer used */
#define QMSO_ERR10   0x031010 /* qMsoReadPrintf(), bad message size (cnt) */
#define QMSO_ERR11   0x031011 /* qMsoReadCb(), for SP, incoming IPC message
                                 has destination address which is not for this
                                 processor */
#define QMSO_ERR12   0x031012 /* qMsoReadCb(), for ONYX, Incoming IPC message
                                 size is greater than QMSG_MAX_SIZE  (incoming
                                 IPC message queue is corrupted) */
#define QMSO_ERR13   0x031013 /* Comments to be included */
#define QMSO_ERR14   0x031014 /* Comments to be included */
#define QMSO_ERR15   0x031015 /* Comments to be included */
#define QMSO_ERR16   0x031016 /* Comments to be included */
#define QMSO_ERR17   0x031017 /* Comments to be included */
#define QMSO_ERR18   0x031018 /* Comments to be included */
#define QMSO_ERR19   0x031019 /* Comments to be included */
#define QMSO_ERR1A   0x03101a /* Comments to be included */
#define QMSO_ERR1B   0x03101b /* Comments to be included */
#define QMSO_ERR1C   0x03101c /* Comments to be included */
#define QMSO_ERR1D   0x03101d /* Comments to be included */
#define QMSO_ERR1E   0x03101e /* Comments to be included */
#define QMSO_ERR1F   0x03101f /* Comments to be included */
#define QMSO_ERR20   0x031020 /* Comments to be included */
#define QMSO_ERR21   0x031021 /* Comments to be included */
#define QMSO_ERR22   0x031022 /* Comments to be included */
#define QMSO_ERR23   0x031023 /* Comments to be included */
#define QMSO_ERR24   0x031024 /* Msg Undelivered by kernel*/
#define QMSO_ERR25	0x031025 /* Kernel Failed to allocate Scratch
                                 memory of 2K/DSP to perform Fast IPC
                                 queue processing */
#define QMSO_ERR26 	0x031026 /* Underlying Mma call failed in qMsoReadCb */
#define QMSO_ERR27	0x031027 /* Bad Message Read from IPC Queue */

/*******************************************************************************
* qossem.h qErrNo definitions (0x038000 to 0x038fff)
*******************************************************************************/
#define QSEM_ERR1    0x038001 /* qOsSemPost(), underlying O.S. call failed */

#define QSEM_ERR2    0x038002 /* no longer used */
#define QSEM_ERR3    0x038003 /* qOsSemPend(), underlying O.S. call failed */

#define QSEM_ERR4    0x038004 /* qOsSemCreate(), underlying O.S. call failed */

#define QSEM_ERR5    0x038005 /* qOsSemDelete(), underlying O.S. call failed */

#define QSEM_ERR6    0x038006 /* qOsSemReset(), underlying O.S. call failed */

#define QSEM_ERR7    0x038008  /* Comments to be included */
#define QSEM_ERR8    0x038009  /* Comments to be included */
#define QSEM_ERR9    0x03800a  /* Comments to be included */
#define QSEM_ERRA    0x03800b  /* Comments to be included */

#define QTASK_INVALID_TID  0x038007 /* qTaskDelete(), Invalid TaskID. */
#define QTASK_ERR1         0x038021 /* WINOS platform, nested usage of
												   qOsTaskLock. */
#define QTASK_ERR2         0x038022 /* Comments to be included  */
#define QTASK_ERR3         0x038023 /* Comments to be included */
#define QTASK_ERR4         0x038024 /* Comments to be included  */
#define QTASK_ERR5         0x038025 /* Comments to be included  */
#define QTASK_ERR6         0x038026 /* Comments to be included  */
#define QTASK_ERR7         0x038027 /* Comments to be included  */
#define QTASK_ERR8         0x038028 /* Comments to be included  */
#define QTASK_ERR9         0x038029 /* Comments to be included  */
#define QTASK_ERRA         0x03802a /* Comments to be included  */
#define QTASK_ERRB         0x03802b /* Comments to be included  */
#define QTASK_ERRC         0x03802c /* Comments to be included  */
#define QTASK_ERRD         0x03802d /* Comments to be included  */
#define QTASK_ERRE         0x03802e /* Comments to be included  */
#define QTASK_ERRF         0x03802f /* Comments to be included  */
#define QTASK_ERR10        0x038030 /* Comments to be included  */
#define QTASK_ERR11        0x038031 /* Comments to be included  */
#define QTASK_ERR12        0x038032 /* Comments to be included  */
#define QTASK_ERR13        0x038033 /* Comments to be included  */
#define QTASK_ERR14        0x038034 /* Comments to be included  */
#define QTASK_ERR15        0x038035 /* Comments to be included  */
#define QTASK_ERR16        0x038036 /* Comments to be included  */
#define QTASK_ERR17        0x038037 /* Comments to be included  */
#define QTASK_ERR18        0x038038 /* Comments to be included  */
#define QTASK_ERR19        0x038039 /* Comments to be included  */
#define QTASK_ERR1A        0x03803a /* Comments to be included  */
#define QTASK_ERR1B        0x03803b /* Comments to be included  */
#define QTASK_ERR1C        0x03803c /* Comments to be included  */
#define QTASK_ERR1D        0x03803d /* Comments to be included  */
#define QTASK_ERR1E        0x03803e /* Comments to be included  */
#define QTASK_ERR1F        0x03803f /* Comments to be included  */
#define QTASK_ERR20        0x038040 /* Comments to be included  */
#define QTASK_ERR21        0x038041 /* Comments to be included  */
#define QTASK_ERR22        0x038042 /* Comments to be included  */
#define QTASK_ERR23        0x038043 /* Comments to be included  */
#define QTASK_ERR24        0x038054 /* Comments to be included  */
#define QTASK_ERR25        0x038055 /* Comments to be included  */
#define QTASK_ERR26        0x038056 /* Comments to be included  */
#define QTASK_ERR27        0x038057 /* Comments to be included  */
#define QTASK_ERR28        0x038058 /* Comments to be included  */
#define QTASK_ERR29        0x038059 /* Comments to be included  */
#define QTASK_ERR2A        0x03805a /* WINOS platform, defensive programming
												   check in qOsTaskUnlock macro that
												   previous qOsTaskLock macro correctly
												   used.  In this case, making sure
												   qOsTaskLock was used at PASSIVE_LEVEL or
												   is used at DISPATCH_LEVEL. */
#define QTASK_ERR2B        0x03805b /* WINOS platform, defensive programming
                                       check in qOsTaskUnlock macro that task
                                       unlock succeeded.  In this case, making
                                       sure there are no more outstanding locks
                                       and that the IRQL has been appropriately
                                       lowered. */
#define QTASK_ERR2C 0x03805c    /* Invalid memory region for stack */
#define QTASK_ERR2D 0x03805d    /* On 563XXX chip memory can not be used as
                                    stack. */
#define QTASK_ERR2E 0x03805e    /* On this processor one the default memory
                                    region can be used.  Pass -1 */
#define QTASK_ERR2F 0x03805f    /* Out of memory for stack */
#define QTASK_ERR30 0x038060    /* Out of memory for static data memory */
#define QTASK_ERR31 0x038061    /* Unable to create message queue for task. */
#define QTASK_ERR32 0x038062    /* Os task create failed. */

#define QISR_ERR1          0x038070 /* WINOS platform, defensive programming
                                       check in qOsClearInt for unsupported
                                       nested ISR disabling */
#define QISR_ERR2          0x038071 /* WINOS platform, defensive programming
                                       check in qOsSetInt for unsupported nested
                                       ISR disabling */


/*******************************************************************************
* LIBRARY Errors
*******************************************************************************/
#define QLIB_ERR1      0x039001 /* Comments to be included */
#define QLIB_ERR2      0x039002 /* Comments to be included */
#define QLIB_ERR3      0x039003 /* Comments to be included */
#define QLIB_ERR4      0x039004 /* Comments to be included */
#define QLIB_ERR5      0x039005 /* Comments to be included */
#define QLIB_ERR6      0x039006 /* Comments to be included */
#define QLIB_ERR7      0x039007 /* Comments to be included */
#define QLIB_ERR8      0x039008 /* Comments to be included */
#define QLIB_ERR9      0x039009 /* Comments to be included */
#define QLIB_ERRA      0x03900a /* Comments to be included */
#define QLIB_ERRB      0x03900b /* Comments to be included */
#define QLIB_ERRC      0x03900c /* Comments to be included */
#define QLIB_ERRD      0x03900d /* Comments to be included */
#define QLIB_ERRE      0x03900e /* Comments to be included */
#define QLIB_ERRF      0x03900f /* Comments to be included */
#define QLIB_ERR10     0x039010 /* Comments to be included */
#define QLIB_ERR11     0x039011 /* Comments to be included */
#define QLIB_ERR12     0x039012 /* Comments to be included */
#define QLIB_ERR13     0x039013 /* Comments to be included */
#define QLIB_ERR14     0x039014 /* Comments to be included */
#define QLIB_ERR15     0x039015 /* qTaskCompInstListUninit: failed to delete
                                   qTaskCompInstSem. */
#define QLIB_ERR16     0x039016 /* Comments to be included */
#define QLIB_ERR17     0x039017 /* Comments to be included */
#define QLIB_ERR18     0x039018 /* Comments to be included */
#define QLIB_ERR19     0x039019 /* Comments to be included */
#define QLIB_ERR1A     0x03901a /* Comments to be included */
#define QLIB_ERR1B     0x03901b /* Comments to be included */
#define QLIB_ERR1C     0x03901c /* Comments to be included */
#define QLIB_ERR1D     0x03901d /* Comments to be included */
#define QLIB_ERR1E     0x03901e /* Comments to be included */
#define QLIB_ERR1F     0x03901f /* Comments to be included */
#define QLIB_ERR20     0x039020 /* qTaskConvertToIdleTask: re-entrency check
                                   failed. */
#define QLIB_ERR21     0x039021 /* qTaskConvertToIdleTask: task Id check
                                   failed */
#define QLIB_ERR22     0x039022 /* qTaskConvertToIdleTask: failed to create
                                   qIdleTskQId. */
#define QLIB_ERR23     0x039023 /* qTaskConvertToIdleTask: failed to register
                                   idle task. */
#define QLIB_ERR24     0x039024 /* qTaskConvertToIdleTask: failed to set idle
                                   task's priority. */
#define QLIB_ERR25     0x039025 /* no longer used */
#define QLIB_ERR26     0x039026 /* Comments to be included */
#define QLIB_ERR27     0x039027 /* Comments to be included */
#define QLIB_ERR28     0x039028 /* Comments to be included */
#define QLIB_ERR29     0x039029 /* Failed to delete qIdleTskQId during
											  shutdown */
#define QLIB_ERR2A     0x03902a /* Comments to be included */
#define QLIB_ERR2B     0x03902b /* Failed to allocate Overall ErrTable - CP */
#define QLIB_ERR2C     0x03902c /* Failed to allocate Latest ErrTable - CP */
#define QLIB_ERR2D     0x03902d /* Failed to allocate Overall ErrTable - SP's */
#define QLIB_ERR2E     0x03902e /* Failed to allocate Latest ErrTable - SP's */
#define QLIB_ERR2F     0x03902f /* Failed to allocate QProcStatusReply message*/
#define QLIB_ERR30     0x039030 /* Failed to Write QProcStatusReply message */
#define QLIB_ERR31     0x039031 /* Failed to allocate QProcMiniStatusReply
											  message*/
#define QLIB_ERR32     0x039032 /* Failed to Write QProcMiniStatusReply
                                   message */
#define QLIB_ERR33     0x039033 /* Failed to Send QBoardAlarmAck message */
#define QLIB_ERR34     0x039034 /* Failed to Allocate QBoardAlarmAck message */
#define QLIB_ERR35     0x039035 /* Failed to Allocate OverallErr buffer*/

/*******************************************************************************
* bstream sub-system qErrNo definitions (0x040000 to 0x040fff)
*******************************************************************************/
#define QBSTRM_ERR1  0x040001 /* qBStreamTask(), qOsSemPost failed */
#define QBSTRM_ERR2  0x040002 /* qBStreamTask(), Message definitions have
                                 changed so that one or more messages is larger
                                 than the minimum message size (i.e. 24 bytes)*/
#define QBSTRM_ERR3  0x040003 /* qOsSemCreate failed */
#define QBSTRM_ERR4  0x040004 /* qOsSemPend failed */
#define QBSTRM_ERR5  0x040005 /* qOsSemDelete failed */
#define QBSTRM_ERR6  0x040006 /* qBStreamTask(), Expected QCompRegisterResult */
#define QBSTRM_ERR7  0x040007 /* qBStreamTask(), Bad cmd type in bstream info */
#define QBSTRM_ERR8  0x040008 /* (used in various synchronous calls), Bad cmd
                                 type in bstream info after qOsSemPend*/
#define QBSTRM_ERR9  0x040009 /* qBStreamOpen()(synchronous), NULL handle
                                 received from bstream task */
#define QBSTRM_ERRA  0x04000A /* qBStreamUse(), Bad streamRef passed (non-NULL
                                 handle but id == 0) */
#define QBSTRM_ERRB  0x04000B /* qBlockAllocate(), attempt to allocate too many
                                 blocks before putting */
#define QBSTRM_ERRC  0x04000C /* qBStreamPut() does not support sync mode */
#define QBSTRM_ERRD  0x04000D /* qBStreamPut(), attempt to put blocks on a
                                 different stream than allocated */
#define QBSTRM_ERRE  0x04000E /* qBStreamPut(), attempt to put blocks in
                                 different order than allocated */
#define QBSTRM_ERRF  0x04000F /* qBStreamPut(), NULL pBufInfo passed */
#define QBSTRM_ERR10 0x040010 /* qBStreamPut(), more puts than allocates */
#define QBSTRM_ERR11 0x040011 /* qBStreamGet() does not support sync mode */
#define QBSTRM_ERR12 0x040012 /* qBStreamGet(), attempt to get too many
                                 blocks before freeing */
#define QBSTRM_ERR13 0x040013 /* qBlockFree(), attempt to free blocks in
                                 different order than gotten */
#define QBSTRM_ERR14 0x040014 /* qBlockFree(), more frees than gets */


/*******************************************************************************
* gstream sub-system qErrNo definitions (0x041000 to 0x041fff)
*******************************************************************************/
#define QGSTRM_ERR1  0x041001 /* qGStreamOpenNext(), All streams with given
                                 size requirements are used (i.e. open,
                                 suspended, or closed w/ persistent data) */
#define QGSTRM_ERR2  0x041002 /* qGStreamOpenCb(), gstream handle contains bad
                                 index (bad handle) */
#define QGSTRM_ERR3  0x041003 /* qGStreamOpenCb(), User specified read stream
                                 id is already open */
#define QGSTRM_ERR4  0x041004 /* qGStreamOpenCb(), User specified write stream
                                 id is already open */
#define QGSTRM_ERR5  0x041005 /* qGStreamOpenCb(), Internal error, stream not
                                 open for read, write or look */
#define QGSTRM_ERR6  0x041006 /* qGStreamOpen(), Attempt to open stream in
                                 multiple modes (write, read, or look) */
#define QGSTRM_ERR7  0x041007 /* qGStreamOpen(), Attempt to open stream in
                                 multiple modes (write, read, or look), or
                                 attempt to open for read look with persistent
                                 mode set. */
#define QGSTRM_ERR8  0x041008 /* qGStreamOpen(), Attempt to open stream in
                                 multiple modes (write, read, or look), or
                                 attempt to open for look look with persistent
                                 mode set. */
#define QGSTRM_ERR9  0x041009 /* qGStreamOpen(), No open mode specified (stream
                                 must be opened for write, read, or look) */
#define QGSTRM_ERRA  0x04100a /* qGStreamOpen(), No streams with 'size' or more
                                 bytes configured */
#define QGSTRM_ERRB  0x04100b /* qGStreamCloseCb(), Internal error (read stream
                                 is not open to this processor) */
#define QGSTRM_ERRC  0x04100c /* qGStreamCloseCb(), Internal error (write stream
                                 is not open to this processor) */
#define QGSTRM_ERRD  0x04100d /* qGStreamCloseCb(), Internal error (not open for read or write */
#define QGSTRM_ERRE  0x04100e /* qGStreamClose(), gstream handle contains bad
                                 index (bad handle) */
#define QGSTRM_ERRF  0x04100f /* qGStreamClose(), gstream handle not open for
                                 read, write or look */
#define QGSTRM_ERR10 0x041010 /* qGStreamClose(), stream is not open by this
                                 processor*/
#define QGSTRM_ERR11 0x041011 /* qGStreamRead(), gstream handle contains bad
                                 index (bad handle) */
#define QGSTRM_ERR12 0x041012 /* no longer used */
#define QGSTRM_ERR13 0x041013 /* qGStreamRead(), Not open for read or look */
#define QGSTRM_ERR14 0x041014 /* no longer used */
#define QGSTRM_ERR15 0x041015 /* no longer used */
#define QGSTRM_ERR16 0x041016 /* qGStreamWrite(), gstream handle contains bad
                                 index (bad handle) */
#define QGSTRM_ERR17 0x041017 /* qGStreamWrite(), not open for write */
#define QGSTRM_ERR18 0x041018 /* no longer used */
#define QGSTRM_ERR19 0x041019 /* no longer used */
#define QGSTRM_ERR1A 0x04101A /* qGStreamIndexRead(), gstream handle contains
                                 bad index (bad handle) */
#define QGSTRM_ERR1B 0x04101B /* no longer used */
#define QGSTRM_ERR1C 0x04101C /* qGStreamIndexRead(), Not open for read or
                                 look */
#define QGSTRM_ERR1D 0x04101D /* no longer used */
#define QGSTRM_ERR1E 0x04101E /* qGStreamIndexWrite(), gstream handle contains
                                 bad index (bad handle) */
#define QGSTRM_ERR1F 0x04101F /* qGStreamIndexWrite(), not open for write */
#define QGSTRM_ERR20 0x041020 /* no longer used */
#define QGSTRM_ERR21 0x041021 /* qGStreamAdvanceRead(), gstream handle contains
                                 bad index (bad handle) */
#define QGSTRM_ERR22 0x041022 /* no longer used */
#define QGSTRM_ERR23 0x041023 /* qGStreamAdvanceRead(), Not open for read or
                                 look */
#define QGSTRM_ERR24 0x041024 /* no longer used */
#define QGSTRM_ERR25 0x041025 /* no longer used */
#define QGSTRM_ERR26 0x041026 /* qGStreamAdvanceWrite(), gstream handle contains
                                 bad index (bad handle) */
#define QGSTRM_ERR27 0x041027 /* qGStreamAdvanceWrite(),  not open for write */
#define QGSTRM_ERR28 0x041028 /* no longer used */
#define QGSTRM_ERR29 0x041029 /* no longer used */
#define QGSTRM_ERR2A 0x04102A /* qGStreamFlushRead(), gstream handle contains
                                 bad index (bad handle) */
#define QGSTRM_ERR2B 0x04102B /* qGStreamFlushRead(), not open for read */
#define QGSTRM_ERR2C 0x04102C /* no longer used */
#define QGSTRM_ERR2D 0x04102D /* qGStreamStatusCb(), Internal error (bad
                                 handle) */
#define QGSTRM_ERR2E 0x04102E /* qGStreamStatus(), gstream handle contains
                                 bad index (bad handle) */
#define QGSTRM_ERR2F 0x04102F /* no longer used */
#define QGSTRM_ERR30 0x041030 /* qGStreamStatusByIdCb(), Internal error (bad
                                 handle) */
#define QGSTRM_ERR31 0x041031 /* no longer used */
#define QGSTRM_ERR32 0x041032 /* SendGStrmOpenCmplt(), qSysMsgWrite failed */
#define QGSTRM_ERR33 0x041033 /* SendGStrmCloseCmplt(), qSysMsgWrite failed */
#define QGSTRM_ERR34 0x041034 /* SendGStrmIOCmplt(), qSysMsgWrite failed */
#define QGSTRM_ERR35 0x041035 /* SendGStrmStatus(), qSysMsgWrite failed */
#define QGSTRM_ERR36 0x041036 /* qGStreamRandomRead(), gstream handle contains
                                 bad index (bad handle) */
#define QGSTRM_ERR37 0x041037 /* no longer used */
#define QGSTRM_ERR38 0x041038 /* qGStreamRandomRead(), Not open for look */
#define QGSTRM_ERR39 0x041039 /* qGStreamTerminateCb(), Stream id specified for
                                 read terminate is not closed on read end */
#define QGSTRM_ERR3A 0x04103A /* qGStreamTerminateCb(), Stream id specified for
                                 write terminate is not closed on write end */
#define QGSTRM_ERR3B 0x04103B /* qGStreamTerminateCb(), Internal error (not
                                 specified read or write) */
#define QGSTRM_ERR3C 0x04103C /* qGStreamTerminate(), Stream id is invalid */
#define QGSTRM_ERR3D 0x04103D /* qGStreamTerminate(), Only one end of a stream
                                 may be terminated at once */
#define QGSTRM_ERR3E 0x04103E /* qGStreamTerminate(), Neither end of the stream
                                 specified */
#define QGSTRM_ERR3F 0x04103F /* qGStreamStatusById(), Stream id is invalid */
#define QGSTRM_ERR40 0x041040 /* qGStreamOpen(), Invalid Stream id */
#define QGSTRM_ERR41 0x041041 /* qGStreamOpen(), Must specifiy explicit stream
                                 id when opening for LOOK */
#define QGSTRM_ERR42 0x041042 /* Out of Reqlst entries during callback.  Increase
                                    number of Reqlst entries to fix. */
#define QGSTRM_ERR43 0x041043 /* Unable to allocate GStream Handle in
                           qGStreamStatusById. */
#define QGSTRM_ERR44 0x041044 /* Unable to allocate pInfo struct in
                           qGStreamStatusById. */
#define QGSTRM_ERR45 0x041045 /* Internal MMA error in qGStreamStatusById. */

#define QGSTRM_ERR46 0x041046 /* Illegal Mode Options Set in qGStreamRead2 */
#define QGSTRM_ERR47 0x041047 /* pStruct is NULL, with the QIO_STRUCT option in
                                 qGStreamRead2 */
#define QGSTRM_ERR48 0x041048 /* pStruct is NULL, with QIO_REPLY option in
                                 qGStreamRead2 */
#define QGSTRM_ERR49 0x041049 /* Illegal Mode Options Set in qGStreamWrite2 */
#define QGSTRM_ERR4A 0x04104a /* pStruct is NULL, with the QIO_STRUCT option in
                                 qGStreamWrite2 */
#define QGSTRM_ERR4B 0x04104b /* pStruct is NULL, with QIO_REPLY option in
                                 qGStreamWrite2 */
#define QGSTRM_ERR4C 0x04104c /* Illegal Mode Options Set in qGStreamIndexRead2 */
#define QGSTRM_ERR4D 0x04104d /* pStruct is NULL, with the QIO_STRUCT option in
                                 qGStreamIndexRead2 */
#define QGSTRM_ERR4E 0x04104e /* pStruct is NULL, with QIO_REPLY option in
                                 qGStreamIndexRead2 */
#define QGSTRM_ERR4F 0x04104f /* Illegal Mode Options Set in qGStreamIndexWrite2 */
#define QGSTRM_ERR50 0x041050 /* pStruct is NULL, with the QIO_STRUCT option in
                                 qGStreamIndexWrite2 */
#define QGSTRM_ERR51 0x041051 /* pStruct is NULL, with QIO_REPLY option in
                                 qGStreamIndexWrite2 */
#define QGSTRM_ERR52 0x041052 /* Illegal Mode Options Set in qGStreamAdvanceRead2 */
#define QGSTRM_ERR53 0x041053 /* pStruct is NULL, with the QIO_STRUCT option in
                                 qGStreamAdvanceRead2 */
#define QGSTRM_ERR54 0x041054 /* pStruct is NULL, with QIO_REPLY option in
                                 qGStreamAdvanceRead2 */
#define QGSTRM_ERR55 0x041055 /* Illegal Mode Options Set in qGStreamAdvanceWrite2 */
#define QGSTRM_ERR56 0x041056 /* pStruct is NULL, with the QIO_STRUCT option in
                                 qGStreamAdvanceWrite2 */
#define QGSTRM_ERR57 0x041057 /* pStruct is NULL, with QIO_REPLY option in
                                 qGStreamAdvanceWrite2 */
#define QGSTRM_ERR58 0x041058 /* pStruct is NULL, for QIO_STRUCT option in qGStreamFlushRead2 */
#define QGSTRM_ERR59 0x041059 /* Illegal Mode Options Set in qGStreamRandomRead2 */
#define QGSTRM_ERR5A 0x04105a /* pStruct is NULL, with the QIO_STRUCT option in
                                 qGStreamRandomRead2 */
#define QGSTRM_ERR5B 0x04105b /* pStruct is NULL, with QIO_REPLY option in
                                 qGStreamRandomRead2 */
#define QGSTRM_ERR5C 0x04105c /* pStruct is NULL, for QIO_REPLY option in qGStreamFlushRead2 */
#define QGSTRM_ERR5D 0x04105d /* No processors specified for qGStreamRemoteOpen */
#define QGSTRM_ERR5E 0x04105e /* Invalid mode options for write processor  */
#define QGSTRM_ERR5F 0x04105f /* Invalid mode options for read processor  */
#define QGSTRM_ERR60 0x041060 /* Invalid mode options */
#define QGSTRM_ERR61 0x041061 /* Invalid mode options for OpenLook*/
#define QGSTRM_ERR62 0x041062 /* Invalid: User asked Kernel to find the Stream
                                 with OpenLook as the mode */
#define QGSTRM_ERR63 0x041063 /* The user provided Stream number does not Exist */
#define QGSTRM_ERR64 0x041064 /* qGStreamRemoteOPen: Read Handle Alloc Failed */
#define QGSTRM_ERR65 0x041065 /* qGStreamRemoteOPen: Write Handle Alloc Failed */
#define QGSTRM_ERR66 0x041066 /* qGStreamRemoteOPen: pInfo Alloc Failed */
#define QGSTRM_ERR67 0x041067 /* qGStreamRemoteOPen: Msg Alloc for response Failed */
#define QGSTRM_ERR68 0x041068 /* qGStreamRemoteOPen: Message alloc for HI Failed */
#define QGSTRM_ERR68 0x041068 /* qGStreamRemoteOPen: Message alloc for HI Failed */
#define QGSTRM_ERR69 0x041069 /* qGStreamRemoteOPen: MsgPost Failed */
#define QGSTRM_ERR6A 0x04106a /* qGStreamRemoteClose: Invalid Stream Id */
#define QGSTRM_ERR6B 0x04106b /* qGStreamRemoteClose:  No processor specified */
#define QGSTRM_ERR6C 0x04106c /* qGStreamRemoteClose:  Invalid procesor specified as the readproc */
#define QGSTRM_ERR6D 0x04106d /* qGStreamRemoteClose:  Invalid procesor specified as the writeproc */
#define QGSTRM_ERR6E 0x04106e /* qGStreamRemoteClose: Could not alloc pInfo */
#define QGSTRM_ERR6F 0x04106f /* qGStreamRemoteClose: Could not alloc pmsg for responce */
#define QGSTRM_ERR70 0x041070 /* qGStreamRemoteClose: Could not alloc msg for HI */
#define QGSTRM_ERR71 0x041071 /* qGStreamRemoteClose: MsgPost Failed */
#define QGSTRM_ERR72	0x041072 /* qGStreamCreateHndl: qmsg passed into the API
											was NULL */
#define QGSTRM_ERR73 0x041073 /* qGStreamCreateHndl: Failed to allocate a handle
											for the GStream */
#define QGSTRM_ERR74	0x041074	/* qGStreamCreateHndl: Failed to allocate a message
											to send the GStreamOpenCmplt back to the resource */
#define QGSTRM_ERR75	0x041075 /* qGStreamCreateHndl: Resource did not specify a
											specific StreamID */
#define QGSTRM_ERR76	0x041076 /* qGStreamCreateHndl: Invalid Stream ID */
#define QGSTRM_ERR77	0x041077 /* qGStreamCreateHndl: Invalid Mode, Mode cannot
											contain Write, Read and OpenForLook option
											simultaneously */
#define QGSTRM_ERR78	0x041078 /* qGStreamCreateHndl: Invalid Mode, Mode cannot
											contain Read and Write option
											simultaneously */
#define QGSTRM_ERR79	0x041079 /* qGStreamCreateHndl: Invalid Mode, Mode cannot
											contain Read and Write option
											simultaneously */
#define QGSTRM_ERR80	0x041080 /* qGStreamCreateHndl: User did not specify open mode*/
#define QGSTRM_ERR81	0x041081 /* qGStreamCreateHndlCb: Failed To send GStreamOpenCmplt message
											to the resource*/
#define QGSTRM_ERR82	0x041082 /* qGStreamCreateHndlCb: Particular Stream not opened for this
											processor */
#define QGSTRM_ERR83	0x041083 /* qGStreamCreateHndlCb: Failed to free the allocated
											handle */
#define QGSTRM_ERR84	0x041084 /* qGStreamCreateHndl: Failed in qMmaSimpleIO Call */
#define QGSTRM_ERR85 0x041085 /* qGStreamRemoteClose: Failed to Pend on HI message queue */
#define QGSTRM_ERR86 0x041086 /* qGStreamRemoteOpen: Failed to Pend on HI message queue */
#define QGSTRM_ERR87 0x041087 /* qGStreamRemoteOpen: Out or Range or invalid processor
                                 number specified as the write processor */
#define QGSTRM_ERR88 0x041088 /* qGStreamRemoteOpen: Out or Range or invalid processor
                                 number specified as the Read processor */
#define QGSTRM_ERR89 0x041089 /* Failed to Send QGStrmCloseCmplt for
											DestroyHndlCb */
#define QGSTRM_ERR90 0x041090 /* In qGStreamDestroyHndl: Failed to allocate
											message */
#define QGSTRM_ERR91 0x041091 /* In qGStreamDestroyHndl: qMmaSimpleIO call failed */
#define QGSTRM_ERR92 0x041092 /* In qGStreamDestroyHndlCb: qMmaSimple call failed 
                                 for qGStreamDestroyHndlCb2 */
#define QGSTRM_ERR93 0x041093 
#define QGSTRM_ERR94 0x041094 
#define QGSTRM_ERR95 0x041095 
#define QGSTRM_ERR96 0x041096 
#define QGSTRM_ERR97 0x041097 
#define QGSTRM_ERR98 0x041098 
#define QGSTRM_ERR99 0x041099 
#define QGSTRM_ERR9A 0x04109A 
#define QGSTRM_ERR9B 0x04109B 
#define QGSTRM_ERR9C 0x04109C 
#define QGSTRM_ERR9D 0x04109D 
#define QGSTRM_ERR9E 0x04109E 
#define QGSTRM_ERR9F 0x04109F 
#define QGSTRM_ERR100 0x0410100
#define QGSTRM_ERR101 0x0410101
#define QGSTRM_ERR102 0x0410102
#define QGSTRM_ERR103 0x0410103
#define QGSTRM_ERR104 0x0410104
#define QGSTRM_ERR105 0x0410105



/*******************************************************************************
* cstream sub-system qErrNo definitions (0x042000 to 0x042fff)
*******************************************************************************/
#define QCSTRM_ERR1  0x042001 /* SendCStreamCloseMsg(), msg write failed */
#define QCSTRM_ERR2  0x042002 /* qCStreamOpen(), pHandle is NULL */
#define QCSTRM_ERR3  0x042003 /* qCStreamOpen(), pBuffer is NULL */
#define QCSTRM_ERR4  0x042004 /* qCStreamOpen(), pBufWords is NULL */
#define QCSTRM_ERR5  0x042005 /* qCStreamOpen(), Invalid mode bits set */
#define QCSTRM_ERR6  0x042006 /* qCStreamOpen(), internal error, pmcs end bit
                                 was not found (opening for read) */
#define QCSTRM_ERR7  0x042007 /* qCStreamOpen(), Can't open inbound mma buffer
                                 for write */
#define QCSTRM_ERR8  0x042008 /* no longer used */
#define QCSTRM_ERR9  0x042009 /* qCStreamOpen(), Active CStream is already open
                                 for write on this processor */
#define QCSTRM_ERRA  0x04200a /* qCStreamOpen(), No more room left on pmcs
                                 (out of cstreams) */
#define QCSTRM_ERRB  0x04200b /* no longer used */
#define QCSTRM_ERRC  0x04200c /* no longer used */

#define QCSTRM_ERRD  0x04200d /* qCStreamClose(), Bad cstream handle */
#define QCSTRM_ERRE  0x04200e /* qCStreamClose(), cstream isn't open */
#define QCSTRM_ERRF  0x04200f /* no longer used */
#define QCSTRM_ERR10 0x042010 /* qCStreamClose(), Close index option not
                                 available on read CStream */
#define QCSTRM_ERR11 0x042011 /* qCStreamClose(), internal error, # of readers
                                 state is zero */
#define QCSTRM_ERR12 0x042012 /* qCStreamClose(), Write CStream is in process
                                 of being closed */
#define QCSTRM_ERR13 0x042013 /* qCStreamClose(), Bad close index */
#define QCSTRM_ERR14 0x042014 /* no longer used */

#define QCSTRM_ERR15 0x042015 /* qCStreamPosition(), pIndex is null */

#define QCSTRM_ERR16 0x042016 /* qCStreamFTProcess(), internal error, bad
                                 pmcsIdx on qCStreamFTQue */
#define QCSTRM_ERR17 0x042017 /* qCStreamFTProcess(), internal error, only
                                 QPMCS_CLOSING or QPMCS_INDEX_WAIT states
                                 should be on the qCStreamFTQue */
#define QCSTRM_ERR18 0x042018 /* no longer used */
#define QCSTRM_ERR19 0x042019 /* no longer used */

#define QCSTRM_ERR1A 0x04201a /* qCStreamFTQueAdd(), qCStreamFTQue is full */

#define QCSTRM_ERR1B 0x04201b /* qCStreamFTQueRemove(), pmcsIdx is not on
                                 qCStreamFTQue */

#define QCSTRM_ERR1C 0x04201c /* qCStreamInit(), configured # of cstreams is
                                 too large for this kernel */
#define QCSTRM_ERR1D 0x04201d /* qCStreamInit(), ran out of memory when trying
                                 to allocate pmcs circular buffers */
#define QCSTRM_ERR1E 0x04201e /* */
#define QCSTRM_ERR1F 0x04201f /* */
#define QCSTRM_ERR20 0x042020 /* qCStreamInit(), ran out of memory when trying
                                 to allocate pmcs control structures */
#define QCSTRM_ERR21 0x042021 /* qCStreamInit(), ran out of memory when trying
                                 to allocate cstream ftimer queue */

#define QCSTRM_ERR22 0x042022 /* initPcmBuff(), qOsSemPend failed */

#define QCSTRM_ERR23 0x042023 /* PutInactivePmcsIndex(), internal error,
                                 qPmcsUnusedTos out of range */

#define QCSTRM_ERR24 0x042024 /* qCStreamInit(), ran out of memory when trying
                                 to allocate qPmcsUnusedStack */
#define QCSTRM_ERR25 0x042025 /* qCStreamInit(), ran out of memory when trying
                                 to allocate qWriteSlotPmcsIdxTable */
#define QCSTRM_ERR26 0x042026 /* qCStreamInit(), configured cstream buffer size
                                 is not a power of 2 */
#define QCSTRM_ERR27 0x042027 /* qOnyxCheckFreePMem(), not enough memory to
                                 allocate ping-pong buffers for softmma */
#define QCSTRM_ERR28 0x042028 /* Internal error (Open), pending on
                                 qWINOS_LocalMmaStreamSem semaphore failed. */
#define QCSTRM_ERR29 0x042029 /* Internal error, unable to create
                                 qWINOS_LocalMmaStreamSem semaphore. */
#define QCSTRM_ERR2A 0x04202a /* Internal error (Open), posting
                                 qWINOS_LocalMmaStreamSem semaphore failed. */
#define QCSTRM_ERR2B 0x04202b /* Internal error (Close), pending on
                                 qWINOS_LocalMmaStreamSem semaphore failed. */
#define QCSTRM_ERR2C 0x04202c /* Internal error (Close), posting
                                 qWINOS_LocalMmaStreamSem semaphore failed. */
#define QCSTRM_ERR2D 0x04202d /* Internal error (Close), invalid handle. */
#define QCSTRM_ERR2E 0x04202e /* Internal error (Close), multiple writers
                                 found. */
#define QCSTREAM_TEARDOWN_NOMEMORY 0x04202f /* Teardown's resource tracking
                                  library was unable to allocate memory. */


#define QCSTRM_ERR30 0x042030 /* SerialCStream:Allocate 256 Circular buffer memory failed */
#define QCSTRM_ERR31 0x042031 /* SerialCStream:Allocate 128 Tx Buffer failed */
#define QCSTRM_ERR32 0x042032 /* SerialCStream:Allocate 256 Rx Buffer failed */
#define QCSTRM_ERR33 0x042033 /* SerialCStream:Allocate of pmcs Control memory failed*/
#define QCSTRM_ERR34 0x042034 /* SerialCStream:Passed a NULL pointer to get pmcs index*/
#define QCSTRM_ERR35 0x042035 /* SerialCStream:No free pmcs control structure*/
#define QCSTRM_ERR36 0x042036 /* SerialCStream:Called obsolete cstream API for DTI16*/
#define QCSTRM_ERR37 0x042037 /* SerialCStream:Bad Cstream handle on close*/
#define QCSTRM_ERR38 0x042038 /* SerialCStream:Write open without outbound set*/
#define QCSTRM_ERR39 0x042039 /* SerialCStream:Wrong encoding law, tried ALaw should be Mu*/
#define QCSTRM_ERR3A 0x04203a /* SerialCStream:Wrong encoding law, tried MuLaw shoudl be ALaw*/
#define QCSTRM_ERR3B 0x04203b /* SerialCStream:convertCTx12ToLocalSlot failed */
#define QCSTRM_ERR3C 0x04203c /* SerialCStream:Null pointers passed to SerialStreamOpen*/
#define QCSTRM_ERR3D 0x04203d /* SerialCStream:Same Cstream opened for write*/
#define QCSTRM_ERR3E 0x04203e /* SerialCStream:Trying to close already closed stream*/
#define QCSTRM_ERR3F 0x04203f /* Failure to close CStream Handle */
#define QCSTRM_ERR40 0x042040 /* Unable to allocate space for CStream handles */
#define QCSTRM_ERR41 0x042041 /* SerialCStream:Wrong encoding law, tried Unknown law*/
#define QCSTRM_ERR42 0x042042 /* Failed to allocate QClusterSerXGeo message
                                 -- Serial CStreams*/
#define QCSTRM_ERR43 0x042043 /* CStreamOpen2:convertCTToLocalSlot failed */
#define QCSTRM_ERR44 0x042044 /* Unable to allocate memory for Luna CStream Close list */
#define QCSTRM_ERR45 0x042045 /* CStreamOpen: Slot passed in is -1*/

/*******************************************************************************
* qgstream.c  qErrNo definitions (0x043000 to 0x043fff)
*******************************************************************************/
#define QSTINI_ERR1  0x043001 /* qMmaStrmGlobalInit(), Kernel configuration for
                                 GStreams must be in increasing order of size */
#define QSTINI_ERR2  0x043002 /* qMmaStrmGlobalInit(), internal error,
                                 calculations for # of streams didn't match */
#define QSTINI_ERR3  0x043003 /* qMmaStrmGlobalInit(), qOsSemPend failed */

#define QSTINI_ERR4  0x043004 /* qMmaIpcStrmInit(), qOsSemPend failed */
#define QSTINI_ERR5  0x043005 /* qMmaIpcStrmInit(), qOsSemPend failed */
#define QSTINI_ERR6  0x043006 /* qMmaIpcStrmInit(), qOsSemPend failed */

#define QSTINI_ERR7  0x043007 /* qMmaStrmSysInit(), qOsSemPend failed */

#define QSTINI_ERR8  0x043008 /* qMmaIpcStrmInit(), cpToSpQsize is 0 */
#define QSTINI_ERR9  0x043009 /* qMmaIpcStrmInit(), spToCpQsize is 0 */

/*******************************************************************************
* STREAM sub-system qErrNo definitions (0x044000 to 0x044fff)
*******************************************************************************/
#define QSTREAM_ERR1      0x044001 /* qMmaStrmGlobalInit: failed to allocate
                                      qMmaStrmInit. */
#define QSTREAM_ERR2      0x044002 /* No longer used. */
#define QSTREAM_ERR3      0x044003 /* qMmaStrmGlobalInit: failed to allocate
                                      qKerBoardInit->pMmaStrmInit. */
#define QSTREAM_ERR4      0x044004 /* qMmaStrmGlobalInit: failed to allocate
                                      qMmaStrmInit->ctl. */
#define QSTREAM_ERR5      0x044005 /* qMmaStrmGlobalInit: failed to allocate
                                      qMmaStrmInit->ctlCopy. */
#define QSTREAM_ERR6      0x044006 /* Comments to be included */
#define QSTREAM_ERR7      0x044007 /* Comments to be included */
#define QSTREAM_ERR8      0x044008 /* Comments to be included */
#define QSTREAM_ERR9      0x044009 /* Comments to be included */
#define QSTREAM_ERRA      0x04400a /* Comments to be included */
#define QSTREAM_ERRB      0x04400b /* Comments to be included */
#define QSTREAM_ERRC      0x04400c /* Comments to be included */
#define QSTREAM_ERRD      0x04400d /* Comments to be included */
#define QSTREAM_ERRE      0x04400e /* Comments to be included */
#define QSTREAM_ERRF      0x04400f /* Comments to be included */
#define QSTREAM_ERR10      0x044010 /* Comments to be included */
#define QSTREAM_ERR11      0x044011 /* Comments to be included */
#define QSTREAM_ERR12      0x044012 /* Comments to be included */
#define QSTREAM_ERR13      0x044013 /* Comments to be included */
#define QSTREAM_ERR14      0x044014 /* Comments to be included */
#define QSTREAM_ERR15      0x044015 /* Comments to be included */
#define QSTREAM_ERR16      0x044016 /* Comments to be included */
#define QSTREAM_ERR17      0x044017 /* Comments to be included */
#define QSTREAM_ERR18      0x044018 /* Comments to be included */
#define QSTREAM_ERR19      0x044019 /* Comments to be included */
#define QSTREAM_ERR1A      0x04401a /* Comments to be included */
#define QSTREAM_ERR1B      0x04401b /* Comments to be included */
#define QSTREAM_ERR1C      0x04401c /* Comments to be included */
#define QSTREAM_ERR1D      0x04401d /* Comments to be included */
#define QSTREAM_ERR1E      0x04401e /* Comments to be included */
#define QSTREAM_ERR1F      0x04401f /* Comments to be included */
#define QSTREAM_ERR20      0x044020 /* Comments to be included */
#define QSTREAM_ERR21      0x044021 /* Comments to be included */
#define QSTREAM_ERR22      0x044022 /* Comments to be included */
#define QSTREAM_ERR23      0x044023 /* Comments to be included */
#define QSTREAM_ERR24      0x044024 /* Comments to be included */
#define QSTREAM_ERR25      0x044025 /* Comments to be included */
#define QSTREAM_ERR26      0x044026 /* Comments to be included */
#define QSTREAM_ERR27      0x044027 /* Comments to be included */
#define QSTREAM_ERR28      0x044028 /* Comments to be included */
#define QSTREAM_ERR29      0x044029 /* Comments to be included */
#define QSTREAM_ERR2A      0x04402a /* Comments to be included */
#define QSTREAM_ERR2B      0x04402b /* Comments to be included */
#define QSTREAM_ERR2C      0x04402c /* Comments to be included */
#define QSTREAM_ERR2D      0x04402d /* Comments to be included */
#define QSTREAM_ERR2E      0x04402e /* Comments to be included */
#define QSTREAM_ERR2F      0x04402f /* Comments to be included */
#define QSTREAM_ERR30      0x044030 /* Comments to be included */
#define QSTREAM_ERR31      0x044031 /* Comments to be included */
#define QSTREAM_ERR32      0x044032 /* Comments to be included */
#define QSTREAM_ERR33      0x044033 /* Comments to be included */
#define QSTREAM_ERR34      0x044034 /* Comments to be included */
#define QSTREAM_ERR35      0x044035 /* Comments to be included */
#define QSTREAM_ERR36      0x044036 /* Comments to be included */
#define QSTREAM_ERR37      0x044037 /* Comments to be included */
#define QSTREAM_ERR38      0x044038 /* Comments to be included */
#define QSTREAM_ERR39      0x044039 /* Comments to be included */
#define QSTREAM_ERR3A      0x04403a /* Comments to be included */
#define QSTREAM_ERR3B      0x04403b /* Comments to be included */
#define QSTREAM_ERR3C      0x04403c /* Comments to be included */
#define QSTREAM_ERR3D      0x04403d /* Comments to be included */
#define QSTREAM_ERR3E      0x04403e /* Comments to be included */
#define QSTREAM_ERR3F      0x04403f /* Comments to be included */
#define QSTREAM_ERR40      0x044040 /* Comments to be included */
#define QSTREAM_ERR41      0x044041 /* Comments to be included */
#define QSTREAM_ERR42      0x044042 /* Comments to be included */
#define QSTREAM_ERR43      0x044043 /* Comments to be included */
#define QSTREAM_ERR44      0x044044 /* Comments to be included */
#define QSTREAM_ERR45      0x044045 /* Comments to be included */
#define QSTREAM_ERR46      0x044046 /* Comments to be included */
#define QSTREAM_ERR47      0x044047 /* Comments to be included */
#define QSTREAM_ERR48      0x044048 /* Comments to be included */
#define QSTREAM_ERR49      0x044049 /* Comments to be included */
#define QSTREAM_ERR4A      0x04404a /* Comments to be included */
#define QSTREAM_ERR4B      0x04404b /* Comments to be included */
#define QSTREAM_ERR4C      0x04404c /* Comments to be included */
#define QSTREAM_ERR4D      0x04404d /* Comments to be included */
#define QSTREAM_ERR4E      0x04404e /* Comments to be included */
#define QSTREAM_ERR4F      0x04404f /* Comments to be included */
#define QSTREAM_ERR50      0x044050 /* Comments to be included */
#define QSTREAM_ERR51      0x044051 /* Comments to be included */
#define QSTREAM_ERR52      0x044052 /* Comments to be included */
#define QSTREAM_ERR53      0x044053 /* Comments to be included */
#define QSTREAM_ERR54      0x044054 /* Comments to be included */
#define QSTREAM_ERR55      0x044055 /* Comments to be included */
#define QSTREAM_ERR56      0x044056 /* no longer used */
#define QSTREAM_ERR57      0x044057 /* no longer used */
#define QSTREAM_ERR58      0x044058 /* no longer used */
#define QSTREAM_ERR59      0x044059 /* Comments to be included */
#define QSTREAM_ERR5A      0x04405a /* Comments to be included */
#define QSTREAM_ERR5B      0x04405b /* Comments to be included */
#define QSTREAM_ERR5C      0x04405c /* Comments to be included */
#define QSTREAM_ERR5D      0x04405d /* Comments to be included */
#define QSTREAM_ERR5E      0x04405e /* Comments to be included */
#define QSTREAM_ERR5F      0x04405f /* Comments to be included */
#define QSTREAM_ERR60      0x044060 /* Comments to be included */
#define QSTREAM_ERR61      0x044061 /* Comments to be included */
#define QSTREAM_ERR62      0x044062 /* Pool Find for RemoteInfo Pool
                                       Failed */
#define QSTREAM_ERR63      0x044063 /* qGStreamRemoteOpen Failed to make
                                       MMaIO Call */
#define QSTREAM_ERR64      0x044064 /* Failed to find a Pool that can be
                                      used for qGStreamRemoteOpen */

/*******************************************************************************
* NID sub-system qErrNo definitions (0x049000 to 0x049eff)
*******************************************************************************/
#define NID_NO_ERROR           0        /* No errors */
#define NID_STATUS_DONE        0x049000 /* There were no errors encountered,
                                           function completed successfully */
#define NID_DEVICE_NOT_PRESENT 0x049001 /* network device is not present at the
                                           given address. */
#define NID_BAD_TYPE           0x049002 /* Input type is neither E1 nor T1.*/
#define NID_BAD_DEVICE_ADDRESS 0x049003 /* Input Network Interface does not
                                           agree with the defined addresses. */
#define NID_TOO_MANY_DEVICES   0x049004 /* Attempt to register more than the
                                           maximum number of devices. */
#define NID_BAD_ID             0x049005 /* The specified identifier is not
                                           within the range of registered
                                           identifiers */
#define NID_ALREADY_ENABLED    0x049006 /* History already enabled */
#define NID_ALREADY_DISABLED   0x049007 /* History already disabled */
#define NID_NOT_ENABLED        0x049008 /* History not enabled */
#define NID_NOT_DISABLED       0x049009 /* History not disabled */
#define NID_SCHEDULE_FULL      0x04900a /* No more room in schedule */
#define NID_BAD_TIMESLOT       0x04900b /* Timeslot out of range */
#define NID_BAD_FRAMETYPE      0x04900c /* Illegal Frame Type Value */
#define NID_UNSUPPORTED_FRAMETYPE 0x04900d /* Frame Type Not Supported by Device*/
#define NID_BAD_PARM              0x04900e /* Invalid parameter identifier */
#define NID_BAD_PARM_VALUE        0x04900f /* Invalid parameter value */
#define NID_NOT_SUPPORTED      0x049010    /* Feature not supported */
#define NID_BAD_STATE          0x049011
#define NID_PARM_VAL_BUF_SIZE  0x049012 /* Parameter value buffer too small */
#define NID_WRONG_DEVICE_TYPE  0x049013 /* Wrong device type */
#define NID_NULL_POINTER       0x049014 /* Function parameter points to NULL */
#define QNID_ERR15             0x049015 /* Comments to be included */
#define QNID_ERR16             0x049016 /* Comments to be included */
#define QNID_ERR17             0x049017 /* Comments to be included */
#define QNID_ERR18             0x049018 /* Comments to be included */
#define QNID_ERR19             0x049019 /* Comments to be included */
#define QNID_ERR1A             0x04901a /* Comments to be included */
#define QNID_ERR1B             0x04901b /* Comments to be included */
#define QNID_ERR1C             0x04901c /* Comments to be included */
#define QNID_ERR1D             0x04901d /* Comments to be included */
#define QNID_ERR1E             0x04901e /* Comments to be included */
#define QNID_ERR1F             0x04901f /* Comments to be included */
#define QNID_ERR20             0x049020 /* Comments to be included */
#define QNID_ERR21             0x049021 /* Comments to be included */
#define QNID_ERR22             0x049022 /* Comments to be included */
#define QNID_ERR23             0x049023 /* Comments to be included */
#define QNID_ERR24             0x049024 /* Comments to be included */
#define QNID_ERR25             0x049025 /* Comments to be included */
#define QNID_ERR26             0x049026 /* Comments to be included */
#define QNID_ERR27             0x049027 /* Comments to be included */
#define QNID_ERR28             0x049028 /* Comments to be included */
#define QNID_ERR29             0x049029 /* Comments to be included */
#define QNID_ERR2A             0x04902a /* Comments to be included */
#define QNID_ERR2B             0x04902b /* Comments to be included */
#define QNID_ERR2C             0x04902c /* Comments to be included */
#define QNID_ERR2D             0x04902d /* Comments to be included */
#define QNID_ERR2E             0x04902e /* Comments to be included */
#define QNID_ERR2F             0x04902f /* Comments to be included */
#define QNID_ERR30             0x049030 /* Comments to be included */
#define QNID_ERR31             0x049031 /* Comments to be included */
#define QNID_ERR32             0x049032 /* Comments to be included */
#define QNID_ERR33             0x049033 /* Comments to be included */
#define QNID_ERR34             0x049034 /* Comments to be included */
#define QNID_ERR35             0x049035 /* Comments to be included */
#define QNID_ERR36             0x049036 /* Comments to be included */
#define QNID_ERR37             0x049037 /* Comments to be included */
#define QNID_ERR38             0x049038 /* Comments to be included */
#define QNID_ERR39             0x049039 /* Comments to be included */
#define QNID_ERR3A             0x04903a /* Comments to be included */
#define QNID_ERR3B             0x04903b /* Comments to be included */
#define QNID_ERR3C             0x04903c /* Comments to be included */
#define QNID_ERR3D             0x04903d /* Comments to be included */
#define QNID_ERR3E             0x04903e /* Comments to be included */
#define QNID_ERR3F             0x04903f /* Comments to be included */
#define QNID_ERR40             0x049040 /* Comments to be included */
#define QNID_ERR41             0x049041 /* Comments to be included */
#define QNID_ERR42             0x049042 /* Comments to be included */
#define QNID_ERR43             0x049043 /* Comments to be included */
#define QNID_ERR44             0x049044 /* Comments to be included */
#define QNID_ERR45             0x049045 /* Comments to be included */
#define QNID_ERR46             0x049046 /* Comments to be included */
#define QNID_ERR47             0x049047 /* Comments to be included */
#define QNID_ERR48             0x049048 /* Comments to be included */
#define QNID_ERR49             0x049049 /* Comments to be included */
#define QNID_ERR4A             0x04904a /* Comments to be included */
#define QNID_ERR4B             0x04904b /* Comments to be included */
#define QNID_ERR4C             0x04904c /* Comments to be included */
#define QNID_ERR4D             0x04904d /* Comments to be included */
#define QNID_ERR4E             0x04904e /* Comments to be included */
#define QNID_ERR4F             0x04904f /* Comments to be included */
#define QNID_ERR50             0x049050 /* Comments to be included */
#define QNID_ERR51             0x049051 /* Comments to be included */
#define QNID_ERR52             0x049052 /* Comments to be included */
#define QNID_ERR53             0x049053 /* Comments to be included */
#define QNID_ERR54             0x049054 /* Comments to be included */
#define QNID_ERR55             0x049055 /* Comments to be included */
#define QNID_ERR56             0x049056 /* Comments to be included */
#define QNID_ERR57             0x049057 /* Comments to be included */
#define QNID_ERR58             0x049058 /* Comments to be included */
#define QNID_ERR59             0x049059 /* Comments to be included */
#define QNID_ERR5A             0x04905a /* Comments to be included */
#define QNID_ERR5B             0x04905b /* Comments to be included */
#define QNID_ERR5C             0x04905c /* Comments to be included */
#define QNID_ERR5D             0x04905d /* Comments to be included */
#define QNID_ERR5E             0x04905e /* Comments to be included */
#define QNID_ERR5F             0x04905f /* Comments to be included */
#define QNID_ERR60             0x049060 /* Comments to be included */
#define QNID_ERR61             0x049061 /* Comments to be included */
#define QNID_ERR62             0x049062 /* Comments to be included */

#define NID_MSG_SEND_FAILED    0x049063 /* ESI message send failed */
#define NID_BAD_ENCODING       0x049064 /* Invalid encoding type */

#define QNID_ERR65             0x049065 /* Comments to be included */
#define QNID_ERR66             0x049066 /* Comments to be included */
#define QNID_ERR67             0x049067 /* Comments to be included */
#define QNID_ERR68             0x049068 /* Comments to be included */
#define QNID_ERR69             0x049069 /* Comments to be included */
#define QNID_ERR6A             0x04906A /* Comments to be included */
#define QNID_ERR6B             0x04906B /* Comments to be included */
#define QNID_ERR6C             0x04906C /* Comments to be included */
#define QNID_ERR6D             0x04906D /* Comments to be included */
#define QNID_ERR6E             0x04906E /* Comments to be included */
#define QNID_ERR6F             0x04906F /* Comments to be included */
#define QNID_ERR70             0x049070 /* Comments to be included */
#define QNID_ERR71             0x049071 /* Comments to be included */
#define QNID_ERR72             0x049072 /* Comments to be included */
#define QNID_ERR73             0x049073 /* Comments to be included */
#define QNID_ERR74             0x049074 /* Comments to be included */
#define QNID_ERR75             0x049075 /* Comments to be included */
#define QNID_ERR76             0x049076 /* Comments to be included */
#define QNID_ERR77             0x049077 /* Comments to be included */
#define QNID_ERR78             0x049078 /* Comments to be included */
#define QNID_ERR79             0x049079 /* Comments to be included */
#define QNID_ERR7A             0x04907A /* Comments to be included */
#define QNID_ERR7B             0x04907B /* Comments to be included */
#define QNID_ERR7C             0x04907C /* Comments to be included */
#define QNID_ERR7D             0x04907D /* Comments to be included */
#define QNID_ERR7E             0x04907E /* Comments to be included */
#define QNID_ERR7F             0x04907F /* Comments to be included */
#define QNID_ERR80             0x049080 /* Comments to be included */
#define QNID_ERR81             0x049081 /* Comments to be included */
#define QNID_ERR82             0x049082 /* Comments to be included */
#define QNID_ERR83             0x049083 /* Comments to be included */
#define QNID_ERR84             0x049084 /* Comments to be included */
#define QNID_ERR85             0x049085 /* Comments to be included */
#define QNID_ERR86             0x049086 /* Comments to be included */
#define QNID_ERR87             0x049087 /* Comments to be included */
#define QNID_ERR88             0x049088 /* Comments to be included */
#define QNID_ERR89             0x049089 /* Comments to be included */
#define QNID_ERR8A             0x04908A /* Comments to be included */
#define QNID_ERR8B             0x04908B /* Comments to be included */
#define QNID_ERR8C             0x04908C /* Comments to be included */
#define QNID_ERR8D             0x04908D /* Comments to be included */
#define QNID_ERR8E             0x04908E /* Comments to be included */
#define QNID_ERR8F             0x04908F /* Comments to be included */
#define QNID_ERR90             0x049090 /* Comments to be included */
#define QNID_ERR91             0x049091 /* Comments to be included */
#define QNID_ERR92             0x049092 /* Comments to be included */
#define QNID_ERR93             0x049093 /* Comments to be included */
#define QNID_ERR94             0x049094 /* Comments to be included */
#define QNID_ERR95             0x049095 /* Comments to be included */
#define QNID_ERR96             0x049096 /* Comments to be included */
#define QNID_ERR97             0x049097 /* Comments to be included */
#define QNID_ERR98             0x049098 /* Comments to be included */
#define QNID_ERR99             0x049099 /* Comments to be included */
#define QNID_ERR9A             0x04909A /* Comments to be included */
#define QNID_ERR9B             0x04909B /* Comments to be included */
#define QNID_ERR9C             0x04909C /* Comments to be included */
#define QNID_ERR9D             0x04909D /* Comments to be included */
#define QNID_ERR9E             0x04909E /* Comments to be included */
#define QNID_ERR9F             0x04909F /* Comments to be included */
#define QNID_ERRA0             0x0490A0 /* Comments to be included */
#define QNID_ERRA1             0x0490A1 /* Comments to be included */
#define QNID_ERRA2             0x0490A2 /* Comments to be included */
#define QNID_ERRA3             0x0490A3 /* Comments to be included */
#define QNID_ERRA4             0x0490A4 /* Comments to be included */
#define QNID_ERRA5             0x0490A5 /* NID semaphore create failed */
#define QNID_ERRA6             0x0490A6 /* NID semaphore create failed */
#define QNID_ERRA7             0x0490A7 /* NID semaphore create failed */
#define QNID_ERRA8             0x0490A8 /* NID semaphore create failed */
#define NID_PORT_MODE_MISMATCH 0x0490A9 /* Port mode does not match another
                                           port on same device */
#define NID_BAD_SIG_BITS       0x0490AA /* ABCD bit pattern is invalid */
#define QNID_ERRAB             0x0490AB /* HDSI Firmware out of rev */
#define QNID_ERRAC             0x0490AC /* ESI Global Parm Semaphore
                                           creation failed */
#define QNID_ERRAD             0x0490AD /* Mismatched XC/QSLAC (NID) library
                                           version */
#define QNID_ERRAE             0x0490AE /* Mismatched ESI (NID) library
                                           version */
#define QNID_ERRAF             0x0490AF /* Mismatched COMET (NID) library
                                           version */
#define QNID_ERRB0             0x0490B0 /* Max T1 PMon poll count exceeded */
#define QNID_ERRB1             0x0490B1 /* Max E1 PMon poll count exceeded */
#define QNID_ERRB2             0x0490B2 /* Call to trace subsystem failed */
#define QNID_ERRB3             0x0490B3 /* Call to trace subsystem failed */
#define NID_BAD_DIAG_MODE      0x0490B4 /* Diagnostic mode is invalid */
#define QNID_ERRB5             0x0490B5 /* qOsSemPost failed in qCometControllerUnlock() */
#define QNID_ERRB6             0x0490B6 /* qOsSemPend failed in qCometControllerLock() */
#define QNID_ERRB7             0x0490B7 /* Failed to setup Comet LIU equalizer */
/* 0x0490B8 - 0x04910F reserved */
#define QNID_ERR110            0x049110 /* Unknown or unsupported board type */



/*******************************************************************************
* Board law qErrNo definitions (0x0490f00-0x049fff)
*******************************************************************************/
#define QLAW_BAD_TYPE                0x490f00 /* Invalid law type specified */
#define QLAW_MODE_SET_FAILED         0x490f01 /* Failed to set conversion mode */
#define QLAW_ALREADY_SET             0x490f02 /* Board law can only be set once */
#define QLAW_BAD_NET_IF_TYPE         0x490f03 /* Unknown or unexpected network interface type */
#define QLAW_BAD_NET_IF_ID           0x490f04 /* Invalid network interface identifier */
#define QLAW_BAD_IDLE                0x490f05 /* Invalid idle pattern */
#define QLAW_ERR6                    0x490f06 /* TSP is trying to set wrong conversion mode for CG7 */
#define QLAW_ERR7                    0x490f07 /* TSP is trying to set mixed PCM law values */
#define QLAW_ERR8                    0x490f08 /* TDM BUS law already set by Host Admin */
#define QLAW_ERR9                    0x490f09 /* Different TDM BUS law already set by Host Admin */
#define QLAW_ERRA                    0x490f0a /* TDM BUS law already set by FCD parameter */
#define QLAW_ERRB                    0x490f0b /* Different TDM BUS law already set by FCD parameter */
#define QLAW_ERRC                    0x490f0C /* TSP or MOH is trying to set wrong conversion mode for CG7 */


/*******************************************************************************
* qmmalib.c qErrNo definitions (0x050000-0x050fff)
*******************************************************************************/
#define QMMA_ERR1    0x050001 /* qMmaSimpleIO(), bad count parameter passed */
#define QMMA_ERR2    0x050002 /* qMmaSimpleIO(), bad global address passed */
#define QMMA_ERR3    0x050003 /* qMmaSimpleIO(), bad local address passed */
#define QMMA_ERR4    0x050004 /* qMmaSimpleIO(), bad options for this call */
#define QMMA_ERR5    0x050005 /* qMmaSimpleIO(), internal error, sem pend
                                 failed */
#define QMMA_ERR6    0x050006 /* qMmaSimpleIO(), internal error, GMCS full */
#define QMMA_ERR7    0x050007 /* qMmaSimpleIO(), internal error, request list
                                 corrupted */
#define QMMA_ERR8    0x050008 /* qMmaIO(), bad count parameter passed */
#define QMMA_ERR9    0x050009 /* qMmaIO(), bad global address passed */
#define QMMA_ERRA    0x05000a /* qMmaIO(), bad local address passed */
#define QMMA_ERRB    0x05000b /* qMmaIO(), bad options for this call */
#define QMMA_ERRC    0x05000c /* qMmaIO(), bad mma semaphore # */
#define QMMA_ERRD    0x05000d /* qMmaIO(), processor specified to receive
                                 interrupt is invalid */
#define QMMA_ERRE    0x05000e /* qMmaIO(), internal error, sem pend failed */
#define QMMA_ERRF    0x05000f /* qMmaIO(), internal error, GMCS full */
#define QMMA_ERR10   0x050010 /* qMmaIO(), internal error, request list
                                 corrupted */
#define QMMA_ERR11   0x050011 /* qMmaSetFrameTDM(), bad opCode passed */
#define QMMA_ERR12   0x050012 /* qMmaSetFrameTDM(), attempting to change to
                                 the current state */
#define QMMA_ERR13   0x050013 /* qMmaSetFrameTDM(), internal error, GMCS full */
#define QMMA_ERR14   0x050014 /* qMmaSetFrameTDM(), internal error, request
                                 list corrupted */
#define QMMA_ERR15   0x050015 /* qMmaLoad(), This command cannot be issued if
                                 TDM is ENABLED */
#define QMMA_ERR16   0x050016 /* qMmaLoad(), bad count parameter passed */
#define QMMA_ERR17   0x050017 /* qMmaLoad(), bad global address passed */
#define QMMA_ERR18   0x050018 /* qMmaLoad(), bad options for this call */
#define QMMA_ERR19   0x050019 /* qMmaLoad(), bad processor specified for target
                                 of download or upload */
#define QMMA_ERR1A   0x05001a /* qMmaLoad(), internal error, GMCS full */
#define QMMA_ERR1B   0x05001b /* qMmaLoad(), internal error, request list
                                 corrupted */
#define QMMA_ERR1C   0x05001c /* qMmaLinked(), bad count parameter passed */
#define QMMA_ERR1D   0x05001d /* qMmaLinked(), bad address for stream handle */
#define QMMA_ERR1E   0x05001e /* qMmaLinked(), bad options for this call */
#define QMMA_ERR1F   0x05001f /* qMmaLinked(), bad mma command */
#define QMMA_ERR20   0x050020 /* qMmaLinked(), stream handle contains bad index
                                 (bad handle) */
#define QMMA_ERR21   0x050021 /* qMmaLinked(), bad local buffer address */
#define QMMA_ERR22   0x050022 /* qMmaLinked(), internal error, sem pend failed*/
#define QMMA_ERR23   0x050023 /* qMmaLinked(), internal error, request list
                                 corrupted */
#define QMMA_ERR24   0x050024 /* qMmaLinked(), internal error, GMCS full */
#define QMMA_ERR25   0x050025 /* qMmaQueueIO(), bad local buffer address */
#define QMMA_ERR26   0x050026 /* qMmaQueueIO(), bad options for this call */
#define QMMA_ERR27   0x050027 /* qMmaQueueIO(), internal error, sem pend
                                 failed */
#define QMMA_ERR28   0x050028 /* qMmaQueueIO(), internal error, GMCS full */
#define QMMA_ERR29   0x050029 /* qMmaQueueIO(), internal error, request list
                                 corrupted */
#define QMMA_ERR2A   0x05002a /* qMmaQueueIO(), bad offset passed */
#define QMMA_ERR2B   0x05002b /* qMmaQueueIO(), bad count passed */
#define QMMA_ERR2C   0x05002c /* qMmaQueueIO(), internal error, GMCS full */
#define QMMA_ERR2D   0x05002d /* qMmaQueueIO(), internal error, request list
                                 corrupted */
#define QMMA_ERR2E   0x05002e /* qMmaQueueIO(), internal error, sem pend
                                 failed */
#define QMMA_ERR2F   0x05002f /* qMmaQueueIO(), internal error, GMCS full */
#define QMMA_ERR30   0x050030 /* qMmaSendSigs(), internal error, request list
                                 corrupted */
#define QMMA_ERR31   0x050031 /* qMmaSendSigs(), internal error, sem pend
                                 failed */
#define QMMA_ERR32   0x050032 /* qMmaSendSigs(), internal error, GMCS full */
#define QMMA_ERR33   0x050033 /* qMmaSendSigs(), internal error, request list
                                 corrupted */
#define QMMA_ERR34   0x050034 /* qMmaWaitGmcsCnt(), internal error,
                                 qOsTaskSetPri to lower priority failed */
#define QMMA_ERR35   0x050035 /* qMmaWaitGmcsCnt(), internal error,
                                 gmcsCnt is less than zero */
#define QMMA_ERR36   0x050036 /* qMmaWaitGmcsCnt(), internal error,
                                 qOsTaskSleep of zero failed */
#define QMMA_ERR37   0x050037 /* qMmaWaitGmcsCnt(), internal error,
                                 qOsTaskSetPri to original priority failed */
#define QMMA_ERR38   0x050038 /* qMmaQueueIO(), bad count parameter passed */
#define QMMA_ERR39   0x050039 /* MMA time slice parameter out of range */
#define QMMA_ERR3A   0x05003a /* Comments to be included */
#define QMMA_ERR3B   0x05003b /* Comments to be included */
#define QMMA_ERR3C   0x05003c /* Comments to be included */
#define QMMA_ERR3D   0x05003d /* Comments to be included */
#define QMMA_ERR3E   0x05003e /* Comments to be included */
#define QMMA_ERR3F   0x05003f /* Comments to be included */
#define QMMA_ERR40   0x050040 /* Comments to be included */
#define QMMA_ERR41   0x050041 /* Comments to be included */
#define QMMA_ERR42   0x050042 /* Comments to be included */
#define QMMA_ERR43   0x050043 /* Comments to be included */
#define QMMA_ERR44   0x050044 /* Comments to be included */
#define QMMA_ERR45   0x050045 /* Comments to be included */
#define QMMA_ERR46   0x050046 /* Comments to be included */
#define QMMA_ERR47   0x050047 /* Comments to be included */
#define QMMA_ERR48   0x050048 /* Comments to be included */
#define QMMA_ERR49   0x050049 /* Comments to be included */
#define QMMA_ERR4A   0x05004a /* Comments to be included */
#define QMMA_ERR4B   0x05004b /* Comments to be included */
#define QMMA_ERR4C   0x05004c /* Comments to be included */
#define QMMA_ERR4D   0x05004d /* Comments to be included */
#define QMMA_ERR4E   0x05004e /* Comments to be included */
#define QMMA_ERR4F   0x05004f /* Comments to be included */
#define QMMA_ERR50   0x050050 /* qMmaWaitGmcsCnt(), post to
											qMmaGetGmcsSem failed */
#define QMMA_ERR51   0x050051 /* qMmaWaitGmcsCnt(), pend on
											qMmaWaitGmcsSem failed */
#define QMMA_ERR52   0x050052 /* qMmaWaitGmcsCnt(), post to
											qMmaWaitGmcsSem failed */
#define QMMA_ERR53   0x050053 /* qMmaSimpleIOPreAlloc bad lcl addr */
#define QMMA_ERR54   0x050054 /* qMmaBGSimpleIO bad lcl addr */
#define QMMA_ERR55   0x050055 /* Unable to create mma startup sem */
#define QMMA_ERR56   0x050056 /* qMmaSPSimpleIO bad count */
#define QMMA_ERR57   0x050057 /* qMmaSPSimpleIO bad global address */
#define QMMA_ERR58   0x050058 /* qMmaSPSimpleIO bad options */
#define QMMA_ERR59   0x050059 /* qMmaSPSimpleIO bad processor number */
#define QMMA_ERR5A   0x05005A /* qMmaSPSimpleIO bad request list entry */


/*******************************************************************************
* qmmabg.c qErrNo definitions (0x051000-0x051fff)
*******************************************************************************/
#define QMMABG_ERR1  0x051001 /* qMmaRestoreSigIsr(), Internal error,
                                 qNumIpcReadOps should be zero */
#define QMMABG_ERR2  0x051002 /* processIpcSig(), we should never get here on
                                 the simulator */
#define QMMABG_ERR3  0x051003 /* processIpcSig(), Internal error,
                                 qNumIpcReadOps should be zero */
#define QMMABG_ERR4  0x051004 /* processIpcSig(), incomplete message on CP IPC
                                 read queue (size is less than message headr) */
#define QMMABG_ERR5  0x051005 /* processIpcSig(), incomplete message on SP IPC
                                 read queue (size is less than message headr) */
#define QMMABG_ERR6  0x051006 /* mmaBGTsk(), internal error, mmaSyncSem pend
                                 failed */
#define QMMABG_ERR7  0x051007 /* mmaBGTsk(), internal error, complete list
                                 corrupted */
#define QMMABG_ERR8  0x051008 /* mmaBGTsk(), bad mma callback function address*/
#define QMMABG_ERR9  0x051009 /* mmaBGTsk(), internal error, failed list
                                 corrupted */
#define QMMABG_ERRA  0x05100a /* mmaBGTsk(), internal error, gmcsCnt greater
                                 than gmcsSize */
#define QMMABG_ERRB  0x05100b /* processIPCSig(), count is zero or negative */
#define QMMABG_ERRC  0x05100c /* mmaBGTsk(), QMMA_SIG_IPC_READ called on
											SP_NONE platform */
#define QMMABG_ERRD  0x05100d /* mmaBGTsk(), qOsTaskExit called (note that this
											isn't really an error condition). */

/*******************************************************************************
* qmmaisr.c qErrNo definitions (0x052000-0x052fff)
*******************************************************************************/
#define QMMAISRERR1  0x052001 /* qMmaIsrLinkedRead(), bad count field in
                                 request entry */
#define QMMAISRERR2  0x052002 /* qMmaIsrLinkedRead(), bad offset field in
                                 request entry */
#define QMMAISRERR3  0x052003 /* qMmaIsrLinkedRead(), bad count field in
                                 request entry */
#define QMMAISRERR4  0x052004 /* qMmaIsrLinkedRead(), bad processor number for
                                 interrupt (stream ctl struct corrupted) */
#define QMMAISRERR5  0x052005 /* qMmaIsrLinkedWrite(), bad count field in
                                 request entry */
#define QMMAISRERR6  0x052006 /* qMmaIsrLinkedWrite(), bad offset field in
                                 request entry */
#define QMMAISRERR7  0x052007 /* qMmaIsrLinkedWrite(), bad count field in
                                 request entry */
#define QMMAISRERR8  0x052008 /* qMmaIsrLinkedWrite(), bad processor number
                                 for interrupt (stream ctl struct corrupted) */
#define QMMAISRERR9  0x052009 /* qMmaIsrProcSecondary(), qMmaLinkedCount is 0 */
#define QMMAISRERRA  0x05200a /* qMmaIsrPutPended(), qMmaLinkedCount is 0 */
#define QMMAISRERRB  0x05200b /* qMmaIsr(), qMmaState == QMMA_TDM_DISABLE,
                                 gmcsBase->tail != 1 */
#define QMMAISRERRC  0x05200c /* qMmaIsr(), qMmaState == QMMA_TDM_DISABLE,
                                 request list corrupted */
#define QMMAISRERRD  0x05200d /* qMmaIsr(), qMmaState == QMMA_TDM_DISABLE,
                                 more than 1 entry is on the request list */
#define QMMAISRERRE  0x05200e /* qMmaIsr(), qMmaState == QMMA_TDM_DISABLE,
                                 linked transactions not allowed in this mode */
#define QMMAISRERRF  0x05200f /* qMmaIsr(), QGMCS_OPCODE == QGMCS_DISABLE_TDM,
                                 this is not the last item on the gmcs */
#define QMMAISRERR10 0x052010 /* qMmaIsr(), QGMCS_OPCODE == QGMCS_DISABLE_TDM,
                                 request list is corrupted */
#define QMMAISRERR11 0x052011 /* qMmaIsr(), request list is corrupted */
#define QMMAISRERR12 0x052012 /* qMmaIsr(), secondary commands for non-blocked
                                 stream complete, qMmaLinkedCount is non-zero */
#define QMMAISRERR13 0x052013 /* qMmaIsr(), Secondary commands  NOT completed
                                 and gmcs is empty */


/*******************************************************************************
* mma subsystem reqlst.c qErrNo definitions (0x053000-0x053fff)
*******************************************************************************/
#define QMMAREQ_ERR1 0x053001 /* sigCtlCmdInit(), qMmaStrtupSem pend failed */


/*******************************************************************************
* mma subsystem mma.c qErrNo definitions (0x054000-0x054fff)
*******************************************************************************/
#define QMMAINI_ERR1 0x054001 /* qMmaCbStartup(), qMmaStrtupSem post failed */
#define QMMAINI_ERR2 0x054002 /* sigCtlCmdInit(), qMmaStrtupSem pend failed */
#define QMMAINI_ERR3 0x054003 /* initMmaLib(), unable to create mmaSyncSem */
#define QMMAINI_ERR4 0x054004 /* initMmaLib(), unable to create
											qMmaWaitGmcsSem */
#define QMMAINI_ERR5 0x054005 /* initMmaLib(), unable to create
										 qMmaGetGmcsSem */

/*******************************************************************************
* soft mma subsystem  qErrNo definitions (0x056000-0x056fff)
*******************************************************************************/
#define QSFTMMA_ERR1        0x056001 /* Comments to be included */
#define QSFTMMA_ERR2        0x056002 /* Comments to be included */
#define QSFTMMA_ERR3        0x056003 /* Comments to be included */
#define QSFTMMA_ERR4        0x056004 /* Comments to be included */
#define QSFTMMA_ERR5        0x056005 /* Comments to be included */
#define QSFTMMA_ERR6        0x056006 /* Comments to be included */
#define QSFTMMA_ERR7        0x056007 /* Comments to be included */
#define QSFTMMA_ERR8        0x056008 /* Comments to be included */
#define QSFTMMA_ERR9        0x056009 /* Comments to be included */
#define QSFTMMA_ERRA        0x05600a /* Comments to be included */
#define QSFTMMA_ERRB        0x05600b /* Comments to be included */
#define QSFTMMA_ERRC        0x05600c /* Comments to be included */
#define QSFTMMA_ERRD        0x05600d /* Comments to be included */
#define QSFTMMA_ERRE        0x05600e /* Comments to be included */
#define QSFTMMA_ERRF        0x05600f /* Comments to be included */
#define QSFTMMA_ERR10       0x056010 /* Comments to be included */
#define QSFTMMA_ERR11       0x056011 /* Comments to be included */
#define QSFTMMA_ERR12       0x056012 /* Comments to be included */
#define QSFTMMA_ERR13       0x056013 /* Comments to be included */
#define QSFTMMA_ERR14       0x056014 /* Comments to be included */
#define QSFTMMA_ERR15       0x056015 /* Comments to be included */
#define QSFTMMA_ERR16       0x056016 /* Comments to be included */
#define QSFTMMA_ERR17       0x056017 /* Comments to be included */
#define QSFTMMA_ERR18       0x056018 /* Comments to be included */
#define QSFTMMA_ERR19       0x056019 /* Comments to be included */
#define QSFTMMA_ERR1A       0x05601a /* Comments to be included */
#define QSFTMMA_ERR1B       0x05601b /* Comments to be included */
#define QSFTMMA_ERR1C       0x05601c /* Comments to be included */
#define QSFTMMA_ERR1D       0x05601d /* Comments to be included */
#define QSFTMMA_ERR1E       0x05601e /* Comments to be included */
#define QSFTMMA_ERR1F       0x05601f /* Comments to be included */
#define QSFTMMA_ERR20       0x056020 /* Comments to be included */
#define QSFTMMA_ERR21       0x056021 /* Comments to be included */
#define QSFTMMA_ERR22       0x056022 /* Comments to be included */
#define QSFTMMA_ERR23       0x056023 /* Comments to be included */
#define QSFTMMA_ERR24       0x056024 /* Comments to be included */
#define QSFTMMA_ERR25       0x056025 /* Comments to be included */

/*******************************************************************************
* Third Rock SoftMMA (dmxscale.c) qErrNo definitions (0x057000-0x057fff)
*******************************************************************************/
#define QDM_ERR1            0x057001
#define QDM_ERR2            0x057002
#define QDM_ERR3            0x057003
#define QDM_ERR4            0x057004
#define QDM_ERR5            0x057005
#define QDM_ERR6            0x057006
#define QDM_ERR7            0x057007
#define QDM_ERR8            0x057008
#define QDM_ERR9            0x057009
#define QDM_ERRA            0x05700A
#define QDM_ERRB            0x05700B
#define QDM_ERRC            0x05700C
#define QDM_ERRD            0x05700D
#define QDM_ERRE            0x05700E
#define QDM_ERRF            0x05700F
#define QDM_ERR10           0x057010
#define QDM_ERR11           0x057011
#define QDM_ERR12           0x057012
#define QDM_ERR13           0x057013
#define QDM_ERR14           0x057014
#define QDM_ERR15           0x057015
#define QDM_ERR16           0x057016
#define QDM_ERR17           0x057017
#define QDM_ERR18           0x057018
#define QDM_ERR19           0x057019
#define QDM_ERR1A           0x05701A
#define QDM_ERR1B           0x05701B
#define QDM_ERR1C           0x05701C
#define QDM_ERR1D           0x05701D
#define QDM_ERR1E           0x05701E
#define QDM_ERR1F           0x05701F
#define QDM_ERR20           0x057020
#define QDM_ERR21           0x057021
#define QDM_ERR22           0x057022
#define QDM_ERR23           0x057023
#define QDM_ERR24           0x057024
#define QDM_ERR25           0x057025
#define QDM_ERR26           0x057026
#define QDM_ERR27           0x057027
#define QDM_ERR28           0x057028
#define QDM_ERR29           0x057029
#define QDM_ERR2A           0x05702A
#define QDM_ERR2B           0x05702B
#define QDM_ERR2C           0x05702C

/*******************************************************************************
* ftimer subsystem ftimer.c qErrNo definitions (0x058000-0x058fff)
*******************************************************************************/
#define QFTMR_ERR1   0x058001 /* qFTimerSet2(), Can't support intervals which
                                 are lower than the system resolution*/
#define QFTMR_ERR2   0x058002 /* qFTimerSet2(), NULL pHandle passed */
#define QFTMR_ERR3   0x058003 /* qFTimerSet2(), No more timers available */
#define QFTMR_ERR4   0x058004 /* qFTimerSet2(), internal error, invalid state
                                 mask */

#define QFTMR_ERR5   0x058005 /* startFtimer(), internal error, timeleft is
                                 greater than # of samples per tick */

#define QFTMR_ERR6   0x058006 /* qFTimerTask(), message write failed */

#define QFTMR_ERR7   0x058007 /* qFTimerReset(), bad timer handle passed */
#define QFTMR_ERR8   0x058008 /* qFTimerCancel(), bad timer handle passed */
#define QFTMR_ERR9   0x058009 /* qFTimerWait(), bad timer handle passed
                                 (out of range) */
#define QFTMR_ERRA   0x05800a /* qFTimerWait(), bad timer handle passed
                                 (wrong state) */
#define QFTMR_ERRB   0x05800b /* qFTimerStatus(), bad timer handle passed
                                 (out of range)*/

#define QFTMR_ERRC   0x05800c /* qFTimerSet(), bad component descriptor */

#define QFTMR_ERRD   0x05800d /* qFTimerSysInit(), invalid # of frame timers in
                                 cfg file */

#define QFTMR_ERRE   0x05800e /* cancelTimer(), internal error, bad tree
                                 index */
#define QFTMR_ERRF   0x05800f /* qFTimerStatus(), NULL pStatus passed */

#define QFTMR_ERR10  0x058010 /* qFTimerSet(), Invalid interval; not multiple of
                                 of QFTIMER_SAMPLES_PER_TICK */
#define QFTMR_ERR11  0x058011 /* qFTimerSet3(), Invalid offset value ; not
                                 multiple of QFTIMER_SAMPLES_PER_TICK */
#define QFTMR_ERR12  0x058012 /* Comments to be included */
#define QFTMR_ERR13  0x058013 /* Comments to be included */
#define QFTMR_ERR14  0x058014 /* Comments to be included */
#define QFTMR_ERR15  0x058015 /* Comments to be included */
#define QFTMR_ERR16  0x058016 /* Comments to be included */
#define QFTMR_ERR17  0x058017 /* Comments to be included */
#define QFTMR_ERR18  0x058018 /* Comments to be included */
#define QFTMR_ERR19  0x058019 /* Comments to be included */
#define QFTMR_ERR1A  0x05801a /* Comments to be included */
#define QFTMR_ERR1B  0x05801b /* Comments to be included */
#define QFTMR_ERR1C  0x05801c /* Comments to be included */
#define QFTMR_ERR1D  0x05801d /* Comments to be included */
#define QFTMR_ERR1E  0x05801e /* Comments to be included */
#define QFTMR_ERR1F  0x05801f /* Comments to be included */
#define QFTMR_ERR20  0x058020 /* Comments to be included */
#define QFTMR_ERR21  0x058021 /* Comments to be included */
#define QFTMR_ERR22  0x058022 /* Comments to be included */
#define QFTMR_ERR23  0x058023 /* Comments to be included */
#define QFTMR_ERR24  0x058024 /* Comments to be included */
#define QFTMR_ERR25  0x058025 /* Comments to be included */
#define QFTMR_ERR26  0x058026 /* Comments to be included */
#define QFTMR_ERR27  0x058027 /* Comments to be included */
#define QFTMR_ERR28  0x058028 /* Boot tick Semaphore Create Failure   */
#define QFTMR_ERR29  0x058029 /* Boot timer task failed to create */
#define QFTMR_ERR2A  0x05802a /* Boot tick Semaphore pend Failure */
#define QFTMR_ERR2B  0x05802b /* Null Ftimer passed to qFtimerCancel */
#define QFTMR_ERR2C  0x05802c /* qFTimerTask exit code, frame timer
                                 tree validation failed. */
#define QFTMR_ERR2D  0x05802d /* Failed to get the initial C Stream Position
								 when initializing the qCurrSystime.This is
								 only under Luna */
#define QFTMR_ERR2E  0x05802e /* Semaphore Tick Post failed*/
#define QFTMR_ERR2F  0x05802f /* Semaphore Tick Post failed */
#define QFTMR_ERR30  0x058030 /* Semaphore Tick Post failed */
#define QFTMR_ERR31  0x058031 /* Deleted */
#define QFTMR_ERR32  0x058032 /* Deleted */
#define QFTMR_ERR33  0x058033 /* Semaphore Tick Post failed */
#define QFTMR_ERR34  0x058034 /* Semaphore Tick Post failed */
#define QFTMR_ERR35  0x058035 /* Semaphore Tick Post failed */
#define QFTMR_ERR36  0x058036 /* Semaphore Tick Post failed */
#define QFTMR_ERR37  0x058037 /* Semaphore MMA  Post failed */

/*******************************************************************************
* ftimer mma subsystem ftimer.c qErrNo definitions (0x058400-0x058fff)
*******************************************************************************/
#define QFTMRMMA_ERR1    0x058401 /* Comments to be included */
#define QFTMRMMA_ERR2    0x058402 /* Comments to be included */
#define QFTMRMMA_ERR3    0x058403 /* Comments to be included */
#define QFTMRMMA_ERR4    0x058404 /* Comments to be included */
#define QFTMRMMA_ERR5    0x058405 /* Comments to be included */
#define QFTMRMMA_ERR6    0x058406 /* Comments to be included */
#define QFTMRMMA_ERR7    0x058407 /* Comments to be included */
#define QFTMRMMA_ERR8    0x058408 /* Comments to be included */
#define QFTMRMMA_ERR9    0x058409 /* Comments to be included */
#define QFTMRMMA_ERRA    0x05840a /* Comments to be included */
#define QFTMRMMA_ERRB    0x05840b /* Comments to be included */
#define QFTMRMMA_ERRC    0x05840c /* Comments to be included */
#define QFTMRMMA_ERRD    0x05840d /* Comments to be included */
#define QFTMRMMA_ERRE    0x05840e /* Comments to be included */
#define QFTMRMMA_ERRF    0x05840f /* Comments to be included */
#define QFTMRMMA_ERR10   0x058410 /* Comments to be included */
#define QFTMRMMA_ERR11   0x058411 /* Comments to be included */
#define QFTMRMMA_ERR12   0x058412 /* Comments to be included */
#define QFTMRMMA_ERR13   0x058413 /* Comments to be included */
#define QFTMRMMA_ERR14   0x058414 /* Comments to be included */

/*******************************************************************************
* AGENT sub-system qErrNo definitions (0x060000 to 0x067fff)
*******************************************************************************/
#define QAGENT_ERR1       0x060000   /* Kernel Debug Command: invalid # of parms */
#define QAGENT_ERR2       0x060001   /* Unsupported kernel debug command */
#define QAGENT_ERR3       0x060002   /* Kernel Debug Command: too many parms, max=20 */
#define QAGENT_ERR4       0x060003 /* Comments to be included */
#define QAGENT_ERR5       0x060004 /* Comments to be included */
#define QAGENT_ERR6       0x060005 /* Comments to be included */
#define QAGENT_ERR7       0x060006 /* Comments to be included */
#define QAGENT_ERR8       0x060007 /* Comments to be included */
#define QAGENT_ERR9       0x060008 /* Comments to be included */
#define QAGENT_ERRA       0x060009 /* Comments to be included */
#define QAGENT_ERRB       0x06000a /* Comments to be included */
#define QAGENT_ERRC       0x06000b /* Comments to be included */
#define QAGENT_ERRD       0x06000c /* Comments to be included */
#define QAGENT_ERRE       0x06000d /* Comments to be included */
#define QAGENT_ERRF       0x06000e /* Comments to be included */
#define QAGENT_ERR10      0x06000f /* Comments to be included */
#define QAGENT_ERR11      0x060010 /* Comments to be included */
#define QAGENT_ERR12      0x060011 /* Comments to be included */
#define QAGENT_ERR13      0x060012 /* Comments to be included */
#define QAGENT_ERR14      0x060013 /* Comments to be included */
#define QAGENT_ERR15      0x060014 /* Comments to be included */
#define QAGENT_ERR16      0x060015 /* Comments to be included */
#define QAGENT_ERR17      0x060016 /* Comments to be included */
#define QAGENT_ERR18      0x060017 /* Comments to be included */
#define QAGENT_ERR19      0x060018 /* Comments to be included */
#define QAGENT_ERR1A      0x060019 /* Comments to be included */
#define QAGENT_ERR1B      0x06001a /* no longer used */
#define QAGENT_ERR1C      0x06001b /* Comments to be included */
#define QAGENT_ERR1D      0x06001c /* no longer used */
#define QAGENT_ERR1E      0x06001d /* no longer used */
#define QAGENT_ERR1F      0x06001e /* no longer used */
#define QAGENT_ERR20      0x06001f /* no longer used */
#define QAGENT_ERR21      0x060020 /* In QModuleUnload handler, the call to
												  qUnloadModules() did not return
												  QSTATUS_DONE.  This is just an
												  advisory. */
#define QAGENT_ERR22      0x060021 /* Comments to be included */
#define QAGENT_ERR23      0x060022 /* In qUnloadModules, posting the
												  qModuleUnloadSem semaphore did not return
												  QSTATUS_DONE. */
#define QAGENT_ERR24      0x060023 /* no longer used */
#define QAGENT_ERR25      0x060024 /* Comments to be included */
#define QAGENT_ERR26      0x060025 /* Comments to be included */
#define QAGENT_ERR27      0x060026 /* Comments to be included */
#define QAGENT_ERR28      0x060027 /* Comments to be included */
#define QAGENT_ERR29      0x060028 /* Comments to be included */
#define QAGENT_ERR2A      0x060029 /* Comments to be included */
#define QAGENT_ERR2B      0x06002a /* Comments to be included */
#define QAGENT_ERR2C      0x06002b /* Comments to be included */
#define QAGENT_ERR2D      0x06002c /* Comments to be included */
#define QAGENT_ERR2E      0x06002d /* Comments to be included */
#define QAGENT_ERR2F      0x06002e /* Comments to be included */
#define QAGENT_ERR30      0x06002f /* Comments to be included */
#define QAGENT_ERR31      0x060030 /* Comments to be included */
#define QAGENT_ERR32      0x060031 /* Comments to be included */
#define QAGENT_ERR33      0x060032 /* Comments to be included */
#define QAGENT_ERR34      0x060033 /* Comments to be included */
#define QAGENT_ERR35      0x060034 /* Comments to be included */
#define QAGENT_ERR36      0x060035 /* Comments to be included */
#define QAGENT_ERR37      0x060036 /* Comments to be included */
#define QAGENT_ERR38      0x060037 /* Comments to be included */
#define QAGENT_ERR39      0x060038 /* Comments to be included */
#define QAGENT_ERR3A      0x060039 /* Comments to be included */
#define QAGENT_ERR3B      0x06003a /* Comments to be included */
#define QAGENT_ERR3C      0x06003b /* Comments to be included */
#define QAGENT_ERR3D      0x06003c /* Comments to be included */
#define QAGENT_ERR3E      0x06003d /* Comments to be included */
#define QAGENT_ERR3F      0x06003e /* Comments to be included */
#define QAGENT_ERR40      0x06003f /* Comments to be included */
#define QAGENT_ERR41      0x060040 /* Comments to be included */
#define QAGENT_ERR42      0x060041 /* Failed to delete QAgentMsgQ during
												  shutdown */
#define QAGENT_ERR43      0x060042 /* Comments to be included */
#define QAGENT_ERR44      0x060043 /* Comments to be included */
#define QAGENT_ERR45      0x060044 /* Comments to be included */
#define QAGENT_ERR46      0x060045 /* Comments to be included */
#define QAGENT_ERR47      0x060046 /* Comments to be included */
#define QAGENT_ERR48      0x060047 /* Comments to be included */
#define QAGENT_ERR49      0x060048 /* Comments to be included */
#define QAGENT_ERR4A      0x060049 /* Comments to be included */
#define QAGENT_ERR4B      0x06004a /* Comments to be included */
#define QAGENT_ERR4C      0x06004b /* Comments to be included */
#define QAGENT_ERR4D      0x06004c /* Comments to be included */
#define QAGENT_ERR4E      0x06004d /* Comments to be included */
#define QAGENT_ERR4F      0x06004e /* Comments to be included */
#define QAGENT_ERR50      0x06004f /* Comments to be included */
#define QAGENT_ERR51      0x060050 /* Comments to be included */
#define QAGENT_ERR52      0x060051 /* Comments to be included */
#define QAGENT_ERR53      0x060052 /* Comments to be included */
#define QAGENT_ERR54      0x060053 /* Comments to be included */
#define QAGENT_ERR55      0x060054 /* Comments to be included */
#define QAGENT_ERR56      0x060055 /* Comments to be included */
#define QAGENT_ERR57      0x060056 /* Comments to be included */
#define QAGENT_ERR58      0x060057 /* Comments to be included */
#define QAGENT_ERR59      0x060058 /* Comments to be included */
#define QAGENT_ERR5A      0x060059 /* Comments to be included */
#define QAGENT_ERR5B      0x06005a /* Comments to be included */
#define QAGENT_ERR5C      0x06005b /* Comments to be included */
#define QAGENT_ERR5D      0x06005c /* Comments to be included */
#define QAGENT_ERR5E      0x06005d /* Comments to be included */
#define QAGENT_ERR5F      0x06005e /* Comments to be included */
#define QAGENT_ERR60      0x06005f /* Comments to be included */
#define QAGENT_ERR61      0x060060 /* Comments to be included */
#define QAGENT_ERR62      0x060061 /* Comments to be included */
#define QAGENT_ERR63      0x060062 /* Comments to be included */
#define QAGENT_ERR64      0x060063 /* Comments to be included */
#define QAGENT_ERR65      0x060064 /* Comments to be included */
#define QAGENT_ERR66      0x060065 /* Comments to be included */
#define QAGENT_ERR67      0x060066 /* Comments to be included */
#define QAGENT_ERR68      0x060067 /* Comments to be included */
#define QAGENT_ERR69      0x060068 /* Comments to be included */
#define QAGENT_ERR6A      0x060069 /* Comments to be included */
#define QAGENT_ERR6B      0x06006a /* Comments to be included */
#define QAGENT_ERR6C      0x06006b /* Comments to be included */
#define QAGENT_ERR6D      0x06006c /* Comments to be included */
#define QAGENT_ERR6E      0x06006d /* Comments to be included */
#define QAGENT_ERR6F      0x06006e /* Comments to be included */
#define QAGENT_ERR70      0x06006f /* Comments to be included */
#define QAGENT_ERR71      0x060070 /* Comments to be included */
#define QAGENT_ERR72      0x060071 /* Comments to be included */
#define QAGENT_ERR73      0x060072 /* Comments to be included */
#define QAGENT_ERR74      0x060073 /* Comments to be included */
#define QAGENT_ERR75      0x060074 /* Comments to be included */
#define QAGENT_ERR76      0x060075 /* Error in qRecvKerBoardCfg. Stream
                                      Group Id exceeds range */
#define QAGENT_ERR77      0x060076 /* Error in qRecvKerBoardCfg. Global
                                      pool ID exceeds range */
#define QAGENT_ERR78      0x060077 /* Error in qRecvKerBoardCfg. Global
                                      pool ID exceeds range */
#define QAGENT_ERR79      0x060078 /* Error in qRecvKerProcCfg. Invalid
                                      Local Pool Id */
#define QAGENT_ERR7A      0x060079 /* In qProcessCfgMsg, a QTaskChildExit
												  message was received, and child task's
												  exit code was not 0. */
#define QAGENT_ERR7B      0x06007A /* In qProcessCfgMsg, a QTaskChildExit
												  message was received, and the attempt to
												  qTaskDelete the child task failed.
											     qSpawnModule's task memory was leaked. */
#define QAGENT_ERR7C      0x06007B /* In qSpawnModules, call to
												  formatSysMessage returned NULL.  You're
												  probably out of message pools.
												  qTaskDelete is never called on the
												  qSpawnModules task, so that memory
												  is leaked.*/
#define QAGENT_ERR7D      0x06007C /* In qSpawnModules, the attempt to
												  qMsgWrite our QTaskChildExit msg to
												  QAgentDesc failed.  qTaskDelete is
												  never called on the qSpawnModules task,
												  so that memory is leaked. */
#define QAGENT_ERR80      0x06007F /* Error in qRecvKerProcCfg. Invalid
                                      Global Pool Id */
#define QAGENT_ERR81      0x060080 /* Could not allocate Overall ErrTable for
                                      qError */
#define QAGENT_ERR82      0x060081 /* Could not allocate latest ErrTable for
                                      qError */
#define QAGENT_ERR83      0x060082 /* Conflicting info in DB SP HW configuration
                                      information */
#define QAGENT_ERR84      0x060083 /* Kernel timeout download error for special
                                      and experimental kernels */
#define QAGENT_ERR85      0x060084 /* CP failed to write its component format to
                                      the DSP */
#define QAGENT_ERR86      0x060085 /* SP Failure: Incompatible QCompDesc format comapared
                                      to the CP */
#define QAGENT_ERR87      0x060086 /* Error occured when sending
                                      QTBCRspTDMBusLawSet message*/
#define QAGENT_ERR88      0x060087 /* The msg QTBCCmdTDMBusLawSet was
                                      received multiple times, it is
                                      allowed only once */
#define QAGENT_ERR89      0x060088 /* The law specified in
                                      QTBCCmdTDMBusLawSet msg is not supported
                                      by the kernel for this board*/
#define QAGENT_ERR8A      0x060089 /* Error setting TDM bus law */
#define QAGENT_ERR8B      0x06008A /* The msg QTBCCmdTDMBusLawSet was send
                                      to the kernel which does not
                                      support that functionality */
#define QAGENT_ERR8C      0x06008B /* Set parameter msg cannot be decoded
                                       in qProcessKernelParmMsg */
#define QAGENT_ERR8D      0x06008C /* Success message allocation failed in
                                      function qRespondKernelParmMsg */
#define QAGENT_ERR8E      0x06008D /* qMsgWrite failed in
                                      qRespondKernelParmMsg */
#define QAGENT_ERR8F      0x06008E /* Set parameter message not supported */
#define QAGENT_ERR90      0x06008F /* qMsgWrite failed in
                                      qRespondUnknownMsg */
#define QAGENT_ERR91      0x060090 /* Set parameter msg cannot be decoded
                                       in qRespondKernelParmMsg */
#define QAGENT_ERR92      0x060091 /* Failure message allocation failed in
                                      function qRespondKernelParmMsg */
#define QAGENT_ERR93      0x060092 /* Message allocation failed in
                                      function qRespondUnknownMsg*/
#define QAGENT_ERR94      0x060093 /* Unable to allocate space for license key */

#define QSCMGR_BAD_EVENT  0x060100   /* Invalid or out-of-range AlarmEvent */
#define QSCMGR_BAD_PARM   0x060101   /* Invalid or out-of-range parameter */
#define QAGENT_ERR95      0x060102 /* For the luna kernel, we got the variable
                                      frame timer from the PCD file but we could
                                      not set the time interval */

#define QAGENT_ERR96      0x060095 /* Interval or threshold is out of range */
#define QAGENT_ERR97      0x060096 /* Error allocating QHostSendAliveConfigResult msg */
#define QAGENT_ERR98      0x060097 /* Error writing QHostSendAliveConfigResult msg */
#define QAGENT_ERR99      0x060098 /* The host descriptor in QHostSendAliveConfig msg
                                      is currently not active */
#define QAGENT_ERR_SendAlive_Locked  0x060103 /*qSendAliveEnable: Structure is locked out */
#define QAGENT_ERR104      0x060104 /* Unable to send qCompDownloadComplete message */
#define QAGENT_ERR105     0x060105 /* Unable to create teardown task */
#define QAGENT_ERR106     0x060106 /* Unable to allocate memory for the serial
                                    * line configuration information in the Flash
                                    */
#define QAGENT_ERR107     0x060107 /* Mercury1 Span Boards are allowed to use any
                                      encoding with IPLink mlms in the Resource
                                      mode only. Any attempt to do this on other
                                      platforms will result in task kill */

/*******************************************************************************
* ACG (Audio Convand Gain) sub-system qErrNo definitions (0x068000 to 0x069fff)
*******************************************************************************/
#define QACG_ERROR_INBOUND_GAIN_TOO_HIGH            0x068000
#define QACG_ERROR_INBOUND_GAIN_TOO_LOW             0x068001
#define QACG_ERROR_OUTBOUND_GAIN_TOO_HIGH           0x068002
#define QACG_ERROR_OUTBOUND_GAIN_TOO_LOW            0x068003
#define QACG_ERROR_INVALID_DIRECTION                0x068004
#define QACG_ERROR_NO_STATE_TABLE_ENTRY             0x068005
#define QACG_ERROR_FUNCTION_NOT_INSTALLED           0x068006
#define QACG_ERROR_NO_STREAMMAP_TABLE_ENTRY         0x068007
#define QACG_ERROR_NO_ENTRYPOINT_TABLE_ENTRY        0x068008
#define QACG_ERROR_NO_MODEMAP_ENTRY                 0x068009
#define QACG_ERROR_CG7_CLOCK_RATE_LESS_THAN_STREAM_RATE  0x06800A
#define QACG_ERROR_CG7_UNRECOGNIZED_CHAN_TYPE       0x06800B
#define QACG_ERROR_CG7_INVALID_CHAN_NUMBER          0x06800C
#define QACG_ERROR_CG7_UNRECOGNIZED_MODE            0x06800D
#define QACG_ERROR_CG7_GAIN_OUT_OF_RANGE            0x06800E
#define QACG_ERROR_CG7_INVALID_STREAM_ID_FOR_RATE   0x06800F
#define QACG_ERROR_CG7_INVALID_TIMESLOT_FOR_RATE    0x068010
#define QACG_ERROR_CG7_INVALID_STREAM_RATE          0x068011
#define QACG_ERROR_CG7_INVALID_CLOCK_RATE           0x068012
#define QACG_ERROR_CG7_INVALID_CLOCK_POLARITY       0x068013
#define QACG_ERROR_CG7_INVALID_FSYNC_POLARITY       0x068014
#define QACG_ERROR_CG7_INVALID_FSYNC_POSITION       0x068015
#define QACG_ERROR_CG7_INVALID_DIRECTION            0x068016
#define QACG_ERROR_CG7_INVALID_DEVICE_ID            0x068017
/*
 * Errors 0x068018 through 0x06802F reserved for future "named" errors
 * as opposed to the "numbered" errors listed below.
 */
#define QACG_ERR30      0x068030   /* Error setting CG7 base address */
#define QACG_ERR31      0x068031   /* Error creating CG7 access semaphore */
#define QACG_ERR32      0x068032   /* Error initializing CG7 clock rate */
#define QACG_ERR33      0x068033   /* Error initializing CG7 Stream rate */
#define QACG_ERR34      0x068034   /* Error initializing CG7 clock polarity */
#define QACG_ERR35      0x068035   /* Error initializing CG7 Frame sync polarity */
#define QACG_ERR36      0x068036   /* Error initializing CG7 Frame sync position */
#define QACG_ERR37      0x068037   /* Error initializing CG7 channel gain */
#define QACG_ERR38      0x068038   /* Error initializing CG7 channel gain */
#define QACG_ERR39      0x068039   /* Error initializing CG7 channel mode */
#define QACG_ERR3A      0x06803A   /* Error initializing CG7 channel mode */
#define QACG_ERR3B      0x06803B   /* Error disabling CG7 global bypass */
#define QACG_ERR3C      0x06803C   /* CG7 Failed to acquire semaphore */
#define QACG_ERR3D      0x06803D   /* CG7 Failed to release semaphore */
#define QACG_ERR3E      0x06803E   /* CG7 Failed to acquire semaphore */
#define QACG_ERR3F      0x06803F   /* CG7 Failed to release semaphore */
#define QACG_ERR40      0x068040   /* CG7 Failed to acquire semaphore */
#define QACG_ERR41      0x068041   /* CG7 Failed to release semaphore */
#define QACG_ERR42      0x068042   /* CG7 Failed to acquire semaphore */
#define QACG_ERR43      0x068043   /* CG7 Failed to release semaphore */
#define QACG_ERR44      0x068044   /* CG7 Failed to acquire semaphore */
#define QACG_ERR45      0x068045   /* CG7 Failed to release semaphore */
#define QACG_ERR46      0x068046   /* CG7 Failed to acquire semaphore */
#define QACG_ERR47      0x068047   /* CG7 Failed to release semaphore */
#define QACG_ERR48      0x068048   /* CG7 Failed to acquire semaphore */
#define QACG_ERR49      0x068049   /* CG7 Failed to release semaphore */
#define QACG_ERR4A      0x06804A   /* CG7 Failed to acquire semaphore */
#define QACG_ERR4B      0x06804B   /* CG7 Failed to release semaphore */
#define QACG_ERR4C      0x06804C   /* CG7 Failed to acquire semaphore */
#define QACG_ERR4D      0x06804D   /* CG7 Failed to release semaphore */
#define QACG_ERR4E      0x06804E   /* CG7 Failed to acquire semaphore */
#define QACG_ERR4F      0x06804F   /* CG7 Failed to release semaphore */
#define QACG_ERR50      0x068050   /* CG7 Failed to acquire semaphore */
#define QACG_ERR51      0x068051   /* CG7 Failed to release semaphore */
#define QACG_ERR52      0x068052   /* CG7 Failed to acquire semaphore */
#define QACG_ERR53      0x068053   /* CG7 Failed to release semaphore */
#define QACG_ERR54      0x068054   /* CG7 Failed to acquire semaphore */
#define QACG_ERR55      0x068055   /* CG7 Failed to release semaphore */
#define QACG_ERR56      0x068056   /* CG7 Failed to acquire semaphore */
#define QACG_ERR57      0x068057   /* CG7 Failed to release semaphore */
#define QACG_ERR58      0x068058   /* CG7 Failed to acquire semaphore */
#define QACG_ERR59      0x068059   /* CG7 Failed to release semaphore */
#define QACG_ERR5A      0x06805A   /* CG7 Failed to acquire semaphore */
#define QACG_ERR5B      0x06805B   /* CG7 Failed to release semaphore */
#define QACG_ERR5C      0x06805C   /* CG7 Failed to acquire semaphore */
#define QACG_ERR5D      0x06805D   /* CG7 Failed to release semaphore */
#define QACG_ERR5E      0x06805E   /* CG7 Failed to acquire semaphore */
#define QACG_ERR5F      0x06805F   /* CG7 Failed to release semaphore */
#define QACG_ERR60      0x068060   /* ACG Init failed to set initial inbound gain */
#define QACG_ERR61      0x068061   /* ACG Init failed to set initial outbound gain */


/*******************************************************************************
* TDM Bus sub-system qErrNo definitions (0x070000 to 0x077fff)
*******************************************************************************/
#define QSC4K_ERR1   0x070001 /* init_connections(), mismatch between baseboard
                                 and NI daughter board information */
#define QSC4K_ERR2   0x070002 /* no NI stuffed on the NI daughterboard */
#define QSC4K_ERR3   0x070003 /* invalid SC4000 device id */
#define QSC4K_ERR4   0x070004 /* Comments to be included */
#define QSC4K_ERR5   0x070005 /* Comments to be included */
#define QSC4K_ERR6   0x070006 /* Comments to be included */
#define QSC4K_ERR7   0x070007 /* Comments to be included */
#define QSC4K_ERR8   0x070008 /* Comments to be included */
#define QSC4K_ERR9   0x070009 /* Comments to be included */
#define QSC4K_ERRA   0x07000a /* Comments to be included */
#define QSC4K_ERRB   0x07000b /* Comments to be included */
#define QSC4K_ERRC   0x07000c /* Comments to be included */
#define QSC4K_ERRD   0x07000d /* Comments to be included */
#define QSC4K_ERRE   0x07000e /* Comments to be included */
#define QSC4K_ERRF   0x07000f /* Comments to be included */
#define QSC4K_ERR10  0x070010 /* Comments to be included */
#define QSC4K_ERR11  0x070011 /* Comments to be included */
#define QSC4K_ERR12  0x070012 /* Comments to be included */
#define QSC4K_ERR13  0x070013 /* Comments to be included */
#define QSC4K_ERR14  0x070014 /* Comments to be included */
#define QSC4K_ERR15  0x070015 /* Comments to be included */
#define QSC4K_ERR16  0x070016 /* Comments to be included */
#define QSC4K_ERR17  0x070017 /* Comments to be included */
#define QSC4K_ERR18  0x070018 /* Comments to be included */
#define QSC4K_ERR19  0x070019 /* Comments to be included */
#define QSC4K_ERR1A  0x07001a /* QOS_WINOS, currently unsupported
											qFindSCBusSpeed called. */
#define QSC4K_ERR1B  0x07001B /* Comments to be included */
#define QSC4K_ERR1C  0x07001C /* Comments to be included */
#define QSC4K_ERR1D  0x07001D /* Comments to be included */
#define QSC4K_ERR1E  0x07001E /* Comments to be included */
#define QSC4K_ERR1F  0x07001F /* shremote: incompatible libraries */

#define TDMBUS_ERR20 0x070020 /* Incompatible ctx12 debug library */
#define TDMBUS_ERR21 0x070021 /* Call to trace subsystem failed */
#define TDMBUS_ERR22 0x070022 /* Call to trace subsystem failed */
#define TDMBUS_ERR23 0x070023 /* Call to trace subsystem failed */
#define TDMBUS_ERR24 0x070024 /* Call to trace subsystem failed */
#define TDMBUS_ERR25 0x070025 /* Call to trace subsystem failed */
#define TDMBUS_ERR26 0x070026 /* Call to trace subsystem failed */


/*******************************************************************************
* QSYSINIT errors
*******************************************************************************/
#define QSYSINIT_ERR1      0x078001 /* Comments to be included */
#define QSYSINIT_ERR2      0x078002 /* Comments to be included */
#define QSYSINIT_ERR3      0x078003 /* Comments to be included */
#define QSYSINIT_ERR4      0x078004 /* Comments to be included */
#define QSYSINIT_ERR5      0x078005 /* Comments to be included */
#define QSYSINIT_ERR6      0x078006 /* Comments to be included */
#define QSYSINIT_ERR7      0x078007 /* Comments to be included */
#define QSYSINIT_ERR8      0x078008 /* Comments to be included */
#define QSYSINIT_ERR9      0x078009 /* Comments to be included */
#define QSYSINIT_ERRA      0x07800a /* Comments to be included */
#define QSYSINIT_ERRB      0x07800b /* Comments to be included */
#define QSYSINIT_ERRC      0x07800c /* Comments to be included */
#define QSYSINIT_ERRD      0x07800d /* Comments to be included */
#define QSYSINIT_ERRE      0x07800e /* Comments to be included */
#define QSYSINIT_ERRF      0x07800f /* Comments to be included */
#define QSYSINIT_ERR10     0x078010 /* Comments to be included */
#define QSYSINIT_ERR11     0x078011 /* Comments to be included */
#define QSYSINIT_ERR12     0x078012 /* qshutdown(), creation of the
													qModuleUnloadSem semaphore failed.
													This semaphore is required for teardown
													to be successful, as it is signalled
													when the resources have all been torn
													down. */
#define QSYSINIT_ERR13     0x078013 /* qshutdown(), allocation of the
													QModuleUnload message failed.  This msg
													is required for teardown to be
													successful, as it is sent to qAgent in
													order to begin teardown of resources. */
#define QSYSINIT_ERR14     0x078014 /* qshutdown(), sending the QModuleUnload
													message failed.  This msg is required
													for teardown to be successful, as it is
													sent to qAgent in order to begin
													teardown of resources. */
#define QSYSINIT_ERR15     0x078015 /* qshutdown(), pending on the
													qModuleUnloadSem semaphore didn't return
													QSTATUS_DONE.  This semaphore is
													posted when the resources have all been
													torn down. */
#define QSYSINIT_ERR16     0x078016 /* qshutdown(), deletion of the
													qModuleUnloadSem semaphore failed.  This
													is only an advisory, as memory will be
													leaked but the kernel can continue to
                                       unload.      */
#define QSYSINIT_ERR17     0x078017 /* no longer used */
#define QSYSINIT_ERR18     0x078018 /* no longer used */
#define QSYSINIT_ERR19     0x078019 /* no longer used */
#define QSYSINIT_ERR1A     0x07801a /* qshutdown(), allocation of the
													Std_MsgExit message destined for the
													idle task failed.  This message is
													required for shutdown to be
													successful. */
#define QSYSINIT_ERR1B     0x07801b /* qshutdown(), sending the Std_MsgExit
													message to the idle task failed.  This
													message is required for shutdown to be
													successful. */
#define QSYSINIT_ERR1C     0x07801c /* Comments to be included */
#define QSYSINIT_ERR1D     0x07801d /* Comments to be included */
#define QSYSINIT_ERR1E     0x07801e /* Comments to be included */
#define QSYSINIT_ERR1F     0x07801f /* Comments to be included */
#define QSYSINIT_ERR20     0x078020 /* Comments to be included */
#define QSYSINIT_ERR21     0x078021 /* Comments to be included */
#define QSYSINIT_ERR22     0x078022 /* Comments to be included */
#define QSYSINIT_ERR23     0x078023 /* Comments to be included */
#define QSYSINIT_ERR24     0x078024 /* Comments to be included */
#define QSYSINIT_ERR25     0x078025 /* Comments to be included */
#define QSYSINIT_ERR26     0x078026 /* Unable to allocate space for Licensing
                                        information */

/*******************************************************************************
* regmgt subsystem qErrNo definitions (0x080000-0x08ffff)
*******************************************************************************/
#define QREGMGT_BADMODE                0x080000 /* invalid mode argment */
#define QREGMGT_C_UNAVAILABLE          0x080001 /* component is unavailable */
#define QREGMGT_C_NOTREGISTERED        0x080002 /* component is not registered */
#define QREGMGT_C_INSTUNREGISTERED     0x080003 /* component instance is not registered */
#define QREGMGT_C_INVALID_DESC         0x080004 /* invalid component descriptor */
#define QREGMGT_INVALID_ARGUMENTS      0x080005 /* invalid API arguments */
#define QREGMGT_ATTR_UNIQUEKEY_REDEF   0x080006 /* attribute key is greater thanthe allowed unique key range */
#define QREGMGT_ATTR_PRIMARY           0x080007 /* cannot remove primary attributes */
#define QREGMGT_ATTR_NOTFOUND          0x080008 /* attribute not found */
#define QREGMGT_I_UNAVAILABLE          0x080009 /* instance is unavailable */
#define QREGMGT_I_STILL_REGISTERED     0x08000a /* instance is still registered */
#define QREGMGT_I_STILL_ALLOCATED      0x08000b /* instance is still allocated */
#define QREGMGT_CLUSTER_NOT_FOUND      0x08000c /* cluster was not found */
#define QREGMGT_CLUSTER_FULL           0x08000d /* cluster database is full */
#define QREGMGT_ATTR_MAX_NUM_EXCEEDED  0x08000e /* number of attributes exceeds maximum limit */
#define QREGMGT_ATTR_NO_ATTRIBUTES     0x08000f /* no attributes supplied, attributes are required */
#define QREGMGT_ATTR_NOT_COMPONENT     0x080010 /* qCompAttrAdd operates on components only - instance was supplied */
#define QREGMGT_INVALID_PROC_NUM       0x080011 /* processor number exceeds the max processor num */
#define QREGMGT_INVALID_COMPONENT_NUM  0x080012 /* component number exceeds the max component num */
#define QREGMGT_COMPONENT_NOT_FOUND    0x080013 /* qCompFind failed to find a matching component */
#define QREGMGT_I_INVALID_DESC         0x080014 /* invalid instance descriptor */
#define QREGMGT_I_NOT_ALLOCATED        0x080015 /* qCompUse/qCompFree: instance is not allocated */
#define QREGMGT_NOT_AN_OWNER           0x080016 /* qCompFree: Only an owner (allocator) can free its component instances */
#define QREGMGT_INVALID_ALLOCDESC      0x080017 /* qCompAllocate: Invalid allocator descriptor */
#define QREGMGT_REMOTE_ALLOCDESC       0x080018 /* qCompAllocate: Allocator is on a remote board */
#define QREGMGT_UNREG_ALLOCDESC        0x080019 /* qCompAllocate: Allocator is an un-registered component */
#define QREGMGT_I_FREE_PENDING         0x08001a /* qCompFree: Instance is already scheduled to be freed as soon as there are no users. */
#define QREGMGT_CLUST_DESTROY_PENDING  0x08001b /* qCompUse: Cannot use component in a cluster which is pending to be destroyed */
#define QREGMGT_PROC_IS_NOT_ALIVE      0x08001c /* qCompAllocate: Cannot allocate instances from processor that it is not alive */
#define QREGMGT_CANNOT_CMPLT_SYNC      0x08001d /* Cannot complete the call synchronously */
#define QREGMGT_INVALID_OPTIONS        0x08001e /* No longer used */
#define QREGMGT_I_BEING_ALLOCATED      0x08001f /* qCompAllocate: Shared component waiting for ALLOCACK from first allocation */
#define QREGMGT_MODDESC_NOT_FOUND      0x080020 /* qCompInitStart/qCompInitCmplt: moddesc entry matching the input string not found */
#define QREGMGT_UNINIT_PROCTAB         0x080021 /* qCompTable[proc id].qCompTable is uninitialized (NULL)  */
#define QREGMGT_REMOTE_TRANS_TIMEOUT   0x080022 /* Couldn't complete remote transaction. */
#define QREGMGT_REMOTE_COMP_ADD_FAIL   0x080023 /* Couldn't add the remote component to inventory */
#define QREGMGT_REMOTE_TRANS_INVALID   0x080024 /* Couldn't find the specified remote transaction in the table */
#define QREGMGT_CAPSULE_SINGLE_ERROR   0x080025 /* Attempt to allocate a caposule without specifying a cliuster.*/
#define QREGMGT_REMOTE_TRANS_CANCEL    0x080026 /* Message buffer failures (et al) forced a cancellation of req.*/
#define QREGMGT_REMOTE_ESTAB_FAILURE   0x080027 /* Message buffer failures (et al) forced a cancellation of req.*/
#define QREGMGT_CTBUS_TIMESLOT_EXHAUST 0x080028 /* The local CTbus timeslot pool is empty.*/
#define QREGMGT_CTBUS_TIMESLOT_INVALID 0x080029 /* The timeslot can't be freed since it's not used.*/
#define QREGMGT_CONFLICTING_MODE_ARG   0x080030 /* Both ASYNC & IMMEDIATE modes are set. */
#define QREGMGT_TIMEOUT_WITH_IMMD_MODE 0x080031 /* Timeout with IMMEDIATE mode. */
#define QREGMGT_UNSUPPORTED_MODE_IN_SP 0x080032 /* SYNC mode not supported in SPs. */
#define QREGMGT_INVALID_ALLOCMASK      0x080033 /* qCompAllocate: Invalid Component Mask.*/
#define QREGMGT_ERR34                  0x080034 /* Comments to be included */
#define QREGMGT_ERR35                  0x080035 /* Comments to be included */
#define QREGMGT_ERR36                  0x080036 /* Comments to be included */
#define QREGMGT_ERR37                  0x080037 /* Comments to be included */
#define QREGMGT_ERR38                  0x080038 /* Comments to be included */
#define QREGMGT_ERR39                  0x080039 /* qDeleteDatabase:  failed to
                                                   delete qRsrcdbSemId. */
#define QREGMGT_ERR3A                  0x08003a /* Comments to be included */
#define QREGMGT_ERR3B                  0x08003b /* Comments to be included */
#define QREGMGT_ERR3C                  0x08003c /* Comments to be included */
#define QREGMGT_ERR3D                  0x08003d /* qRsrcServerConfig:  failed
                                                   to create the resource
                                                   server task. */
#define QREGMGT_ERR3E                  0x08003e /* qRsrcServerTeardown:  failed
                                                   to allocate teardown msg for
                                                   resource server task. */
#define QREGMGT_ERR3F                  0x08003f /* qRsrcServerTeardown:  failed
                                                   to send teardown msg to
                                                   resource server task. */
#define QREGMGT_ERR40                  0x080040 /* Comments to be included */
#define QREGMGT_ERR41                  0x080041 /* Comments to be included */
#define QREGMGT_ERR42                  0x080042 /* Comments to be included */
#define QREGMGT_ERR43                  0x080043 /* Comments to be included */
#define QREGMGT_ERR44                  0x080044 /* Comments to be included */
#define QREGMGT_ERR45                  0x080045 /* Comments to be included */
#define QREGMGT_ERR46                  0x080046 /* Comments to be included */
#define QREGMGT_ERR47                  0x080047 /* Comments to be included */
#define QREGMGT_ERR48                  0x080048 /* Comments to be included */
#define QREGMGT_ERR49                  0x080049 /* Comments to be included */
#define QREGMGT_ERR4A                  0x08004a /* Comments to be included */
#define QREGMGT_ERR4B                  0x08004b /* Comments to be included */
#define QREGMGT_ERR4C                  0x08004c /* Comments to be included */
#define QREGMGT_ERR4D                  0x08004d /* Comments to be included */
#define QREGMGT_ERR4E                  0x08004e /* Comments to be included */
#define QREGMGT_ERR4F                  0x08004f /* Comments to be included */
#define QREGMGT_ERR50                  0x080050 /* Comments to be included */
#define QREGMGT_ERR51                  0x080051 /* Comments to be included */
#define QREGMGT_ERR52                  0x080052 /* Comments to be included */
#define QREGMGT_ERR53                  0x080053 /* Comments to be included */
#define QREGMGT_ERR54                  0x080054 /* Comments to be included */
#define QREGMGT_ERR55                  0x080055 /* Comments to be included */
#define QREGMGT_ERR56                  0x080056 /* Comments to be included */
#define QREGMGT_ERR57                  0x080057 /* Comments to be included */
#define QREGMGT_ERR58                  0x080058 /* Comments to be included */
#define QREGMGT_ERR59                  0x080059 /* Comments to be included */
#define QREGMGT_ERR5A                  0x08005a /* Comments to be included */
#define QREGMGT_ERR5B                  0x08005b /* Comments to be included */
#define QREGMGT_ERR5C                  0x08005c /* Comments to be included */
#define QREGMGT_ERR5D                  0x08005d /* Comments to be included */
#define QREGMGT_ERR5E                  0x08005e /* Comments to be included */
#define QREGMGT_ERR5F                  0x08005f /* Comments to be included */
#define QREGMGT_ERR60                  0x080060 /* Comments to be included */
#define QREGMGT_ERR61                  0x080061 /* Comments to be included */
#define QREGMGT_ERR62                  0x080062 /* Comments to be included */
#define QREGMGT_ERR63                  0x080063 /* Comments to be included */
#define QREGMGT_ERR64                  0x080064 /* Comments to be included */
#define QREGMGT_ERR65                  0x080065 /* Comments to be included */
#define QREGMGT_ERR66                  0x080066 /* Comments to be included */
#define QREGMGT_ERR67                  0x080067 /* Comments to be included */
#define QREGMGT_ERR68                  0x080068 /* Comments to be included */
#define QREGMGT_ERR69                  0x080069 /* Comments to be included */
#define QREGMGT_ERR6A                  0x08006a /* Comments to be included */
#define QREGMGT_ERR6B                  0x08006b /* Comments to be included */
#define QREGMGT_ERR6C                  0x08006c /* Comments to be included */
#define QREGMGT_ERR6D                  0x08006d /* Comments to be included */
#define QREGMGT_ERR6E                  0x08006e /* Comments to be included */
#define QREGMGT_ERR6F                  0x08006f /* Comments to be included */
#define QREGMGT_ERR70                  0x080070 /* Comments to be included */
#define QREGMGT_ERR71                  0x080071 /* Comments to be included */
#define QREGMGT_ERR72                  0x080072 /* Comments to be included */
#define QREGMGT_ERR73                  0x080073 /* Comments to be included */
#define QREGMGT_ERR74                  0x080074 /* Comments to be included */
#define QREGMGT_ERR75                  0x080075 /* Comments to be included */
#define QREGMGT_ERR76                  0x080076 /* Comments to be included */
#define QREGMGT_ERR77                  0x080077 /* Comments to be included */
#define QREGMGT_ERR78                  0x080078 /* Comments to be included */
#define QREGMGT_ERR79                  0x080079 /* Comments to be included */
#define QREGMGT_ERR7A                  0x08007a /* Comments to be included */
#define QREGMGT_ERR7B                  0x08007b /* Comments to be included */
#define QREGMGT_ERR7C                  0x08007c /* Comments to be included */
#define QREGMGT_ERR7D                  0x08007d /* Comments to be included */
#define QREGMGT_ERR7E                  0x08007e /* Comments to be included */
#define QREGMGT_ERR7F                  0x08007f /* Comments to be included */
#define QREGMGT_ERR80                  0x080080 /* Comments to be included */
#define QREGMGT_ERR81                  0x080081 /* Comments to be included */
#define QREGMGT_ERR82                  0x080082 /* Comments to be included */
#define QREGMGT_ERR83                  0x080083 /* Comments to be included */
#define QREGMGT_ERR84                  0x080084 /* Comments to be included */
#define QREGMGT_ERR85                  0x080085 /* Comments to be included */
#define QREGMGT_ERR86                  0x080086 /* Comments to be included */
#define QREGMGT_ERR87                  0x080087 /* Comments to be included */
#define QREGMGT_ERR88                  0x080088 /* Comments to be included */
#define QREGMGT_ERR89                  0x080089 /* Comments to be included */
#define QREGMGT_ERR8A                  0x08008a /* Comments to be included */
#define QREGMGT_ERR8B                  0x08008b /* Comments to be included */
#define QREGMGT_ERR8C                  0x08008c /* Comments to be included */
#define QREGMGT_ERR8D                  0x08008d /* Comments to be included */
#define QREGMGT_ERR8E                  0x08008e /* Comments to be included */
#define QREGMGT_ERR8F                  0x08008f /* Comments to be included */
#define QREGMGT_ERR90                  0x080090 /* Comments to be included */
#define QREGMGT_ERR91                  0x080091 /* Comments to be included */
#define QREGMGT_ERR92                  0x080092 /* Comments to be included */
#define QREGMGT_ERR93                  0x080093 /* Comments to be included */
#define QREGMGT_ERR94                  0x080094 /* Comments to be included */
#define QREGMGT_ERR95                  0x080095 /* Comments to be included */
#define QREGMGT_ERR96                  0x080096 /* Comments to be included */
#define QREGMGT_ERR97                  0x080097 /* Comments to be included */
#define QREGMGT_ERR98                  0x080098 /* Comments to be included */
#define QREGMGT_ERR99                  0x080099 /* Comments to be included */
#define QREGMGT_ERR9A                  0x08009a /* Comments to be included */
#define QREGMGT_ERR9B                  0x08009b /* Comments to be included */
#define QREGMGT_ERR9C                  0x08009c /* Comments to be included */
#define QREGMGT_ERR9D                  0x08009d /* Comments to be included */
#define QREGMGT_ERR9E                  0x08009e /* Comments to be included */
#define QREGMGT_ERR9F                  0x08009f /* Comments to be included */
#define QREGMGT_ERRA0                  0x0800a0 /* Comments to be included */
#define QREGMGT_ERRA1                  0x0800a1 /* Comments to be included */
#define QREGMGT_ERRA2                  0x0800a2 /* Comments to be included */
#define QREGMGT_ERRA3                  0x0800a3 /* Comments to be included */
#define QREGMGT_ERRA4                  0x0800a4 /* Comments to be included */
#define QREGMGT_ERRA5                  0x0800a5 /* Comments to be included */
#define QREGMGT_ERRA6                  0x0800a6 /* Comments to be included */
#define QREGMGT_ERRA7                  0x0800a7 /* Comments to be included */
#define QREGMGT_ERRA8                  0x0800a8 /* Comments to be included */
#define QREGMGT_ERRA9                  0x0800a9 /* Comments to be included */
#define QREGMGT_ERRAA                  0x0800aa /* Comments to be included */
#define QREGMGT_ERRAB                  0x0800ab /* Comments to be included */
#define QREGMGT_ERRAC                  0x0800ac /* Comments to be included */
#define QREGMGT_ERRAD                  0x0800ad /* Comments to be included */
#define QREGMGT_ERRAE                  0x0800ae /* Comments to be included */
#define QREGMGT_CLUST_USECOUNT_MAXED   0x0800af /* qCompUse: Too many uses on componants within the cluster */
#define QREGMGT_MAX_INST_NUM_EXCEEDED  0x0800b0 /* Given instance number
                                                   exceeds max allowed */
#define QREGMGT_reserved1              0x0800b1 /* No Longer Used */
#define QREGMGT_reserved2              0x0800b2 /* No Longer Used */
#define QREGMGT_reserved3              0x0800b3 /* No Longer Used */
#define QREGMGT_reserved4              0x0800b4 /* No Longer Used */
#define QREGMGT_C_INVALID_UNUSER       0x0800b5 /* qCompUnuse: Specified User is not using Component */

#define QREGMGT_ERRB6                  0x0800b6 /* Error when adding attributes */
#define QREGMGT_ERR_UNLINK_UNLINKALL   0x0800b7 /* Error in qXnUseUnlinkAll() returned from qXnUseUnlink() */
#define QREGMGT_ERR_DEALLOC_UNLINKALL  0x0800b8 /* Error in qXnUseUnlinkAll() returned from qClusterDeallocate() */
#define QREGMGT_ERR_DISMANT_UNLINKALL  0x0800b9 /* Error in qXnUseUnlinkAll() returned from cClusterDismantle() */
#define QREGMGT_INVALID_PROC2          0x0800ba /* qDeleteProcTableEntry:
                                                   invalid processor number. */

#define QREGMGT_REG_TASKMSGQID_1       0x0800bb /* qSysCompInstReg: No memory to allocate taskmsgid table */
#define QREGMGT_REG_TASKMSGQID_2       0x0800bc /* qTaskCompInstReg: No memory to allocate taskmsgid table */
#define QREGMGT_REG_TASKMSGQID_3       0x0800bd /* procSysReg: No memory to allocate taskmsgid table */
#define QREGMGT_REG_TASKMSGQID_4       0x0800be /* procQSysReg: No memory to allocate taskmsgid table */
#define QREGMGT_REG_TASKMSGQID_5       0x0800bf /* procSysInstReg: No memory to allocate taskmsgid table */
#define QREGMGT_TASKMSGQID_ALLOC       0x0800c0 /* No memory to allocate taskmsgid table  */

#define QREGMGT_ATTR_MEMALLOC_FAIL     0x0800c1 /* failed to allocate memory for qClusterActive&Inact
                                                   message suppress state control block. */
#define QREGMGT_ATTR_WRONG_VALUE       0x0800c2 /* user specified wrong value for above
                                                   message suppress attribute value. */
#define QREGMGT_UNINIT_ACT_MSG_FLAG    0x0800c3 /* actInactMsgFlag was not initialized when qCompResgerter() called*/
#define QREGMGT_INVALID_COMP           0x0800c4 /* Invalid component parameter specified*/
#define QREGMGT_INVALID_ARGUMENTS1     0x0800c5 /* invalid API arguments */
#define QREGMGT_ERRC6   0x0800c6 /* No component table has been allocated for
                                    the processor.  Either a serious
                                    initialization error has occured or the
                                    processor number is corrupted  */
#define QREGMGT_ERRC7   0x0800c7 /* No component table has been allocated for
                                    the processor.  Either a serious
                                    initialization error has occured or the
                                    processor number is corrupted  */
#define QREGMGT_ERRC8   0x0800c8 /* A resource attempted to allocate more instance then licensed */
#define QREGMGT_ERRC9   0x0800c9 /* The verification of the license failed */
#define QREGMGT_ERRCA   0x0800ca /* The verification of the license failed */
#define QREGMGT_ERRCB   0x0800cb /* An internal fault in the license verification occured. */
#define QREGMGT_ERRCC   0x0800cc /* The licensing library failed. */
#define QREGMGT_ERRCD   0x0800cd /* The licensing library return NULL for the
                                    license table */
#define QREGMGT_ERRCE   0x0800ce /* Could not create SendAlive list */
#define QREGMGT_ERRCD   0x0800cd /* Erro sending QHostExited msg */
#define QREGMGT_UNINIT_PROCTAB2         0x0800cf /* qCompTable[proc id].qCompTable is uninitialized (NULL)  */


/*******************************************************************************
* sram.c  qErrNo definitions (0x098000-0x098fff)
*******************************************************************************/
#define QSRAM_ERR1   0x098001 /* qSramBAllocate(), free block list corrupted */
#define QSRAM_ERR2   0x098002 /* qSramBFree(), free block list corrupted */
#define QSRAM_ERR3   0x098003 /* qSramMsgRead(), qMsgAllocate failed */
#define QSRAM_ERR4   0x098004 /* qSramMsgRead(), no longer used */
#define QSRAM_ERR5   0x098005 /* qSramMsgRead(), no longer used */
#define QSRAM_ERR6   0x098006 /* qSramMsgRead(), no longer used */
#define QSRAM_ERR7   0x098007 /* qSramMsgRead(), no longer used */
#define QSRAM_ERR8   0x098008 /* qSramMsgRead(), no longer used */
#define QSRAM_ERR9   0x098009 /* qSramInit(), qOsSemPend error while waiting
                                 for 1st interrupt */
#define QSRAM_ERRA   0x09800a /* qSramInit(), Error encountered in Sram
                                 configuration */
#define QSRAM_ERRB   0x09800b /* qSramTask(), Code accessed point beyond
                                 infinate loop */
#define QSRAM_ERRC   0x09800c /* qSramMsgWrite(), Big message data block
                                 pointer invalid */
#define QSRAM_ERRD   0x09800d /* qSramBAllocate(), Free List pHeadNode invalid*/
#define QSRAM_ERRE   0x09800e /* qSramBAllocate(), Free List pNext invalid*/
#define QSRAM_ERRF   0x09800f /* qShramMgrInit: failed to allocate
                                 qHostIntGstrmTable. */
#define QSRAM_ERR10  0x098010 /* qShramMgrExit: failed to delete
                                 qHostIntMgrQId. */
#define QSRAM_ERR11  0x098011 /* Comments to be included */
#define QSRAM_ERR12  0x098012 /* Comments to be included */
#define QSRAM_ERR13  0x098013 /* Comments to be included */
#define QSRAM_ERR14  0x098014 /* Comments to be included */
#define QSRAM_ERR15  0x098015 /* Comments to be included */
#define QSRAM_ERR16  0x098016 /* qHostIntStrmProcExit:  failed to delete
                                 qHostIntMmaDataSem. */
#define QSRAM_ERR17  0x098017 /* qHostIntStrmProcExit:  failed to delete
                                 qHostIntMmaCtlSem. */
#define QSRAM_ERR18  0x098018 /* qHostIntStrmProcExit:  failed to delete
                                 qHostIntMmaSem. */
#define QSRAM_ERR19  0x098019 /* Comments to be included */
#define QSRAM_ERR1A  0x09801a /* Comments to be included */
#define QSRAM_ERR1B  0x09801b /* Comments to be included */
#define QSRAM_ERR1C  0x09801c /* Comments to be included */
#define QSRAM_ERR1D  0x09801d /* Comments to be included */
#define QSRAM_ERR1E  0x09801e /* Comments to be included */
#define QSRAM_ERR1F  0x09801f /* Comments to be included */
#define QSRAM_ERR20  0x098020 /* Comments to be included */
#define QSRAM_ERR21  0x098021 /* Comments to be included */
#define QSRAM_ERR22  0x098022 /* Comments to be included */
#define QSRAM_ERR23  0x098023 /* Comments to be included */
#define QSRAM_ERR24  0x098024 /* Comments to be included */
#define QSRAM_ERR25  0x098025 /* Comments to be included */
#define QSRAM_ERR26  0x098026 /* Comments to be included */
#define QSRAM_ERR27  0x098027 /* Comments to be included */
#define QSRAM_ERR28  0x098028 /* no longer used */
#define QSRAM_ERR29  0x098029 /* qSramInit(), NT's IoCreateSynchronizationEvent
											failed.  This event is what signals to the
											loader that loading is complete.  The loader
											will never be notified that the module is
											loaded and running. */
#define QSRAM_ERR2A  0x09802a /* no longer used */
#define QSRAM_ERR2B  0x09802b /* Comments to be included */
#define QSRAM_ERR2C  0x09802c /* no longer used */
#define QSRAM_ERR2D  0x09802d /* Comments to be included */
#define QSRAM_ERR2E  0x09802e /* Warning for Overflow queue HI Stall */
#define QSRAM_ERR2F  0x09802f /* Warning for Pool Alloc HI Stall */
#define QSRAM_ERR30  0x098030 /* Warning for Safety net for  Alloc HI Stall */
#define QSRAM_ERR31  0x098031 /* Failed to allocate SmartMessage in HI */
#define QSRAM_ERR32  0x098032 /* Wrong format in the embedded message within
                                 the smart message */
#define QSRAM_ERR33  0x098033 /* While processing the qGStreamRemoteOpen,
                                 there was an error, and the error message
	                              was not able to be posted to the resources
                                 message queue */
#define QSRAM_ERR34  0x098034 /* While processing the qGStreamRemoteClose,
                                 there was an error, and the error message
	                              was not able to be posted to the resources
                                 message queue */
#define QSRAM_ERR35  0x098035 /* qHostIntOpenGstrm2, No StreamGroups Available */
#define QSRAM_ERR36  0x098036 /* qHostIntOpenGstrm2, No Streams Available */
#define QSRAM_ERR37  0x098037 /* qHostIntOpenGstrm2, Stream already opened for Writer */
#define QSRAM_ERR38  0x098038 /* qHostIntOpenGstrm2, Stream already opened for Reader */
#define QSRAM_ERR39  0x098039 /* qHostIntCloseGstrm2,Stream not opened for this Reader  */
#define QSRAM_ERR3A  0x09803a /* qHostIntCloseGstrm2,Stream not opened for this Writer  */
#define QSRAM_ERR3B  0x09803b 
#define QSRAM_ERR3C  0x09803c 

/*******************************************************************************
* Host Memory Host Interface  qErrNo definitions (0x098800-0x098fff)
*******************************************************************************/
#define QHOSTMEM_ERR0    0x098800
#define QHOSTMEM_ERR1    0x098801
#define QHOSTMEM_ERR2    0x098802
#define QHOSTMEM_ERR3    0x098803
#define QHOSTMEM_ERR4    0x098804
#define QHOSTMEM_ERR5    0x098805
#define QHOSTMEM_ERR6    0x098806
#define QHOSTMEM_ERR7    0x098807
#define QHOSTMEM_ERR8    0x098808
#define QHOSTMEM_ERR9    0x098809
#define QHOSTMEM_ERRA    0x09880A
#define QHOSTMEM_ERRB    0x09880B
#define QHOSTMEM_ERRC    0x09880C
#define QHOSTMEM_ERRD    0x09880D
#define QHOSTMEM_ERRE    0x09880E
#define QHOSTMEM_ERRF    0x09880F
#define QHOSTMEM_ERR10   0x098810
#define QHOSTMEM_ERR11   0x098811
#define QHOSTMEM_ERR12   0x098812
#define QHOSTMEM_ERR13   0x098813
#define QHOSTMEM_ERR14   0x098814
#define QHOSTMEM_ERR15   0x098815
#define QHOSTMEM_ERR16   0x098816
#define QHOSTMEM_ERR17   0x098817
#define QHOSTMEM_ERR18   0x098818
#define QHOSTMEM_ERR19   0x098819
#define QHOSTMEM_ERR1A   0x09881A
#define QHOSTMEM_ERR1B   0x09881B
#define QHOSTMEM_ERR1C   0x09881C
#define QHOSTMEM_ERR1D   0x09881D
#define QHOSTMEM_ERR1E   0x09881E
#define QHOSTMEM_ERR1F   0x09881F
#define QHOSTMEM_ERR20   0x098820
#define QHOSTMEM_ERR21   0x098821
#define QHOSTMEM_ERR22   0x098822
#define QHOSTMEM_ERR23   0x098823
#define QHOSTMEM_ERR24   0x098824
#define QHOSTMEM_ERR25   0x098825
#define QHOSTMEM_ERR26   0x098826
#define QHOSTMEM_ERR27   0x098827
#define QHOSTMEM_ERR28   0x098828
#define QHOSTMEM_ERR29   0x098829

/*******************************************************************************
* Host Memory Host Interface MSG  qErrNo definitions (0x098900-0x0989ff)
*******************************************************************************/

#define QHOSTMEM_MSG_ERR0 0x098900
#define QHOSTMEM_MSG_ERR1 0x098901
#define QHOSTMEM_MSG_ERR2 0x098902
#define QHOSTMEM_MSG_ERR3 0x098903
#define QHOSTMEM_MSG_ERR4 0x098904
#define QHOSTMEM_MSG_ERR5 0x098905
#define QHOSTMEM_MSG_ERR6 0x098906
#define QHOSTMEM_MSG_ERR7 0x098907
#define QHOSTMEM_MSG_ERR8 0x098908
#define QHOSTMEM_MSG_ERR9 0x098909


/*******************************************************************************
* strmmgr.c  qErrNo definitions (0x099000-0x099fff)
*******************************************************************************/
#define QSTRMM_ERR1  0x099001 /* qSramMgrInit(), qOsMsgqCreate failed */
#define QSTRMM_ERR2  0x099002 /* qSramMgrInit(), qSysCompInstanceRegister
                                 failed */
#define QSTRMM_ERR3  0x099003 /* qSramSendFailed(), message write failed */
#define QSTRMM_ERR4  0x099004 /* qSramSendSuccess(), message write failed */
#define QSTRMM_ERR5  0x099005 /* qSramSendSessClosed(), message write failed */
#define QSTRMM_ERR6  0x099006 /* qSramSendInitAck(), message write failed */
#define QSTRMM_ERR7  0x099007 /* qSramSendOpenAck(), message write failed */
#define QSTRMM_ERR8  0x099008 /* qSramProcCanTake(), message allocation failed*/
#define QSTRMM_ERR9  0x099009 /* qSramProcCanTake(), message write failed */
#define QSTRMM_ERRA  0x09900A /* qSramProcDriverMsgs(), error freeing msg */


/*******************************************************************************
* hostgmcs.c  qErrNo definitions (0x09a000-0x09afff)
*******************************************************************************/
#define QHGMCS_ERR1  0x09a001 /* qHostGmcsAdd(), semTake error */
#define QHGMCS_ERR2  0x09a002 /* qHostGmcsIsr(), semGive error */


/*******************************************************************************
* strmkrnl.c  qErrNo definitions (0x09b000-0x09bfff)
*******************************************************************************/
#define QSKRNL_ERR1  0x09b001 /* qSramKrnlInit(), qSramMmaSem create failed */
#define QSKRNL_ERR2  0x09b002 /* qSramKrnlInit(), qSramMmaCtlSem create
                                 failed */
#define QSKRNL_ERR3  0x09b003 /* qSramKrnlInit(), qSramMmaDataSem create
                                 failed */
#define QSKRNL_ERR4  0x09b004 /* qSramMmaCb(), semGive error */
#define QSKRNL_ERR5  0x09b005 /* qSramMmaCtlCb(), semGive error */
#define QSKRNL_ERR6  0x09b006 /* qSramMmaDataCb(), semGive error */
#define QSKRNL_ERR7  0x09b007 /* qSramMmaCopyCtl(), semTake error */
#define QSKRNL_ERR8  0x09b008 /* qSramMmaReleaseCtl(), semTake error */
#define QSKRNL_ERR9  0x09b009 /* qSramMmaReleaseCtl(), qSramMmaCtlSem is not
                                 empty, internal error */
#define QSKRNL_ERRA  0x09b00a /* qSramProcHostMma(), semTake error
                                 (qSramMmaDataSem) */
#define QSKRNL_ERRB  0x09b00b /* qSramProcHostMma(), qSramMmaDataSem is not
                                 empty, internal error */
#define QSKRNL_ERRC  0x09b00c /* qSramProcHostMma(), semTake error
                                 (hostGmcsSyncSem) */
#define QSKRNL_ERRD  0x09b00d /* qSramProcCpMma(), qSramToDo has overflowed */
#define QSKRNL_ERRE  0x09b00e /* qSramProcCpMma(), bad entry on qSramToDo list*/
#define QSKRNL_ERRF  0x09b00f /* qSramProcCpMma(), semTake error (qSramMmaSem)*/
#define QSKRNL_ERR10 0x09b010 /* qSramProcCpMma(), qSramMmaSem is not empty */
#define QSKRNL_ERR11 0x09b011 /* qSramProcCloseLater(), qSramCloseList has
                                 overflowed */
#define QSKRNL_ERR12 0x09b012 /* qSramProcCloseLater(), Bad entry on
                                 qSramCloseList */
#define QSKRNL_ERR13 0x09b013 

/******************************************************************************
* LOADER Errors
 ******************************************************************************/
#define QLOADER_ERR1      0x09c001 /* Comments to be included */
#define QLOADER_ERR2      0x09c002 /* Comments to be included */
#define QLOADER_ERR3      0x09c003 /* Comments to be included */
#define QLOADER_ERR4      0x09c004 /* Comments to be included */
#define QLOADER_ERR5      0x09c005 /* Comments to be included */
#define QLOADER_ERR6      0x09c006 /* Comments to be included */
#define QLOADER_ERR7      0x09c007 /* Comments to be included */
#define QLOADER_ERR8      0x09c008 /* Comments to be included */
#define QLOADER_ERR9      0x09c009 /* Comments to be included */
#define QLOADER_ERRA      0x09c00a /* Comments to be included */
#define QLOADER_ERRB      0x09c00b /* Comments to be included */
#define QLOADER_ERRC      0x09c00c /* Comments to be included */
#define QLOADER_ERRD      0x09c00d /* Comments to be included */
#define QLOADER_ERRE      0x09c00e /* Comments to be included */
#define QLOADER_ERRF      0x09c00f /* Comments to be included */
#define QLOADER_ERR10     0x09c010 /* Comments to be included */
#define QLOADER_ERR11     0x09c011 /* Comments to be included */
#define QLOADER_ERR12     0x09c012 /* Comments to be included */
#define QLOADER_ERR13     0x09c013 /* Comments to be included */
#define QLOADER_ERR14     0x09c014 /* Comments to be included */
#define QLOADER_ERR15     0x09c015 /* Comments to be included */
#define QLOADER_ERR16     0x09c016 /* Comments to be included */
#define QLOADER_ERR17     0x09c017 /* Comments to be included */
#define QLOADER_ERR18     0x09c018 /* Comments to be included */
#define QLOADER_ERR19     0x09c019 /* Comments to be included */
#define QLOADER_ERR1A     0x09c01a /* Comments to be included */
#define QLOADER_ERR1B     0x09c01b /* Comments to be included */
#define QLOADER_ERR1C     0x09c01c /* Comments to be included */
#define QLOADER_ERR1D     0x09c01d /* Comments to be included */
#define QLOADER_ERR1E     0x09c01e /* Comments to be included */
#define QLOADER_ERR1F     0x09c01f /* Comments to be included */
#define QLOADER_ERR20     0x09c020 /* Comments to be included */
#define QLOADER_ERR21     0x09c021 /* Comments to be included */
#define QLOADER_ERR22     0x09c022 /* Comments to be included */
#define QLOADER_ERR23     0x09c023 /* Comments to be included */
#define QLOADER_ERR24     0x09c024 /* Comments to be included */
#define QLOADER_ERR25     0x09c025 /* Comments to be included */
#define QLOADER_ERR26     0x09c026 /* Comments to be included */

/*for_hdlc_start*/
/******************************************************************************
 *       HDLC API return error types                                          *
 *       Refer to "DM3 Kernel Software Reference" for details.                *
 ******************************************************************************/
typedef enum
{
QHDLC_INV_IF        = 0x0b0001, /* Invalid Interface ID                       */
QHDLC_INV_CHAN      = 0x0b0002, /* The channel indicated is invalid           */
QHDLC_BAD_STATE     = 0x0b0003, /* The function cannot be called in the current
                                  state of the channel                       */
QHDLC_CHAN_UNAVAIL  = 0x0b0004, /* Channel not available                      */
QHDLC_INV_TDM       = 0x0b0005, /* Invalid TDM option                         */
QHDLC_CMD_FAIL      = 0x0b0006, /* HDLC command to the controller has failed. */
QHDLC_TIMEOUT       = 0x0b0007, /* Function timed out.                        */
QHDLC_INV_CFG       = 0x0b0008, /* Invalid configuration                      */
QHDLC_BAD_STRUCT    = 0x0b0009, /* Invalid structure                          */
QHDLC_MEM_FAIL      = 0x0b000a, /* SRAM could not allocate buffers            */
QHDLC_INV_BUFSIZE   = 0x0b000b, /* The receive and transmit buffer size
                                   exceeds the maximum frame length (MFL)     */
QHDLC_INV_DEVTYPE   = 0x0b000c, /* Device type defined doesn't match.         */
QHDLC_INV_TIMESLOTS = 0x0b000d, /* Timeslot map doesn't match with device type*/
QHDLC_BUF_UNAVAIL   = 0x0b000e, /* The buffer is not available. Cannot send
                                   the message                                */
QHDLC_LOOP_TEST_FAIL= 0x0b000f, /* Loop Back test failed.                     */
QHDLC_NO_FILTERING  = 0x0b0010, /* FISU Filtering is not activeo on this
                                   channel*/
QHDLC_INV_PARAMETER = 0x0b0011, /* Invalid parameter value                    */
QHDLC_INV_DEVICE    = 0x0b0012, /* Invalid parameter value                    */
QHDLC_TRACE_ACT     = 0x0b0013, /* Trace already active                       */
QHDLC_TRACE_NOACT   = 0x0b0014, /* Trace is not active                        */
QHDLC_INV_PROTOCOL  = 0x0b0015, /* Invalid protocol                           */
QHDLC_INV_MFL       = 0x0b0016, /* Invalid MFL - applies to SS7 protocol only */

QHDLC_ERR17         = 0x0b0017, /* Comments to be included */
QHDLC_ERR18         = 0x0b0018, /* Comments to be included */
QHDLC_ERR19         = 0x0b0019, /* Comments to be included */
QHDLC_ERR1A         = 0x0b001a, /* Comments to be included */
QHDLC_ERR1B         = 0x0b001b, /* Comments to be included */
QHDLC_ERR1C         = 0x0b001c, /* Comments to be included */
QHDLC_ERR1D         = 0x0b001d, /* Comments to be included */
QHDLC_ERR1E         = 0x0b001e, /* Comments to be included */
QHDLC_ERR1F         = 0x0b001f, /* Comments to be included */
QHDLC_ERR20         = 0x0b0020, /* Comments to be included */
QHDLC_ERR21         = 0x0b0021, /* Comments to be included */
QHDLC_ERR22         = 0x0b0022, /* Comments to be included */
QHDLC_ERR23         = 0x0b0023, /* Comments to be included */
QHDLC_ERR24         = 0x0b0024, /* Comments to be included */
QHDLC_ERR25         = 0x0b0025, /* Comments to be included */

/* Available as of 1/31/2001 - HDLC sub-system Memory Manager - ERROR Codes */
QHDLC_MM_EXCEEDED_MAX_POOLS         = 0x0b0026, /* Exceeded maximum configured Memory Pools */
QHDLC_MM_INVALID_POOL_HANDLE        = 0x0b0027, /* Invalid Pool Handle specification */
QHDLC_MM_PREALLOC_TBL_FAIL          = 0x0b0028, /* "Buffer Table" memory allocation failure */
QHDLC_MM_PREALLOC_BUF_FAIL          = 0x0b0029, /* "Buffer Pool" memory allocation failure */
QHDLC_MM_PREALLOC_MSG_FAIL          = 0x0b002a, /* "Message Pool" memory allocation failure */
QHDLC_MM_PREALLOC_WRONG_MEMTYPE     = 0x0b002b, /* Invalid  "Memory Type" specification */
QHDLC_MM_BUFGET_EXCEEDED_MAX_BUFS   = 0x0b002c, /* Exceeded maximum configured Buffers per Memory Pool */
QHDLC_MM_INVALID_BUF_PTR            = 0x0b002d, /* Invalid Buffer/Message pointer */
QHDLC_MM_POOL_ALREADY_FREED         = 0x0b002e, /* Memory Pool has already been freed */
QHDLC_FRAME_UNAVAIL                 = 0x0b002f, /* No frames are available on call to Frame Receive */
QHDLC_CREATE_TASK_FAIL              = 0x0b0030, /* Failed to create hdlc receiving task*/
QHDLC_CREATE_MSG_QUEUE_FAIL         = 0x0b0031, /* Failed to create msg queue for hdlc receiving task.*/
QHDLC_REG_TASK_FAIL                 = 0x0b0032, /* Failed to register hdlc receiving task instance.*/
QHDLC_HSCX_LIB_NOT_MATCH_KERNEL     = 0x0b0033, /* HSCX driver library and kernel are not from same build. */

QHDLC_DRV_NO_SUPPORT1               = 0x0b0034, /* Driver does not support insertion of CRC
                                                   in software */
QHDLC_INV_PARAMETER1                = 0x0b0035, /* Invalid value of crc_receive field  */
QHDLC_INV_PARAMETER2                = 0x0b0036, /* Invalid value of crc_format field  */
QHDLC_DRV_NO_SUPPORT2               = 0x0b0037, /* Driver does not support removal of
                                                   four byte CRC in software */
QHDLC_INV_PARAMETER3                = 0x0b0038, /* Frame length is > MLF or buffer
                                                   pointer is NULL  */
QHDLC_INV_CONFIG                    = 0x0b0039, /* Invalid configuration passed to
                                                   device config  */
QHDLC_BUF_UNAVAIL_TX                = 0x0b003a, /* Transmit memory buffer is unavailable */
QHDLC_BUF_UNAVAIL_RX                = 0x0b003b, /* Receive memory buffer is unavailable */
QHDLC_RX_DESC_ERR1                  = 0x0b003c, /* First Rx desc is is not first desc */
QHDLC_TX_BUF_LEN_ZERO               = 0x0b003d, /* The Tx buffer length is 0 bytes */

QHDLC_SEM_PEND_ERR1                 = 0x0b003e, /* qOsSemPend failed */
QHDLC_SEM_PEND_ERR2                 = 0x0b003f, /* qOsSemPend failed */
QHDLC_SEM_PEND_ERR3                 = 0x0b0040, /* qOsSemPend failed */
QHDLC_SEM_PEND_ERR4                 = 0x0b0041, /* qOsSemPend failed */
QHDLC_SEM_PEND_ERR5                 = 0x0b0042, /* qOsSemPend failed */
QHDLC_SEM_PEND_ERR6                 = 0x0b0043, /* qOsSemPend failed */
QHDLC_SEM_PEND_ERR7                 = 0x0b0044, /* qOsSemPend failed */
QHDLC_SEM_PEND_ERR8                 = 0x0b0045, /* qOsSemPend failed */
QHDLC_SEM_POST_ERR1                 = 0x0b0046, /* qOsSemPost failed */
QHDLC_SEM_POST_ERR2                 = 0x0b0047, /* qOsSemPost failed */
QHDLC_SEM_POST_ERR3                 = 0x0b0048, /* qOsSemPost failed */
QHDLC_SEM_POST_ERR4                 = 0x0b0049, /* qOsSemPost failed */
QHDLC_SEM_POST_ERR5                 = 0x0b004a, /* qOsSemPost failed */
QHDLC_SEM_POST_ERR6                 = 0x0b004b, /* qOsSemPost failed */
QHDLC_SEM_POST_ERR7                 = 0x0b004c, /* qOsSemPost failed */
QHDLC_SEM_POST_ERR8                 = 0x0b004d, /* qOsSemPost failed */
QHDLC_SEM_POST_ERR9                 = 0x0b004e  /* qOsSemPost failed */

} QHDLC_ERRORS;
/* for_hdlc_end */



/*******************************************************************************
* qtrace.c  qErrNo definitions (0x0a0000-0x0a7fff)
*******************************************************************************/
#define QTRACE_ERR1 0x0a0001 /* Out of memory.  Try reducing traceqsize
                                parameter */
#define QTRACE_ERR2  0x0a0002 /* Comments to be included */
#define QTRACE_ERR3  0x0a0003 /* Comments to be included */
#define QTRACE_ERR4  0x0a0004 /* Comments to be included */
#define QTRACE_ERR5  0x0a0005 /* Comments to be included */
#define QTRACE_ERR6  0x0a0006 /* Comments to be included */
#define QTRACE_ERR7  0x0a0007 /* Comments to be included */
#define QTRACE_ERR8  0x0a0008 /* Comments to be included */
#define QTRACE_ERR9  0x0a0009 /* No longer used */
#define QTRACE_ERRA  0x0a000a /* Warning, unable to delete qTraceDumpSem */
#define QTRACE_ERRB  0x0a000b /* Comments to be included */
#define QTRACE_ERRC  0x0a000c /* Comments to be included */
#define QTRACE_ERRD  0x0a000d /* Comments to be included */
#define QTRACE_ERRE  0x0a000e /* Comments to be included */
#define QTRACE_ERRF  0x0a000f /* Comments to be included */
#define QTRACE_ERR10 0x0a0010 /* Comments to be included */
#define QTRACE_ERR11 0x0a0011 /* CP Print Buffer allocation failed */
#define QTRACE_ERR12 0x0a0012 /* Out of memory, when allocating stream for XSCALE */

/*******************************************************************************
* trace.c (print to host ) qErrNo definitions (0x0a8000-0x0affff)
*******************************************************************************/
#define QHOSTPRINT_ERR1 0x0a8001 /* cp Out of memory.   unable to send cp's
                                   prints to host, try reducing memory
                                   via pools etc */
#define QHOSTPRINT_ERR2 0x0a8002 /* cp Out of memory.   unable to send sp's
                                   prints to host, try reducing memory
                                   via pools etc */

/*******************************************************************************
* TCP/IP  qErrNo definitions (0x0c0000-0x0cffff)
*******************************************************************************/
#define QSTACK_ERR1    0x0c0001 /* qBind uninitialzed qstack */
#define QSTACK_ERR2    0x0c0002 /* qBind out of table range */
#define QSTACK_ERR3    0x0c0003 /* qBind bind failed */
#define QSTACK_ERR4    0x0c0004 /* qBind duplicated port number */
#define QSTACK_ERR5    0x0c0005 /* qBind reserved */
#define QSTACK_ERR6    0x0c0006 /* qRecvfromConfig uninitialized qstack */
#define QSTACK_ERR7    0x0c0007 /* qRecvfromConfig stock unbinded */
#define QSTACK_ERR8    0x0c0008 /* qRecvfromConfig reserved */
#define QSTACK_ERR9    0x0c0009 /* qRecvfromConfig reserved */
#define QSTACK_ERRA    0x0c000A /* qRecvfromConfig reserved */
#define QSTACK_ERRB    0x0c000B /* qSendtoConfig uninitialized qstack */
#define QSTACK_ERRC    0x0c000C /* qSendtoConfig port unbinded */
#define QSTACK_ERRD    0x0c000D /* qSendtoConfig remote ip address error*/
#define QSTACK_ERRE    0x0c000E /* qSendtoConfig remote udp port error*/
#define QSTACK_ERRF    0x0c000F /* qSendtoConfig callback error*/
#define QSTACK_ERR10    0x0c0010 /* qSendtoConfig getsockopt TOS error */
#define QSTACK_ERR11    0x0c0011 /* qSendtoConfig getsockopt TTL error*/
#define QSTACK_ERR12    0x0c0012 /* qSendtoConfig no ip address*/
#define QSTACK_ERR13    0x0c0013 /* qSendtoConfig route lookup error*/
#define QSTACK_ERR14    0x0c0014 /* qSendtoConfig arp lookup error*/
#define QSTACK_ERR15    0x0c0015 /* qSendtoConfig multicast TTL get error*/
#define QSTACK_ERR16    0x0c0016 /* qSendtoConfig no header buffer*/
#define QSTACK_ERR17    0x0c0017 /* qSendtoConfig free hd error*/
#define QSTACK_ERR18    0x0c0018 /* qSendtoConfig reserved */
#define QSTACK_ERR19    0x0c0019 /* qSendtoConfig reserved */
#define QSTACK_ERR1A    0x0c001A /* qSendto no callback function */
#define QSTACK_ERR1B    0x0c001B /* qSendto parameter error */
#define QSTACK_ERR1C    0x0c001C /* qSendto qnode has child node*/
#define QSTACK_ERR1D    0x0c001D /* qSendto driver tx failed*/
#define QSTACK_ERR1E    0x0c001E /* qSendto no header buffer*/
#define QSTACK_ERR1F    0x0c001F /* qSendto reserved*/
#define QSTACK_ERR20    0x0c0020 /* qSendto reserved */
#define QSTACK_ERR21    0x0c0021 /* qSendto reserved */
#define QSTACK_ERR22    0x0c0022 /* qSendto reserved */
#define QSTACK_ERR23    0x0c0023 /* qStackInit parameter error */
#define QSTACK_ERR24    0x0c0024 /* qStackInit memory alloc error */
#define QSTACK_ERR25    0x0c0025 /* qStackInit no ip address found */
#define QSTACK_ERR26    0x0c0026 /* qStackInit no mac address found */
#define QSTACK_ERR27    0x0c0027 /* qStackInit route sock open error */
#define QSTACK_ERR28    0x0c0028 /* qStackInit no ip mask found */
#define QSTACK_ERR29    0x0c0029 /* qStackInit external node pool error */
#define QSTACK_ERR2A    0x0c002a /* qClose close() failed */
#define QSTACK_ERR2B    0x0c002b /* qClose no port binded */
#define QSTACK_ERR2C    0x0c002c /* qClose free header buf error*/
#define QSTACK_ERR2D    0x0c002d /* qClose reserved*/
#define QSTACK_ERR2E    0x0c002e /* qClose reserved*/
#define QSTACK_ERR2f    0x0c002f /* qClose reserved */
#define QSTACK_ERR30    0x0c0030 /* qSetsockopt reserved */
#define QSTACK_ERR31    0x0c0031 /* qSetsockopt setsockopt failed */
#define QSTACK_ERR32    0x0c0032 /* qsetSockopt Multicast membership full */
#define QSTACK_ERR33    0x0c0033 /* qsetSockopt Multicast membership notfound*/
#define QSTACK_ERR34    0x0c0034 /* qsetSockopt reserved*/
#define QSTACK_ERR35    0x0c0035 /*  qsetSockopt reserved*/
#define QSTACK_ERR36    0x0c0036 /*  qsetSockopt reserved*/
#define QSTACK_ERR37    0x0c0037 /*  qsetSockopt reserved*/
#define QSTACK_ERR38    0x0c0038 /*  qsetSockopt reserved*/
#define QSTACK_ERR39    0x0c0039 /*  qsetSockopt reserved*/
#define QSTACK_ERR3A	0x0c003a /* qStackHDCheckForFree returned Error in qSendtoConfig */
#define QSTACK_ERR3B	0x0c003b /* qStackHDCheckForFree returned Error in qClose */

/*******************************************************************************
* The following errors are specific to QLUNA. Since we did not see a need
* for defining a whole section for different error types ( we don't anticipate
* those many errors) we combine the various errors into one section.
* Ranges from (0x0d0000-0x0dffff)
*******************************************************************************/
#define QLUNA_EXCEPTIONHANDLED      0x0d0000 /* Exception Handled */
#define QLUNA_APICUNAVAILABLE    0x0d0001 /* APIC is unavailable */
#define QLUNA_SEM1               0x0d0002 /* Semaphore Get Count failed for message
												available sempahore */
#define QLUNA_SEM2               0x0d0003 /* Posting of the message removed Semaphore failed */
#define QLUNA_SEM3               0x0d0004 /* Pend on the message available Semaphore failed */
#define QLUNA_SEM4               0x0d0005 /* Posting of the message available Semaphore failed */
#define QLUNA_SEM5               0x0d0006 /* Pend on the message removed Semaphore failed */
#define QLUNA_SEM6               0x0d0007 /* A pend on the message available semaphore timed out */
#define QLUNA_SEM7               0x0d0008 /* A pend on the message removed semaphore timed out */
#define QLUNA_READQUEUE_EMPTY    0x0d0009 /* Read Queue is empty even though a pend on the message
												Available Semaphore succeeded */
#define  QLUNA_WRITEQUEUE_EMPTY     0x0d000a /* Write Queue is empty even though a pend on the message
												Removed semaphore succeeded */
#define QLUNA_MEM1               0x0d000b /* Message Queue Object is null when pending on the message
												queue */
#define QLUNA_MEM2               0x0d000c /* Message Queue Object is null while trying to post to the message
												queue */
#define QLUNA_MEM3               0x0d000d /* Message Queue Object is null when deleting the message queue */
#define  QLUNA_MEM4              0x0d000e /* Message Queue Object is null when getting the number of
												messages in the message Queue */
#define QLUNA_EXCHANDLINGDISABLED   0x0d000f /* Exception Handling is disabled */


#ifdef __cplusplus
}
#endif


#endif /* QKERNERR */

