/******************************************************************************
*     Copyright (c) 1995-2001 Intel Corporation. All Rights Reserved.
*
*     All names, products, and services mentioned herein are the trademarks
*     or registered trademarks of their respective organizations and are the
*     sole property of their respective owners.
*  
*
*     THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation.
*     The copyright notice above does not evidence any actual or
*     intended publication of such source code.
******************************************************************************/

/******************************************************************************
 *		  FILE: qmsomgr.h
 *
 *	  PURPOSE:
 *		This module contains all the specific includes for the Message 
 * 		stream Object manager
 *
 * HISTORY
 * Date				who	Description
 * 10-16-96			DG		Total re-write
 * 10-Nov-94		GP 	Initial Creation.
 ***************************************************************************/

/***************************************************************************/
/***************************** IMPORTANT NOTE ******************************/
/***************************************************************************/
/*                                                                         */
/* This file belongs to the kernel group and must not be modified by any   */
/* other group.                                                            */
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/***************************************************************************/
/********************************* NOTE ************************************/
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/* This file is part of the system release. Please try not to add kernel   */
/* specific stuff to this file. However, if you must, it should be         */
/* included in if (QCPU < QHOST) section.                                  */
/***************************************************************************/

#if (QCPU < QHOST)
#include	<qostask.h>
#include	<qosmsgq.h>
#include	<qmsg.h>
#endif /* QCPU < QHOST */
#ifndef __MSOMGR_H__
#define __MSOMGR_H__

#ifdef __cplusplus
extern "C" {
#endif

#if (QCPU < QHOST)
boolean qMsoWrite(QMsg *inMsg);
#if (QCPU == QI960)
boolean qMsoWriteBroadcast(QMsg *inMsg);
#endif

void qMsoWritePrintf(void);
void qMsoReadPrintf(QMsg *qmsg, int spNo);
#endif /* (QCPU < QHOST) */

#if (QCPU == QM56301)
#define QGM_MSG_HEAD_SIZE	((QMSG_HEAD_SIZE / 3) * 4)
#else
#define QGM_MSG_HEAD_SIZE	QMSG_HEAD_SIZE
#endif


/******************************************************************************
*        NAME: QMsgSize2GmMsgSize
* DESCRIPTION: convert qmsg->size to gloabl memory message body size (in bytes)
					Note: This macro will always round up to the next multiple of 4
					bytes to keep the ipc queues aligned on 32-bit boundries.
*    CAUTIONS: The size parameter is modified by this macro.
******************************************************************************/
#define QMsgSize2GmMsgSize(size) { \
	(size) += 3; \
	(size) &= (~3); \
}

/******************************************************************************
*        NAME: QMsgOffset2RealOffset, RealOffset2QMsgOffset, QMsgZeroOffset
* DESCRIPTION: 
*    CAUTIONS: 
******************************************************************************/
#if (QCPU == QPPC603) || (QCPU == QMPC8260) || (QCPU == QHOST_BIG_ENDIAN)
/* PPC bytes are in reversed order so Negate the lower 2 bits of the
   index to do the swapping automatically 
*/
#define QMsgOffset2RealOffset(offset) { \
	(offset) ^= 0x3; \
}
#define RealOffset2QMsgOffset(offset) { \
	(offset) ^= 0x3; \
}

/* PPC msg bytes are reversed so the default value should be 3 */
#define QMsgZeroOffset(offset) { \
	(offset) = 0x3; \
}

#else
#define QMsgOffset2RealOffset(offset)
#define RealOffset2QMsgOffset(offset)
#define QMsgZeroOffset(offset) { \
	(offset) = 0; \
}
#endif





#ifdef __cplusplus
}
#endif

#endif
