/****************************************************************************
 *		Copyright (c) 1995 Intel Corporation
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qparam.h
 * AUTHOR:       Sam Gao
 * ORG:          Intel Corporation
 * ORIG-DATE:     4-Apr-96 at 08:44:16
 * LAST-MOD:     24-Jul-97 at 15:57:14 by Gerry Lachac
 * PURPOSE:
 *    This file contains all the defines for accessing library and driver
 *    parameters.
 *
 * HISTORY:
 * Date                 Who     Description
 *  4-Apr-96            SG      created for qhostlib parameter functions
 ***************************************************************************/

#ifndef __QPARAM_H__
#define __QPARAM_H__



/*  Mercury Parameters are of 4 types: UInt32, UInt16, Uint8 and ptr
    One parameter looks like this:

    4 bits  4 bits	8 bits			16 bits
	_________________________________________________
   | Size  | Mode  | System    |     Parameter      |
   |_______|_______|___________|____________________|
	
	Size: the size of this parameter
   Mode: R/W, RDONLY, WRONLY
   System: Whose parameter? driver or library
   Parameter: parameters
 */

#define QPRM_MASK_SIZE     0xF0000000
#define QPRM_SIZE_32       0x10000000
#define QPRM_SIZE_16	      0x20000000
#define QPRM_SIZE_8        0x30000000

#define QPRM_MASK_MODE     0x0F000000
#define QPRM_MODE_READ     0x01000000
#define QPRM_MODE_WRITE    0x02000000
#define QPRM_MODE_RDWR     (QPRM_MODE_READ | QPRM_MODE_WRITE)

#define QPRM_MASK_SYS      0x00FF0000
#define QPRM_SYS_QLIB	   0x00010000
#define QPRM_SYS_QDRV	   0x00020000
#define QPRM_SYS_QDRV_STRM 0x00030000

#define QPRM_MASK_PRM		0x0000FFFF


/* Number of library parameters in table */
#define NUMLIB_QPARM      6


/**
 ** L i b r a r y    P a r a m s 
 ** 
 **/
#define QPRM_QMSG_HIWATER  (QPRM_SIZE_32|QPRM_MODE_RDWR|QPRM_SYS_QLIB|0x00000000)
#define QPRM_QMSG_LOWATER  (QPRM_SIZE_32|QPRM_MODE_RDWR|QPRM_SYS_QLIB|0x00000001)
#define QPRM_STREAMTBLSIZE (QPRM_SIZE_32|QPRM_MODE_RDWR|QPRM_SYS_QLIB|0x00000002)
#define QPRM_QMSG_CLEANUP  (QPRM_SIZE_32|QPRM_MODE_READ|QPRM_SYS_QLIB|0x00000003)
#define QPRM_QMSG_ALLOCS   (QPRM_SIZE_32|QPRM_MODE_READ|QPRM_SYS_QLIB|0x00000004)
#define QPRM_QMSG_FREES    (QPRM_SIZE_32|QPRM_MODE_READ|QPRM_SYS_QLIB|0x00000005)


/**
 ** D r i v e r    P a r a m s 
 ** 
 **/
#define NUMDRV_QPARM      3
#define QPRM_NUMBINDS (QPRM_SIZE_32|QPRM_MODE_READ|QPRM_SYS_QDRV|0x00000000)
#define QPRM_NUMSTREAMS (QPRM_SIZE_32|QPRM_MODE_READ|QPRM_SYS_QDRV|0x00000001)
#define QPRM_STREAMBUFSIZE (QPRM_SIZE_32|QPRM_MODE_RDWR|QPRM_SYS_QDRV_STRM|0x00000002)



/*The following is for version string parameter*/
#define QVERSION_STRING    80


#ifdef __cplusplus
extern "C"{
#endif


/* Prototypes */
QStatus qLibParmGet(UInt32 parm, void * pValue);
QStatus qLibParmSet(UInt32 parm, void * pValue);
QStatus qDrvParmGet(QHandle,UInt32, void *);
QStatus qDrvParmSet(QHandle,UInt32, void *);

#ifdef __cplusplus
}
#endif

#endif










