/****************************************************************************
 *		Copyright (c) 1995 Intel Corporation
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qstream.h         
 * AUTHOR:       Sam Gao
 * ORG:          Intel Corporationration
 * ORIG-DATE:    28-Nov-95 at 14:51:15
 * LAST-MOD:     30-May-97 at 13:30:15 by Gerry Lachac
 * PURPOSE:
 *    This module contains all the specific code for initializing all the
 *    data structures in shared RAM.  This occurrs once after initialization
 *    if the init. process fails then an error code is returned.
 *
 * HISTORY:
 * Date                 Who     Description
 * 7-May-96             GL      Changed EOF/EOT added two new function protos
 * 18-Oct-94            CC      First bug fix.
 * 15-Oct-94            CC      Initial Creation.
 *
 * 30-Jul-98	PH       	Added QIO_GSTREAMS_MULTI and QSTREAM_GSTREAM
 *				for GStream support. Added the GStreams
 *				function prototypes.
 ***************************************************************************/

#ifndef __QSTREAM_H__
#define __QSTREAM_H__



/* Indicates whether flags are valid */
#define  QIO_NONE     		0x00
#define  QIO_SETFLAGS 		0x01
#define  QIO_NOSEQ    		0x02

#define	 QIO_GSTREAMS_MULTI	0x03

/* Maximum size of a Block stream buffer */
#define  QMAX_BLOCKSIZE 4032

/* Good default value to use for stream size in qBStreamConnect() */
#define  QDEF_STREAMSIZE (4*QMAX_BLOCKSIZE)


/* Streams specific typedefs */
typedef UInt24 QStreamId;
typedef UInt24	QOpenMode;
typedef UInt24 QIOMode;
typedef UInt24	QBufFlags;

#if 0 
typedef void *	QBufRef;
#endif



/* Stream Open modes */
#define QSTREAM_OPENREAD      	0x00000002
#define QSTREAM_OPENWRITE     	0x00000001
#define QSTREAM_OPENFLUSH     	0x00000004
#define QSTREAM_OPENPERSISTENT	0x00000008

#define QSTREAM_GSTREAM		0x00000010

/* Stream ID value for qBStreamOpen() to request first available stream */
#define QSTREAM_FIRST_AVAIL   0

/* Flags used in QBufInfo flags field */
#define QEOD         0x00000001
#define QEOD_MASK    0xFFFFFFFE 
#define QEOT         0x00000002
#define QEOT_MASK    0xFFFFFFFD
#define QEOF         0x00000004
#define QEOF_MASK    0xFFFFFFFB
#define QUSER1       0x00000008
#define QUSER1_MASK  0xFFFFFFF7
#define QUSER2       0x00000010
#define QUSER2_MASK  0xFFFFFFEF
#define QUSER3       0x00000020
#define QUSER3_MASK  0xFFFFFFDF
#define QUSER4       0x00000040
#define QUSER4_MASK  0xFFFFFFBF
#define QEOS         0x00000080


/* Data stream buffer information structure */
typedef  struct {
#if 0
   QBufRef     link;
#endif
   void        *link;
   QBufFlags   flags;
   UInt16      blockSize;
   UInt16      dataSize;
   UInt16      sequence;
} QBufInfo;


/* Connection info structure */
typedef struct {
   UInt24   streamId;
   UInt32   blockSize;
   UInt32   maxByteCount;
   UInt32   actualSize;
   //WW Streaming Change: Upper
   //Transport Layers can ask
   //For the receive buffer size
   //in WW mode:
  UInt32  wwreadBufSize;
} QConnectInfo;


/* Cantake info structure */
typedef struct {
   UInt32   byteCount;
} QCanTakeInfo;

   

 
/* Function Prototypes */
#ifdef __cplusplus
extern "C"{
#endif
QHandle qBStreamOpen(void *);
QStatus qBStreamClose(QHandle);
QStatus qBStreamWrite(QHandle,void *,Int32,QIOMode,QBufInfo *);
QStatus qBStreamRcvConnect(QHandle,QConnectInfo *);
QStatus qBStreamRead(QHandle,UInt32,void *,QBufInfo * );
QStatus qBStreamRcvCanTake(QHandle,QCanTakeInfo *);
QStatus qBStreamRcvDisconnect(QHandle);
QStatus qBStreamConnect(QHandle,QCompDesc,QStreamId,QOpenMode,UInt32);
QStatus qBStreamConnect2(QHandle,QCompDesc, QStreamId,QOpenMode, UInt32, UInt32, UInt32,UInt32);
QStatus qBStreamDisconnect(QHandle);
Int32 qBStreamWriteMulti(QHandle,QIOMode, Int32,void *, QBufInfo *);


/* GStreams function prototypes */
QHandle qGStreamOpen(void *);
QStatus qGStreamClose(QHandle);
QStatus qGStreamWrite(QHandle,void *,Int32);
QStatus qGStreamRcvConnect(QHandle,QConnectInfo *);
QStatus qGStreamRead(QHandle,UInt32,void *,QBufInfo * );
QStatus qGStreamRcvCanTake(QHandle,QCanTakeInfo *);
QStatus qGStreamRcvDisconnect(QHandle);
QStatus qGStreamConnect(QHandle,QCompDesc,QStreamId,QOpenMode,UInt32);
QStatus qGStreamConnect2(QHandle,QCompDesc, QStreamId,QOpenMode, UInt32, UInt32, UInt32, UInt32);
QStatus qGStreamDisconnect(QHandle);
Int32 qGStreamWriteMulti(QHandle,Int32,void *,QBufInfo *);

#ifdef __cplusplus
}
#endif


#endif /* !defined(_qstreammsg_h_) */
