/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         recordLocs.h
 * AUTHOR:       Ray Bailey
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    13-Apr-00 at 18:03:04
 * PURPOSE:
 *
 * HISTORY:
 * Date			Who	Description
 * 13-Apr-00          	RB	Initial Version
 ***************************************************************************/
#if !defined(_recorderLocations_h)
#define _recorderLocations_h 1

#define END_OF_LOCS_TABLE 0

#include "qmiscapi.h"

void recorderErrKillTask ( Uint24 errTag );
void recorderErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc );
void recorderErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                               int arg1, int arg2, int arg3, int arg4 );
void recorderErrWarning ( Uint24 errTag );
void recorderErrInstWarning ( Uint24 errTag, QCompDesc *pDesc );
void recorderErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                              int arg1, int arg2, int arg3, int arg4 );
void recorderErrAdvisory ( Uint24 errTag );
void recorderErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc );
void recorderErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                               int arg1, int arg2, int arg3, int arg4 );


#if !defined(_Reccomp_C__)
extern char *recorderLocationsFileName;
#else 
char *recorderLocationsFileName = "reclocs.h";
/******************************************************************************
 *       NAME : recorderErrKillTask
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void recorderErrKillTask ( Uint24 errTag )
{
   qError (QERR_KILLTASK, errTag, recorderLocationsFileName);
}

/******************************************************************************
 *       NAME : recorderErrInstKillTask
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void recorderErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_KILLTASK, errTag, recorderLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : recorderErrArgsKillTask
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void recorderErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
   int count=4;
   qErrorArgs (QERR_KILLTASK, errTag, recorderLocationsFileName, pDesc, count, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : recorderErrWarning
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void recorderErrWarning ( Uint24 errTag )
{
  qError (QERR_WARNING, errTag, recorderLocationsFileName);
}

/******************************************************************************
 *       NAME : recorderErrInstWarning
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void recorderErrInstWarning ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_WARNING, errTag, recorderLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : recorderErrArgsWarning
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void recorderErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_WARNING, errTag, recorderLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : recorderErrAdvisory
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void recorderErrAdvisory ( Uint24 errTag )
{
  qError (QERR_ADVISORY, errTag, recorderLocationsFileName);
}

/******************************************************************************
 *       NAME : recorderErrInstAdvisory
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void recorderErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_ADVISORY, errTag, recorderLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : recorderErrArgsAdvisory
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void recorderErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_ADVISORY, errTag, recorderLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

#endif



#define RECORD_LOC_000	0x800000 /* recorder:.c:(),
				    */

#define RECORD_LOC_001	0x800001 /* recorder:reccomp.c:
				    qCompInstanceRegister failure */

#define RECORD_LOC_002	0x800002 /* recorder:reccomp.c:
				    qMsgWrite failure */

#define RECORD_LOC_003	0x800003 /* recorder:reccomp.c:
				    qMemAlloc failure for Component Paarameter Table */

#define RECORD_LOC_004	0x800004 /* recorder:reccomp.c:+
				    qCompRegister failure */

#define RECORD_LOC_005	0x800005 /* recorder:reccomp.c:
				    qMsgRead failure */

#define RECORD_LOC_006	0x800006 /* recorder:reccomp.c:
				    Std_MsgSetParm_get failure */

#define RECORD_LOC_007	0x800007 /* recorder:reccomp.c:
				    Std_MsgSetParmDef_get  failure */

#define RECORD_LOC_008	0x800008 /* recorder:reccomp.c:
				    Std_MsgGetParm_get failure */

#define RECORD_LOC_009	0x800009 /* recorder:reccomp.c:
				    qMsgAllocate failure for Std_MsgGetParmCmplt */

#define RECORD_LOC_010	0x800010 /* recorder:reccomp.c: 
        Std_MsgGetParmCmplt_put failure */

#define RECORD_LOC_011	0x800011 /* recorder:reccomp.c: 
        qMsgWrite failure */

#define RECORD_LOC_012	0x800012 /* recorder:reccomp.c: 
        failure in recorderGetParmValue getting Std_ParmInstNum */   

#define RECORD_LOC_013	0x800013 /* recorder:reccomp.c: 
        failure in recorderGetParmValue getting Std_ParmMaxInst */   

#define RECORD_LOC_014	0x800014 /* recorder:reccomp.c: 
        failure in recorderGetParmValue getting Std_ParmStartInst */   

#define RECORD_LOC_015	0x800015 /* recorder:reccomp.c: 
        qMemAlloc failure during instance database allocation */

#define RECORD_LOC_016	0x800016 /* recorder:reccomp.c: 
        qMemAlloc failure during encoder attribute table allocation */

#define RECORD_LOC_017	0x800017 /* recorder:reccomp.c: 
        qMsgWrite failure */

#define RECORD_LOC_018	0x800018 /* recorder:reccomp.c: 
        qMsgWrite failure */

#define RECORD_LOC_019	0x800019 /* recorder:reccomp.c: 
        recorderComp in unexpected initState */

#define RECORD_LOC_020	0x800020 /* recorder:reccomp.c: 
        recorderComp in unexpected state */

#define RECORD_LOC_021	0x800021 /* recorder:reccomp.c: 
        qMsgFree failure */

#define RECORD_LOC_022	0x800022 /* recorder:reccomp.c: 
        recorder_MsgSetSpeedAdjTable_get FAILURE */

#define RECORD_LOC_023	0x800023 /* recorder:reccomp.c: 
        Unable to allocate message 
        recorder_MsgSetSpeedAdjTableCmplt, qMsgAllocate FAILURE*/

#define RECORD_LOC_024	0x800024 /* recorder:reccomp.c: 
        Unable to send
        recorder_MsgSetSpeedAdjTableCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_025	0x800025 /* recorder:reccomp.c: 
        recorder_MsgSetVolumeAdjTable_get FAILURE */

#define RECORD_LOC_026	0x800026 /* recorder:reccomp.c: 
        Unable to allocate message
        recorder_MsgSetVolumeAdjTableCmplt, qMsgAllocate
        FAILURE */

#define RECORD_LOC_027	0x800027 /* recorder:reccomp.c: 
        Unable to send
        recorder_MsgSetVolumeAdjTableCmplt, qMsgWrite FAILURE*/

#define RECORD_LOC_028	0x800028 /* recorder:reccomp.c: 
        Unable to allocate
        recorder_MsgGetSpeedAdjTableCmplt, qMsgAllocate
        FAILURE */

#define RECORD_LOC_029	0x800029 /* recorder:reccomp.c: 
        recorder_MsgGetSpeedAdjTableCmplt_put FAILURE */

#define RECORD_LOC_030	0x800030 /* recorder:recinst.c:(),
        Unable to send
        recorder_MsgGetSpeedAdjTableCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_031	0x800031 /* recorder:recinst.c:(),
        Unable to allocate message
        recorder_MsgGetVolumeAdjTableCmplt, qMsgAllocate
        FAILURE */

#define RECORD_LOC_032	0x800032 /* recorder:recinst.c:(),
        recorder_MsgGetVolumeAdjTableCmplt_put FAILURE */

#define RECORD_LOC_033	0x800033 /* recorder:recinst.c:(),
        Unable to send
        recorder_MsgGetVolumeAdjTableCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_034	0x800034 /* recorder:recinst.c:(),
        recorderGetParmValue FAILURE for Std_ParmcompNum */

#define RECORD_LOC_035	0x800035 /* recorder:recinst.c:(),
        recorderGetParmValue FAILURE for Std_ParmMaxcomp*/

#define RECORD_LOC_036	0x800036 /* recorder:recinst.c:(),
        recorderGetParmValue FAILURE for Std_ParmStartcomp*/

#define RECORD_LOC_037	0x800037 /* recorder:recinst.c:(),
         qMemAlloc FAILURE while creating recorder
         compances (IDBs) */

#define RECORD_LOC_038	0x800038 /* recorder:recinst.c:(),
         qMemAlloc FAILURE while creating decoder
         attribute  table */

#define RECORD_LOC_039	0x800039 /* recorder:recinst.c:(),
        Unable to allocate message
        recorder_MsgAllocateDecoderCmplt, qMsgAllocate
        FAILURE */

#define RECORD_LOC_040	0x800040 /* recorder:recinst.c:(),
        Unable to send recorder_MsgAllocateDecoderCmplt,
        qMsgWrite FAILURE */

#define RECORD_LOC_041	0x800041 /* recorder:recinst.c:(),
        Unable to allocate message Std_MsgInitCmplt,
        qMsgAllocate FAILURE */

#define RECORD_LOC_042	0x800042 /* recorder:recinst.c:(),
        Unable to send Std_MsgInitCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_043	0x800043 /* recorder:recinst.c:(),
        qMsgFree FAILURE */

#define RECORD_LOC_044	0x800044 /* recorder:recinst.c:(),
        During  MsgStart unable to allocate
        Std_MsgSetParm, qMsgAllocate FAILURE, for recorder_MsgAdjVolume */

#define RECORD_LOC_045	0x800045 /* recorder:recinst.c:(),
        Std_MsgSetParm_put FAILURE, for recorder_MsgAdjVolume */

#define RECORD_LOC_046	0x800046 /* recorder:recinst.c:(),
        Unable to send
        Std_MsgSetParm, qMsgWrite FAILURE, for 
        recorder_MsgAdjVolume */

#define RECORD_LOC_047	0x800047 /* recorder:recinst.c:(),
        Unable to allocate
        Std_MsgSetParm, qMsgAllocate FAILURE, for
        recorder_MsgAdjSpeed  */

#define RECORD_LOC_048	0x800048 /* recorder:recinst.c:(),
        Std_MsgSetParm_put FAILURE, for
        recorder_MsgAdjSpeed */

#define RECORD_LOC_049	0x800049 /* recorder:recinst.c:(),
        Unable to send
        Std_MsgSetParm, qMsgWrite FAILURE, for 
        recorder_MsgAdjSpeed*/

#define RECORD_LOC_050	0x800050 /* recorder:recinst.c:(),
        Unable to allocate ADec_MsgStart, qMsgAllocate
        FAILURE */

#define RECORD_LOC_051	0x800051 /* recorder:recinst.c:(),
        Unable to allocate message Std_MsgSetParm,
        qMsgAllocate FAILURE during 
        */

#define RECORD_LOC_052	0x800052 /* recorder:recinst.c:(),
        Std_MsgSetParm_put FAILURE duing 
        */

#define RECORD_LOC_053	0x800053 /* recorder:recinst.c:(),
        Unable to send Std_MsgSetParm, qMsgWrite
        FAILURE 
         */

#define RECORD_LOC_054	0x800054 /* recorder:recinst.c:(),
        Unable to allocate message Std_MsgEvtDetected,
        qMsgAllocate FAILURE */

#define RECORD_LOC_055	0x800055 /* recorder:recinst.c:(),
        Unable to send Std_MsgSetParm, qMsgWrite
        FAILURE */

#define RECORD_LOC_056	0x800056 /* recorder:recinst.c:(),
         qGStreamTerminate failure */

#define RECORD_LOC_057	0x800057 /* recorder:recinst.c:(),
        Unable to send AEnc_MsgStart, qMsgWrite
        FAILURE */

#define RECORD_LOC_058	0x800058 /* recorder:recinst.c:(),
        Unable to send Tgen_MsgStop, qMsgWrite
        FAILURE */

#define RECORD_LOC_059	0x800059 /* recorder:recinst.c:(),
         qGStreamTerminate failure */

#define RECORD_LOC_060	0x800060 /* recorder:recinst.c:(),
         qGStreamTerminate failure */

#define RECORD_LOC_061	0x800061 /* recorder:recinst.c:(),
        Unable to send AEnc_MsgStop, qMsgWrite
        FAILURE */

#define RECORD_LOC_062	0x800062 /* recorder:recinst.c:(),
        Unable to send AEnc_MsgPause, qMsgWrite
        FAILURE */

#define RECORD_LOC_063	0x800063 /* recorder:recinst.c:(),
        Unable to send Recorder_MsgPauseCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_064	0x800064 /* recorder:recinst.c:(),
        Unable to send AEnc_MsgStop, qMsgWrite
        FAILURE */

#define RECORD_LOC_065	0x800065 /* recorder:recinst.c:(),
        Std_MsgError_get FAILURE */

#define RECORD_LOC_066	0x800066 /* recorder:recinst.c:(),
        Unexpected recordingState */

#define RECORD_LOC_067	0x800067 /* recorder:recinst.c:(),
        Recorder_MsgStart_get failure */

#define RECORD_LOC_068	0x800068 /* recorder:recinst.c:(),
         qGStreamTerminate failure */

#define RECORD_LOC_069	0x800069 /* recorder:recinst.c:(),
        Unable to send Recorder_MsgStartCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_070	0x800070 /* recorder:recinst.c:(),
        qGStreamTerminate failure */

#define RECORD_LOC_071	0x800071 /* recorder:recinst.c:(),
        recorderGetParmValue FAILURE */

#define RECORD_LOC_072	0x800072 /* recorder:recinst.c:(),
        Tgen_MsgPlayTone_put FAILURE */

#define RECORD_LOC_073	0x800073 /* recorder:recinst.c:(),
        Unable to send Tgen_MsgPlayTone, qMsgWrite
        FAILURE */

#define RECORD_LOC_074	0x800074 /* recorder:recinst.c:(),
        Unable to send Recorder_MsgStartCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_075	0x800075 /* recorder:recinst.c:(),
        qGStreamTerminate failure */

#define RECORD_LOC_076	0x800076 /* recorder:recinst.c:(),
        Unable to send AEnc_MsgStart, qMsgWrite
        FAILURE */

#define RECORD_LOC_077	0x800077 /* recorder:recinst.c:(),
        Unable to send Recorder_MsgStartCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_078	0x800078 /* recorder:recinst.c:(),
        Unable to allocate encoder,
        qCompAllocate FAILURE */

#define RECORD_LOC_079	0x800079 /* recorder:recinst.c:(),
        Unable to send Std_MsgInitCmplt, qMsgWrite FAILURE*/

#define RECORD_LOC_080	0x800080 /* recorder:recinst.c:(),
        Unexpected mainState */

#define RECORD_LOC_081	0x800081 /* recorder:recinst.c:(),
        Std_MsgEvtDetected_get FAILURE */

#define RECORD_LOC_082	0x800082 /* recorder:recinst.c:(),
        recorderGetParmValue FAILURE  */

#define RECORD_LOC_083	0x800083 /* recorder:recinst.c:(),
        Invalid Action in RTC Action List */

#define RECORD_LOC_084	0x800084 /* recorder:recinst.c:(),
        Std_MsgSetParm_put FAILURE */

#define RECORD_LOC_085	0x800085 /* recorder:recinst.c:(),
        Unable to send Std_MsgSetParm,
        qMsgWrite FAILURE */

#define RECORD_LOC_086	0x800086 /* recorder:recinst.c:(),
        Std_MsgSetParm_put FAILURE */
             
#define RECORD_LOC_087	0x800087 /* recorder:recinst.c:(),
        recorderGetParmValue FAILURE */

#define RECORD_LOC_088	0x800088 /* recorder:recinst.c:(),
        Std_MsgSetParm_put FAILURE */

#define RECORD_LOC_089	0x800089 /* recorder:recinst.c:(),
        Unable to send Std_MsgSetParm,
        qMsgWrite FAILURE */

#define RECORD_LOC_090	0x800090 /* recorder:recinst.c:(),
        Std_MsgSetParmDef_get FAILURE */

#define RECORD_LOC_091	0x800091 /* recorder:recinst.c:(),
        Std_MsgSetParm_put FAILURE */

#define RECORD_LOC_092	0x800092 /* recorder:recinst.c:(),
        Unable to send Std_MsgSetParm,
        qMsgWrite FAILURE */

#define RECORD_LOC_093	0x800093 /* recorder:recinst.c:(),
        Std_MsgSetParm_put FAILURE */

#define RECORD_LOC_094	0x800094 /* recorder:recinst.c:(),
        Unable to send Std_MsgSetParm,
        qMsgWrite FAILURE */

#define RECORD_LOC_095	0x800095 /* recorder:recinst.c:(),
        Std_MsgGetParm_get FAILURE */

#define RECORD_LOC_096	0x800096 /* recorder:recinst.c:(),
        Unable to allocate message
        Std_MsgGetParmCmplt,
        qMsgAllocate FAILURE */

#define RECORD_LOC_097	0x800097 /* recorder:recinst.c:(),
        Std_MsgGetParmCmplt_put FAILURE */

#define RECORD_LOC_098	0x800098 /* recorder:recinst.c:(),
        Unable to send Std_MsgGetParmCmplt,
        qMsgWrite FAILURE */

#define RECORD_LOC_099	0x800099 /* recorder:recinst.c:(),
        Unable to allocate message Std_MsgGetxParmsCmplt,
        qMsgAllocate FAILURE  */

#define RECORD_LOC_100	0x800100 /* recorder:recinst.c:(),
        Std_MsgGetxParmsCmplt_put FAILURE  */

#define RECORD_LOC_101	0x800101 /* recorder:recinst.c:(),
         Std_MsgGetxParms_List_get FAILURE */

#define RECORD_LOC_102	0x800102 /* recorder:recinst.c:(),
        Unable to send Std_MsgGetxParmsCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_103	0x800103 /* recorder:recinst.c:(),
        Std_MsgDetectEvt_get FAILURE */

#define RECORD_LOC_104	0x800104 /* recorder:recinst.c:(),
        Std_MsgDetectxEvts_get FAILURE */

#define RECORD_LOC_105	0x800105 /* recorder:recinst.c:(),
        Std_MsgDetectxEvts_List_get FAILURE */

#define RECORD_LOC_106	0x800106 /* recorder:recinst.c:(),
        Std_MsgDetectxEvts_List_get FAILURE */

#define RECORD_LOC_107	0x800107 /* recorder:recinst.c:(),
        Unable to send Std_MsgDetectxEvtsCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_108	0x800108 /* recorder:recinst.c:(),
        Std_MsgCancelEvt_get FAILURE  */

#define RECORD_LOC_109	0x800109 /* recorder:recinst.c:(),
        Std_MsgCancelxEvts_get FAILURE */

#define RECORD_LOC_110	0x800110 /* recorder:recinst.c:(),
        Std_MsgCancelxEvts_List_get FAILURE  */

#define RECORD_LOC_111	0x800111 /* recorder:recinst.c:(),
        Unable to allocate message
        Std_MsgCancelxEvtCmplt, qMsgAllocate FAILURE */

#define RECORD_LOC_112	0x800112 /* recorder:recinst.c:(),
        Unable to send Std_MsgCancelxEvtsCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_113	0x800113 /* recorder:recinst.c:(),
        Std_MsgArmRTC_get FAILURE */

#define RECORD_LOC_114	0x800114 /* recorder:recinst.c:(),
        recorderGetParmValue for Recorder_ParmRtcStopBuffering FAILURE */

#define RECORD_LOC_115	0x800115 /* recorder:recinst.c:(),
                              Std_MsgArmxRTCs_get FAILURE */

#define RECORD_LOC_116	0x800116 /* recorder:recinst.c:(),
        Std_MsgArmxRTCs_List_get FAILURE */

#define RECORD_LOC_117	0x800117 /* recorder:recinst.c:(),
        Std_MsgArmxRTCs_List_get FAILURE */

#define RECORD_LOC_118	0x800118 /* recorder:recinst.c:(),
        recorderGetParmValue FAILURE for 
        Recorder_ParmRtcStopBuffering */

#define RECORD_LOC_119	0x800119 /* recorder:recinst.c:(),
        Unable to allocate
        Std_MsgArmxRTCsCmplt_Size,
        qMsgAllocate FAILURE */

#define RECORD_LOC_120	0x800120 /* recorder:recinst.c:(),
        Unable to send Std_MsgArmxRTCsCmplt, qMsgWrite
        FAILURE  */

#define RECORD_LOC_121	0x800121 /* recorder:recinst.c:(),
        Std_MsgDisarmRTC_get FAILURE  */

#define RECORD_LOC_122	0x800122 /* recorder:recinst.c:(),
        Unable to allocate Std_MsgDisarmRTCCmplt,
        qMsgAllocate FAILURE */

#define RECORD_LOC_123	0x800123 /* recorder:recinst.c:(),
        Unable to send Std_MsgDisarmRTCCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_124	0x800124 /* recorder:recinst.c:(),
        Std_MsgDisarmxRTCs_get FAILURE */

#define RECORD_LOC_125	0x800125 /* recorder:recinst.c:(),
        Std_MsgDisarmxRTCs_List_get FAILURE */

#define RECORD_LOC_126	0x800126 /* recorder:recinst.c:(),
        Unable to allocate Std_MsgDisarmxRTCsCmplt,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_127	0x800127 /* recorder:recinst.c:(),
        Unable to send Std_MsgDisarmxRTCsCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_128	0x800128 /* recorder:recinst.c:(),
        Unable to allocate Std_MsgDisarmAllRTCsCmplt,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_129	0x800129 /* recorder:recinst.c:(),
        Unable to send Std_MsgDisarmAllRTCsCmplt, qMsgWrite
         FAILURE*/

#define RECORD_LOC_130	0x800130 /* recorder:recinst.c:(),
        Std_MsgEvtDetected_get FAILURE */

#define RECORD_LOC_131	0x800131 /* recorder:recinst.c:(),
        Recorder_MsgEncoderQuery_get FAILURE*/

#define RECORD_LOC_132	0x800132 /* recorder:recinst.c:(),
        Unable to allocate Recorder_MsgEncoderQueryCmplt,
        qMsgAllocate FAILURE  */

#define RECORD_LOC_133	0x800133 /* recorder:recinst.c:(),
        Recorder_MsgEncoderQueryCmplt_put FAILURE */

#define RECORD_LOC_134	0x800134 /* recorder:recinst.c:(),
        Unable to send Recorder_MsgEncoderQueryCmplt,
        qMsgAllocate FAILURE */

#define RECORD_LOC_135	0x800135 /* recorder:recinst.c:(),
        QCompInstNotify_get FAILURE */

#define RECORD_LOC_136	0x800136 /* recorder:recinst.c:(),
        QHostExited_get FAILURE */

#define RECORD_LOC_137	0x800137 /* recorder:recinst.c:(),
        qHostExitCmplt FAILURE in RECORDER_IDLE state*/

#define RECORD_LOC_138	0x800138 /* recorder:recinst.c:(),
        qHostExitCmplt FAILURE in RECORDER_INIT state */

#define RECORD_LOC_139	0x800139 /* recorder:recinst.c:(),
        qHostExitCmplt FAILURE in RECORDER_DEALLOCATED state  */

#define RECORD_LOC_140	0x800140 /* recorder:recinst.c:(),
        qHostExitCmplt FAILURE in in active state state  */

#define RECORD_LOC_141	0x800141 /* recorder:recinst.c:(),
        QCompExited_get FAILURE */

#define RECORD_LOC_142	0x800142 /* recorder:recinst.c:(),
        qGStreamTerminate failure */

#define RECORD_LOC_143	0x800143 /* recorder:recinst.c:(),
        Unable to send special message type b0ff0, qMsgWrite
        FAILURE */

#define RECORD_LOC_144	0x800144 /* recorder:recinst.c:(),
        Unable to send Std_MsgDetectxEvtsCmplt, qMsgWrite FAILURE */

#define RECORD_LOC_145	0x800145 /* recorder:recinst.c:(),
        Unable to allocate AEnc_MsgStart,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_146	0x800146 /* recorder:recinst.c:(),
        Unable to allocate AEnc_MsgStop,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_147	0x800147 /* recorder:recinst.c:(),
        Unable to allocate AEnc_MsgStart,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_148	0x800148 /* recorder:recinst.c:(),
        Unable to allocate AEnc_MsgStart,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_149	0x800149 /* recorder:recinst.c:(),
        Unable to allocate AEnc_MsgStop,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_150	0x800150 /* recorder:recinst.c:(),
        Unable to allocate AEnc_MsgStop,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_151	0x800151 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgError,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_152	0x800152 /* recorder:recstds.c:(),
        Std_MsgError_put FAILURE */

#define RECORD_LOC_153	0x800153 /* recorder:recstds.c:(),
        Unable to send Std_MsgError, qMsgWrite
        FAILURE */

#define RECORD_LOC_154	0x800154 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgError,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_155	0x800155 /* recorder:recstds.c:(),
        Std_MsgError_put FAILURE */

#define RECORD_LOC_156	0x800156 /* recorder:recstds.c:(),
        Unable to send Std_MsgError, qMsgWrite
        FAILURE */

#define RECORD_LOC_157	0x800157 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgComtestCmplt,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_158	0x800158 /* recorder:recstds.c:(),
        Unable to send Std_MsgComtestCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_159	0x800159 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgSetParmCmplt,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_160	0x800160 /* recorder:recstds.c:(),
        Unable to send Std_MsgSetParmCmplt, qMsgWrite
        FAILURE */

#define RECORD_LOC_161	0x800161 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgSetxParmsCmplt,
        qMsgAllocate FAILURE*/

#define RECORD_LOC_162	0x800162 /* recorder:recstds.c:(),
        Unable to send Std_MsgSetxParmsCmplt, qMsgWrite FAILURE*/

#define RECORD_LOC_163	0x800163 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgSetParmDefCmplt,
        qMsgAllocate FAILURE */

#define RECORD_LOC_164	0x800164 /* recorder:recstds.c:(),
        Unable to send Std_MsgSetParmDefCmplt,
        qMsgWrite FAILURE*/

#define RECORD_LOC_165	0x800165 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgSetxParmsDefCmplt,
        qMsgAllocate FAILURE */

#define RECORD_LOC_166	0x800166 /* recorder:recstds.c:(),
        Unable to send Std_MsgSetxParmsDefCmplt,
        qMsgWrite FAILURE*/

#define RECORD_LOC_167	0x800167 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgSetAllParmsDefCmplt,
        qMsgAllocate FAILURE */

#define RECORD_LOC_168	0x800168 /* recorder:recstds.c:(),
        Unable to send Std_MsgSetAllParmsDefCmplt,
        qMsgWrite FAILURE*/

#define RECORD_LOC_169	0x800169 /* recorder:recstds.c:(),
        Std_MsgDetectEvt_get FAILURE */

#define RECORD_LOC_170	0x800170 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgDetectEvtCmplt,
        qMsgAllocate FAILURE */

#define RECORD_LOC_171	0x800171 /* recorder:recstds.c:(),
        Unable to send Std_MsgDetectEvtCmplt,
        qMsgWrite FAILURE*/

#define RECORD_LOC_172	0x800172 /* recorder:recstds.c:(),
        Std_MsgCancelEvt_get FAILURE */

#define RECORD_LOC_173	0x800173 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgCancelEvtCmplt,
        qMsgAllocate FAILURE */  

#define RECORD_LOC_174	0x800174 /* recorder:recstds.c:(),
        Unable to send Std_MsgCancelEvtCmplt,
        qMsgWrite FAILURE */

#define RECORD_LOC_175	0x800175 /* recorder:recstds.c:(),
        Std_MsgArmRTC_get FAILURE */

#define RECORD_LOC_176	0x800176 /* recorder:recstds.c:(),
        Unable to allocate Std_MsgArmRTCCmplt,
        qMsgAllocate FAILURE */  

#define RECORD_LOC_177	0x800177 /* recorder:recstds.c:(),
        Unable to send Std_MsgArmRTCCmplt,
        qMsgWrite FAILURE */

#define RECORD_LOC_178	0x800178 /* recorder:recstds.c:(),
        Std_MsgEvtDetected_get FAILURE */

#define RECORD_LOC_179	0x800179 /* recorder:recinst.c:(),
                         QResultError was received as a result of 
                         opening a GStream in order to flush it.
                         */

#define RECORD_LOC_180	0x800180 /* recorder:recinst.c:(),
                         received unexpected message in stopping state */

#define RECORD_LOC_181	0x800181 /* recorder:recinst.c:(),
                         received unexpected message in paused_start state
                         */

#define RECORD_LOC_182	0x800182 /* recorder:recinst.c:(),
                         received unexpected message in paused_normal state */

#define RECORD_LOC_183	0x800183 /* recorder:recinst.c:(),
                         received unexpected message in recording_startbeepinit state */

#define RECORD_LOC_184	0x800184 /* recorder:recinst.c:(),
                         received unexpected message in recording_normal state */

#define RECORD_LOC_185	0x800185 /* recorder:recinst.c:(),
                         Invalid GStream ID */

#define RECORD_LOC_186	0x800186 /* recorder:recinst.c:(),
                         Cluster not activated */

#define RECORD_LOC_187	0x800187 /* recorder:recinst.c:(),
                         received unexpected message in idle state */

#define RECORD_LOC_188	0x800188 /* recorder:recinst.c:(),
                         received unexpected message in deallocated state */

#define RECORD_LOC_189	0x800189 /* recorder:recinst.c:(),
                         received unexpected message in init state */

#define RECORD_LOC_190	0x800190 /* recorder:recinst.c:(),
                         Received Completely Unexpected Asynchronous Event */

#define RECORD_LOC_191	0x800191 /* recorder:recinst.c:(),
                         recorderGetParmValue FAILURE */

#define RECORD_LOC_192	0x800192 /* recorder:recinst.c:(),
                         Std_MsgSetParm_put FAILURE */

#define RECORD_LOC_193	0x800193 /* recorder:recinst.c:(),
                         qMsgWrite FAILURE */

#define RECORD_LOC_194	0x800194 /* recorder:recorderInit.c:(),
        qTaskCreate FAILURE */

#define RECORD_LOC_195	0x800195 /* recorder:recorderInit.c:(),
        qCompInitStart FAILURE */

#define RECORD_LOC_196	0x800196 /* recorder:recinst.c:(),
        Second CStream in a cluster has different
        encoding or idle pattern from first CStream */

#define RECORD_LOC_197	0x800197 /* recorder:recinst.c:(),
        Second CStream in a cluster has different
        encoding or idle pattern from first CStream */

#define RECORD_LOC_198	0x800198 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgStopped failed */

#define RECORD_LOC_199	0x800199 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgStopped failed */

#define RECORD_LOC_200	0x800200 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgResumeCmplt failed */

#define RECORD_LOC_201	0x800201 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgResumeCmplt failed */

#define RECORD_LOC_202	0x800202 /* recorder:recinst.c:(),
        Allocation of message block for AEnc_MsgResume failed */

#define RECORD_LOC_203	0x800203 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgResumeCmplt failed */

#define RECORD_LOC_204	0x800204 /* recorder:recinst.c:(),
        Allocation of message block for Tgen_MsgStop failed */

#define RECORD_LOC_205	0x800205 /* recorder:recinst.c:(),
        Allocation of message block for AEnc_MsgPause failed */

#define RECORD_LOC_206	0x800206 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgPauseCmplt failed */

#define RECORD_LOC_207	0x800207 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgStartCmplt failed */

#define RECORD_LOC_208	0x800208 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgStartCmplt failed */

#define RECORD_LOC_209	0x800209 /* recorder:recinst.c:(),
        Allocation of message block for Tgen_MsgPlayTone failed */

#define RECORD_LOC_210	0x800210 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgStartCmplt failed */

#define RECORD_LOC_211	0x800211 /* recorder:recinst.c:(),
        Allocation of message block for Recorder_MsgStartCmplt failed */

#define RECORD_LOC_212	0x800212 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgInitCmplt failed */

#define RECORD_LOC_213	0x800213 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgSetParm failed */

#define RECORD_LOC_214	0x800214 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgSetParm failed */

#define RECORD_LOC_215	0x800215 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgSetParm failed */

#define RECORD_LOC_216	0x800216 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgSetParm failed */

#define RECORD_LOC_217	0x800217 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgSetParm failed */

#define RECORD_LOC_218	0x800218 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgEvtDetected failed */

#define RECORD_LOC_219	0x800219 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgEvtDetected failed */

#define RECORD_LOC_220	0x800220 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgEvtDetected failed */

#define RECORD_LOC_221	0x800221 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgEvtDetected failed */

#define RECORD_LOC_222	0x800222 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgEvtDetected failed */

#define RECORD_LOC_223	0x800223 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgEvtDetected failed */

#define RECORD_LOC_224	0x800224 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgEvtDetected failed */

#define RECORD_LOC_225	0x800225 /* recorder:recinst.c:(),
        Allocation of message block for Std_MsgEvtDetected failed */

#define RECORD_LOC_226	0x800226 /* recorder:reccomp.c:(),
        Allocation of message block for Std_MsgInit failed */

#define RECORD_LOC_227	0x800227 /* recorder:reccomp.c:(),
        Allocation of message block for Recorder_MsgAllocateEncoderCmplt failed */

#define RECORD_LOC_228	0x800228 /* recorder:reccomp.c:(),
        Allocation of message block for Std_MsgInitCmplt failed */

#define RECORD_LOC_229	0x800229 /* recorder:.c:(),
        Allocation of message block for Std_MsgSetParm failed */

#define RECORD_LOC_230	0x800230 /* recorder:.c:(),
        Std_MsgSetParm_put FAILURE */

#define RECORD_LOC_231	0x800231 /* recorder:.c:(),
        qMsgWrite FAILURE */

#define RECORD_LOC_232	0x800232 /* recorder:.c:(),
        recorderGetParmValue FAILURE */

#define RECORD_LOC_233	0x800233 /* recorder:.c:(),
        Std_MsgSetParm_put FAILURE */

#define RECORD_LOC_234	0x800234 /* recorder:.c:(),
        Unable to send Std_MsgSetParm,
        qMsgWrite FAILURE */

#define RECORD_LOC_235	0x800235 /* recorder:.c:(),
        Allocation of message block for Std_MsgSetParm failed */

#define RECORD_LOC_236	0x800236 /* recorder:.c:(),
        Std_MsgSetParm_put FAILURE */

#define RECORD_LOC_237	0x800237 /* recorder:.c:(),
        qMsgWrite FAILURE */

#define RECORD_LOC_238	0x800238 /* recorder:.c:(),
        Allocation of message block for Std_MsgSetParm failed */

#define RECORD_LOC_239	0x800239 /* recorder:.c:(),
        recorderGetParmValue FAILURE for Recorder_ParmSyncRecord */

#define RECORD_LOC_240	0x800240 /* recorder:.c:(),
        Allocation of message block for Std_MsgSetParm FAILURE */

#define RECORD_LOC_241	0x800241 /* recorder:.c:(),
        Std_MsgSetParm_put FAILURE */

#define RECORD_LOC_242	0x800242 /* recorder:.c:(),
        qMsgWrite FAILURE */

#define RECORD_LOC_243	0x800243 /* recorder:recinst.c:(),
        Recorder_MsgDecoderXQuery_get failed */

#define RECORD_LOC_244	0x800244 /* recorder:recinst.c:(),
        qMsgAllocate failed for Recorder_MsgDecoderXQueryCmplt */

#define RECORD_LOC_245	0x800245 /* recorder:recinst.c:(),
        Recorder_MsgDecoderXQueryCmplt failed */

#define RECORD_LOC_246	0x800246 /* recorder:recinst.c:(),
        Recorder_MsgDecoderXQueryCmplt_CoderList_put failed */

#define RECORD_LOC_247	0x800247 /* recorder:recinst.c:(),
        qMsgWrite failed */

#define RECORD_LOC_248	0x800248 /* recorder:recinst.c:(),
        Recorder_MsgStartx_get failed. */

#if  END_OF_LOCS_TABLE

#define RECORD_LOC_249	0x800249 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_250	0x800250 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_251	0x800251 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_252	0x800252 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_253	0x800253 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_254	0x800254 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_255	0x800255 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_256	0x800256 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_257	0x800257 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_258	0x800258 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_259	0x800259 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_260	0x800260 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_261	0x800261 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_262	0x800262 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_263	0x800263 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_264	0x800264 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_265	0x800265 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_266	0x800266 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_267	0x800267 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_268	0x800268 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_269	0x800269 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_270	0x800270 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_271	0x800271 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_272	0x800272 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_273	0x800273 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_274	0x800274 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_275	0x800275 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_276	0x800276 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_277	0x800277 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_278	0x800278 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_279	0x800279 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_280	0x800280 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_281	0x800281 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_282	0x800282 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_283	0x800283 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_284	0x800284 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_285	0x800285 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_286	0x800286 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_287	0x800287 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_288	0x800288 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_289	0x800289 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_290	0x800290 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_291	0x800291 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_292	0x800292 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_293	0x800293 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_294	0x800294 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_295	0x800295 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_296	0x800296 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_297	0x800297 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_298	0x800298 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_299	0x800299 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_300	0x800300 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_301	0x800301 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_302	0x800302 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_303	0x800303 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_304	0x800304 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_305	0x800305 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_306	0x800306 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_307	0x800307 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_308	0x800308 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_309	0x800309 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_310	0x800310 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_311	0x800311 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_312	0x800312 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_313	0x800313 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_314	0x800314 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_315	0x800315 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_316	0x800316 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_317	0x800317 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_318	0x800318 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_319	0x800319 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_320	0x800320 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_321	0x800321 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_322	0x800322 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_323	0x800323 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_324	0x800324 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_325	0x800325 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_326	0x800326 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_327	0x800327 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_328	0x800328 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_329	0x800329 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_330	0x800330 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_331	0x800331 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_332	0x800332 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_333	0x800333 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_334	0x800334 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_335	0x800335 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_336	0x800336 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_337	0x800337 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_338	0x800338 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_339	0x800339 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_340	0x800340 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_341	0x800341 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_342	0x800342 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_343	0x800343 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_344	0x800344 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_345	0x800345 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_346	0x800346 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_347	0x800347 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_348	0x800348 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_349	0x800349 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_350	0x800350 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_351	0x800351 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_352	0x800352 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_353	0x800353 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_354	0x800354 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_355	0x800355 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_356	0x800356 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_357	0x800357 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_358	0x800358 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_359	0x800359 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_360	0x800360 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_361	0x800361 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_362	0x800362 /* recorder:reccomp.c:(),
        FAILURE */

#define RECORD_LOC_363	0x800363 /* recorder:reccomp.c:(),
        FAILURE */

#define RECORD_LOC_364	0x800364 /* recorder:reccomp.c:(),
        FAILURE */

#define RECORD_LOC_365	0x800365 /* recorder:reccomp.c:(),
        FAILURE */

#define RECORD_LOC_366	0x800366 /* recorder:reccomp.c:(),
        FAILURE */

#define RECORD_LOC_367	0x800367 /* recorder:reccomp.c:(),
        FAILURE */

#define RECORD_LOC_368	0x800368 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_369	0x800369 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_370	0x800370 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_371	0x800371 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_372	0x800372 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_373	0x800373 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_374	0x800374 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_375	0x800375 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_376	0x800376 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_377	0x800377 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_378	0x800378 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_379	0x800379 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_380	0x800380 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_381	0x800381 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_382	0x800382 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_383	0x800383 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_384	0x800384 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_385	0x800385 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_386	0x800386 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_387	0x800387 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_388	0x800388 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_389	0x800389 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_390	0x800390 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_391	0x800391 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_392	0x800392 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_393	0x800393 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_394	0x800394 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_395	0x800395 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_396	0x800396 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_397	0x800397 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_398	0x800398 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_399	0x800399 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_400	0x800400 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_401	0x800401 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_402	0x800402 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_403	0x800403 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_404	0x800404 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_405	0x800405 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_406	0x800406 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_407	0x800407 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_408	0x800408 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_409	0x800409 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_410	0x800410 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_411	0x800411 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_412	0x800412 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_413	0x800413 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_414	0x800414 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_415	0x800415 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_416	0x800416 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_417	0x800417 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_418	0x800418 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_419	0x800419 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_420	0x800420 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_421	0x800421 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_422	0x800422 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_423	0x800423 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_424	0x800424 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_425	0x800425 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_426	0x800426 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_427	0x800427 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_428	0x800428 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_429	0x800429 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_430	0x800430 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_431	0x800431 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_432	0x800432 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_433	0x800433 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_434	0x800434 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_435	0x800435 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_436	0x800436 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_437	0x800437 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_438	0x800438 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_439	0x800439 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_440	0x800440 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_441	0x800441 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_442	0x800442 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_443	0x800443 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_444	0x800444 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_445	0x800445 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_446	0x800446 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_447	0x800447 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_448	0x800448 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_449	0x800449 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_450	0x800450 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_451	0x800451 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_452	0x800452 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_453	0x800453 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_454	0x800454 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_455	0x800455 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_456	0x800456 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_457	0x800457 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_458	0x800458 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_459	0x800459 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_460	0x800460 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_461	0x800461 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_462	0x800462 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_463	0x800463 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_464	0x800464 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_465	0x800465 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_466	0x800466 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_467	0x800467 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_468	0x800468 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_469	0x800469 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_470	0x800470 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_471	0x800471 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_472	0x800472 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_473	0x800473 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_474	0x800474 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_475	0x800475 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_476	0x800476 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_477	0x800477 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_478	0x800478 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_479	0x800479 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_480	0x800480 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_481	0x800481 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_482	0x800482 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_483	0x800483 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_484	0x800484 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_485	0x800485 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_486	0x800486 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_487	0x800487 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_488	0x800488 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_489	0x800489 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_490	0x800490 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_491	0x800491 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_492	0x800492 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_493	0x800493 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_494	0x800494 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_495	0x800495 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_496	0x800496 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_497	0x800497 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_498	0x800498 /* recorder:.c:(),
        FAILURE */

#define RECORD_LOC_499	0x800499 /* recorder:.c:(),
        FAILURE */

#endif END_OF_LOCS_TABLE
#endif
