/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/


/****************************************************************************
 * FILE:         
 * AUTHOR:       Chris Chuba
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    10-Aug-95 at 12:18:50
 * LAST-MOD:     Tue Feb 26 18:13:30 2002 by Amin Rhemtulla
 * PURPOSE:
 *
 * HISTORY:
 * Date			Who	Description
 * 25-Feb-00      AR    Memory optimization not possible. Maintaining the
 *                      LUNA merge done for the task.
 *                      (TASK-12736:PT-N/A)
 * 25-Feb-00      AR    Memory optimization. Type now 32 bits instead of
 *                      128 bits as default value which can be overriden.
 *                      - Also merged the LUNA changes done by chris ring
 *                      that were not part of 6.0
 *                      (TASK-12719:PT-N/A)
 * 24-Sep-96	DNH	Added bit-based event types via functions RtcDetectBEvt(),
 *							RtcWriteBEvtDetected(), and RtcCancelBEvt().  This reduces
 *							the memory needed for grouped event types where the armer
 *							address, transaction Id, Label, and RetAddress (destination)
 *							remain constant.
 * 10-Aug-95   CC    Initial creation.
 ***************************************************************************/
#ifndef  _RTCAPI_H__
#define _RTCAPI_H__
#include <qmsg.h>

typedef  enum {RTC_STATUS_ERROR, RTC_STATUS_DONE} RtcStatus;

typedef struct
{
   QCompDesc  destination;
} RtcEventType;

/*
 * Bit Event Management defines.
 *
 * RTC_NumBitEvents determines the maximum eventType that can
 * be enabled using the Bit Event functions.  Change this value by
 * adding or subtracting 32 to increase or reduce the number of events 
 * (note that increasing this beyond 128 will increase the size of 
 * the Rtc structure).
 */
#define RTC_NumBitEvents	128
#define RTC_BitWordSize		(sizeof(Uint32)*8)
#define RTC_NumBitWords		(RTC_NumBitEvents/RTC_BitWordSize)

/* Calculates the bit position of the specified event type */
#define RTC_BitEventInd(event)	(event/RTC_BitWordSize)
#define RTC_BitEventValue(event)	((Uint32)1 << (event%RTC_BitWordSize))

typedef  Uint16   RtcRef;
   
typedef struct
{
   RtcRef      next;
   QCompDesc   ArmerAddr;
   QTrans      ArmerId;
   Uint32      label;
   union {
      RtcEventType   event;   /* Destination  address */
      UInt32         action;  /* The requested action */
   } x;
   /*
    * The following was broken into a scalar array in order to decrease
    * the structure size from 64 bytes to 48 bytes.
    */
   UInt32 type[RTC_NumBitWords];/* Event types */
} Rtc;

/*
 * The RTC_ERRNO_??? defines are used when RTC_STATUS_ERROR
 * is returned from the function.  When this occurrs use
 * RtcGetErrno(RtcPoolId   thePool) to get one of the following 
 * values for a more precise error definition.
 */

/* No error has occurred for this pool */
#define  RTC_ERRNO_NONE    0

/* The value of an RTC Reference was too big */
#define  RTC_ERRNO_BAD_EVENT_REFERENCE  1

/* The value of an RTC reference was NULL */
#define  RTC_ERRNO_NULL_REFERENCE  2

/* The value of an RTC Reference was too big */
#define  RTC_ERRNO_BAD_ACTION_REFERENCE  3

/* Duplicate entry on the action list */
#define  RTC_ERRNO_ALREADY_ON_LIST  4

/* The heap is out of entries */
#define  RTC_ERRNO_POOL_EXHUASTED   5

/* The value of an RTC reference was NULL */
#define  RTC_ERRNO_BAD_REFERENCE  6

/* The event type is out of range */
#define  RTC_ERRNO_EVENT_TYPE_BAD   7

typedef struct {
   RtcRef   head;       /* The head of the free list */
   int      count;      /* The number of elements in the pool */
   int      rtcErrno;   /* The last error code */
   #if (QCPU == QX86)   
	Uint32   numBytes;   /* total size of this pool */
   #endif
   Rtc      refs[1];    /* The actual storage for the RTC references. */
                        /* Note, this is [1] for dynamic memory allocation. */
} RtcPool;

typedef RtcPool*  RtcPoolId;

   
RtcStatus RtcCreatePool(Uint16, RtcPoolId*, Uint32*);
RtcStatus RtcDeletePool(RtcPoolId);
RtcStatus RtcDetectEvt(RtcPoolId, QMsgRef, QCompDesc, Uint32, Uint32,
                       RtcRef*);
RtcStatus RtcDetectBEvt(RtcPoolId, QMsgRef, QCompDesc, Uint32, Uint32,
                       RtcRef*);
RtcStatus RtcWriteEvtDetected(RtcPoolId, Uint32, RtcRef*, QMsgRef, Uint32*);
RtcStatus RtcWriteBEvtDetected(RtcPoolId, Uint32, RtcRef*, QMsgRef, Uint32*);
RtcStatus RtcCancelEvt(RtcPoolId, QMsgRef, Uint32, RtcRef*);
RtcStatus RtcCancelBEvt(RtcPoolId, QMsgRef, Uint32, RtcRef*);
RtcStatus RtcArmRTC(RtcPoolId, QMsgRef, Uint32, Uint32, RtcRef*);
RtcStatus RtcReadEvtDetected(RtcPoolId, QMsgRef, RtcRef, Uint32, Uint32*);
RtcStatus RtcDisarmRTC(RtcPoolId,QMsgRef, Uint32, RtcRef*);
RtcStatus RtcDisarmAllRTCs(RtcPoolId, QMsgRef,RtcRef*);
RtcStatus RtcCancelAllEvts(RtcPoolId, QMsgRef, RtcRef*);
RtcStatus RtcFreeAllRtcs(RtcPoolId thePool, QCompDesc*,RtcRef* theList);
void  RtcPrintList(RtcPoolId  thePool,RtcRef    theList);
RtcStatus RtcFindAction(RtcPoolId thePool,UInt32 theAction,RtcRef theList);

/* If flag == true then print errors, global to all pools */
void RtcSetPrint(int  flag);

/* Get the errno value for this RTC pool */

/* See the RTC_ERROR_??? defines for actual error codes */
int   RtcGetErrno(RtcPoolId   thePool);




#endif   /* protects against nested includes */
