#ifndef  _SDSIGNAL_H__
#define  _SDSIGNAL_H__


/*
 * The following define reserves a set of 32 id's for each possible
 * country code.
 */
#define  SD_WORLD  (26*26) /*Reserves for country codes */
#define  SIG_ID_MASK 0x1f     /*Mask to extract the id portion of any set*/

/*
 * This generates a start and end range for a given set.
 */
#define  CreateRange(_NAME,_NUM_OF_SETS) \
SD_ ## _NAME ## _START, \
SD_ ## _NAME ## _END = ((SD_ ## _NAME ## _START) + ((_NUM_OF_SETS*32)-1))

/*
 * These are all the set ranges.
 * New set ranges must always be added to the end of this list.
 */
enum {
   SD_START=31,                  /* Set 0 is not used */

   CreateRange(BEEP, 1),         /*SD_BEEP_START and SD_BEEP_END defined */
   CreateRange(BUSY, SD_WORLD),  /*SD_BUSY_START and SD_BUSY_END defined */
   CreateRange(DIALTONE, SD_WORLD), /*SD_DIALTONE_START and SD_DIALTONE_END */
   CreateRange(DGSD, 1),         /*etc. */
   CreateRange(DTMF, SD_WORLD),
   CreateRange(FAX_CED, 1),
   CreateRange(FAX_CNG, 1),
   CreateRange(MF, SD_WORLD),
   CreateRange(PAMD, SD_WORLD),
   CreateRange(PVD, SD_WORLD),
   CreateRange(RINGING, SD_WORLD),
   CreateRange(SILENCE, SD_WORLD),
   CreateRange(SIT, SD_WORLD),
   CreateRange(R2MFF, SD_WORLD),
   CreateRange(R2MFB, SD_WORLD),
   CreateRange(DISCONNECT, 1),
   /*
    * Add new ranges here 
    */
   SD_END
};


#define  CreateCountrySet(_BASE_SET,_LETTER1,_LETTER2) \
(_BASE_SET + (((_LETTER1-'A') + ((_LETTER2-'A')*26))*32) )


/*
 * Miscellaneous dialogic signal id and set definitions.
 */
#include <dlmisc.h>

/*
 * CALL ANALYSIS - Signal Id and set definitions
 */
#include <sdcall.h>

#endif
