/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2000-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/

#ifndef __SRLLIB_H__
#define __SRLLIB_H__

#ifdef __STANDALONE__            /* List of required header files */
#endif

#include "dlgctypes.h"
#if defined(__cplusplus)
extern "C" {
#endif

/*
 * Included header files
 */
#include "srl_eblk.h"
#include "srltpt.h"

/*
 * Machine and System dependent defines
 */
#ifdef UNIX

/*
 * Disable far, near, huge and cdecl keywords
 */
#define  far
#define  near
#define  huge
#define  cdecl

#endif            /* System V/386 */

/* Define NULL if it hasn't been defined already */
#ifndef NULL
#define NULL        0L
#endif

/*
 * Defines used for standard attributes 
 */

/*
 * Undefined attribute or Failed to get attribute
 */
#define AT_FAILURE  -1
#define AT_FAILUREP NULL

#define EDV_BADDESC -1
#define EDV_NOERROR 0

/*
 * Open Flags for devices
 */
#define OF_DEFAULT 0x00           /* Open device without automatic notification */
#define O_NOTIFY   0x01           /* Open device with automatic notification */


/*
 * General Defines
 */
#define EV_ANYEVT  0xFFFFFFFF     /* Matches Any Event Type   */
#define EV_ANYDEV   -1            /* Matches Any Device      */
#define SR_DFLT_DATASIZE 48       /* Max size for SRL's statically allocated 
                                     event data area */

#define sr_putevt _sr_putevt /* Alias to be compliant with the NT signature */

typedef struct _tagSrlDeviceInfo
{
   char szDevName[12]; /* Name of the device */
   int  iDevType;      /* Device type - see ATDV_DEVICETYPE */
} SRLDEVICEINFO, *LPSRLDEVICEINFO;

typedef long SRL_DEVICE_HANDLE;


/*
 * SRL standard attribute functions
 */
#if defined(__cplusplus) || defined(__STDC__)

extern char *ATDV_ERRMSGP( long ddd );
extern long ATDV_IOPORT( long ddd );
extern long ATDV_IRQNUM( long ddd );
extern long ATDV_LASTERR( long ddd );
extern char *ATDV_NAMEP( long ddd );
extern long ATDV_SUBDEVS( long ddd );

#else

extern char *ATDV_ERRMSGP();
extern long ATDV_IOPORT();
extern long ATDV_IRQNUM();
extern long ATDV_LASTERR();
extern char *ATDV_NAMEP();
extern long ATDV_SUBDEVS();

#endif

/* 
 * EVENT MANAGEMENT 
 */
#define SR_INTERPOLLID 0x01     /* Parameter id for inter-poll delay */
#define SR_MODEID      0x02     /* Set SRL running in signalling or DOS mode */
#define SR_DATASZID    0x03     /* Parameter id for getting/setting SRL's 
                                   preallocated event data memory size */
#define SR_QSIZEID     0x04     /* Maximum size of SRL's internal event 
                                   queue */
#define SR_USERCONTEXT 0x06	/* Allows user to set per device context */

#define SR_POLLMODE    0        /* Run SRL in polling mode */
#define SR_SIGMODE     1        /* Run SRL in signalling/interrupt mode */
#define SRL_DEVICE     0        /* The SRL device */
                                   
/* SRL EVENTS */
#define SR_TMOUTEVT    0        /* Timeout event - occurs on the SRL DEVICE */

/* SRL errors */
#define ESR_NOERR        0      /* No SRL errors */
#define ESR_SCAN         1      /* SRL scanning function returned an error */
#define ESR_PARMID       2      /* Unknown parameter id */
#define ESR_TMOUT        3      /* Returned by ATDV_LASTERR( SRL_DEVICE ) when
                                   an SRL function timed out */
#define ESR_SYS          4      /* System error - consult errno */
#define ESR_DATASZ       5      /* Invalid size for default event data 
                                   memory */
#define ESR_QSIZE        6      /* Illegal event queue size */
#define ESR_NOHDLR       7      /* No such handler */
#define ESR_MODE         8      /* Illegal mode for this operation */
#define ESR_NULL_DATAP   9      /* Pointer argument is null */
#define ESR_BADDEV      10      /* Invalid or Missing device */
#define ESR_NOMEM       11      /* No or insufficient memory available */
#define ESR_BADPARM     12      /* Invalid parameter or parameter value */
#define ESR_NOCOM       13      /* SRL can not communicate with another sub system */
#define ESR_INSUFBUF    14      /* No or insufficient buffers available */
#define ESR_THREAD_DEVICE_GROUP_EXISTS 15
#define ESR_THREAD_DEVICE_GROUP_NO_GROUP_DEFINED 16
#define SR_TMOUT   -1           /* Returned by event scanning functions (e.g.
                                   sr_waitevt()) when they time out */

typedef enum tagSR_EVENTDATASCOPE_TAG
{
   SR_EVENTDATASCOPE_TAG_SRL,  /* SRL will free up the event data memory upon 
								  the next call to sr_waitevt() or sr_getevtdatap().*/
   SR_EVENTDATASCOPE_TAG_USER  /* Application must free up the event data  memory 
								  through a call to sr_destroy().*/
}SR_EVENTDATASCOPE;


#if defined(__cplusplus) || defined(__STDC__)


extern long SRLGetAllPhysicalBoards(int *piNum, AUID *pPhysicalBoards);
extern long SRLGetPhysicalBoardName(AUID physicalBoard, int *piLen, char *szName);
extern long SRLGetVirtualBoardsOnPhysicalBoard(
    AUID physicalBoard,
    int *piNum,
    SRLDEVICEINFO *pInfo);
extern long SRLGetSubDevicesOnVirtualBoard(
    char *szVirtualBoard,
    int *piNum,
    SRLDEVICEINFO *pInfo);
extern long SRLGetJackForR4Device(char *szR4Device, int *piJackNum);

extern long sr_CreateThreadDeviceGroup( long *dddp, int count); /* Block incoming events for thread */
extern long sr_AddToThreadDeviceGroup( long *dddp, int count); /* Block incoming events for thread */
extern long sr_RemoveFromThreadDeviceGroup( long *dddp, int count); /* Unblock incoming events for thread */
extern long sr_GetThreadDeviceGroup( long *dddp, int *count); /* get list of devices blocked for this thread */
extern long sr_DeleteThreadDeviceGroup( void ); /* Unblock incoming events for thread */
extern long sr_WaitThreadDeviceGroup( long tmout ); /* Wait for next event per thread */
extern long sr_waitevt( long tmout ); /* Wait for next event */
extern long sr_waitevtEx( long *dddp, int count, long tmout, long *evhandle ); /* Wait for next event per device group */

extern long sr_enbhdlr( long ddd, unsigned long event_type, 
                       long (*hdlr)( void *parm ) ); 
                                /* Enable an event handler */

extern long sr_dishdlr( long ddd, unsigned long event_type, 
                       long (*hdlr)( void *parm ) ); 
                                /* Disable an event handler */

extern long sr_getevtdev( void ); /* Get the ddd of the current event */
extern long sr_getevttype( void ); /* Get the type of the current event */
extern long sr_getevtlen( void ); /* Get the data length for current event */
extern void *sr_getevtdatap( void ); /* Get the data pointer for current event */
extern void *sr_getUserContext( void ); /* Get the data pointer for current event */
extern long sr_hold( void );     /* Hold off events in SIGNAL mode */
extern long sr_release( void ); /* Release events in SIGNAL mode */
extern long sr_getparm( long ddd, long parmid, void* valuep);   
                                /* Get the value of an SRL paramater */

extern long sr_setparm( long ddd, long parmid, void* valuep ); 
                                /* Set the value of an SRL paramater */

extern void sr_getfdinfo( int *fdp );
extern int  sr_getfdcnt( void );
extern void sr_pollhandler( void );

extern long  _sr_putevt(long, unsigned long, long, void *, long); /* Queue an event. */
extern long  sr_putevtUserContext(long, unsigned long, long, void *, long, void *); /* Queue an event. */


extern void * sr_createevtdatapcopy(long evt, const void * evtdatap, int datalen); /* Request a copy of event data from the SRL */
extern void * sr_getevtdatapex(SR_EVENTDATASCOPE evtDataScopeValue); /* Request a copy of event data from the SRL */
extern long sr_destroy(void * evtdatap); /* Delete the memory created by sr_createevtdatapcopy() or sr_getevtdatapex()*/

extern long SRLGetAllAuid (AUID* lpAuid, int *lpLen);
extern long SRLGetDevices (AUID auBrd, LPSRLDEVICEINFO lpSrlDev, int* lpLen);

extern long sr_getboardcnt(char *brdname, int *brdcnt);

#else

extern long SRLGetAllPhysicalBoards();
extern long SRLGetPhysicalBoardName();
extern long SRLGetVirtualBoardsOnPhysicalBoard();
extern long SRLGetSubDevicesOnVirtualBoard();
extern long SRLGetJackForR4Device();

extern long sr_CreateThreadDeviceGroup(); /* Block incoming events for thread */
extern long sr_AddToThreadDeviceGroup(); /* Block incoming events for thread */
extern long sr_RemoveFromThreadDeviceGroup(); /* Unblock incoming events for thread */
extern long sr_GetThreadDeviceGroup(); /* get list of devices blocked for this thread */
extern long sr_DeleteThreadDeviceGroup(); /* Unblock incoming events for thread */
extern long sr_WaitThreadDeviceGroup(); /* Wait for next event per thread */
extern long sr_waitevt();        /* Wait for next event */
extern long sr_waitevtEx();      /* Wait for next event per device group */
extern long sr_enbhdlr();        /* Enable an event handler */
extern long sr_dishdlr();        /* Disable an event handler */
extern long sr_getevtdev();      /* Get the ddd of the current event */
extern long sr_getevttype();     /* Get the type of the current event */
extern long sr_getevtlen();      /* Get the data length for current event */
extern void *sr_getevtdatap();   /* Get the data pointer for current event */
extern void *sr_getUserContext();   /* Get the data pointer for current event */
extern long sr_hold();           /* Hold off events in SIGNAL mode */
extern long sr_release();        /* Release events in SIGNAL mode */
extern long sr_getparm();        /* Get the value of an SRL paramater */
extern long sr_setparm();        /* Set the value of an SRL paramater */

extern void sr_getfdinfo();
extern int  sr_getfdcnt();
extern void sr_pollhandler();

extern long sr_putevtUserContext();	/* Queue an event. */
extern long _sr_putevt();	/* Queue an event. */

/*	Free event data blocks generated by sr_createevtdatapcopy() and sr_getevtdatapex()*/
extern void * sr_createevtdatapcopy(); /* Request a copy of event data from the SRL */
extern void * sr_getevtdatapex(); /* Request a copy of event data from the SRL */
extern long sr_destroy();

extern long __cdecl SRLGetAllAuid ();
extern long __cdecl SRLGetDevices ();

extern long __cdecl sr_getboardcnt();

#endif


/* terminate the extern "C" for c plus plus */
#if defined(__cplusplus)
}
#endif

#endif                          /* __SRLLIB_H__ */

