#ifndef _STDMSGS_H__
#define  _STDMSGS_H__
#include <rtcapi.h>
#include <qtaskapi.h>
#include <stddefs.h>

/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         stdmsgs.h         
 * AUTHOR:       Luke Kiernan
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    24-May-95 at 14:57:17
 * LAST-MOD:     Tue Apr 02 15:26:26 2002 by Amin Rhemtulla
 * PURPOSE:
 *    This header file contains all of the prototpe statements for the
 *    Standard Component Message Library.
 *
 * HISTORY:
 * Date			Who	Description
 * 17-Apr-02      AR    included stddefs.h
 * 02-Apr-02      AR    Added stdSearchALRActionGivenLabel and 
 *                      stdSetActionLabelRange functions for processing
 *                      Action Label Ranges (ALR).
 *                      (TASK-13017:PT-N/A)
 * 24-May-95	LK 	Initial Version
 ***************************************************************************/

#define PARM_READONLY   1
#define PARM_READWRITE  2
#define PARM_WRITEONLY  3

#define STDMSGS_FREEACTION (0)

/*
 * Parameter Table Entry Typedef
 */
typedef struct {
   Uint32   pNum;
   Uint32   pType;
   Uint32   pVal;
   Uint32   pDef;
} ParmStruc_t;

/*
 * Standard Protoyping statements
 */
QStatus stdError (QMsgRef, Uint32, Uint32, Uint32, Uint32, Uint32);
QStatus stdAck (QMsgRef);
QStatus stdComtest (QMsgRef);
QStatus stdCreateInst (QCompDesc, Uint24, Uint24, QTaskId, QTaskDesc);
QStatus stdSetParm (QMsgRef, ParmStruc_t *);
QStatus stdSetParmDef (QMsgRef, ParmStruc_t *);
QStatus stdSetAllParmsDef (QMsgRef, ParmStruc_t *);
QStatus stdGetParm (QMsgRef, ParmStruc_t *);
#ifdef KERNEL_CP 
QStatus stdDetectEvt (QMsgRef, RtcRef *, RtcPoolId);
QStatus stdCancelEvt (QMsgRef, RtcRef *, RtcPoolId);
QStatus stdCancelAllEvts (QMsgRef, RtcRef *, RtcPoolId);
QStatus stdArmRTC (QMsgRef, RtcRef *, RtcPoolId);
QStatus stdDisarmRTC (QMsgRef, RtcRef *, RtcPoolId);
QStatus stdDisarmAllRTCs (QMsgRef, RtcRef *, RtcPoolId);
QStatus stdEvtDetected (QMsgRef, RtcRef *, RtcPoolId, Uint32 *);
QStatus stdSetActionLabelRange(QMsgRef                  inMsg,
                               Std_MsgSetActLbls_ALR_t  *ALRArr,
                               Uint32                   sizeALRArr,
                               Uint32                   validActionMin,
                               Uint32                   validActionMax);
Uint32 stdSearchALRActionGivenLabel(Std_MsgSetActLbls_ALR_t  *ALRArr,
                                    Uint32                   sizeALRArr,
                                    Uint32                   label);
#endif
#endif
