#ifndef _SIGSTD_H__
#define _SIGSTD_H__
/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         
 * AUTHOR:       Chris Chuba
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    22-Aug-95 at 16:47:12
 * LAST-MOD:     Sun Aug 11 23:17:41 2002 by Amin Rhemtulla
 * PURPOSE:
 *    This contains definitions that are common to most of the modules of
 *    the tone detection resource.
 *
 * HISTORY:
 * Date			Who	Description
 * 11-Aug-02   AR    (TASK-15262:PT27516,23731)
 *                   Increase the value of MAX_QSTD_TABLE to 51 from 48.
 *                   Need to handle new messages Std_MsgSetActLbls.
 * 22-Aug-95   CC    Initial creation.
 ***************************************************************************/
#include <qmsg.h>


/***************************************************************************
 * All instance variables are declared and accessed through the following macros
 */
#define  NewVar(cType,vName) \
cType vName ##_v;

#define  NewVarArray(cType,vName,vDemension) \
cType vName ## _v[vDemension];

/*
 * VarAccess - A macro used to access instance variables.
 * vName - The name of the variable being referenced.
 * bName - The name of the pointer to the base address of the instances
 *         variables 
 */
#define  VarAccess(vName,bName)  bName ## -> ## vName ## _v
/***************************************************************************/


/***************************************************************************/

/*
 * Given a source address, destination address, transaction Id, and message
 * type this macro will format a simple Mercury message.
 */
#define  MakeQMsg(_source,_dest,_trans,_type,_val1) \
_val1->transaction = _trans;        \
_val1->source = _source;            \
_val1->destination = _dest;         \
_val1->type = _type;
/***************************************************************************/

#define  QPrivate static
#define  QPrivateInline static __inline

/*
 * The following structure definition is for that are read/write parameters 
 */
typedef  struct {
   Uint32   val;
   Uint32   def;
} QParmEntry;

/*
 * This is type definition is for the standard component parameters
 */
typedef struct {
   Uint32      version;
   Uint32      vendor;
   Uint32      maxInst;
   QParmEntry  instNum;         /* The actual number of instances */
   QParmEntry  startInstance;
} StdQCompParms;

/*
 * The following typedef is for a pointer to a function that returns true
 * if the function needs the reply message to be sent to the client or false
 * if a reply message should not be sent.  If a reply message is to be sent
 * then it is the responsibility of that function to format the message body
 * and type if it changes from the default message type.  Note, all the other
 * fields of the message header are formatted by stdQMsgProcess().
 */
typedef  boolean (*StdQMsgHandler)(void*,QMsgRef,QMsgRef);

/*(TASK-15262:PT27516,23731). Increase to 51 from 48*/
#define  MAX_QSTD_TABLE 51    /* The maximum dimension of the table */

void  stdQMsgFormatParmError(QMsgRef,Uint32,Uint32,Uint32);
void  stdQMsgSysInit(StdQMsgHandler*);
void  stdQMsgHdlr(void*,StdQMsgHandler*,StdQCompParms*,QMsgRef);
void  stdQMsgWriteFault(int lineNumber, char* fileName, int compType, QMsgRef theMsg);

void stdQMsgFormatError( QMsgRef   replyMsg,
                         Uint32    errMsg,
                         Uint32    errCode,
                         Uint32    Data1,
                         Uint32    Data2);

/* This is used for the Instance state machine */
enum {InstState_FREE=1,InstState_ALLOCATED};



#define QStdAddrCompare(_arg1,_arg2) \
((_arg1.instance == _arg2.instance) && \
 (_arg1.component == _arg2.component) && \
 (_arg1.processor == _arg2.processor) && \
 (_arg1.board == _arg2.board) && \
 (_arg1.node == _arg2.node))


#endif
