/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         tgenLocs.h
 * AUTHOR:       Rosebud Alexander
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    13-Apr-00 at 18:03:04
 * LAST-MOD:     14-Feb-03 at 07:34:54 by Jayanthi Bhagavathula
 * PURPOSE:
 *    This module contains the error code definitions for the Tone Generator Resource.
 *
 * HISTORY:
 * Date			Who	Description
 * 13-Feb-03   JB    Task 17256: Added entries from 259 - 262.
 * 21-Jun-02   BC    Task 14530:PT 25285, added error number from 256-258 for extended messages.
 * 17-Jan-02   BC    Task 12038, added error number from 254/255 for exit function.
 * 22-Aug-01   XKM   Task 9566,added error number 253 for Std_MsgClearPendingAction.
 * 10-May-01   BC    Added error messages for extended message handlers.
 *                   From 247 to 252.   
 * 09-Aug-00   RA	   Initial Version
 ***************************************************************************/
#if !defined(_tgenLocs_h)
#define _tgenLocs_h 1
  
#include "qmiscapi.h"

/* 
 * Tonegen wrappers for qError( ) calls
 */
extern char *tonegenLocationsFileName;
void tonegenErrKillTask ( Uint24 errTag );
void tonegenErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc );
void tonegenErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 );
void tonegenErrWarning ( Uint24 errTag );
void tonegenErrInstWarning ( Uint24 errTag, QCompDesc *pDesc );
void tonegenErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 );
void tonegenErrAdvisory ( Uint24 errTag );
void tonegenErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc );
void tonegenErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 );

#if !defined(_TGENCOMP_C__)
extern char *tonegenLocationsFileName;
#else
char *tonegenLocationsFileName = "tgenLocs.h";

/******************************************************************************
 *       NAME : tonegenErrKillTask
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void tonegenErrKillTask ( Uint24 errTag )
{
  qError (QERR_KILLTASK, errTag, tonegenLocationsFileName);
}

/******************************************************************************
 *       NAME : tonegenErrInstKillTask
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void tonegenErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_KILLTASK, errTag, tonegenLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : tonegenErrArgsKillTask
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void tonegenErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
   int count=4;
   qErrorArgs (QERR_KILLTASK, errTag, tonegenLocationsFileName, pDesc, count, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : tonegenErrWarning
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void tonegenErrWarning ( Uint24 errTag )
{
  qError (QERR_WARNING, errTag, tonegenLocationsFileName);
}

/******************************************************************************
 *       NAME : tonegenErrInstWarning
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void tonegenErrInstWarning ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_WARNING, errTag, tonegenLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : tonegenErrArgsWarning
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void tonegenErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_WARNING, errTag, tonegenLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : tonegenErrAdvisory
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void tonegenErrAdvisory ( Uint24 errTag )
{
  qError (QERR_ADVISORY, errTag, tonegenLocationsFileName);
}

/******************************************************************************
 *       NAME : tonegenErrInstAdvisory
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void tonegenErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_ADVISORY, errTag, tonegenLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : tonegenErrArgsAdvisory
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void tonegenErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_ADVISORY, errTag, tonegenLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

#endif

#define TONEGEN_LOC_000	0x800000 /* TONEGEN:.c:(),
				    */

#define TONEGEN_LOC_001	0x800001 /* TONEGEN:tgencomp.c:tgenCreateDelete_ValidErr(),
                                    Unable to retrieve infomation from the standard error message
                                    Std_MsgError_get FAILURE */

#define TONEGEN_LOC_002	0x800002 /* TONEGEN:tgencomp.c:tgenCreate_GoodCreateMessage(),
                                    Failure in getting the label and id information from the create tone message 
                                    tgenQueue_GetMsg FAILURE */ 

#define TONEGEN_LOC_003	0x800003 /* TONEGEN:tgencomp.c:tgenCreate_GoodCreateMessage(),
                                    Failure in taking the message off the queue when tgenFindWgenID found the same
                                    signal ID already existing in the system  
                                    TgenQueue_KillMsg FAILURE */

#define TONEGEN_LOC_004	0x800004 /* TONEGEN:tgencomp.c:tgenCreate_GoodCreateMessage(),
                                    failure in  sending the error code when tgenFindWgenID found the same
                                    signal ID already existing in the system
                                    stdError FAILURE */

#define TONEGEN_LOC_005	0x800005 /* TONEGEN:tgencomp.c:tgenCreate_GoodCreateMessage(),
                                    Failure in getting the id information from the delete message 
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_006	0x800006 /* TONEGEN:tgencomp.c:tgenCreate_GoodCreateMessage(),
                                    Failure in taking the message off the queue, as signal ID in
                                    tgenDeleteToneMsg does not exists. 
                                    tgenQueue_KillMsg FAILURE */

#define TONEGEN_LOC_007	0x800007 /* TONEGEN:tgencomp.c:tgenCreate_GoodCreateMessage(),
                                    failure in  sending the error code, as signal ID in
                                    tgenDeleteToneMsg does not exists. 
                                    stdError FAILURE */

#define TONEGEN_LOC_008	0x800008 /* TONEGEN:tgencomp.c:tgenCreate_PlaceInTable(),
                                    failure in getting the label and id information from the create tone message 
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_009	0x800009 /* TONEGEN:tgencomp.c:tgenCreate_PlaceInTable(),
                                    failure in taking the message off the
                                    queue, when an error condition occurred
                                    in sigId in qListGet 
                                    TgenQueue_KillMsg FAIURE */

#define TONEGEN_LOC_010	0x800010 /* TONEGEN:tgencomp.c:tgenCreate_PlaceInTable(),
                                    failure in  sending the error code when
                                    an error condition occurred in sigId in qListGet
                                    stdError FAILURE */

#define TONEGEN_LOC_011	0x800011 /* TONEGEN:tgencomp.c:tgenCreate_PlaceInTable(),
                                    failure in taking the message off the
                                    queue when an error condition occurred in
                                    labelId in qListGet  
                                    TgenQueue_KillMsg FAIURE */

#define TONEGEN_LOC_012	0x800012 /* TONEGEN:tgencomp.c:tgenCreate_PlaceInTable(),
                                    failure in  sending the error code when
                                    an error condition occurred in labelId in qListGet
                                    stdError FAILURE */

#define TONEGEN_LOC_013	0x800013 /* TONEGEN:tgencomp.c:tgenCreate_PlaceInTable(),
                                    failure in taking the message off the
                                    queue when tgenFindWgenID found the same signal ID already existing in the system  
                                    TgenQueue_KillMsg FAILURE */

#define TONEGEN_LOC_014	0x800014 /* TONEGEN:tgencomp.c:tgenCreate_PlaceInTable(),
                                    failure in  sending the error code when tgenFindWgenID found the same
                                    signal ID already existing in the system
                                    stdError FAILURE */

#define TONEGEN_LOC_015	0x800015 /* TONEGEN:tgencomp.c:tgenCreate_StateHandler(),
                                    In TGEN_CREATE_IDLE state, Unable to allocate messsage block WGen_MsgStartNewToneSeq. 
                                    qMsgAllocate FAILURE */

#define TONEGEN_LOC_016	0x800016 /* TONEGEN:tgencomp.c:tgenCreate_StateHandler(),
                                    In TGEN_CREATE_IDLE state, failure in getting the number of
                                    sequences from the create tone message in the queue .
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_017	0x800017 /* TONEGEN:tgencomp.c:tgenCreate_StateHandler(),
                                    In TGEN_CREATE_IDLE state, Unable to send WGen_MsgStartNewToneSeq.
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_018	0x800018 /* TONEGEN:tgencomp.c:tgenCreate_StateHandler(),
                                    in the TGEN_CREATE_IDLE state, failure in the get and put functions as
                                    (MsgsInQueue is < 0 ).*/


#define TONEGEN_LOC_019	0x800019 /* TONEGEN:tgencomp.c:tgenCreate_StateHandler(),
                                    In the TGEN_CREATE_WAITSTART state, failure in the get and put functions as
                                    (MsgsInQueue is < 0 ). */
				  
#define TONEGEN_LOC_020	0x800020 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In the TGEN_CREATE_WAITSTART state,
                                    tgenQueue_GetMsg FAILURE  */   

#define TONEGEN_LOC_021	0x800021 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgStartNewToneSeqCmplt in TGEN_CREATE_WAITSTART state,
                                    Unable to get ToneId from message in wgenStartNewToneCmpltMsg
                                    WGen_MsgStartNewToneSeqCmplt_get FAILURE */

#define TONEGEN_LOC_022	0x800022 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgStartNewToneSeqCmplt in TGEN_CREATE_WAITSTART state,
                                    unable to take the message off the stack after decrementing the number of
                                    expected complete messages.
                                    tgenQueue_KillMsg FAILURE*/

#define TONEGEN_LOC_023	0x800023 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgStartNewToneSeqCmplt in TGEN_CREATE_WAITSTART state,
                                    Unable to free the message in queue.
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_024	0x800024 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgStartNewToneSeqCmplt in TGEN_CREATE_WAITSTART state,
                                    Unable to get the segment information in from the create message
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_025	0x800025 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgStartNewToneSeqCmplt in TGEN_CREATE_WAITSTART state,
                                    Unable to get a copy of the sigId. 
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_026	0x800026 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgStartNewToneSeqCmplt in TGEN_CREATE_WAITSTART state,
                                    Unable to allocate messsage Tgen_MsgDeleteTone. 
                                    qMsgAllocate FAILURE */

#define TONEGEN_LOC_027	0x800027 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgStartNewToneSeqCmplt in TGEN_CREATE_WAITSTART state,
                                    Unable to send messsage tgenDeleteToneMsg. 
                                    qMsgWrite FAILURE  */

#define TONEGEN_LOC_028	0x800028 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgStartNewToneSeqCmplt TGEN_CREATE_WAIT state, 
                                    Unable to allocate messsage WGen_MsgAddToneSeg 
                                    qMsgAllocate FAILURE */ 

#define TONEGEN_LOC_029	0x800029 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgStartNewToneSeqCmplt TGEN_CREATE_WAITSTART state,
                                    Unable to send messsage wgenAddToneSegMsg 
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_030	0x800030 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_IDLE state, unable to get pointer to the message. 
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_031	0x800031 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in  TGEN_CREATE_IDLE state, unable to get error message off the stack. 
                                    tgenQueue_KillMsg FAILURE */

#define TONEGEN_LOC_032	0x800032 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_IDLE state, unable to free the error message. 
                                    qMsgFree FAILURE */ 

#define TONEGEN_LOC_033	0x800033 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_IDLE state, unable to get the
                                    error message interpreted as insufficient number of TSD's or too few ToneID's
                                    tgenQueue_GetMsg FAILURE */ 

#define TONEGEN_LOC_034	0x800034 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_IDLE state, unable to get the
                                    error message (interpreted as insufficient number of TSD's or too few ToneID's), off the stack.
                                    tgenQueue_KillMsg FAILURE */
				    

#define TONEGEN_LOC_035	0x800035 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_IDLE state, failure in sending the error code interpreted
                                    as insufficient number of TSD's or too few ToneID's. stdError FAILURE */

#define TONEGEN_LOC_036	0x800036 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    Invalid message read in the TGEN_CREATE_WAITSTART state */

#define TONEGEN_LOC_037	0x800037 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In TGEN_CREATE_WAITSEG state, failure in the get and put functions as
                                    (MsgsInQueue is < 0 ).*/

#define TONEGEN_LOC_038	0x800038 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In TGEN_CREATE_WAITSEG state, unable to get the message 
                                    tgenQueue_GetMsg FAILURE*/

#define TONEGEN_LOC_039	0x800039 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgAddToneSegCmplt in TGEN_CREATE_WAITSEG state , error in getting the
                                    message off the stack after decrementing the number of expected complete messages.
                                    tgenQueue_KillMsg FAILURE */

#define TONEGEN_LOC_040	0x800040 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgAddToneSegCmplt in TGEN_CREATE_WAITSEG state , error in
                                    freeing message 
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_041	0x800041 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgAddToneSegCmplt in TGEN_CREATE_WAITSEG state, error in
                                    getting the segment information from the create message. 
                                    tgenQueue_GetMsg FAILURE*/

#define TONEGEN_LOC_042	0x800042 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgAddToneSegCmplt in TGEN_CREATE_WAITSEG state, error in
                                    getting the  message off the stack.
                                    tgenQueue_KillMsg FAILURE */

#define TONEGEN_LOC_043	0x800043 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgAddToneSegCmplt in TGEN_CREATE_WAITSEG state, 
                                    unable to reallocate messsage Tgen_MsgCreateToneCmplt. 
                                    qMsgReallocate FAILURE */

#define TONEGEN_LOC_044	0x800044 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgAddToneSegCmplt in TGEN_CREATE_WAITSEG state, 
                                    Unable to send messsage Tgen_MsgCreateToneCmplt 
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_045	0x800045 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgAddToneSegCmplt in TGEN_CREATE_WAITSEG state, 
                                    error in getting the segment information from the create message. 
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_046	0x800046 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgAddToneSegCmplt in TGEN_CREATE_WAITSEG state,
                                    unable to allocate messsage wgenAddToneSegMsg. 
                                    qMsgAllocate FAILURE */

#define TONEGEN_LOC_047	0x800047 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type WGen_MsgAddToneSegCmplt in TGEN_CREATE_WAITSEG state,
                                    Unable to send wgenAddToneSegMsg.
                                    qMsgWrite FAILURE*/

#define TONEGEN_LOC_048	0x800048 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to get the standard error message 
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_049	0x800049 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to get the standard error message off the queue.
                                    tgenQueue_KillMsg FAILURE*/

#define TONEGEN_LOC_050	0x800050 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to get the  error message. 
                                    tgenQueue_GetMsg FAILURE */
				    

#define TONEGEN_LOC_051	0x800051 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to get the  error message off the queue.
                                    tgenQueue_KillMsg FAILURE*/
				    

#define TONEGEN_LOC_052	0x800052 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to de-allocate the error message.
                                    qMsgFree FAILURE*/
				    

#define TONEGEN_LOC_053	0x800053 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    WAITSEG: sending the delete message to the Wavegenerator*/

#define TONEGEN_LOC_054	0x800054 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to get the  error message. 
                                    tgenQueue_GetMsg FAILURE*/

#define TONEGEN_LOC_055	0x800055 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to allocate Tgen_MsgDeleteTone. 
                                    qMsgAllocate FAILURE */
				    

#define TONEGEN_LOC_056	0x800056 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    Unable to send messsage tgenDeleteToneMsg
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_057	0x800057 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to get the  CreateToneMessage. 
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_058	0x800058 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to get the  CreateToneMessage off the queue. 
                                    tgenQueue_KillMsg FAILURE*/
				    

#define TONEGEN_LOC_059	0x800059 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    failure in  getting the error code from the Wgen Message 
                                    Std_MsgError_get FAILURE */

#define TONEGEN_LOC_060	0x800060 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state, returning
                                    the appropriate error code. 
                                    Error Code: WGen_ErrUndefTID, massive internal error */

#define TONEGEN_LOC_061	0x800061 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state, returning
                                    the appropriate error code, failure in  sending the error code: WGen_ErrNoTSDs. 
                                    StdError FAILURE */

#define TONEGEN_LOC_062	0x800062 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state, returning
                                    the appropriate error code. 
                                    Should not get this here..Error code: WGen_ErrNoTID */

#define TONEGEN_LOC_063	0x800063 /* TONEGEN:tgencomp.c:In msg type Std_MsgError in TGEN_CREATE_WAITSEG state, returning
                                    the appropriate error code. 
                                    failure in  sending the error code: WGen_ErrBadMSD. 
                                    StdError FAILURE */

#define TONEGEN_LOC_064	0x800064 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state, returning
                                    the appropriate error code.  Error Code: WGen_ErrBadTSD */
				    
#define TONEGEN_LOC_065	0x800065 /* TONEGEN:tgencomp.c:In msg type Std_MsgError in TGEN_CREATE_WAITSEG state, returning
                                    the appropriate error code. 
                                    failure in  sending the error code: WGen_ErrBadLink. 
                                    StdError FAILURE */
				    

#define TONEGEN_LOC_066	0x800066 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state, returning
                                    the appropriate error code.  Error Code:
                                    all other errors. */

#define TONEGEN_LOC_067	0x800067 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Std_MsgError in TGEN_CREATE_WAITSEG state,
                                    unable to de-allocate the error message.
                                    qMsgFree FAILURE*/

#define TONEGEN_LOC_068	0x800068 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    Invalid message read in the TGEN_CREATE_WAITSEG state */

#define TONEGEN_LOC_069	0x800069 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In TGEN_CREATE_WAITDELETE state, unable to get the complete delete message.
                                    tgenQueue_GetMsg FAILURE */
				    

#define TONEGEN_LOC_070	0x800070 /* TONEGEN:tgencomp.c:,tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Tgen_MsgDeleteToneCmplt in TGEN_CREATE_WAITDELETE state,
                                    unable to get the message off the queue.
                                    tgenQueue_KillMsg FAILURE*/

#define TONEGEN_LOC_071	0x800071 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In msg type Tgen_MsgDeleteToneCmplt in TGEN_CREATE_WAITDELETE state,
                                    unable to de-allocate the message.
                                    qMsgFree FAILURE */
				    

#define TONEGEN_LOC_072	0x800072 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(), 
                                    In TGEN_CREATE_WAITDELETE state, received an illegal message type, code in an unstable state */

#define TONEGEN_LOC_073	0x800073 /* TONEGEN:tgencomp.c:tgencomp.c:tgenCreate_StateHandler(),
                                    Recieved an illegal state handler */

#define TONEGEN_LOC_074	0x800074 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In TGEN_DELETE_IDLE state, Unable to allocate messsage WGen_MsgDeleteToneSequence. 
                                    qMsgAllocate FAILURE */

#define TONEGEN_LOC_075	0x800075 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In TGEN_DELETE_IDLE state, Unable to send messsage WGen_MsgDeleteToneSequence.
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_076	0x800076 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In TGEN_DELETE_IDLE state,failure in the get and put functions as
                                    (MsgsInQueue is < 0 ) */

#define TONEGEN_LOC_077	0x800077 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In TGEN_DELETE_WAITDELETE state,failure in the get and put functions as
                                    (MsgsInQueue is < 0 ) */

#define TONEGEN_LOC_078	0x800078 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In TGEN_DELETE_WAITDELETE state,unable to get the message. 
                                    tgenQueue_GetMsg FAILURE */
                                    

#define TONEGEN_LOC_079	0x800079 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type WGen_MsgDeleteToneSequenceCmplt in the TGEN_DELETE_WAITDELETE state
                                    unable to get the message off the queue, tgenQueue_KillMsg FAILURE*/


#define TONEGEN_LOC_080	0x800080 /* TONEGEN:tgencomp.c: tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type WGen_MsgDeleteToneSequenceCmplt in the TGEN_DELETE_WAITDELETE state
                                    unable to de-allocate the message,  qMsgFree FAILURE */

#define TONEGEN_LOC_081	0x800081 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type WGen_MsgDeleteToneSequenceCmplt in the TGEN_DELETE_WAITDELETE state
                                    unable to get the message, tgenQueue_GetMsg FAILURE */
				    

#define TONEGEN_LOC_082	0x800082 /* TONEGEN:tgencomp.c: tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type WGen_MsgDeleteToneSequenceCmplt in the TGEN_DELETE_WAITDELETE state
                                    unable to get the message off the queue, tgenQueue_KillMsg FAILURE */
				    

#define TONEGEN_LOC_083	0x800083 /* TONEGEN:tgencomp.c: tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type WGen_MsgDeleteToneSequenceCmplt in the TGEN_DELETE_WAITDELETE state
                                    failure in  sending the error code when unable to remove the information from tone table
                                    stdError FAILURE */

#define TONEGEN_LOC_084	0x800084 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type WGen_MsgDeleteToneSequenceCmplt in the TGEN_DELETE_WAITDELETE state
                                    unable to re-allocate message Tgen_MsgDeleteToneCmplt 
                                    qMsgReallocate FAILURE */

#define TONEGEN_LOC_085	0x800085 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type WGen_MsgDeleteToneSequenceCmplt in the TGEN_DELETE_WAITDELETE state
                                    unable to send message Tgen_MsgDeleteToneCmplt 
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_086	0x800086 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type Std_MsgError in the TGEN_DELETE_WAITDELETE state unable to
                                    get the standard error message 
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_087	0x800087 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type Std_MsgError in the TGEN_DELETE_WAITDELETE state unable to
                                    get the standard error message off the queue.
                                    tgenQueue_KillMsg FAILURE*/

#define TONEGEN_LOC_088	0x800088 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type Std_MsgError in the TGEN_DELETE_WAITDELETE state unable to
                                    unable to de-allocate the error message.
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_089	0x800089 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type Std_MsgError in the TGEN_DELETE_WAITDELETE state unable to
                                    get the standard error message (last message from wgen)
                                    tgenQueue_GetMsg FAILURE */

#define TONEGEN_LOC_090	0x800090 /* TONEGEN:tgencomp.c:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type Std_MsgError in the TGEN_DELETE_WAITDELETE state
                                    unable to get the standard error message (last message from wgen) off the queue.
                                    tgenQueue_KillMsg FAILURE*/

#define TONEGEN_LOC_091	0x800091 /* TONEGEN:tgencomp.c:tgenDelete_StateHandler(),
                                    In msg type Std_MsgError in the TGEN_DELETE_WAITDELETE state
                                    unable to de-allocate the error message (last message from wgen).
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_092	0x800092 /* TONEGEN:tgencomp.c:tgenDelete_StateHandler(),
                                    In all other msg type in the TGEN_DELETE_WAITDELETE state,
                                    an invalid message has been read */

#define TONEGEN_LOC_093	0x800093 /* TONEGEN:tgencomp.c:tgenDelete_StateHandler(),
                                    Should never get to this section as this is an undefined state in the delete_state handler */

#define TONEGEN_LOC_094	0x800094 /* TONEGEN:tgencomp.c:tgenFindWgen(),
                                    Tonegen : Found 0 wave generators.
				    */

#define TONEGEN_LOC_095	0x800095 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    The tone template definitions count, exceeds the maximum allowable tone
                                    templates in maxSignalIds */

#define TONEGEN_LOC_096	0x800096 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    The tone template definitions count, exceeds the maximum allowable tone
                                    templates in tgComp.maxIds */

#define TONEGEN_LOC_097	0x800097 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    error in getting the SignalId and label
                                    associated with the user specified tone definition 
                                    qListGet FAILURE */


#define TONEGEN_LOC_098	0x800098 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    duplicate signalId found: tgenFindWgenId returned a signalId that already exists */

#define TONEGEN_LOC_099	0x800099 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    duplicate label found : error when adding the label to the wgenID hash table */

#define TONEGEN_LOC_100	0x800100 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    Unable to allocate messsage WGen_MsgStartNewToneSeq 
                                    qMsgAllocate FAILURE */

#define TONEGEN_LOC_101	0x800101 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    Unable to send  WGen_MsgStartNewToneSeq 
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_102	0x800102 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    qMsgRead FAILURE*/

#define TONEGEN_LOC_103	0x800103 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    unable to get message WGen_MsgStartNewToneSeqCmplt */

#define TONEGEN_LOC_104	0x800104 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    error in message type */

#define TONEGEN_LOC_105	0x800105 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    error in de-allocating message qMsgFree FAILURE */

#define TONEGEN_LOC_106	0x800106 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    unable to allocate message WGen_MsgAddToneSeg qMsgAllocate FAILURE*/

#define TONEGEN_LOC_107	0x800107 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    WGen_MsgAddToneSeg FAILURE */

#define TONEGEN_LOC_108	0x800108 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    Unable to send  WGen_MsgAddToneSeg qMsgWrite FAILURE*/

#define TONEGEN_LOC_109	0x800109 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    error when waiting for a response from Wgen
                                    qMsgRead FAILURE */

#define TONEGEN_LOC_110	0x800110 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    tgencomp in an unexpected inMsg->type */

#define TONEGEN_LOC_111	0x800111 /* TONEGEN:tgencomp.c:tgenInitTmplts(),
                                    tonegen in an unexpected state when expecting msg type 
                                    WGen_MsgAddToneSegCmplt */

#define TONEGEN_LOC_112	0x800112 /* TONEGEN:tgencomp.c:tgenRegisterInstances(),
                                    unable to register the instance
                                    qCompInstanceRegister FAILURE*/
				    

#define TONEGEN_LOC_113	0x800113 /* TONEGEN:tgencomp.c:tgenRegisterInstances(),
                                    qMsgRead FAILURE */

#define TONEGEN_LOC_114	0x800114 /* TONEGEN:tgencomp.c:tgenRegisterInstances(),
                                    unable to de-allocate QResultComplete  message 
                                    qMsgFree Error */

#define TONEGEN_LOC_115	0x800115 /* TONEGEN:tgencomp.c:tgenRegisterInstances(),
                                    tonegen in an unexpected state when expecting msg type 
                                    QResultComplete */

#define TONEGEN_LOC_116	0x800116 /* TONEGEN:tgencomp.c:tgenInitInstances(),
                                    Unable to allocate Std_MsgInit, qMsgAllocate FAILURE */

#define TONEGEN_LOC_117	0x800117 /* TONEGEN:tgencomp.c:tgenInitInstances(),
                                    Unable to send Std_MsgInit, qMsgWrite FAILURE */

#define TONEGEN_LOC_118	0x800118 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    Unable to create Component Parameter Table,  qMemAlloc() FAILURE*/

#define TONEGEN_LOC_119	0x800119 /* TONEGEN:tgencomp.c:tgenCompTask(), 
                                    unable to register task qTaskCompSelf FAILURE */
                                   

#define TONEGEN_LOC_120	0x800120 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to register task qCompRegister FAILURE */

#define TONEGEN_LOC_121	0x800121 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    error in reading message from Mercury queue
                                    qMsgRead FAILURE */

#define TONEGEN_LOC_122	0x800122 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    tgenComp unable to receive Std_MsgComtest
                                    stdComtest FAILURE */

#define TONEGEN_LOC_123	0x800123 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    stdSetParm FAILURE  */

#define TONEGEN_LOC_124	0x800124 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    stdSetParmDef FAILURE */

#define TONEGEN_LOC_125	0x800125 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    stdSetAllParmsDef FAILURE */

#define TONEGEN_LOC_126	0x800126 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    stdGetParm FAILURE */

#define TONEGEN_LOC_127	0x800127 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    qHostExitCmplt FAILURE */

#define TONEGEN_LOC_128	0x800128 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to de-allocate message in qHostExitCmplt qMsgFree FAILURE */

#define TONEGEN_LOC_129	0x800129 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to de-allocate message in Tgen_MsgCreateTone, qMsgFree FAILURE */

#define TONEGEN_LOC_130	0x800130 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    tgenQueue_PutMsg FAILURE */

#define TONEGEN_LOC_131	0x800131 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to de-allocate message, when tgenCom received Tgen_MsgDeleteTone in init state
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_132	0x800132 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to send message,  tgenQueue_PutMsg FAILURE*/

#define TONEGEN_LOC_133	0x800133 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to de-allocate message in Std_MsgError state in msg type CREATE_TONE_MESSAGE 
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_134	0x800134 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to de-allocate message in Std_MsgError state in msg type DELETE_TONE_MESSAGE 
                                    qMsgFree FAILURE */
				    

#define TONEGEN_LOC_135	0x800135 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    tonegen in an unexpected state when expecting msg type of Std_MsgError */

#define TONEGEN_LOC_136	0x800136 /* TONEGEN:tgencomp.c:(),
                                    */

#define TONEGEN_LOC_137	0x800137 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    error in setting the  maxSignalIds */

#define TONEGEN_LOC_138	0x800138 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to allocate the Signal Id to wgenId hash table qMemAlloc FAILURE */

#define TONEGEN_LOC_139	0x800139 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to allocate the label to the Signal Id hash table qMemAlloc FAILURE */

#define TONEGEN_LOC_140	0x800140 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    Unable to send a stdError, when an error occured creating a
                                    Run Time Control Pool stdError FAILURE */

#define TONEGEN_LOC_141	0x800141 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    qMemAlloc FAILURE during instance
                                    database allocation */

#define TONEGEN_LOC_142	0x800142 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to free message in init_normal state qMsgFree FAILURE */

#define TONEGEN_LOC_143	0x800143 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    tgenComp received unexpected message
                                    %02xH in init_normal state */

#define TONEGEN_LOC_144	0x800144 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    Unable to send Std_MsgInitCmplt qMsgWrite FAILURE  */

#define TONEGEN_LOC_145	0x800145 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to free message  Std_MsgInitCmplt qMsgFree FAILURE */

#define TONEGEN_LOC_146	0x800146 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    tgenComp received unexpected message %02xH in init_waitinitcmplt state */

#define TONEGEN_LOC_147	0x800147 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    tgenComp in unexpected initState %02xH */

#define TONEGEN_LOC_148	0x800148 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    error in de-allocating message when tgenComp received Std_MsgExit in idle state
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_149	0x800149 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    error in loading up the message body in
                                    tgenFindWgenId for SignalId Dm3_R2MFF1  */

#define TONEGEN_LOC_150	0x800150 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    error in loading up the message body in
                                    tgenFindWgenId for SignalId Dm3_R2MFB1 */

#define TONEGEN_LOC_151	0x800151 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to send message Tgen_MsgR2MFSetCmplt_put
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_152	0x800152 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    tgenComp received unexpected message %02xH in idle state */

#define TONEGEN_LOC_153	0x800153 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to send message WGen_MsgStartNewToneSeqCmplt, in
                                    createdeletetone state, tgenQueue_PutMsg FAILURE */

#define TONEGEN_LOC_154	0x800154 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to send message WGen_MsgAddToneSegCmplt, in
                                    createdeletetone state, tgenQueue_PutMsg FAILURE */

#define TONEGEN_LOC_155	0x800155 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to send message WGen_MsgDeleteToneSequenceCmplt, in
                                    createdeletetone state, tgenQueue_PutMsg FAILURE */

#define TONEGEN_LOC_156	0x800156 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to free message, when tgenComp received Std_MsgExit in createdeletetone state 
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_157	0x800157 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to send message when tgenComp received Std_MsgInitCmplt in
                                    createdeletetone state, qMsgWrite FAILURE */

#define TONEGEN_LOC_158	0x800158 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    unable to de-allocate message in Std_MsgInitCmplt in
                                    createdeletetone state, qMsgFree FAILURE */

#define TONEGEN_LOC_159	0x800159 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    tgenComp received unexpected message %02xH in createdeletetone state*/

#define TONEGEN_LOC_160	0x800160 /* TONEGEN:tgencomp.c:tgenCompTask(),
                                    tgenComp in unexpected state %02xH */

#define TONEGEN_LOC_161	0x800161 /* TONEGEN:qlst.c:qListGet(),
                                    */

#define TONEGEN_LOC_162	0x800162 /* TONEGEN:tgenstds.c:tgenError(),
                                    unable to re-allocate Std_MsgError qMsgReallocate FAILURE */

#define TONEGEN_LOC_163	0x800163 /* TONEGEN:tgenstds.c:tgenError(),
                                    Std_MsgError_put FAILURE  */

#define TONEGEN_LOC_164	0x800164 /* TONEGEN:tgenstds.c:tgenSetParm(),
                                    Std_MsgSetParm_get FAILURE  */

#define TONEGEN_LOC_165	0x800165 /* TONEGEN:tgenstds.c:tgenSetParm(),
                                    Std_MsgSetParmDef_get */

#define TONEGEN_LOC_166	0x800166 /* TONEGEN:tgenstds.c:tgenGetParm(),
                                     Std_MsgGetParm_get FAILURE */

#define TONEGEN_LOC_167	0x800167 /* TONEGEN:tgenstds.c:tgenGetParm(), 
                                    unable to re-allocate message Std_MsgGetParmCmplt qMsgReallocate FAILURE */

#define TONEGEN_LOC_168	0x800168 /* TONEGEN:tgenstds.c:tgenDetectEvt(),
                                    Std_MsgDetectEvt_get FAILURE */

#define TONEGEN_LOC_169	0x800169 /* TONEGEN:tgenstds.c:tgenCancelEvt(),
                                    Std_MsgCancelEvt_get FAILURE */

#define TONEGEN_LOC_170	0x800170 /* TONEGEN:tgenstds.c:tgenArmRTC(),
                                    Std_MsgArmRTC_get FAILURE */

#define TONEGEN_LOC_171	0x800171 /* TONEGEN:tgenstds.c:tgenDisarmRTC(),
                                    Std_MsgDisarmRTC_get FAILURE */

#define TONEGEN_LOC_172	0x800172 /* TONEGEN:tgenstds.c:tgenEvtDetected(),
                                    Std_MsgEvtDetected_get FAILURE */

#define TONEGEN_LOC_173	0x800173 /* TONEGEN:tgeninst.c:tgenCleanInstance(),
                                    unable to send an exit complete message for the case when a tone was not in
                                    the process of playing  qHostExitCmplt FAILURE*/

#define TONEGEN_LOC_174	0x800174 /* TONEGEN:tgeninst.c:tgenCleanInstance(),
                                    unable to send an exit complete message (exit did not come from client)
                                    qHostExitCmplt FAILURE */

#define TONEGEN_LOC_175	0x800175 /* TONEGEN:tgeninst.c:tgenInstInit(),
                                    tgenInst unable to allocate wgenInst
                                    qHostExitCmplt FAILURE */

#define TONEGEN_LOC_176	0x800176 /* TONEGEN:tgeninst.c:tgenSendEvtStarted(),
                                    unable to allocate message Std_MsgEvtDetected, qMsgAllocate FAILURE */

#define TONEGEN_LOC_177	0x800177 /* TONEGEN:tgeninst.c:tgenSendEvtStarted(),
                                    Std_MsgEvtDetected_put FAILURE */

#define TONEGEN_LOC_178	0x800178 /* TONEGEN:tgeninst.c:tgenSendEvtStarted(),
                                    unable to send Std_MsgEvtDetected message
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_179	0x800179 /* TONEGEN:tgeninst.c:tgenSendEvtStarted(),
                                    unable to allocate message
                                    Std_MsgEvtDetected qMsgAllocate FAILURE */

#define TONEGEN_LOC_180	0x800180 /* TONEGEN:tgeninst.c:tgenSendEvtStarted(),
                                    unable to free message Std_MsgEvtDetected
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_181	0x800181 /* TONEGEN:tgeninst.c:tgenSendEvtStopped(),
                                    unable to allocate message
                                    Std_MsgEvtDetected, qMsgAllocate FAILURE */

#define TONEGEN_LOC_182	0x800182 /* TONEGEN:tgeninst.c:tgenSendEvtStopped(),
                                    Std_MsgEvtStopped_put FAILURE */

#define TONEGEN_LOC_183	0x800183 /* TONEGEN:tgeninst.c:tgenSendEvtStopped(),
                                    unable to send Std_MsgEvtDetected message
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_184	0x800184 /* TONEGEN:tgeninst.c:tgenSendEvtStopped(),
                                    unable to allocate message
                                    Std_MsgEvtDetected qMsgAllocate FAILURE*/

#define TONEGEN_LOC_185	0x800185 /* TONEGEN:tgeninst.c:tgenSendEvtStopped(),
                                    unable to free message Std_MsgEvtDetected
                                    qMsgFree FAILURE*/

#define TONEGEN_LOC_186	0x800186 /* TONEGEN:tgeninst.c:tgenOutputStreamIdGet(),
                                    qClusterSlotInfo FAILURE */

#define TONEGEN_LOC_187	0x800187 /* TONEGEN:tgeninst.c:tgenStartPlayTone(),
                                    unable to allocate message WGen_MsgPlayTone_ToneIDs
                                    qMsgAllocate FAILURE */

#define TONEGEN_LOC_188	0x800188 /* TONEGEN:tgeninst.c:tgenStartPlayTone(),
                                    unable to re-allocate message WGen_MsgPlayToneCmplt
                                    qMsgReallocate FAILURE */

#define TONEGEN_LOC_189	0x800189 /* TONEGEN:tgeninst.c:tgenStartPlayTone(),
                                    unable to send message WGen_MsgPlayToneCmplt, qMsgWrite FAILURE */

#define TONEGEN_LOC_190	0x800190 /* TONEGEN:tgeninst.c:tgenSetupPlayTone(),
                                    Tgen_MsgPlayTone_get FAILURE */

#define TONEGEN_LOC_191	0x800191 /* TONEGEN:tgeninst.c:tgenSetupPlayTone(),
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_192	0x800192 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    qMsgFree FAILURE */

#define TONEGEN_LOC_193	0x800193 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    WGen_MsgPlayToneCmplt_get FAILURE */

#define TONEGEN_LOC_194	0x800194 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    invalid message received from WGen, wgenPlayToneCmpltMsg.Reason !=
                                    WGen_MsgPlayToneCmplt_Reason_EOTS, */

#define TONEGEN_LOC_195	0x800195 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    unable to re-allocate message, in cmpltMessage
                                    type Tgen_MsgPlayToneCmplt, qMsgReallocate FAILURE */

#define TONEGEN_LOC_196	0x800196 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    Tgen_MsgPlayToneCmplt_put FAILURE */

#define TONEGEN_LOC_197	0x800197 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    unable to re-allocate message, in cmpltMessage
                                    type Tgen_MsgDialCmplt, qMsgReallocate FAILURE */

#define TONEGEN_LOC_198	0x800198 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    Tgen_MsgDialCmplt_put FAILURE  */

#define TONEGEN_LOC_199	0x800199 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone()
                                    unable to re-allocate message, in cmpltMessage
                                    type Tgen_MsgPlaySequenceCmplt, qMsgReallocate FAILURE   */

#define TONEGEN_LOC_200	0x800200 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    Tgen_MsgPlaySequenceCmplt_put FAILURE */

#define TONEGEN_LOC_201	0x800201 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    unexpected message in cmpltMessage type */

#define TONEGEN_LOC_202	0x800202 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    unable to send message Tgen_MsgPlayToneCmplt to Host, qMsgWrite FAILURE */

#define TONEGEN_LOC_203	0x800203 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    qClusterDeactivate FAILURE */

#define TONEGEN_LOC_204	0x800204 /* TONEGEN:tgeninst.c:tgenTeardownPlayTone(),
                                    HostExitCmplt FAILURE */
                                 

#define TONEGEN_LOC_205	0x800205 /* TONEGEN:tgeninst.c:tgenStoppingStateHdlr(),
                                    unable to de-allocate message  Tgen_MsgStop, qMsgFree FAILURE */

#define TONEGEN_LOC_206	0x800206 /* TONEGEN:tgeninst.c:tgenPlayingStateHdlr(),
                                    unable to send message, in playingState TGEN_PLAYING_NORMAL,msg type Tgen_MsgStop
                                    qMsgWrite FAILURE */

#define TONEGEN_LOC_207	0x800207 /* TONEGEN:tgeninst.c:tgenPlayingStateHdlr(),
                                    tgenTeardownPlayTone FAILURE, in playingState TGEN_PLAYING_NORMAL,msg type
                                    WGen_MsgPlayToneCmplt */

#define TONEGEN_LOC_208	0x800208 /* TONEGEN:tgeninst.c:tgenPlayingStateHdlr(),
                                    tgenInst in unexpected playing state*/

#define TONEGEN_LOC_209	0x800209 /* TONEGEN:tgeninst.c:tgenDeallocatedStateHdlr(),
                                    qClusterByComp FAILURE in msg type QCompInstNotify */

#define TONEGEN_LOC_210	0x800210 /* TONEGEN:tgeninst.c:tgenDeallocatedStateHdlr(),
                                    unable to de-allocate message in msg type
                                    QCompInstNotify qMsgFree FAILURE */

#define TONEGEN_LOC_211	0x800211 /* TONEGEN:tgeninst.c:tgenDeallocatedStateHdlr(),
                                    unable to de-allocate message
                                    WGen_MsgPlayToneCmplt qMsgFree FAILURE */

#define TONEGEN_LOC_212	0x800212 /* TONEGEN:tgeninst.c:tgenIdleStateHdlr(),
                                    unable to de-allocate message in msg type
                                    QCompInstNotify qMsgFree FAILURE   */

#define TONEGEN_LOC_213	0x800213 /* TONEGEN:tgeninst.c:tgenIdleStateHdlr(),
                                    unable to allocate message Tgen_MsgWgenInfoCmplt qMsgAllocate FAILURE */

#define TONEGEN_LOC_214	0x800214 /* TONEGEN:tgeninst.c:tgenIdleStateHdlr(),
                                    unable to send message Tgen_MsgWgenInfoCmplt, qMsgWrite FAILURE */

#define TONEGEN_LOC_215	0x800215 /* TONEGEN:tgeninst.c:tgenIdleStateHdlr(),
                                    unable to de-allocate message in msg type
                                    QResultComplete qMsgFree FAILURE */

#define TONEGEN_LOC_216	0x800216 /* TONEGEN:tgeninst.c:tgenInitStateHdlr(),
                                    unable to de-allocate message in TGEN_INIT_NORMAL state, msg type
                                    Std_MsgInit, qMsgFree FAILURE */

#define TONEGEN_LOC_217	0x800217 /* TONEGEN:tgeninst.c:tgenInitStateHdlr(),
                                    QComponentResult_get FAILURE in TGEN_INIT_WAITALLOC state, msg
                                    type QComponentResult */

#define TONEGEN_LOC_218	0x800218 /* TONEGEN:tgeninst.c:tgenInitStateHdlr(),
                                    unable to send message Std_MsgInitCmplt
                                    in TGEN_INIT_WAITALLOC state, qMsgWrite FAILURE */

#define TONEGEN_LOC_219	0x800219 /* TONEGEN:tgeninst.c:tgenInitStateHdlr(),
                                    tgenInst in unexpected initState */

#define TONEGEN_LOC_220	0x800220 /* TONEGEN:tgeninst.c:tgenMainStateHdlr(),
                                    tgenInst in unexpected mainState */

#define TONEGEN_LOC_221	0x800221 /* TONEGEN:tgeninst.c:tgenDoAction(),
                                    Std_MsgEvtDetected_get FAILURE */

#define TONEGEN_LOC_222	0x800222 /* TONEGEN:tgeninst.c:tgenDoAction(),
                                    Invalid Action in RTC Action List */

#define TONEGEN_LOC_223	0x800223 /* TONEGEN:tgeninst.c:tgenDoAction(),
                                    unable to allocate message Std_MsgError
                                    qMsgAllocate FAILURE */

#define TONEGEN_LOC_224	0x800224 /* TONEGEN:tgeninst.c:tgenDoAction(),
                                    tgenMirrorMessage FAILURE*/

#define TONEGEN_LOC_225	0x800225 /* TONEGEN:tgeninst.c:tgenDoAction(),
                                    stdError FAILURE */

#define TONEGEN_LOC_226	0x800226 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdComtest FAILURE */

#define TONEGEN_LOC_227	0x800227 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdSetParm FAILURE */

#define TONEGEN_LOC_228	0x800228 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdSetParmDef FAILURE */

#define TONEGEN_LOC_229	0x800229 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdSetAllParmsDef FAILURE */

#define TONEGEN_LOC_230	0x800230 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    Std_MsgDetectEvt_get FAILURE */

#define TONEGEN_LOC_231	0x800231 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE, when sending error msg
                                    when stdDetectEvt failed. */

#define TONEGEN_LOC_232	0x800232 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE, when sending error msg
                                    for an Invalid Event Type */

#define TONEGEN_LOC_233	0x800233 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    Std_MsgCancelEvt_get FAILURE */

#define TONEGEN_LOC_234	0x800234 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE, when sending error msg
                                    when stdCancelEvt failed */

#define TONEGEN_LOC_235	0x800235 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    Std_MsgArmRTC_get FAILURE */

#define TONEGEN_LOC_236	0x800236 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE */

#define TONEGEN_LOC_237	0x800237 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE */

#define TONEGEN_LOC_238	0x800238 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE */

#define TONEGEN_LOC_239	0x800239 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE */

#define TONEGEN_LOC_240	0x800240 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE */

#define TONEGEN_LOC_241	0x800241 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE */

#define TONEGEN_LOC_242	0x800242 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    unable to allocate Std_MsgError
                                    qMsgAllocate FAILURE */

#define TONEGEN_LOC_243	0x800243 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    tgenMirrorMessage FAILURE */

#define TONEGEN_LOC_244	0x800244 /* TONEGEN:tgeninst.c:tgenInstFunc(),
                                    stdError FAILURE */

#define TONEGEN_LOC_245	0x800245 /* TONEGEN:tgeninst.c:tgenCompTask(),
                                    error in allocating physical storage for
                                    elements of hash table */

#define TONEGEN_LOC_246	0x800246 /* TONEGEN:qlst.c:qListGet(),
                                    error in getting request from list */

#define TONEGEN_LOC_247	0x800247 /* TONEGEN:tgeninst.c
                                    error in getting count in Std_MsgArmxRTCs.
                                    */

#define TONEGEN_LOC_248	0x800248 /* TONEGEN:tgeninst.c:(),
                                    error in reading out messages in
                                    Std_MsgArmxRTCs
                                    */

#define TONEGEN_LOC_249	0x800249 /* TONEGEN:tgeninst.c:()
                                    error in sending out reply/error messages
                                    in Std_MsgArmxRTCs.                              
                                    */
#define TONEGEN_LOC_250	0x800250 /* TONEGEN:tgeninst.c
                                    error in getting count in Std_MsgDisarmxRTCs.
                                    */
#define TONEGEN_LOC_251	0x800251 /* TONEGEN:tgeninst.c:(),
                                    error in reading out messages in
                                    Std_MsgDisarmxRTCs
                                    */
#define TONEGEN_LOC_252	0x800252 /* TONEGEN:tgeninst.c:()
                                    error in sending out reply/error messages
                                    in Std_MsgDisarmxRTCs.                           
                                    */
#define TONEGEN_LOC_253	0x800253 /* TONEGEN:tgeninst.c:()
                                    error in freeing the Std_MsgClearPendingAction message
                                    in tgenInstFunc().                           
                                    */
#define TONEGEN_LOC_254	0x800254 /* TONEGEN:tgenInit.c:()
                                    Unable to allocate memory for
                                    messsage Std_MsgExit 
                                    qMsgAllocate() FAILURE                           
                                    */
#define TONEGEN_LOC_255	0x800255 /* TONEGEN:tgenInit.c:()
                                    Unable to send
                                    messsage Std_MsgExit 
                                    qMsgWrite() FAILURE                             
                                    */
#define TONEGEN_LOC_256	0x800256 /* TONEGEN:tgeninst.c:()
                                    Failure in Tgen_MsgDialx_get macro.                             
                                    */
#define TONEGEN_LOC_257	0x800257 /* TONEGEN:tgeninst.c:()
                                    Failure in Tgen_MsgPlayTonex_get macro.                             
                                    */
#define TONEGEN_LOC_258	0x800258 /* TONEGEN:tgeninst.c:()
                                    Failure in Tgen_MsgPlaySequencex macro.                             
                                    */
#define TONEGEN_LOC_259	0x800259 /* TONEGEN:tgeninst.c:tgenIdleStateHdlr()
                                    Failure in qClusterSlotInfo. 
                                    */
#define TONEGEN_LOC_260	0x800260 /* TONEGEN:tgeninst.c:tgenIdleStateHdlr()
                                    Failure in qHostExitCmplt. 
                                    */
#define TONEGEN_LOC_261	0x800261 /* TONEGEN:tgeninst.c:tgenDeallocatedStateHdlr()
                                    Failure in qHostExitCmplt.                       
                                    */
#define TONEGEN_LOC_262	0x800262 /* TONEGEN:tgeninst.c:tgenDeallocatedStateHdlr()
                                    Failure in qMsgFree.                             
                                    */
#endif
