/***************************************************************************
 *		Copyright (c) 2000 Dialogic Corp., an Intel Company.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:			tsp_chplocations.h
 * AUTHOR:		DM3 TSP Team
 * ORG:			Dialogic Corporation
 * ORIG-DATE:	13-Apr-00
 * LAST-MOD:	13-Apr-00 at 14:58:51 by Supriya Sen 
 * PURPOSE:		This header file contains the location tags and error
 *					strings for the qError reports in the chpcomp.c file.
 *					(Part of the TSP resource for chp protocols).
 *
 * HISTORY:
 * Date			Who	Description
 * 04-Feb-02   PJS   Changed name of header file to accomodate for flattened
 *                   header file structure required for all components.
 * 13-Apr-00	SKS	Initial version based on Rev 0.7 of the qError 
 *							API Users Guide.
 *							
 ***************************************************************************/

/* Multiple include protection */
#ifndef _tsp_chplocations_h_
#define _tsp_chplocations_h_

#ifdef __cplusplus
extern "C" {
#endif

#define CHP_LOC_0001 0x800101	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0002 0x800102	/* CHP:chpcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CHP_LOC_0003 0x800103	/* CHP:chpcomp.c getsdlpid - instance %d out of range (max=%d) */
#define CHP_LOC_0004 0x800104	/* CHP:chpcomp.c getsdlpid - instance %d not registered */
#define CHP_LOC_0005 0x800105	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0006 0x800106	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0007 0x800107	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0008 0x800108	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0009 0x800109	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0010 0x80010a	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0011 0x80010b	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0012 0x80010c	/* CHP:chpcomp.c qClusterActivate failed - Instance # = %d */
#define CHP_LOC_0013 0x80010d	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0014 0x80010e	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0015 0x80010f	/* CHP:chpcomp.c Could not get Parm to create number of instances */
#define CHP_LOC_0016 0x800110	/* CHP:chpcomp.c Could not get Parm - ProtocolBase */
#define CHP_LOC_0017 0x800111	/* CHP:chpcomp.c Could not get Parm - InboundVariantId */
#define CHP_LOC_0018 0x800112	/* CHP:chpcomp.c Could not get Parm - OutboundVariantId */
#define CHP_LOC_0019 0x800113	/* CHP:chpcomp.c Could not get Parm - R4 Compatibility */
#define CHP_LOC_0020 0x800114	/* CHP:chpcomp.c Could not get Parm - Initial Channel State */
#define CHP_LOC_0021 0x800115 /* CHP:chpcomp.c Failed to find TSC Component address, qErrNo=0x%x */
#define CHP_LOC_0022 0x800116	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0023 0x800117	/* CHP:chpcomp.c qMsgAllocate failed - bufsize = %d */
#define CHP_LOC_0024 0x800118	/* CHP:chpcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CHP_LOC_0025 0x800119	/* CHP:chpcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CHP_LOC_0026 0x80011a /* CHP:chpcomp.c Signal Id's not supported yet */
#define CHP_LOC_0027 0x80011b	/* CHP:chpcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CHP_LOC_0028 0x80011c	/* CHP:chpcomp.c qCompRegister failed, qErrNo=0x%x */
#define CHP_LOC_0029 0x80011d	/* CHP:chpcomp.c qMsgRead failed, qErrNo=0x%x */
#define CHP_LOC_0030 0x80011e	/* CHP:chpcomp.c Could not get Parm - Disable Block */
#define CHP_LOC_0031 0x80011f /* CHP:chpcomp.c Could not get Parm - Enable TocRoc */
#define CHP_LOC_0032 0x800120	/* CHP:chpcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CHP_LOC_0033 0x800121	/* CHP:chpcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CHP_LOC_0034 0x800122	/* CHP:chpcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CHP_LOC_0035 0x800123	/* CHP:chpcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CHP_LOC_0036 0x800124	/* CHP:chpcomp.c qMemCalloc failed - bufsize = %d */

#ifdef __cplusplus
}
#endif

#endif		/* _tsp_chplocations_h_ End multiple include protection */
