/****************************************************************************
 *		Copyright (c) 2000 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         tspds2_tsclocations.h
 * AUTHOR:       Wilson Lo  x6462
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    13-Apr-00 at 17:55:15
 * LAST-MOD:      7-Jun-00 at 15:01:26 by Wilson Lo  x6462
 * PURPOSE:
 *    This file containes all the TSP component location tag.
 *
 * HISTORY:
 * Date                 Who     Description
 * 27-Mar-02            PJS     Added locations to accomodate source changes. 
 * 04-Feb-02            PJS     Changed name to accomodate the flattened header
 *                              file structure required for all components.
 * 13-Apr-00            LOW     Initial Creation.
 ***************************************************************************/

#ifndef _tspds2_tsplocations_h_
#define _tspds2_tsplocations_h_

#define TSC_LOC_000001  0x900001    /* TSC_DS2DPNSS:tsp.h:SIG_INPUT_HDR()
                                       failed on qMsgAllocate at MACRO define
                                       */

#define TSC_LOC_000002  0x900002   /* TSC_DS2DPNSS:tsccomp.c: 
                                      tsc_handle_qinst_msg(),
                                      failed on qMsgAllocate
                                      CHP_EvtFeatureReq switch */

#define TSC_LOC_000003  0x900003   /* TSC_DS2DPNSS:tsccomp.c:
                                      tsc_handle_qinst_msg(),
                                      failed on qMsgAllocate in
                                      CHP_EvtFeatureReq switch. */

#define TSC_LOC_000004  0x900004    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       tspFacilityPut(),
                                       failed on localOffset - *offerset <= 
                                       sizeof(GU_T_FACILITY).*/
   
#define TSC_LOC_00002A  0x90002A    /* TSC_DS2DPNSS:tsccomp.c:tsc_getsdlpid(),
                                       incorrect value of qdesc.instance. */

#define TSC_LOC_00002B  0x90002B    /* TSC_DS2DPNSS:tsccomp.c:tsc_getsdlpid(),
                                       incorrect value of
                                       sdl_instance[qdesc.instance].sdlpid. */

#define TSC_LOC_00002C  0x90002C    /* TSC_DS2DPNSS:tsccomp.c:tscBuildMsg(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_00002D  0x90002D    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_allocate_instance(), 
                                       failed on qCompAllocate. */

#define TSC_LOC_00002E  0x90002E    /* TSC_DS2DPNSS:tsccomp.c:tscTraceEvent(),
                                       failed on qMsgAllocate. */  
                                      
#define TSC_LOC_00002F  0x90002F    /* TSC_DS2DPNSS:tsccomp.c:tscTraceEvent(),
                                       failed on qMsgWrite. */

#define TSC_LOC_000030  0x900030    /* TSC_DS2DPNSS:tsccomp.c:tscTraceEvent(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_000031  0x900031    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_sdl_msg(), 
                                       failed on qMsgWrite */

#define TSC_LOC_000032  0x900032    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qinst_msg(),
                                       failed on qMsgAllocate */

#define TSC_LOC_000033  0x900033    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qinst_msg(),
                                       failed on qMsgAllocate. */ 

#define TSC_LOC_000034  0x900034    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qinst_msg(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_000035  0x900035    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qinst_msg(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_000036  0x900036    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qinst_msg(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_000037  0x900037    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qinst_msg(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_000038  0x900038    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qinst_msg(),
                                       failed on qMsgWrite. */

#define TSC_LOC_000039  0x900039    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qinst_msg(),
                                       failed on qMsgWrite. */

#define TSC_LOC_00003A  0x90003A    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qinst_msg(),
                                       failed on qMsgWrite. */

#define TSC_LOC_00003B  0x90003B    /* TSC_DS2DPNSS:tsccomp.c:tscDetectxEvts(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_00003C  0x90003C    /* TSC_DS2DPNSS:tsccomp.c:tscDetectxEvts(),
                                       eventNum < TSP_MaxEvents. */

#define TSC_LOC_00003D  0x90003D    /* TSC_DS2DPNSS:tsccomp.c:tscDetectxEvts(),
                                       failed on qMsgVarFieldPut. */

#define TSC_LOC_00003E  0x90003E    /* TSC_DS2DPNSS:tsccomp.c:tscDetectxEvts(),
                                       label != transaction. */

#define TSC_LOC_00003F  0x90003F    /* TSC_DS2DPNSS:tsccomp.c:tscDetectxEvets(),
                                       failed on qMsgWrite. */

#define TSC_LOC_000040  0x900040    /* TSC_DS2DPNSS:tsccomp.c:
                                       tscEnableLineManagement(), failed
                                       on qClusterByComp. */

#define TSC_LOC_000041  0x900041    /* TSC_DS2DPNSS:tsccomp.c:
                                       tscEnableLineManagement(), failed
                                       on qCompAllocate. */
 
#define TSC_LOC_000042  0x900042    /* TSC_DS2DPNSS:tsccomp.c:tscStdMsgInit(),
                                       failed on qCompInstanceRegister. */

#define TSC_LOC_000043  0x900043    /* TSC_DS2DPNSS:tsccomp.c:tscStdMsgInit(),
                                       failed on tspGetParm. */
                                           
#define TSC_LOC_000044  0x900044    /* TSC_DS2DPNSS:tsccomp.c:tscStdMsgInit(),
                                           failed on tspGetParm. */

#define TSC_LOC_000045  0x900045    /* TSC_DS2DPNSS:tsccomp.c:tscStdMsgInit(),
                                       failed on tspGetParm. */

#define TSC_LOC_000046  0x900046    /* TSC_DS2DPNSS:tsccomp.c:tscStdMsgInit(),
                                       failed on tspGetParm. */

#define TSC_LOC_000047  0x900047    /* TSC_DS2DPNSS:tsccomp.c:tscStdMsgInit(),
                                       failed on qClusterCreate. */

#define TSC_LOC_000048  0x900048    /* TSC_DS2DPNSS:tsccomp.c:tscStdMsgInit(),
                                       failed on qCompAllocate. */

#define TSC_LOC_000049  0x900049    /* TSC_DS2DPNSS:tsccomp.c:tscStdMsgInit(),
                                       failed on qClusterCreate. */

#define TSC_LOC_00004A  0x90004A    /* TSC_DS2DPNSS:tsccomp.c:tscStdMsgInit(),
                                       failed on qComAllocate. */

#define TSC_LOC_00004B  0x90004B    /* TSC_DS2DPNSS:tsccomp.c:tscDefineBSet(),
                                       nextBChan > TSC.MAX_BCHAN_MAP. */

#define TSC_LOC_00004C  0x90004C    /* TSC_DS2DPNSS:tsccomp.c:
                                       tscSetChanStateCmplt(),
                                       failed on qMsgWrite. */

#define TSC_LOC_00004D  0x90004D    /* TSC_DS2DPNSS:tsccomp.c:
                                       tscSetChanStateCmplt(),
                                       failed on qMsgWrite. */

#define TSC_LOC_00004F  0x90004F    /* TSC_DS2DPNSS:tsccomp.c:
                                       tscSetChanStateCmplt(),
                                       failed on qMsgWrite. */

#define TSC_LOC_000050  0x900050    /* TSC_DS2DPNSS:tsccomp.c:tscSetLineState(),
                                           failed on qMsgWrite. */

#define TSC_LOC_000051  0x900051    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qcomp_msg(),
                                       failed on tspGetParm. */

#define TSC_LOC_000052  0x900052    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qcomp_msg(),
                                       failed on qCompFind. */

#define TSC_LOC_000053  0x900053    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qcomp_msg(),
                                       instInitCount < 0. */

#define TSC_LOC_000054  0x900054    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qcomp_msg(),
                                       failed on LCON_MsgGetAlarms_put. */

#define TSC_LOC_000055  0x900055    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qcomp_msg(),
                                       failed on qMsgVarFieldPut. */

#define TSC_LOC_000056  0x900056    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qcomp_msg(),
                                       failed on
                                       LCON_MsgGetAlarmsCmplt_AlarmInfo_get. */

#define TSC_LOC_000057  0x900057    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qcomp_msg(),
                                       failed on qMsgWrite. */

#define TSC_LOC_000058  0x900058    /* TSC_DS2DPNSS:tsccomp.c:
                                       tsc_handle_qcomp_msg(),
                                       failed on qMsgWrite. */

#define TSC_LOC_000059  0x900059    /* TSC_DS2DPNSS:tsccomp.c:G2X_ETASK_ENTRY(),
                                           failed on qCompregister. */

#define TSC_LOC_00005A  0x90005A    /* TSC_DS2DPNSS:tsccomp.c:G2X_ETASK_ENTRY(),
                                           failed on RtcCreatePool. */

#define TSC_LOC_00005B  0x90005B    /* TSC_DS2DPNSS:tsccomp.c:G2X_ETASK_ENTRY(),
                                       tscParm[ind].parmId != TSC_ParmEncoding.*/

#define TSC_LOC_00005C  0x90005C    /* TSC_DS2DPNSS:tsccomp.c:G2X_ETASK_ENTRY(),
                                       failed on qMsgRead. */

#define TSC_LOC_00005D  0x90005D    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       tspCallInfoWriteBody(),
                                       failed on TSC_CallInfo_put. */

#define TSC_LOC_00005E  0x90005E    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       tspCallInfoWriteBody(),
                                       failed on qMsgVarFieldPut. */

#define TSC_LOC_00005F  0x90005F    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFOSET_addmembers(),
                                       Unknow message. */

#define TSC_LOC_000060  0x900060    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFO_getcallinfo(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_000061  0x900061    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFO_getcallinfo(),
                                       failed on qMsgWrite. */

#define TSC_LOC_000062  0x900062    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFO_available(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_000063  0x900063    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFOEVENTS_isdnMsgAvailable(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_000064  0x900064    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFOEVENTS_ieAvailble(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_000065  0x900065    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFOEVENTS_ieAvailble(),
                                       failed on qMsgVarFieldPut */

#define TSC_LOC_000066  0x900066    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFOEVENTS_plus(), 
                                       events->fd_freehead == -1. */

#define TSC_LOC_000067  0x900067    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFOEVENTS_add(),
                                       events->fd_freehead == -1. */

#define TSC_LOC_000068  0x900068    /* TSC_DS2DPNSS:tspcallinfo.c:
                                       gu_T_CALLINFOEVENTS_isdnMsgAvailable(),
                                       failed on qMsgVarFieldPut. */

#define TSC_LOC_000069  0x900069    /* TSC_DS2DPNSS:tsputils.c:tspSetParmDef(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_00006A  0x90006A    /* TSC_DS2DPNSS:tsputils.c:tspSetParmDef(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_00006B  0x90006B    /* TSC_DS2DPNSS:tsputils.c:tspSetParm(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_00006C  0x90006C    /* TSC_DS2DPNSS:tsputils.c:tspSetParm(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_00006D  0x90006D    /* TSC_DS2DPNSS:tsputils.c:tspGetParm(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_00006E  0x90006E    /* TSC_DS2DPNSS:tsputils.c:tspGetParm(),
                                       failed on qMsgAllocate. */

#define TSC_LOC_00006F  0x90006F    /* TSC_DS2DPNSS:tsputils.c:tspBuildMsg(),
                                       failed on qMsgAllocate. */

#endif










