/****************************************************************************
 *		Copyright (c) 2000 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         
 * AUTHOR:       Wilson Lo  x6462
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    20-Apr-00 at 12:00:00
 * LAST-MOD:     13-Mar-02 at 18:02:25 by SKS
 * PURPOSE:
 *    This module contains error location tags for CHP component.
 *
 * HISTORY:
 * Date                 Who     Description
 * 13-Mar-2002          SKS     Added more error locations for qMemCallocs PT25788 
 * 04-Feb-2002          PJS     Changed the name to accomodate flattened header
 *                              file structure required by all components.
 * 20-Apr-2000          LOW     Initial Creation.
 ***************************************************************************/
#ifndef _tspisdn_chplocations_h_
#define _tspisdn_chplocations_h_

#define CHP_LOC_000002  0xA00002    /* TSC_ISDN:chpcomp.c:chpSendError(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000003  0xA00003    /* TSC_ISDN:chpcomp.c:chpSendError(),
                                       failed on qMsgWrite */

#define CHP_LOC_000004  0xA00004    /* TSC_ISDN:chpcomp.c:chp_getsdlpid(),
                                       qdesc.instance <= 0 or qdesc.instance
                                       > CHP_MaxInstance. */

#define CHP_LOC_000005  0xA00005    /* TSC_ISDN:chpcomp.c:chp_getsdlpid(),
                                       sdl_instance[qdesc.instance].sdlpid ==
                                       NULL */

#define CHP_LOC_000006  0xA00006    /* TSC_ISDN:chpcomp.c:chp_chpDefineVariant(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000007  0xA00007    /* TSC_ISDN:chpcomp.c:chp_chpDefineVariant(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000008  0xA00008    /* TSC_ISDN:chpcomp.c:
                                       chpRetreiveSetParmVariant(), 
                                       failed on qMsgAllocate. */

#define CHP_LOC_000009  0xA00009    /* TSC_ISDN:chpcomp.c:chp_buildmsg(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_00000A  0xA0000A    /* TSC_ISDN:chpcomp.c:chpPrintIEMessage(),
                                       failed on qMsgVarFieldGet. */

#define CHP_LOC_00000B  0xA0000B    /* TSC_ISDN:chpcomp.c:chpPrintIEMessage(),
                                       failed on qMsgVarFieldGet. */

#define CHP_LOC_00000C  0xA0000C    /* TSC_ISDN:chpcomp.c:chpBuildIEMessage(),
                                       failed on CCS_ieHeader_put. */

#define CHP_LOC_00000D  0xA0000D    /* TSC_ISDN:chpcomp.c:chpBuildIEMessage(),
                                       publicSize > 256. */

#define CHP_LOC_00000E  0xA0000E    /* TSC_ISDN:chpcomp.c:chpBuildIEMessage(),
                                       failed on qMsgFieldPut. */

#define CHP_LOC_00000F  0xA0000F    /* TSC_ISDN:chpcomp.c:chpTraceEvent(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000010  0xA00010    /* TSC_ISDN:chpcomp.c:chpTraceEvent(),
                                       failed on qMsgWrite. */

#define CHP_LOC_000011  0xA00011    /* TSC_ISDN:chpcomp.c:chpTraceEvent(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000012  0xA00012    /* TSC_ISDN:chpcomp.c:ichp_handle_sdl_msg(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000013  0xA00013    /* TSC_ISDN:chpcomp.c:ichp_handle_sdl_msg(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000014  0xA00014    /* TSC_ISDN:chpcomp.c:ichp_handle_sdl_msg(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000015  0xA00015    /* TSC_ISDN:chpcomp.c:ichp_handle_sdl_msg(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000016  0xA00016    /* TSC_ISDN:chpcomp.c:ichp_handle_sdl_msg(),
                                       failed on qClusterActivate. */

#define CHP_LOC_000017  0xA00017    /* TSC_ISDN:chpcomp.c:ichp_handle_sdl_msg(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000018  0xA00018    /* TSC_ISDN:chpcomp.c:ichp_handle_qinst_msg(),
                                       callId == 0. */

#define CHP_LOC_000019  0xA00019    /* TSC_ISDN:chpcomp.c:ichp_handle_qinst_msg(),
                                       no signal ID support yet */

#define CHP_LOC_00001A  0xA0001A    /* TSC_ISDN:chpcomp.c:ichp_handle_qinst_msg(),
                                       failed on qNIDIdleDisable. */

#define CHP_LOC_00001B  0xA0001B    /* TSC_ISDN:chpcomp.c:ichp_handle_qinst_msg(),
                                       failed on qNIDIdleEnable. */

#define CHP_LOC_00001C  0xA0001C    /* TSC_ISDN:chpcomp.c:ichp_handle_qinst_msg(),
                                       failed on qMsgWrite. */

#define CHP_LOC_00001D  0xA0001D    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on qCompFind. */

#define CHP_LOC_00001E  0xA0001E    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on tspGetParm. */

#define CHP_LOC_00001F  0xA0001F    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on tspGetParm. */

#define CHP_LOC_000020  0xA00020    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on tspGetParm. */

#define CHP_LOC_000021  0xA00021    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on tspGetParm. */

#define CHP_LOC_000022  0xA00022    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on qCompFiind. */

#define CHP_LOC_000023  0xA00023    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000024  0xA00024    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on qMsgAllocate. */

#define CHP_LOC_000025  0xA00025    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on qMsgWrite. */

#define CHP_LOC_000026  0xA00026    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on qMsgWrite. */

#define CHP_LOC_000027  0xA00027    /* TSC_ISDN:chpcomp.c:G2X_ETASK_ENTRY(),
                                       failed on qCompRegister. */

#define CHP_LOC_000028  0xA00028    /* TSC_ISDN:chpcomp.c:G2X_ETASK_ENTRY(),
                                       failed on RtcCreatePool. */

#define CHP_LOC_000029  0xA00029    /* TSC_ISDN:chpcomp.c:G2X_ETASK_ENTRY(),
                                       failed on qMsgRead. */

#define CHP_LOC_000030  0xA00030    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on tspGetParm for
                                       CHP_ParmDisableBlock */

#define CHP_LOC_000031  0xA00031    /* TSC_ISDN:chpcomp.c:ichp_handle_qcomp_msg(),
                                       failed on tspGetParm for
                                       CHP_ParmEnableTocRoc */

#define CHP_LOC_000032  0xA00032		 /* TSP_ISDN:chpcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CHP_LOC_000033	0xA00033		/* TSP_ISDN:chpcomp.c qMemAlloc failed - bufsize = %d */
#define CHP_LOC_000034	0xA00034		/* TSP_ISDN:chpcomp.c qMemAlloc failed - bufsize = %d */
#define CHP_LOC_000035	0xA00035		/* TSP_ISDN:chpcomp.c qMemAlloc failed - bufsize = %d */
#define CHP_LOC_000036	0xA00036		/* TSP_ISDN:chpcomp.c qMemAlloc failed - bufsize = %d */
#define CHP_LOC_000037	0xA00037		/* TSP_ISDN:chpcomp.c qMemAlloc failed - bufsize = %d */

#endif









