/****************************************************************************
 *		Copyright (c) 2000 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         tspisdn_tsclocations.h
 * AUTHOR:       Wilson Lo  x6462
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    13-Apr-00 at 17:55:15
 * LAST-MOD:     14-Mar-02 at 11:12:24 by SKS 
 * PURPOSE:
 *    This file containes all the TSP component location tag.
 *
 * HISTORY:
 * Date                 Who     Description
 * 14-Mar-02				SKS	  Added more error locations to check for qMemCalloc errors (PT25788)
 * 04-Feb-02            PJS     Changed the file name to accomodate the header 
 *										  file structure required by all components.
 * 13-Apr-00            LOW     Initial Creation.
 ***************************************************************************/

#ifndef _tspisdn_tsclocations_h_
#define _tspisdn_tsclocations_h_

#define TSPISDN_LOC_000001  0x900001    /* TSC_ISDN:tsp.h:SIG_INPUT_HDR()
                                       failed on qMsgAllocate at MACRO define
                                       */

#define TSPISDN_LOC_00002A  0x90002A    /* TSC_ISDN:tsccomp.c:tsc_getsdlpid(),
                                        incorrect value of qdesc.instance. */

#define TSPISDN_LOC_00002B  0x90002B    /* TSC_ISDN:tsccomp.c:tsc_getsdlpid(),
                                        incorrect value of
                                        sdl_instance[qdesc.instance].sdlpid. */

#define TSPISDN_LOC_00002C  0x90002C    /* TSC_ISDN:tsccomp.c:tscBuildMsg(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_00002D  0x90002D    /* TSC_ISDN:tsccomp.c:
                                           tsc_allocate_instance(), 
                                           failed on qCompAllocate. */

#define TSPISDN_LOC_00002E  0x90002E    /* TSC_ISDN:tsccomp.c:tscTraceEvent(),
                                           failed on qMsgAllocate. */  
                                      
#define TSPISDN_LOC_00002F  0x90002F    /* TSC_ISDN:tsccomp.c:tscTraceEvent(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_000030  0x900030    /* TSC_ISDN:tsccomp.c:tscTraceEvent(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000031  0x900031    /* TSC_ISDN:tsccomp.c:tsc_handle_sdl_msg(),
                                           failed on qMsgWrite */

#define TSPISDN_LOC_000032  0x900032    /* TSC_ISDN:tsccomp.c:tsc_handle_qinst_msg(),
                                           failed on qMsgAllocate */

#define TSPISDN_LOC_000033  0x900033    /* TSC_ISDN:tsccomp.c:tsc_handle_qinst_msg(),
                                           failed on qMsgAllocate. */ 

#define TSPISDN_LOC_000034  0x900034    /* TSC_ISDN:tsccomp.c:tsc_handle_qinst_msg(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000035  0x900035    /* TSC_ISDN:tsccomp.c:tsc_handle_qinst_msg(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000036  0x900036    /* TSC_ISDN:tsccomp.c:tsc_handle_qinst_msg(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000037  0x900037    /* TSC_ISDN:tsccomp.c:tsc_handle_qinst_msg(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000038  0x900038    /* TSC_ISDN:tsccomp.c:tsc_handle_qinst_msg(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_000039  0x900039    /* TSC_ISDN:tsccomp.c:tsc_handle_qinst_msg(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_00003A  0x90003A    /* TSC_ISDN:tsccomp.c:tsc_handle_qinst_msg(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_00003B  0x90003B    /* TSC_ISDN:tsccomp.c:tscDetectxEvts(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_00003C  0x90003C    /* TSC_ISDN:tsccomp.c:tscDetectxEvts(),
                                           eventNum < TSP_MaxEvents. */

#define TSPISDN_LOC_00003D  0x90003D    /* TSC_ISDN:tsccomp.c:tscDetectxEvts(),
                                           failed on qMsgVarFieldPut. */

#define TSPISDN_LOC_00003E  0x90003E    /* TSC_ISDN:tsccomp.c:tscDetectxEvts(),
                                           label != transaction. */

#define TSPISDN_LOC_00003F  0x90003F    /* TSC_ISDN:tsccomp.c:tscDetectxEvets(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_000040  0x900040    /* TSC_ISDN:tsccomp.c:
                                           tscEnableLineManagement(), failed
                                           on qCompFind. */

#define TSPISDN_LOC_000041  0x900041    /* TSC_ISDN:tsccomp.c:
                                           tscEnableLineManagement(), failed
                                           to qCompAllocate of CCS. */
 
#define TSPISDN_LOC_000042  0x900042    /* TSC_ISDN:tsccomp.c:tscStdMsgInit(),
                                           failed on qCompInstanceRegister. */

#define TSPISDN_LOC_000043  0x900043    /* TSC_ISDN:tsccomp.c:tscStdMsgInit(),
                                           failed on tspGetParm. */
                                           
#define TSPISDN_LOC_000044  0x900044    /* TSC_ISDN:tsccomp.c:tscStdMsgInit(),
                                           failed on tspGetParm. */

#define TSPISDN_LOC_000045  0x900045    /* TSC_ISDN:tsccomp.c:tscStdMsgInit(),
                                           failed on tspGetParm. */

#define TSPISDN_LOC_000046  0x900046    /* TSC_ISDN:tsccomp.c:tscStdMsgInit(),
                                           failed on tspGetParm. */

#define TSPISDN_LOC_000047  0x900047    /* TSC_ISDN:tsccomp.c:tscStdMsgInit(),
                                           failed on qClusterCreate. */

#define TSPISDN_LOC_000048  0x900048    /* TSC_ISDN:tsccomp.c:tscStdMsgInit(),
                                           failed on qCompAllocate. */

#define TSPISDN_LOC_000049  0x900049    /* TSC_ISDN:tsccomp.c:tscStdMsgInit(),
                                           failed on qClusterCreate. */

#define TSPISDN_LOC_00004A  0x90004A    /* TSC_ISDN:tsccomp.c:tscStdMsgInit(),
                                           failed on qComAllocate. */

#define TSPISDN_LOC_00004B  0x90004B    /* TSC_ISDN:tsccomp.c:tscDefineBSet(),
                                           nextBChan > TSC.MAX_BCHAN_MAP. */

#define TSPISDN_LOC_00004C  0x90004C    /* TSC_ISDN:tsccomp.c:tscSetChanStateCmplt(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_00004D  0x90004D    /* TSC_ISDN:tsccomp.c:tscSetChanStateCmplt(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_00004F  0x90004F    /* TSC_ISDN:tsccomp.c:tscSetChanStateCmplt(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_000050  0x900050    /* TSC_ISDN:tsccomp.c:tscSetLineState(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_000051  0x900051    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           failed on tspGetParm. */

#define TSPISDN_LOC_000052  0x900052    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           failed on qCompFind. */

#define TSPISDN_LOC_000053  0x900053    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           instInitCount < 0. */

#define TSPISDN_LOC_000054  0x900054    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           failed on LCON_MsgGetAlarms_put. */

#define TSPISDN_LOC_000055  0x900055    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           failed on qMsgVarFieldPut. */

#define TSPISDN_LOC_000056  0x900056    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           failed on
                                           LCON_MsgGetAlarmsCmplt_AlarmInfo_get. */

#define TSPISDN_LOC_000057  0x900057    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_000058  0x900058    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           failed on qMsgWrite. */

#define TSPISDN_LOC_000059  0x900059    /* TSC_ISDN:tsccomp.c:G2X_ETASK_ENTRY(),
                                           failed on qCompregister. */

#define TSPISDN_LOC_00005A  0x90005A    /* TSC_ISDN:tsccomp.c:G2X_ETASK_ENTRY(),
                                           failed on RtcCreatePool. */

#define TSPISDN_LOC_00005B  0x90005B    /* TSC_ISDN:tsccomp.c:G2X_ETASK_ENTRY(),
                                           tscParm[ind].parmId != TSC_ParmEncoding.*/

#define TSPISDN_LOC_00005C  0x90005C    /* TSC_ISDN:tsccomp.c:G2X_ETASK_ENTRY(),
                                           failed on qMsgRead. */

#define TSPISDN_LOC_00005D  0x90005D    /* TSC_ISDN:tspcallinfo.c:tspFacilityPut(),
                                           failed on TSC_Facility_put. */

#define TSPISDN_LOC_00005E  0x90005E    /* TSC_ISDN:tspcallinfo.c:tspFacilityPut(),
                                           failed on TSC_Facility_Comp_put. */

#define TSPISDN_LOC_00005F  0x90005F    /* TSC_ISDN:tspcallinfo.c:tspFacilityPut(),
                                           failed on TSC_Faility_Element_put. */

#define TSPISDN_LOC_000060  0x900060    /* TSC_ISDN:tspcallinfo.c:tspFacilityPut(),
                                           failed on qMsgVarFieldPut. */

#define TSPISDN_LOC_000061  0x900061    /* TSC_ISDN:tspcallinfo.c:tspFacilityGet(),
                                           failed on TSC_Facility_get. */

#define TSPISDN_LOC_000062  0x900062    /* TSC_ISDN:tspcallinfo.c:tspFacilityGet(),
                                           failed on TSC_Facility_Comp_get. */

#define TSPISDN_LOC_000063  0x900063    /* TSC_ISDN:tspcallinfo.c:tspFacilityGet(),
                                           failed on TSC_Facility_Element_get. */

#define TSPISDN_LOC_000064  0x900064    /* TSC_ISDN:tspcallinfo.c:tspFacilityGet(),
                                           failed on qMsgVarFieldGet. */

#define TSPISDN_LOC_000065  0x900065    /* TSC_ISDN:tspcallinfo.c:tspFacilityGet(),
                                           (localOffset - *offset) >
                                           sup_T_FACILITY */

#define TSPISDN_LOC_000066  0x900066    /* TSC_ISDN:tspcallinfo.c:
                                           tspCallInfoWriteBody(), 
                                           failed on TSC_CallInfo_put. */

#define TSPISDN_LOC_000067  0x900067    /* TSC_ISDN:tspcallinfo.c:
                                           tspCallInfoWriteBody(),
                                           failed on qMsgVarFieldPut. */

#define TSPISDN_LOC_00005D  0x90005D    /* TSC_ISDN:tspcallinfo.c:tspFacilityPut(),
                                           failed on TSC_Facility_put. */

#define TSPISDN_LOC_00005E  0x90005E    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFOSET_addmembers(),
                                           type is not accepted. */

#define TSPISDN_LOC_00005F  0x90005F    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFOSET_getcallinfo(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000060  0x900060    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFOSET_getcallinfo(),
                                           failed on qMsgWrite. */
                                         
#define TSPISDN_LOC_000061  0x900061    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFO_available(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000062  0x900062    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFOEVENTS_isdnMsgAvailble(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000063  0x900063    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFOEVENTS_isdnMsgAvailble(),
                                           failed on qMsgVarFieldPut. */

#define TSPISDN_LOC_000064  0x900064    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFOEVENTS_ieAvailable(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000065  0x900065    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFOEVENTS_ieAvailable(),
                                           failed on qMsgVarFieldPut. */

#define TSPISDN_LOC_000066  0x900066    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFOEVENTS_plus(),
                                           failed on events->fd_freehead != -1. */

#define TSPISDN_LOC_000067  0x900067    /* TSC_ISDN:tspcallinfo.c:
                                           gu_T_CALLINFOEVENTS_add(),
                                           failed on events->fd_freehead != -1. */

#define TSPISDN_LOC_000068  0x900068    /* TSC_ISDN:tsputils.c:tspSetParmDef(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_000069  0x900069    /* TSC_ISDN:tsputils.c:tspSetParmDef(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_00006A  0x90006A    /* TSC_ISDN:tsputils.c:tspSetParm(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_00006B  0x90006B    /* TSC_ISDN:tsputils.c:tspSetParm(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_00006C  0x90006C    /* TSC_ISDN:tsputils.c:tspGetParm(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_00006D  0x90006D    /* TSC_ISDN:tsputils.c:tspGetParm(),
                                           failed on qMsgAllocate. */

#define TSPISDN_LOC_00006E  0x90006E    /* TSC_ISDN:tsputils.c:tspBuildMsg(),
                                           failed on qMsgAllocate. */


#define TSPISDN_LOC_00006F  0x90006F    /* TSC_ISDN:tsccomp.c:tscEnableLineManagment()
                                           failed to find LineAdmin cluster - qErrNo = 0x%x */

#define TSPISDN_LOC_000070  0x900070 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_000071  0x900071 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_000072  0x900072 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_000073  0x900073 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_000074  0x900074 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_000075  0x900075 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_000076  0x900076 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_000077  0x900077 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_000078  0x900078 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_000079  0x900079 	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSPISDN_LOC_00007A  0x90007A    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           failed on LCON_MsgGetAlarms_put. */

#define TSPISDN_LOC_00007B  0x90007B    /* TSC_ISDN:tsccomp.c:tsc_handle_qcomp_msg(),
                                           failed on qMsgVarFieldPut. */

#define TSPISDN_LOC_00007C  0x90007C    /* TSC_ISDN:tsccomp.c:tscDefineAlarmMask(),
                                           failed on qMsgVarFieldPut. */

#define TSPISDN_LOC_00007D  0x90007D    /* TSC_ISDN:tsccomp.c:tscDefineAlarmMask(),
                                           failed on qMsgWrite */

#endif
