/***************************************************************************
 *		Copyright (c) 2000 Dialogic Corp., an Intel Company.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:			tsppdk_caslocations.h
 * AUTHOR:		DM3 TSP Team
 * ORG:			Dialogic Corporation
 * ORIG-DATE:	13-Apr-00
 * LAST-MOD:	13-Apr-00 at 14:58:51 by Supriya Sen 
 * PURPOSE:		This header file contains the location tags and error
 *					strings for the qError reports in the cascomp.c file.
 *					(Part of the TSP resource for CAS protocols).
 *
 * HISTORY:
 * Date			Who	Description
 * 04-Feb-02   PJS   Changed name of header file to accomodate for flattened
 *                   header file structure required for all components.
 * 13-Apr-00	SKS	Initial version based on Rev 0.7 of the qError 
 *							API Users Guide.
 *							
 ***************************************************************************/

/* Multiple include protection */
#ifndef _tsppdk_caslocations_h_
#define _tsppdk_caslocations_h_

#ifdef __cplusplus
extern "C" {
#endif

#define CAS_LOC_0001 0x800101	/* CAS:cascomp.c getsdlpid - instance %d out of range (max=%d) */
#define CAS_LOC_0002 0x800102	/* CAS:cascomp.c getsdlpid - instance %d not registered */
#define CAS_LOC_0003 0x800103	/* CAS:cascomp.c qMsgAllocate failed - bufsize = %d */
#define CAS_LOC_0004 0x800104	/* CAS:cascomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CAS_LOC_0005 0x800105	/* CAS:cascomp.c qMsgAllocate failed - bufsize = %d */
#define CAS_LOC_0006 0x800106	/* CAS:cascomp.c qMsgAllocate failed - bufsize = %d */
#define CAS_LOC_0007 0x800107	/* CAS:cascomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CAS_LOC_0008 0x800108	/* CAS:cascomp.c qMsgAllocate failed - bufsize = %d */
#define CAS_LOC_0009 0x800109	/* CAS:cascomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CAS_LOC_0010 0x80010a	/* CAS:cascomp.c Unknown signal type for definition */
#define CAS_LOC_0011 0x80010b	/* CAS:cascomp.c Unknown signal type */
#define CAS_LOC_0012 0x80010c	/* CAS:cascomp.c qMsgAllocate failed - bufsize = %d */
#define CAS_LOC_0013 0x80010d	/* CAS:cascomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define CAS_LOC_0014 0x80010e	/* CAS:cascomp.c qCompRegister failed, qErrNo=0x%x */
#define CAS_LOC_0015 0x80010f	/* CAS:cascomp.c Failed to create CAS RTC pool, qErrNo=0x%x */
#define CAS_LOC_0016 0x800110	/* CAS:cascomp.c qMsgRead failed, qErrNo=0x%x */
#define CAS_LOC_0017 0x800111	/* CAS:cascomp.c Failed to find LCON Component address, qErrNo=0x%x */
#define CAS_LOC_0018 0x800112	/* CAS:cascomp.c qMemCalloc failed - bufsize = %d */
#define CAS_LOC_0019 0x800113	/* CAS:cascomp.c qMemCalloc failed - bufsize = %d */
#define CAS_LOC_0020 0x800114	/* CAS:cascomp.c qMemCalloc failed - bufsize = %d */
#define CAS_LOC_0021 0x800115	/* CAS:cascomp.c qMemCalloc failed - bufsize = %d */

#ifdef __cplusplus
}
#endif

#endif		/* _tsppdk_caslocations_h_ End multiple include protection */
