/***************************************************************************
 *		Copyright (c) 2000 Dialogic Corp., an Intel Company.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:			tsppdk_lconlocations.h
 * AUTHOR:		DM3 TSP Team
 * ORG:			Dialogic Corporation
 * ORIG-DATE:	14-Apr-00
 * LAST-MOD:	14-Apr-00 at 14:28:51 by Supriya Sen 
 * PURPOSE:		This header file contains the location tags and error
 *					strings for the qError reports in the lconcomp.c file.
 *					(Part of the Line Admin resource for TSP protocols).
 *
 * HISTORY:
 * Date			Who	Description
 * 04-Feb-02   PJS   Changed name of header file to accomodate for flattened
 *                   header file structure required for all components.
 * 14-Apr-00	SKS	Initial version based on Rev 0.7 of the qError 
 *							API Users Guide.
 *							
 ***************************************************************************/

/* Multiple include protection */
#ifndef _tsppdk_lconlocations_h_
#define _tsppdk_lconlocations_h_

#ifdef __cplusplus
extern "C" {
#endif

#define LCON_LOC_0001 0x800101	/* LCON:lconcomp.c getsdlpid - instance %d out of range (max=%d) */
#define LCON_LOC_0002 0x800102	/* LCON:lconcomp.c getsdlpid - instance %d not registered */
#define LCON_LOC_0003 0x800103   /* LCON:lconcomp.c qClusterCreate failed, qErrNo=0x%x */
#define LCON_LOC_0004 0x800104	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0005 0x800105	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0006 0x800106	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0007 0x800107	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0008 0x800108	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0009 0x800109	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0010 0x80010a	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0011 0x80010b	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0012 0x80010c	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0013 0x80010d	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0014 0x80010e	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0015 0x80010f	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0016 0x800110	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0017 0x800111	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0018 0x800112	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0019 0x800113	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0020 0x800114	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0021 0x800115	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0022 0x800116	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0023 0x800117	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0024 0x800118	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0025 0x800119	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0026 0x80011a	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0027 0x80011b	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0028 0x80011c	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0029 0x80011d	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0030 0x80011e	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0031 0x80011f	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0032 0x800120	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0033 0x800121	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0034 0x800122	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0035 0x800123	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0036 0x800124	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0037 0x800125	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0038 0x800126	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0039 0x800127	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0040 0x800128	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0041 0x800129	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0042 0x80012a	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0043 0x80012b	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0044 0x80012c	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0045 0x80012d	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0046 0x80012e	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0047 0x80012f	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0048 0x800130	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0049 0x800131	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0050 0x800132	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0051 0x800133	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0052 0x800134	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0053 0x800135	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0054 0x800136	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0055 0x800137	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0056 0x800138	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0057 0x800139	/* LCON:lconcomp.c qMsgAllocate failed - bufsize = %d */
#define LCON_LOC_0058 0x80013a	/* LCON:lconcomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define LCON_LOC_0059 0x80013b 	/* LCON:lconcomp.c qCompRegister failed, qErrNo=0x%x */
#define LCON_LOC_0060 0x80013c 	/* LCON:lconcomp.c Failed to create LCON RTC pool, qErrNo=0x%x */
#define LCON_LOC_0061 0x80013d 	/* LCON:lconcomp.c qMsgRead failed, qErrNo=0x%x */
#define LCON_LOC_0062 0x80013e 	/* LCON:lconcomp.c qMemCalloc failed - bufsize = %d */
#define LCON_LOC_0063 0x80013f 	/* LCON:lconcomp.c qMemCalloc failed - bufsize = %d */
#define LCON_LOC_0064 0x800140 	/* LCON:lconcomp.c qMemCalloc failed - bufsize = %d */

#ifdef __cplusplus
}
#endif

#endif		/* _tsppdk_lconlocations_h_ End multiple include protection */
